; REVCOUNT150.ASM 08MAY05 - COPYRIGHT JOHN BECKER
; EPE REV COUNTER & TORQUE MONITOR FOR BOATS ETC

;PIC16F628, WDT OFF, POR ON, INTERNAL 4MHz CLOCK

;PROGRAM WRITTEN IN TASM VARIANT - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

        List P = PIC16F628, R=DEC;
        __CONFIG   h'3F30'

        include P16F628.inc

        CBLOCK

REGA0				;lsb
REGA1
REGA2
REGA3				;msb

REGB0				;lsb
REGB1
REGB2
REGB3				;msb

REGC0				;lsb
REGC1
REGC2
REGC3				;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT

LOOP        ; loop counter
LOOPA       ; loop counter for LCD
LOOPB       ; loop counter

RSLINE      ; LCD command/data flag
CLKCNT      ; pre-counter for seconds
STORE1      ; general store

PREVFAN
BLADES
BLADESRPM
BLADESMIN
BLADESMAX
PULSEMSB
PULSELSB

REGD0				;lsb
REGD1
REGD2
REGD3				;msb

FREQMINMSB
FREQMINLSB
FREQMAXMSB
FREQMAXLSB
FREQRANGEMSB
FREQRANGELSB
FORCECOUNTMSB
FORCECOUNTLSB

UNITSTYPE
TIMERVAL
STOREFREQMSB
STOREFREQLSB
MAXFORCEMSB
MAXFORCELSB

	ENDC

PROMVAL    EQU $70

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        call TABLCD      ;get set-up instruction
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

TABLCD: addwf PCL,F      ;LCD initialisation table
        retlw %00110011  ;initialise lcd - first byte
        retlw %00110011  ;2nd byte (repeat of first)
        retlw %00110010  ;set for 4-bit operation
        retlw %00101100  ;set for 2 lines
        retlw %00000110  ;set entry mode to increment each address
        retlw %00001100  ;set display on, cursor off, blink off
        retlw %00000001  ;clear display
        retlw %00000010  ;return home, cursor & RAM to zero
                         ;end inititalisation table

MESSAG: addwf PCL,F
        retlw 'R'
        retlw 'P'
        retlw 'S'
        retlw ' '
        retlw 'R'
        retlw 'P'
        retlw 'M'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw 'F'
        retlw ' '
        retlw '#'

MESSAG2: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'B'
        retlw 'L'
        retlw 'A'
        retlw 'D'
        retlw 'E'
        retlw ' '
        retlw 'C'
        retlw 'O'
        retlw 'U'
        retlw 'N'
        retlw 'T'
        retlw ' '

MESSAG3: addwf PCL,F
        retlw 'M'
        retlw 'I'
        retlw 'N'
        retlw ' '
        retlw 'F'
        retlw 'R'
        retlw 'E'
        retlw 'Q'

MESSAG4: addwf PCL,F
        retlw 'M'
        retlw 'A'
        retlw 'X'
        retlw ' '
        retlw 'F'
        retlw 'R'
        retlw 'E'
        retlw 'Q'

MESSAG5: addwf PCL,F
        retlw 'W'
        retlw 'E'
        retlw 'I'
        retlw 'G'
        retlw 'H'
        retlw 'T'
        retlw ' '
        retlw ' '

SETSTAR: call LCD28
        movf LOOPB,W
        addwf PCL,F
        goto SHOWSTAR0
        goto SHOWSTAR1
        goto SHOWSTAR2
        goto SHOWSTAR3
        goto SHOWSTAR4
        goto SHOWSTAR5

SHOWSTAR0: movlw ' '
        call LCDOUT
SHOWSTAR1: movlw ' '
        call LCDOUT
SHOWSTAR2: movlw ' '
        call LCDOUT
SHOWSTAR3: movlw ' '
        call LCDOUT
SHOWSTAR4: movlw ' '
        call LCDOUT
SHOWSTAR5: movlw '*'
        call LCDOUT
        return

;*******************

START:  clrf PORTA       ; initialise all port outputs to zero
        clrf PORTB
        movlw $07        ; activate PORTA for PC16F628 as digital
        movwf CMCON

        BANK1
        movlw %01000000
        movwf TRISB      ; RB6 as input
        movlw 255        ; PORTA as input
        movwf TRISA
        movlw %10000101  ; set timer ratio 1:64, pull-ups off
        movwf OPTION_REG
        BANK0

        clrf INTCON
        call PAUSIT
        call LCDSET
        clrf INTCON
        call PAUSIT

        movlw %00001011  ; set timer 1 prescale 1:1, and timer on
                         ; bit 3 = 1 osc enable
        movwf T1CON      ; RB6 as I/O pin (bit 1 set) external timing
        clrf TMR1L       ; reset timer 1
        clrf TMR1H
 
        clrf FREQMINMSB
        clrf FREQMINLSB
        clrf FREQMAXMSB
        clrf FREQMAXLSB
        clrf FREQRANGEMSB
        clrf FREQRANGELSB
        clrf FORCECOUNTMSB
        clrf FORCECOUNTLSB
        clrf UNITSTYPE
        clrf BLADESRPM
        clrf BLADESMIN
        clrf BLADESMAX

        call CLRLINE1
        call CLRLINE2

        movlw 61        ; start value of TIMERVAL
        movwf TIMERVAL
        movwf CLKCNT
        clrf PULSEMSB
        clrf PULSELSB
        clrf PREVFAN

        call GETFACTS   ; recall EEPROM data

        btfsc PORTA,0   ; is blade qty etc setting required?
        call SETBLADES  ; yes

        call LCD1
LCDMSG: clrf LOOP       ; clear loop
LCDMS0: movf LOOP,W     ; get table address
        call MESSAG     ; get message letter
        call LCDOUT     ; show it
        incf LOOP,F     ; inc loop
        btfss LOOP,4    ; has last LCD letter been sent?
        goto LCDMS0     ; no, repeat for next

        movlw %11001111 ; show blades
        call LCDLIN
        movf BLADES,W
        iorlw 48
        call LCDOUT
        call CLKSHW

        clrf TMR1L      ; reset timer 1
        clrf TMR1H

;********* START OF MAIN PROGRAM ********

MAIN:   btfsc PORTA,0     ; is MINFORCE setting required?
        call SETMINFORCE  ; yes

        btfsc PORTA,1     ; is MAXFORCE setting required?
        call SETMAXFORCE  ; yes

        movf PORTA,W      ; get PORTA
        andlw %00010000 
        movwf STORE1
        xorwf PREVFAN,W   ; has RA4 change occurred?
        btfsc STATUS,Z
        goto INT2

        incfsz PULSELSB,F ; inc counter
        goto INT2
        incf PULSEMSB,F

INT2:   movf STORE1,W     ; store RA1 val
        movwf PREVFAN

        btfss INTCON,2    ; has a timer time-out been detected?
        goto MAIN         ; no
        bcf INTCON,2      ; yes
        call CLKADD       ; update time
        goto MAIN  

CLKADD: decfsz CLKCNT,F   ; increment system clock counter. Is it = 0?
        return            ; no

        bcf T1CON,0       ; stop T1 external counter
        movf TMR1H,W
        movwf REGA1
        movf TMR1H,W
        movwf FORCECOUNTMSB
        movwf STOREFREQMSB
        movf TMR1L,W
        movwf REGA0
        movwf FORCECOUNTLSB ; count from coil osc
        movwf STOREFREQLSB

        movf TIMERVAL,W
        movwf CLKCNT
        clrf TMR1L
        clrf TMR1H
        clrf TMR0
        bcf INTCON,2
        bsf T1CON,0         ; start T1 external counter

        clrf REGA2
        clrf REGA3
        call LCD8
        call BIN2DEC
        call SHOWDIG6       ; show coil freq count

CLKSHW: call LCD21
        call GETREVS
        call GETFORCE
        clrf TMR1L          ; reset timer 1 & 0
        clrf TMR1H
        clrf TMR0
        bcf INTCON,2
        return

GETFORCE: movf FORCECOUNTMSB,W   ; subtract min from current val
        movwf REGA1
        movf FORCECOUNTLSB,W
        movwf REGA0
        clrf REGA2
        clrf REGA3

        movf FREQMINMSB,W
        movwf REGB1
        movf FREQMINLSB,W
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call SUBTRACT

;        btfsc STATUS,C
;        call OVERFLOW

        movlw 100               ; multiply by 100
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3

        call MULTIPLY
        movf FREQRANGEMSB,W     ; divide by freq range
        movwf REGB1
        movf FREQRANGELSB,W
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call DIVIDE

        movf MAXFORCEMSB,W      ; multiply by kgs of max force
        movwf REGB1
        movf MAXFORCELSB,W
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call MULTIPLY

        movlw 100               ; divide by 100
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call DIVIDE

        call BIN2DEC            ; show answer as weight
        call LCD27
        call SHOWDIG5
        movlw 'W'
        call LCDOUT
        movlw '-'
        btfss DSIGN,0           ; is answer negative?
        movlw ' '               ; no, positive
        call LCDOUT
        return

GETREVS: movf PULSELSB,W ; get pulse count for LED flashes
	movwf REGA0
        movf PULSEMSB,W
	movwf REGA1
	clrf REGA2
	clrf REGA3

        bcf STATUS,C
        rlf BLADES,W     ; divide by blade count x 2
	movwf REGB0
	clrf REGB1
	clrf REGB2
	clrf REGB3

	call DIVIDE
	
	movf REGA0,W
	movwf REGD0
	movf REGA1,W
	movwf REGD1
	movf REGA2,W
	movwf REGD2
	movf REGA3,W
	movwf REGD3

        call BIN2DEC
        call SHOWDIG9    ; show rev count as secs

	movf REGD0,W
	movwf REGA0
	movf REGD1,W
	movwf REGA1
	movf REGD2,W
	movwf REGA2
	movf REGD3,W
	movwf REGA3

        movlw 60         ; get rev count per min
	movwf REGB0
	clrf REGB1
	clrf REGB2
	clrf REGB3

        call MULTIPLY

        call BIN2DEC
        call SHOWDIG6    ; show RPM

        clrf PULSELSB
        clrf PULSEMSB
	return


; ***** SET BLADE COUNT - RANGE 1 to 9

SETBLADES: movlw %10000000 ; show blades
        call LCDLIN     ; set address for line 1 (address 0)
        clrf LOOP       ; clear loop
        bsf RSLINE,4    ; set RS for data send
LCDMS2: movf LOOP,W     ; get table address
        call MESSAG2    ; get message letter
        call LCDOUT     ; show it
        incf LOOP,F     ; inc loop
        btfss LOOP,4    ; has last LCD letter been sent?
        goto LCDMS2     ; no, repeat for next

        movlw %11000000 ; show blades
        call LCDLIN     ; set address for line 2 (address 64)
        movf BLADES,W
        iorlw 48
        call LCDOUT

SETB1:  btfsc PORTA,0   ; wait till switch released
        goto SETB1

SETB2:  call PAUSIT
        call PAUSIT

SETB3:  btfsc PORTA,0
        goto SETWEIGHT
        btfss PORTA,1   ; wait till switch pressed
        goto SETB3
        incf BLADES,F
        movf BLADES,W   ; are blades >= 10?
        addlw 6
        btfss STATUS,DC
        goto SETB4
        movlw 1
        movwf BLADES

SETB4:  movf BLADES,W
        movwf PROMVAL
        movlw 0
        call SETPRM

        call LCD21      ; show blades
        movf BLADES,W
        iorlw 48
        call LCDOUT
        call PAUSIT
        goto SETB2

SETWEIGHT: call CLRLINE1  ; set weight units
        call CLRLINE2
        call LCD1
        clrf LOOP       ; clear loop
LCDMS5: movf LOOP,W     ; get table address
        call MESSAG5    ; get message letter
        call LCDOUT     ; show it
        incf LOOP,F     ; inc loop
        btfss LOOP,3    ; has last LCD letter been sent?
        goto LCDMS5     ; no, repeat for next

        call SHOWWEIGHT ; show weight units
        movlw 48        ; set all DIGIT5-10 for numerals
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F
        call LCD8
        call SHOWDIG6   ; reshow weight units

        movlw 5         ; set loop for 5 digits to be changed
        movwf LOOPB
        movlw DIGIT6
        movwf FSR

SETW1:  btfsc PORTA,0   ; wait till switch released
        goto SETW1
        call SETSTAR    ; set asterisc position
        call PAUSIT

SETW2:  btfsc PORTA,0   ; is next digit setting requested?
        goto WEIGHTLOOP ; yes
        btfss PORTA,1   ; wait till switch pressed
        goto SETW2

        incf INDF,F     ; inc val of selected digit
        movf INDF,W     ; limit to 9
        addlw 6
        btfss STATUS,DC
        goto SETW2A
        movlw 48
        movwf INDF

SETW2A: call LCD8
        call SHOWDIG6   ; show new weight value
        call PAUSIT
        call PAUSIT
        call PAUSIT
        goto SETW2

WEIGHTLOOP: incf FSR,F  ; inc digit position
        decfsz LOOPB,F
        goto SETW1

ENDSETWEIGHT: btfsc PORTA,0   ; wait till switch released
        goto ENDSETWEIGHT
        clrf DIGIT1      ; convert all digit back to true numerals
        clrf DIGIT2
        clrf DIGIT3
        clrf DIGIT4
        clrf DIGIT5
        movf DIGIT6,W
        andlw %00001111
        movwf DIGIT6
        
        addlw 9          ; limit DIGIT6 to 5
        btfsc STATUS,DC
        clrf DIGIT6

        movf DIGIT7,W
        andlw %00001111
        movwf DIGIT7
        movf DIGIT8,W
        andlw %00001111
        movwf DIGIT8
        movf DIGIT9,W
        andlw %00001111
        movwf DIGIT9
        movf DIGIT10,W
        andlw %00001111
        movwf DIGIT10
        movlw 10
        call DEC2BIN      ; convert decinal vals to binary

        movf REGA1,W      ; store result back into MAXFORCE & into EEPROM
        movwf MAXFORCEMSB
        movwf PROMVAL
        movlw 6
        call SETPRM

        movf REGA0,W
        movwf MAXFORCELSB
        movwf PROMVAL
        movlw 7
        call SETPRM
        return

SHOWWEIGHT:
        call LCD8
        movf MAXFORCEMSB,W
        movwf REGA1
        movf MAXFORCELSB,W
        movwf REGA0
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call SHOWDIG6
        return

;********** LCD CONTROL SECTION *********

LCD1:   movlw B'10000000'
        goto LCDLIN
LCD5:   movlw B'10000101'
        goto LCDLIN
LCD6:   movlw %10000110
        goto LCDLIN
LCD7:   movlw %10000111
        goto LCDLIN
LCD8:   movlw %10001000
        goto LCDLIN
LCD9:   movlw %10001001
        goto LCDLIN
LCD10:  movlw %10001010
        goto LCDLIN
LCD11:  movlw %10001011
        goto LCDLIN
LCD14:  movlw B'10001110'
        goto LCDLIN
LCD15:  movlw B'10001111'
        goto LCDLIN
LCD16:  movlw %10010000
        goto LCDLIN
LCD21:  movlw B'11000000'
        goto LCDLIN
LCD26:  movlw %11000110
        goto LCDLIN
LCD27:  movlw %11000111
        goto LCDLIN
LCD28:  movlw B'11001000'
        goto LCDLIN
LCD30:  movlw %11001010
        goto LCDLIN
LCD2F:  movlw %11001111
        goto LCDLIN
LCD216: movlw %11010000
        goto LCDLIN
LCD21D: movlw %11011100
        goto LCDLIN

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 255       ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        nop
        bsf PORTB,5     ; set E high
        nop
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 14        ; 1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:                  ;
        btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

; **************

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

COPY_REGA_REGB:
        movf REGA0,W    
        movwf REGB0
        movf REGA1,W
        movwf REGB1
        movf REGA2,W
        movwf REGB2
        movf REGA3,W
        movwf REGB3
        return

; *********** PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply:
	clrf	MTEMP		;Reset sign flag
	call	chksgna		;Make REGA positive
	skpc
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand
	
	rlf	REGC3,w		;Test MSB of multiplicand
	skpnc			;If multiplicand bit is a 1 then
	call	addba		;add multiplier to product

	skpc			;Check for overflow
	rlf	REGA3,w
	skpnc
	return

	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return


; *************

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide: clrf    MTEMP           ;Reset sign flag
	movf	REGB0,w		;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpc
	call	chksgna		;Make dividend (REGA) positive
	skpc
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;*** SQUARE ROOT ***
;sqrt(REGA) -> REGA
;Return carry set if negative

sqrt:   rlf     REGA3,w         ;Trap negative values
	skpnc
	return

	call	movac		;Move REGA to REGC
	call	clrba		;Clear remainder (REGB) and root (REGA)

	movlw	D'16'		;Loop counter
	movwf	MCOUNT

sqloop	rlf	REGC0,f		;Shift two msb's
	rlf	REGC1,f		;into remainder
	rlf	REGC2,f
	rlf	REGC3,f
	rlf	REGB0,f
	rlf	REGB1,f
	rlf	REGB2,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	rlf	REGB0,f
	rlf	REGB1,f
	rlf	REGB2,f

	setc			;Add 1 to root
	rlf	REGA0,f		;Align root
	rlf	REGA1,f
	rlf	REGA2,f

	movf	REGA2,w		;Test if remdr (REGB) >= root (REGA)
	subwf	REGB2,w
	skpz
	goto	ststgt
	movf	REGA1,w
	subwf	REGB1,w
	skpz
	goto	ststgt
	movf	REGA0,w
	subwf	REGB0,w
ststgt	skpc			;Carry set if remdr >= root
	goto	sremlt

	movf	REGA0,w		;Subtract root (REGA) from remdr (REGB)
	subwf	REGB0,f
	movf	REGA1,w
	skpc
	incfsz	REGA1,w
	subwf	REGB1,f
	movf	REGA2,w
	skpc
	incfsz	REGA2,w
	subwf	REGB2,f
	bsf	REGA0,1		;Set current root bit

sremlt	bcf	REGA0,0		;Clear test bit
	decfsz	MCOUNT,f	;Next
	goto	sqloop

	clrc
	rrf	REGA2,f		;Adjust root alignment
	rrf	REGA1,f
	rrf	REGA0,f
	return

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        goto BLANKIT            ;Overflow

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
;        xorwf POINT,W
        btfsc STATUS,Z
        return
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return			;Positive

;Negate REGA
;Used by chksgna, multiply, divide, mod, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide, mod

chksgnb	rlf	REGB3,w
	skpc
	return			;Positive

;Negate REGB
;Used by chksgnb, subtract, multiply, divide, mod

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGB and REGA
;Used by sqrt

clrba	clrf	REGB0
	clrf	REGB1
	clrf	REGB2
	clrf	REGB3

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

;Add REGB to REGA (Unsigned)
;Used by add, multiply,

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incfsz	REGB3,w
	addwf	REGA3,f
	return


;*** SIGNED SUBTRACT ***
;REGA - REGB -> REGA
;Return carry set if overflow

subtract
	call	negateb		;Negate and add
	skpnc
	return			;Overflow

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add	movf	REGA3,w		;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

;*** 32 BIT SIGNED DECIMAL TO BINARY ***
;Decimal DIGIT1 thro DIGIT(X) & DSIGN -> REGA
;Set DSIGN = 0 for positive, DSIGN = 1 for negative values
;Most significant digit in DIGIT1
;Enter this routine with digit count in w register
;Return carry set if overflow
;Uses FSR register

dec2bin	movwf	MTEMP		;Save digit count

	movlw	D'32'		;Outer bit loop counter
	movwf	MCOUNT

d2blp1	movlw	DIGIT1-1	;Set up pointer to MSD
	movwf	FSR
	movf	MTEMP,w		;Inner digit loop counter
	movwf	DCOUNT

	movlw	D'10'
	clrc			;Bring in '0' bit into MSD

d2blp2	incf	FSR,f
	skpnc
	addwf	INDF,f		;Add 10 if '1' bit from prev digit
	rrf	INDF,f		;Shift out LSB of digit

	decfsz	DCOUNT,f	;Next L.S. Digit
	goto	d2blp2

	rrf	REGA3,f		;Shift in carry from digits
	rrf	REGA2,f
	rrf	REGA1,f
	rrf	REGA0,f

	decfsz	MCOUNT,f	;Next bit
	goto	d2blp1

	movf	INDF,w		;Check for overflow
	addlw	0xFF
	skpc
	rlf	REGA3,w
	skpnc
	return

	btfsc	DSIGN,0		;Check result sign
	call	negatea		;Negative
	return

SHOWDIG1: movf DIGIT1,W
          call LCDOUT
SHOWDIG2: movf DIGIT2,W
          call LCDOUT
SHOWDIG3: movf DIGIT3,W
          call LCDOUT
SHOWDIG4: movf DIGIT4,W
          call LCDOUT
SHOWDIG5: movf DIGIT5,W
          call LCDOUT
SHOWDIG6: movf DIGIT6,W
          call LCDOUT
SHOWDIG7: movf DIGIT7,W
          call LCDOUT
SHOWDIG8: movf DIGIT8,W
          call LCDOUT
SHOWDIG9: movf DIGIT9,W
          call LCDOUT
SHOWDIG10: movf DIGIT10,W
          call LCDOUT
          return

;****************


; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ; according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
          ; This routine is entered with W holding the eeprom byte address at
          ; which data is to be stored. The data to be stored is held in
          ; PROMVAL, which is located in both pages at or above $70

SETPRM: BANK1
        movwf EEADR     ; copy W into EEADR to set eeprom address
        movf PROMVAL,W  ; get data value from PROMVAL and hold in W
        movwf EEDATA    ; copy W into eeprom data byte register
        bsf EECON1,WREN ; enable write flag

MANUAL: movlw $55       ; these lines cause the action required by
        movwf EECON2    ; by the eeprom to store the data in EEDATA
        movlw $AA       ; at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ; set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ; wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR1,EEIF   ; clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x devices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ; This routine is entered with W holding
                        ; the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ; copy W into EEADR to set eeprom address
        bsf EECON1,RD   ; enable read flag
        movf EEDATA,W   ; read eeprom data now in EEDATA into W
        BANK0
        return

; ***********

SETMINFORCE:
        call LCD21
        clrf LOOP       ; clear loop
LCDMS3: movf LOOP,W     ; get table address
        call MESSAG3    ; get message letter
        call LCDOUT     ; show it
        incf LOOP,F     ; inc loop
        btfss LOOP,3    ; has last LCD letter been sent?
        goto LCDMS3     ; no, repeat for next

        movf STOREFREQMSB,W
        movwf FREQMINMSB
        movwf PROMVAL
        movlw 4
        call SETPRM
        movf STOREFREQLSB,W
        movwf FREQMINLSB
        movwf PROMVAL
        movlw 5
        call SETPRM
        call SHOWMINMAX
        return

SETMAXFORCE:
        call LCD21
        clrf LOOP       ; clear loop
LCDMS4: movf LOOP,W     ; get table address
        call MESSAG4    ; get message letter
        call LCDOUT     ; show it
        incf LOOP,F     ; inc loop
        btfss LOOP,3    ; has last LCD letter been sent?
        goto LCDMS4     ; no, repeat for next

        movf STOREFREQMSB,W
        movwf FREQMAXMSB
        movwf PROMVAL
        movlw 2
        call SETPRM
        movf STOREFREQLSB,W
        movwf FREQMAXLSB
        movwf PROMVAL
        movlw 3
        call SETPRM
        call SHOWMINMAX
        return

; ************

SHOWMINMAX:
        movf FREQMAXMSB,W  ; get freq range
        movwf REGA1
        movf FREQMAXLSB,W
        movwf REGA0

        movf FREQMINMSB,W
        movwf REGB1
        movf FREQMINLSB,W
        movwf REGB0
        clrf REGA2
        clrf REGA3
        clrf REGB2
        clrf REGB3
        call SUBTRACT

        movf REGA1,W
        movwf FREQRANGEMSB
        movf REGA0,W
        movwf FREQRANGELSB
        movlw ' '
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw ' '
        call LCDOUT

CHKPORT: movf PORTA,W   ; wait until switches released
        andlw %00000011
        btfss STATUS,Z
        goto CHKPORT
        call PAUSIT
        call CLRLINE2
        bcf T1CON,0     ; stop T1 external counter 
        clrf TMR1L
        clrf TMR1H
        bsf T1CON,0     ; start T1 external counter 
        clrf TMR0
        bcf INTCON,2
        movf TIMERVAL,W
        movwf CLKCNT
        movlw %11001111 ; show blades
        call LCDLIN
        movf BLADES,W
        iorlw 48
        call LCDOUT
        return

GETFACTS: movlw 0        ; get stored facts from EEPROM
        call PRMGET
        movwf BLADES
        movlw 1
        call PRMGET
        movwf UNITSTYPE  ; not used
        movlw 2
        call PRMGET
        movwf FREQMAXMSB
        movwf REGA1
        movlw 3
        call PRMGET
        movwf FREQMAXLSB
        movwf REGA0
        movlw 4
        call PRMGET
        movwf FREQMINMSB
        movwf REGB1
        movlw 5
        call PRMGET
        movwf FREQMINLSB
        movwf REGB0
        movlw 6
        call PRMGET
        movwf MAXFORCEMSB
        movlw 7
        call PRMGET
        movwf MAXFORCELSB

        clrf REGA2        ; subtract min from max to get range
        clrf REGA3
        clrf REGB2
        clrf REGB3
        call SUBTRACT
        movf REGA1,W
        movwf FREQRANGEMSB
        movf REGA0,W
        movwf FREQRANGELSB
        return

; *************

       .org $2100      ; data eeprom address
        DE 3           ; blade count
        DE 0           ; not used
        DE HIGH 8409   ; highest coil freq MSB  ] vals as found with prototype
        DE LOW  8409   ; highest coil freq LSB  ]
        DE HIGH 7554   ; lowest coil freq MSB   ]
        DE LOW  7554   ; lowest coil freq LSB   ]
        DE HIGH 1000   ; starting max weight (1kg) MSB
        DE LOW  1000   ; starting max weight (1kg) LSB

        END



