;*****************************************************************************        
;
;   Module:     main.asm
;               
;   Author:     Mike Hibbett, mikehibbett@oceanfree.net 
;                                                                  
;   Version:    1.0 11/10/05                                              
;
;               Main source file for the bootloader
;               This file contains only framework code that enables a bootloader
;               to be implemented. All application code starts from 0x0600, and
;               gets called once the bootloader has completed.
;
;               Unless you intend to change the bootloader or memory layout
;               this file should not be edited.
;
;*****************************************************************************        


    ; Pull in the various constants used by the bootloader
    
    #include "blconst.inc"    
    
    ; The settings for config bits are so compilcated now
    ; they deserve their own file.
    
    #include "config.inc"

    

;*****************************************************************************        
;
;   Function :  Reset vector
;               Hardware entry point to the code
;               This vector is also used for soft resets in the event of 
;               abnormal events
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
    
    ORG    0

    call    Bootloader
    goto    Startup



;*****************************************************************************        
;
;   Function :  Interrupt vectors
;               Hardware entry point for interrupts
;               This vectors handles all external and internal interrupts;
;               As we have a bootloader, these transfer control into the
;               application interrupt vector address by a simple branch.
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
    
    ORG    0x08
 
    bra  IntVecHigh

    ORG    0x18
 
    bra  IntVecLow
    
    
    ; Ensure that the bootloader code is at the start of memory,
    ; just after the PIC vectors.
    
    #include "bootload.inc"


    ; User code starts at 0x600 - This is the first flash address that the boot
    ; loader PC application will write to.
    
    ORG     0x600

    ; The symbols Startup,IntVecLow and IntVecHigh must always be at 
    ; the same locations specified here (and in interrupts.inc), since the location 
    ; jumped to by the reset or interrupt system must always be the same - the 
    ; application code, starting after the code in interrupts.inc, can be anywhere.
    
Startup
    ; Goto the main application. 
    goto    Main
    
    ORG     0x604

IntVecLow
    goto    UserIntVecLow 
    
    
    
;*****************************************************************************        
;
;   Function :  IntVecHigh
;               The re-mapped fast interrupt vector goes at 0x608, and
;               the re-mapped low level interrupt handler follows it.
;               The actual code is in interrupts.inc, to allow this file 
;               to remain simple and unedited.
;
;   Input:      None.
;
;   Output:     Using the FAST directive to update registers automatically
;
;*****************************************************************************        

    ORG     0x608

    #include "interrupts.inc"       ; Must always follow the ORG 0x608 statement
                                    ; It contains the IntVecHigh code

    #include "app.inc"              ; This file contains the users main code,
                                    ; and has include references to any other
                                    ; user files.
    
    
    
    END                ; End of program
    