; Smart Kart SK-1 EPE Oct 04 - Owen Bishop

	list	P=16F84 	;SK1-3: (1)Line follower.

        __config        h'3FF3'
 				;(2) Line follower, with stations.
 				;(3) Playpen game.
 				;(4) Maze runner.
status			equ	03h
porta			equ	05h
portb			equ	06h
trisa			equ	05h
trisb			equ	06h
w			equ	00h
f			equ	01h
z			equ   	02h
RP0			equ   	05h
delay0 			equ 	0Ch
delay1 			equ 	0Dh
delay2 			equ 	0Eh
random 			equ 	0Fh
bitn 			equ 	10h
bitm 			equ 	11h
xorout 			equ 	12h
branches 		equ	13h
oldrand 		equ 	14h

		goto start
		org 0004h
		goto start

start:
	bsf status, RP0		;Select page 1.
 	clrf trisa		;RA0 to RA4 as outputs.
 	movlw B'11110000'
 	movwf trisb		;RB4 to RB7 as as inputs.
 	clrwdt
 	bcf status, RP0		;Select page 0.

 	clrf porta		;Clear Port A.
 	clrf portb		;Clear Port B.
 	movlw 0F0h
 	call pause2		;Call Pause2.
 	btfsc portb, 5
 	goto s2on
 	btfsc portb, 4
 	goto behave2
 	goto behave1
s2on:
 	btfsc portb, 4
 	goto behave4
 	goto behave3

behave1:	 
	bsf portb, 0		;Headlamp on.
 	movlw B'00001010'	;Both motors forward.
 	movwf porta
 	movlw 02h
 	call pause2		;Call Pause2.
 	bcf portb, 0		;Headlamps off.
 	clrf porta		;Stop.
tryagain: 
	btfss portb, 6		;Skip if veering right or on line.
 	goto crossing		;If veering left or crossing.
	btfss portb, 7		;Skip if on line.
 	goto spinl		;Is veering right, so correct it.
 	goto behave1		;On line (or free); go forward.
crossing:
 	btfss portb, 7		;Skip if veering left.
 	goto reverse		;Is crossing; back up and try again.
 	goto spinr		;Is veering left, so correct it.
spinl:
 	movlw B'00001001'	;Spin left (right motor fwd)..
 	movwf porta
 	bsf portb, 2		;Left indicator.
 	movlw 03h
 	call pause2		;Call Pause2.
 	bcf portb, 2
 	clrf porta
 	goto behave1
spinr:
	movlw B'00000110'	;Spin right (left motor fwd).
 	movwf porta
 	bsf portb, 3		;Right indicator.
 	movlw 03h
 	call pause2		;Call Pause2.
 	bcf portb, 3
 	clrf porta
 	goto behave1
reverse:
	movlw B'00000101'	;Both motors in reverse.
 	movwf porta
 	bsf portb, 1		;Reversing led and bleeper.
 	movlw 08h
 	call pause2		;Call Pause2.
 	bcf portb, 1		;LED and bleeper off.
 	movlw B'00001001'	;Spin left.
 	movwf porta
 	movlw 08h		;Spin slightly left.
 	call pause2
 	clrf porta
 	goto tryagain		;Re-read inputs

behave2:
	bsf portb, 0		;Headlamp on.
 	movlw B'00001010'	;Both motors forward.
 	movwf porta	 	
	movlw 02h
 	call pause2
 	bcf portb, 0		;Headlamp off.
 	clrf porta		;Stop.
 	btfss portb, 6		;Skip if veering right or on line.
 	goto station		;If veering left or at station.
	btfss portb, 7		;Skip if on line.
	goto spinl2		;Is veering right, so correct it.
 	goto behave2		;On line (or free); go forward.
station:
	btfss portb, 7		;Skip if veering left.
 	goto break		;Is at station.
 	goto spinr2		;Is veering left, so correct it.
spinl2:
	movlw B'00001001'	;Spin left (right motor forward).
 	movwf porta
 	bsf portb, 2		;Left indicator.
 	movlw 03h
 	call pause2
 	bcf portb, 2
 	clrf porta
 	goto behave2
spinr2:
	movlw B'00000110'	;Spin right (left motor forward).
 	movwf porta
 	bsf portb, 3		;Right indicator.
 	movlw 03h
 	call pause2
 	bcf portb, 3
 	clrf porta
 	goto behave2
break:
	clrf porta		;Stop motors.
 	bsf portb, 0		;Headlamp on.
	bsf portb, 1		;Reverse lamp/bleeper on.
 	movlw 025h
 	call pause2
 	bcf portb, 0		;Headlamp off.
	bcf portb, 1		;Reverse lamp/bleeper off.
 	bsf portb, 2		;Left indicator on.
	bsf portb, 3		;Right indicator on.
 	movlw 0F0h
 	call pause2
 	bcf portb, 2		;Left indicator off.
 	bcf portb, 3		;Right indicator off.
 	bsf portb, 1		;Reverse lamp/bleeper on.
 	bsf portb, 0		;Headlamp on.
	movlw 025h
 	call pause2
	bcf portb, 0		;Headlamp off.
 	bcf portb, 1		;Reverse lamp/bleeper off.
 	movlw B'00001010'	;Forward.
 	movwf porta
 	movlw 08h		;Far enough to clear strip.
 	call pause2
 	clrf porta		;Stop.
 	goto behave2		;Back to normal.

behave3:
	bsf portb, 0		;Headlamp on.
 	movlw B'00001010'	;Both motors forward.
 	movwf porta
 	movlw 02h
 	call pause2
 	bcf portb, 0		;Headlamps off.
 	clrf porta		;Stop.
 	btfss portb, 6		;Skip if free or wall right.
 	goto wallal		;If wall ahead or left.
 	btfss portb, 7		;Skip if free.
 	goto turnl		;Wall right so avoid it.
 	goto behave3		;Free so carry on.
wallal:
	btfss portb, 7		;Skip if wall left.
 	goto backup		;Wall ahead so back up.
 	goto turnr		;Wall left so avoid it.
turnl:
 	movlw B'00000101'	;Reverse.
 	movwf porta
 	bsf portb, 1		;Reverse lamp and bleeper.
 	movlw 08h
 	call pause2
 	bcf portb, 1
 	clrf porta		;Stop.
 	movlw B'00001001'	;Spin left.
 	movwf porta
 	movlw 050h
 	call pause2
 	clrf porta		;Stop.
 	goto behave3
turnr:
 	movlw B'00000101'	;Reverse.
 	movwf porta
 	bsf portb, 1		;Reverse lamp and bleeper.
 	movlw 08h
 	call pause2
 	bcf portb, 1
 	clrf porta		;Stop.
 	movlw B'00000110'	;Spin right.
 	movwf porta
 	movlw 050h
 	call pause2
 	clrf porta		;Stop.
 	goto behave3
backup:
 	movlw B'00000101'	;Both motors reverse.
 	movwf porta
 	bsf portb, 1		;Reverse lamp and bleeper.
 	movlw 0Eh
 	call pause2
 	bcf portb, 1		;Lamp and bleeper off.
 	movlw B'00001001'	;Spin left.
 	movwf porta
 	movlw 0F0h		;Long spin.
 	call pause2
 	clrf porta		;Stop spin.
 	bsf portb, 1		;Bleeper on.
 	movlw 02h
 	call pause2
 	bcf portb, 1		;Bleeper off.
 	movlw 05h
 	call pause2
 	bsf portb, 1		;Bleeper on.
 	movlw 04h
 	call pause2
 	bcf portb, 1		;Bleeper off.
 	goto behave3		;New direction.

behave4:
 	movf random, w		;Previous random.
 	btfsc status, z		;z=0?
 	movlw 0DBh		;Seed.
 	movwf random		;Seed or previous random, if not 0.
 	clrf xorout		;Clear random output.
 	movlw 04h		;Set branches counter
 	movwf branches		;to 4 branches.
nextgo:
 	clrf bitn		;Clear registers.
 	clrf bitm
 	btfss branches, 2	;Test for value 4
 	goto shiftreg		;If not 4.
 	movf random, w
 	movwf oldrand		;Copy random at start.
shiftreg:
 	btfss random, 5		;Is n=1?
 	goto findm		;No: now find m.
 	bsf bitn, 0		;Yes: make bitn=1.
findm:
 	btfss random, 6		;Is m=1?
 	goto xorem		;No: go to 'logic gate'.
 	bsf bitm, 0		;Yes: make bitm=1.
xorem:
 	movf bitn, w		;Load bitn into w.
 	xorwf bitm, w		;xor with bitm.
 	movwf xorout		;Result to output.
 	addlw 0FFh		;Set carry if w=1.
 	rlf random, f		;New random for next go.
 
fwd:
 	bsf portb,0		;Headlamp on.
 	movlw B'00001010'	;Both motors forward.
 	movwf porta
 	movlw 02h
 	call pause2
 	bcf portb, 0		;Headlamps off.
 	clrf porta		;Stop.
 	btfss portb, 6		;Skip if veering right or on line.
 	goto split		;If veering left or on a split.
 	btfss portb, 7		;Skip if on line.
 	goto spinl4		;Is veering right, so correct it.
 	goto fwd		;On line; go forward.
split:
 	btfss portb, 7		;Skip if veering left.
 	goto branch		;To branch left or right.
 	goto spinr4		;Is veering left, so correct it.
spinl4:
 	movlw B'00001001'	;Spin left.
 	movwf porta
 	bsf portb, 2		;Left indicator.
 	movlw 03h
 	call pause2
 	bcf portb, 2
 	clrf porta
 	goto fwd
spinr4:
 	movlw B'00000110'	;Spin right.
 	movwf porta
 	bsf portb, 3		;Right indicator.
 	movlw 03h
 	call pause2
 	bcf portb, 3
 	clrf porta
 	goto fwd
branch:
 	decfsz branches, f	;At a terminus?
 	goto lorr		;Turn left or right?
 	goto learn
lorr:
 	btfss xorout, 0		;To turn right? (bit = 1).
 	goto branchl		;No: so branch left.
 	goto branchr		;Yes: so branch right. 
branchl:
	movlw B'00001001'	;Spin left, 35 degrees.
 	movwf porta
 	bsf portb, 2		;Left indicator.
 	movlw 06h
 	call pause2
 	bcf portb, 2
 	goto newbranch
branchr:
 	movlw B'00000110'	;Spin right, 35 degrees.
 	movwf porta
 	bsf portb, 3		;Right indicator.
 	movlw 06h
 	call pause2
 	bcf portb, 3
newbranch:
 	movlw B'00001010'	;Forward.
 	movwf porta
 	movlw 08h
 	call pause2		;Start along new branch.
 	clrf porta		;Stop.
 	goto nextgo		;To get new random for next branch.

learn:
 	bsf portb, 1		;Bleep.
 	movlw 01Fh
 	call pause2
 	bcf portb, 1
 	movlw 0F0h		;Time to clear switch (to off).
 	call pause2
 	movf random, w		;store random.
 	btfss portb, 4		;Test input from Switch 1.
 	movf oldrand, w		;To save oldrand in
 	movwf random		;place of current random.
 	movlw 04h		;Reset branches.
 	movwf branches
 	goto nextgo

finish: goto finish



pause2:
 	movwf delay2		;Already has value in w.
dloop2:
 	call pause1
 	decfsz delay2, f
 	goto dloop2
 	return
pause1:
 	movlw 1h
 	movwf delay1
dloop1:
 	call pause0
 	decfsz delay1, f
 	goto dloop1
 	return
pause0:
 	movlw 080h
 	movwf delay0
dloop0:
 	decfsz delay0, f
 	goto dloop0
 	return

	END

