
;**********************************************************************
;                                                                     *
;    Filename:	    xmixer.asm                                        *
;    Date:                                                            *
;    File Version:                                                    *
;                                                                     *
;    Author:        M.Bensch                                          *
;    Company:                                                         *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes: aileron/elevator or v-tail mixer for r/c planes		      * 	
;			uses pic16f84@4MHZ                                        *
;			pulse resolution 1 microsecond (1000 steps\10 bits)       * 
;			if no pulses are present the finder output goes high      * 
;			for connection of buzzer circuit or similar               *
;			if bat input goes low for 2,5 seconds                     *
;			the led output activates with mark to space               * 
;			set by equ statements, frequency of 1 count               *
;			is input pulse frequency(50 HZ)                           *
;			mixing factor (in percent) settable via two pushbuttons   *
;			increment is 5 units                                      *
;			setting saved in eeprom for next power-up                 *                                        
;                                                                     *
;**********************************************************************


	list      p=16F84A            ; list directive to define processor
	#include <p16F84A.inc>        ; processor specific variable definitions

	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC


#define	out1 PORTA,00
#define out2 PORTA,01
#define bat PORTA,02	
#define inc PORTB,00
#define dec PORTB,01
#define finder PORTB,02
#define led PORTB,03
#define	in1 PORTB,04
#define in2 PORTB,05

;;;;;;;;;pulse timings in microseconds

plscenter	equ 	.1500
hilimit	    equ		.2050
lolimit		equ 	.950

;;;;;;;;;maximum and minimum multiplying factor setting

mulmax		equ 	.100
mulmin		equ 	.50

;;;;;;;;;flasher hi and lo times

flashhi		equ 	.5
flashlo		equ		.50

;;;;;;;;;define tris bits 

trisbitsa	equ b'00100'
trisbitsb	equ b'11110011'

;;;;;;;;;ram allocation

aargb0		equ 0c
aargb1  	equ 0d
bargb0  	equ 0e
bargb1  	equ 0f
sp      	equ 10 	        ;stack pointer
sptemp  	equ 11
temp  		equ 12
temp1   	equ 13
temp2   	equ 14
temp3   	equ 15
temp4   	equ 16
loopcount 	equ 17
ch1h		equ 18	;counted values 
ch1l		equ 19	;of pulses
hitrack1  	equ 1a	;ch1l, hitrack1, ch2l and hitrack2
ch2h		equ 1d	
ch2l		equ 1b	;must be consecutive files
hitrack2	equ 1c
store1h		equ 1e	;files used for calculations 
store1l		equ 1f	;to leave channel files uncorrupted
store2h		equ 20
store2l		equ 21
hitrack		equ 22	;hitrack used to determine hi byte of counted value of pulse
plscnt1		equ 23	;count file for output pulse(units of ten)
extra1		equ 24	;count file for output pulse(extra units)
plscnt2		equ 25
extra2		equ 26
flags		equ 27	;bit flags
  go1		equ 00	;count is complete
  sign		equ 04	;set if value of aarg is negative 
  lobat 	equ 07	;set if bat input is active for more than 2,5 seconds
mulfac		equ 28	;percentage mixing ratio
batcnthi	equ 29	;timer counters for latency in
batcntlo 	equ 2a 	;lobat or bat ok detect
flashcnthi	equ 2b	;count file for on time of led in case of lobat
flashcntlo	equ 2c	;count file for off time
findcnt1	equ 2d	;no pulse timer counter
findcnt		equ 2e
delcnt  	equ 2f	;count files for delays
delcnt1		equ 30

		ORG		0003
		goto	ini
		ORG		0004

isr		btfsc	in1				;channel1 hi?
		goto	meas2			;no, go to test channel2
		clrf	TMR0			;clear count files
		clrf	hitrack
		movf	PORTB,f			;end mismatch
		bcf 	INTCON,RBIF		;clear flag
		bsf		STATUS,RP0	
		movlw	b'00001000'		;start internal clock 
		movwf	OPTION_REG	
		bcf		STATUS,RP0
		retfie
meas2	btfsc	in2				;channel2 hi?
		goto	meas21			;yes
		bsf		STATUS,RP0
		movlw	b'00101000'		;stop internal clock
		movwf	OPTION_REG	
		bcf		STATUS,RP0
		movf	TMR0,w			;save TMRO and hitrack
		movwf	ch1l     	
		movf	hitrack,w
		movwf	hitrack1
		movf	PORTB,f			;end mismatch
		bcf 	INTCON,RBIF		;clear flag
		clrf	TMR0	
		clrf	hitrack
		bsf		STATUS,RP0
		movlw	b'00001000'		;start internal clock 
		movwf	OPTION_REG	
		bcf		STATUS,RP0
		retfie
meas21	bsf		STATUS,RP0	
		movlw	b'00101000'		;stop internal clock
		movwf	OPTION_REG	
		bcf		STATUS,RP0
		movf	TMR0,w			;save TMRO and hitrack
		movwf	ch2l     	
		movf	hitrack,w
		movwf	hitrack2
		bsf		flags,go1		;set end of pulses bit
		movf	PORTB,f			;end mismatch
		bcf 	INTCON,RBIF		;clear flag
		retfie


ini		clrf 	PORTA		
		clrf	PORTB
		bsf		STATUS,RP0		;page1
		movlw	trisbitsb
		movwf	PORTB
		movlw	trisbitsa
		movwf	PORTA
		movlw	b'00001000'		;prescaler 0:0, pull-ups enabled
		movwf	OPTION_REG
		bcf		STATUS,RP0		;page0
		clrf 	PORTA
		clrf	PORTB
		clrf	flags
		clrf	findcnt1
		clrf 	findcnt	
		clrf	batcnthi
		clrf 	batcntlo
		movlw	flashlo			;flash off time
		movwf	flashcntlo	
		movlw	flashhi			;flash on time
		movwf	flashcnthi		;units of 1/(pulse frequency)
		movlw	.0				;eeprom adress of mulfac
		call	eeread
		movwf	mulfac			;mulfac now in ram
		call	mulchk			;ensure valid value
		bsf		led				;flash led to indicate good start up
		call	del500			;start up delay
		call	waitpls			;wait to ensure clean start of interupts
		bcf		led	

;;;;;;;;main program loop

main	call	get12			;get values of pulselengths
		call	eval			;evaluate and output mixed pulses
		call	butnbat			;check buttons, battery and finder STATUS
		goto	main

;;;;;;;;get 12-bit values of pulse lengths 
;;;;;;;;channel 1 and 2 into ch1 and ch2

get12	movlw	b'10001000'		;enable interupt on change
		movwf	INTCON
		clrf	findcnt1
		clrf	findcnt

waitch1	decfsZ	findcnt1,f		;count for finder
		goto	waitch2
		decf	findcnt,f	
		btfsc	STATUS,Z
		bsf		finder			;activate finder
waitch2	incf	hitrack,f	
		btfsc	flags,go1		;both channels in?
		goto	getout			;yes
		nop						;right loop length
		nop						;for incremet of hitrack
		nop	
		nop
		nop
		nop
		nop
		nop	
		goto	waitch1

getout	clrf	INTCON			;disable interupt
		bcf		flags,go1   	;reset for next measuring
		return

;;;;;;;;evaluate ch1 and ch2 and produce 
;;;;;;;;output pulses accoRDingly

;;;;;;;;find hi byte of pulse values from hitrack and lo byte

eval	movlw	.3				;pulse minimum 768 microsec
		movwf	hitrack
		movlw	ch1l
		movwf	FSR
		call	eval01			;find hi byte
		movf	hitrack,w
		movwf	aargb1			;offset correct
		movf	ch1l,w
		movwf	aargb0
		movlw	.6
		movwf	bargb0
		clrf	bargb1
		call	subtract
		movf	aargb1,w
		movwf	ch1h
		call	acc2st1 	;and store
eval02	incf	FSR,f
		movlw	.3			;same for channel2 value
		movwf	hitrack
		call	eval01
		movf	hitrack,w
		movwf	aargb1		;offset correct
		movf	ch2l,w
		movwf	aargb0
		movlw	.10
		movwf	bargb0
		clrf	bargb1
		call	add
		movf	aargb1,w
		movwf	ch2h
		call	acc2st2		;and store
		call	acc2ch2

;;;;;;;;mixing math

evalmix	call	st12a   	;ch1 value to accumulator
		call	load152		;1500 into acc2
		call	subtract	;ch1 - 1500 in acc
		bcf		flags,sign	;store sign of result
		btfss	STATUS,C
		bsf		flags,sign	;and get absolute value
		btfsc	flags,sign
		call	negacc
		movf	mulfac,w
		movwf	bargb0
		clrf	bargb1		;multiply difference
		call	multiply	;with multiplying factor
		movlw	.100
		movwf	bargb0
		clrf	bargb1		;and divide by hundred
		call	divide		;to get percentage
		call	load152		;1500 into acc2
		btfss	flags,sign
		call	negacc
		call	add
		call	acc2st2		;save result to store2
		call	acc2st1		;and store1
		call	ch22a		;channel2 to accumulator
		call	load152		;1500 into acc2
		call	subtract	;ch2 - 1500 in acc
		bcf		flags,sign
		btfss	STATUS,C
		bsf		flags,sign
		btfsc	flags,sign	;get absolute value
		call	negacc
		movf	mulfac,w	
		movwf	bargb0
		clrf	bargb1
		call	multiply
		movlw	.100
		movwf	bargb0
		clrf	bargb1
		call	divide
		call	saveacc		;save accumulator
		call	st12a2		;store1 to accumulator2
		btfsc	flags,sign	;add
		call	negacc
		call	add
		call	acc2st1		;save result to store1
		call	st22a		;store2 to accumulator
		call	getacc  	;restore accumulator2
		btfss	flags,sign	;subtract
		call	negacc2
		call	add
		call	acc2st2		;save result in store2

;;;;;;;;check if resultant pulses are within 
;;;;;;;;range of 800-2200 microseconds

chckpls	call	st12a		
		call	load22		
		call	subtract	
		btfsc	STATUS,C
		call	cor122
		call	st12a
		call	load8
		call	subtract
		btfss	STATUS,C
		call	cor18
		call	st22a		
		call	load22	
		call	subtract	
		btfsc	STATUS,C
		call	cor222
		call	st22a
		call	load8
		call	subtract
		btfss	STATUS,C
		call	cor28

;;;;;;;;calculations for output count files

eval1	call	st12a
		movlw	.4			;offset correct
		movwf	bargb0
		clrf	bargb1
		call	add
		movlw	.10			;10 to bargb0
		movwf	bargb0
		clrf	bargb1
		call 	divide		;number of tens in acc
		movf	aargb0,w	;move to cnt1
		movwf	plscnt1		
		decf	plscnt1,f
		movf	temp3,w		;remainder to extra
		sublw	.9
		movwf	extra1
		movlw	.10
		addwf	extra1,f
	
eval2	call	st22a
		movlw	.2			;offset correct
		movwf	bargb0
		clrf	bargb1
		call	subtract
		movlw	.10			;10 to bargb0
		movwf	bargb0
		clrf	bargb1
		call 	divide		;number of tens in acc
		movf	aargb0,w	;move to cnt2
		movwf	plscnt2		
		decf	plscnt2,f
		movf	temp3,w		;remainder to extra
		sublw	.9
		movwf	extra2
		movlw	.10
		addwf	extra2,f
		goto	pls1
		nop					;these nops ensure both pls
		nop					;routines in second page of 
		nop					;program memory to avoid
		nop					;page crossing problems 
		nop					;with addwf plc,f statement
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop

;;;;;;;;output pulses

pls1	bsf		out1
pls11	call	plsdel
	  	decfsZ	plscnt1,f
		goto	pls11
		movlw	.1
		movwf	PCLATH
		movf	extra1,w
		addwf	PCL,f
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		bcf		out1		;channel1 low
pls2	bsf		out2
pls21	call	plsdel
		decfsz	plscnt2,f
		goto	pls21
		movlw	.1
		movwf	PCLATH
		movf	extra2,w
		addwf	PCL,f
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		bcf		out2		;channel2 low
		return	

plsdel	nop
		nop
		nop
		return

eval01	movf	INDF,w			;ch1l/ch2l
		movwf	aargb0
		movf	hitrack,w
		movwf	aargb1
		rrf		aargb1,f		;divide	by 16
		rrf		aargb0,f
		rrf		aargb1,f
		rrf		aargb0,f
		rrf		aargb1,f
		rrf		aargb0,f
		rrf		aargb1,f
		rrf		aargb0,f
		clrf	aargb1
		incf	FSR,f
		movf	INDF,w			;hitrack1/2
		movwf	bargb0
		clrf	bargb1
		call	subtract
		btfss	STATUS,C
		call	negacc
		movlw	.7                
		movwf	bargb0
		clrf	bargb1
		call	subtract
		btfss	STATUS,C
		return
		incf	hitrack,f
		decf	FSR,f			;back to address ch1/2
		goto	eval01

;;;;;;;;checks buttons, battery STATUS and finder
	
butnbat	btfss	inc
		goto 	incmul
		btfss 	dec
		goto 	decmul
but1	bcf		finder			;if we're here, pulses are coming and finder off
		btfsc	flags,lobat
		call	flash			;flash L.E.D.	
		btfss	bat				;test voltage
		goto 	bathi
	
batlo	decfsz	batcntlo,f
		return
		clrf	batcnthi	
		bsf		flags,lobat		;flasher on
		return

bathi	decfsz	batcnthi,f
		return
		clrf	batcntlo	
		bcf		flags,lobat		;flasher off
		bcf		led				;led off
		return

flash	btfsc	led
		goto	flashon
		decfsZ	flashcntlo,f	;off time over?
		return
		movlw	flashlo			;yes
		movwf	flashcntlo		;reset file and
		bsf		led				;switch on 
		return
flashon	decfsZ	flashcnthi,f	;on time over?
		return
		movlw	flashhi			;yes
		movwf	flashcnthi		;reset file and 
		bcf		led				;switch off
		return

incmul	bsf		led				;led on
		call	debdel			;debounce
		movf	mulfac,w
		addlw	.5
		movwf	mulfac
		call	mulchk			;check if new value is within parameters
		clrf	EEADR			;adress 0 in eeprom
		call 	eewrite
incout	btfss	inc				;wait for button release
		goto	incout
		call	debdel			;debounce
		bcf		led				;led off
		call	waitpls
		goto 	but1		

decmul	bsf	led
		call	debdel			;debounce
		movlw	.5
		subwf	mulfac,w
		movwf	mulfac
		call	mulchk			;check if new value is within parameters
		clrf	EEADR			;adress 0 in eeprom
		call 	eewrite
decout	btfss	dec				;wait for button release
		goto	decout
		call	debdel			;debounce
		bcf		led
		call	waitpls
		goto 	but1		
	
;;;;;;;;checks if new mulfac value is within parameters 
;;;;;;;;and corrects if necessary

mulchk	sublw	mulmax
		btfss	STATUS,C
		goto	cormax
		movf	mulfac,w
		sublw	mulmin-1
		btfsc	STATUS,C
		goto 	cormin
		return

cormax	movlw	mulmax
		movwf	mulfac
		return
cormin	movlw	mulmin
		movwf	mulfac
		return

;;;;;;;;waits for channel2 to be 
;;;;;;;;low to avoid false interupt

waitpls	btfsc	in2				;wait for channel2
		goto	waitpls			;to become low
wait2	btfss	in2				;(low from receiver,
		goto	wait2			;high in circuit)
		return

;;;;;;;;call to here if pulse lengths are beyond
;;;;;;;;boundaries set by hilimit and lolimit

cor122	movlw	hilimit>>8
		movwf	store1h
		movlw	hilimit
		movwf	store1l
		return

cor18	movlw	lolimit>>8
		movwf	store1h
		movlw	lolimit
		movwf	store1l
		return

cor222	movlw	hilimit>>8
		movwf	store2h
		movlw	hilimit>>0
		movwf	store2l
		return

cor28	movlw	lolimit>>8
		movwf	store2h
		movlw	lolimit
		movwf	store2l
		return

saveacc	movf	aargb1,w		;saves accumulator to 
		movwf	temp2			;temp 1-2
		movf	aargb0,w	
		movwf	temp1
		return

getacc	movf	temp2,w			;put saved value 
		movwf	bargb1			;to acc 2
		movf	temp1,w
		movwf	bargb0
		return
	
ch22a	movf	ch2h,w			;channel2 value to 
		movwf	aargb1			;accumulator
		movf	ch2l,w
		movwf	aargb0
		return

st12a	movf	store1h,w		;store1 to accumulator
		movwf	aargb1
		movf	store1l,w
		movwf	aargb0
		return
	
st12a2	movf	store1h,w		;store1 to bargb0
		movwf	bargb1
		movf	store1l,w
		movwf	bargb0
		return

st22a	movf	store2h,w		;ch2 to acc
		movwf	aargb1
		movf	store2l,w
		movwf	aargb0
		return

acc2st1	movf	aargb1,w
		movwf	store1h
		movf	aargb0,w
		movwf	store1l
		return

acc2st2	movf	aargb1,w
		movwf	store2h
		movf	aargb0,w
		movwf	store2l
		return

acc2ch2	movf	aargb1,w
		movwf	ch2h
		movf	aargb0,w
		movwf	ch2l
		return

load151	movlw	plscenter>>8
		movwf	aargb1
		movlw	plscenter
		movwf	aargb0
		return

load152	movlw	plscenter>>8
		movwf	bargb1
		movlw	plscenter
		movwf	bargb0
		return

load22	movlw	hilimit>>8
		movwf	bargb1
		movlw	hilimit
		movwf	bargb0
		return

load8	movlw	lolimit>>8
		movwf	bargb1
		movlw	lolimit
		movwf	bargb0
		return
       

clracc2 clrf 	bargb0
        clrf 	bargb1
		return

negacc  comf 	aargb0,f
        comf 	aargb1,f
        goto 	incacc

negacc2 comf	bargb0,f
		comf	bargb1,f
	
incacc2	incfsZ	bargb0,f
		return
        incf 	bargb1,f
        return
        
incacc  incfsZ 	aargb0,f
        return
cah     incf 	aargb1,f
        return

subtract
		call 	negacc2        	;acc=acc+(-acc2)
add  	movf 	bargb0,w
        addwf 	aargb0,f
        btfsc 	STATUS,C
        incf	aargb1,f
        movf 	bargb1,w
        addwf 	aargb1,f
        return

;;;;;;;;divide aarg/barg, result in aarg, remainder in temp3-temp4

divide  call 	prepmd
divi1   clrf 	temp3
        clrf 	temp4
dloop   clrc
        rlf 	temp1,f
        rlf 	temp2,f
        rlf 	temp3,f
        rlf 	temp4,f
        movf 	bargb1,w
        subwf 	temp4,w
        skpZ
        goto 	nochk
        movf 	bargb0,w
        subwf 	temp3,w
nochk   skpc
        goto 	nogo
        movf 	bargb0,w
        subwf 	temp3,f
        btfss 	STATUS,C
        call 	ca8
        movf 	bargb1,w
        subwf 	temp4,f
        bsf 	STATUS,C
nogo    rlf 	aargb0,f
        rlf 	aargb1,f
        decfsZ 	loopcount,f
        goto 	dloop         
        return

;handle ripple carry for subtraction

ca8     movlw 	.255
        addwf 	temp4,f
        return

;;;;;;;;unsigned 8bit/7bit divide routine 

ufxd0807
		clrf	temp
		rlf		aargb0,w
		rlf		temp,f
		movf	bargb0,w
		subwf	temp,f
		rlf		aargb0,f
		movlw	7
		movwf	loopcount
loopu0807
		rlf		aargb0,w
		rlf		temp,f
		movf	bargb0,w
		btfsc	aargb0,00
		subwf	temp,f
		btfss	aargb0,00
		addwf	temp,f
		rlf		aargb0,f
		decfsZ	loopcount,f
		goto	loopu0807
		btfss	aargb0,00
		addwf	temp,f
		return

;;;;;;;;multiply

multiply
		call 	prepmd
mulloop btfss 	bargb0,0
        goto 	noadd
        movf 	temp1,w
        addwf 	aargb0,f
        skpnc
        call 	cah
nm1     movf 	temp2,w
        addwf 	aargb1,f
noadd   rlf 	temp1,f
        rlf 	temp2,f
        bcf 	temp1,0
        rrf 	bargb1,f
        rrf 	bargb0,f
        decfsz 	loopcount,f
        goto 	mulloop
        return

prepmd  movlw 	.16	    	;woRDsiZe in bits
        movwf 	loopcount
        movf 	aargb0,w
  		movwf 	temp1
        movf 	aargb1,w
        movwf 	temp2
clracc	clrf	aargb0
		clrf	aargb1
		return
        
;;;;;;;;eeprom write routine for mulfac
;;;;;;;;address must already be set

eewrite  movf	mulfac,w
		 movwf 	EEDATA
   	     bsf  	STATUS,RP0     	;only used in inrpt
         bsf 	EECON1,WREN     ;routine
         movlw 	h'55'
         movwf 	EECON2
         movlw 	h'aa'
         movwf 	EECON2
         bsf 	EECON1,WR
chkwrt   btfss 	EECON1,EEIF   	;wait for end of write
         goto 	chkwrt
         bcf 	EECON1,EEIF     ;clear eeprom interupt flag
         bcf 	STATUS,RP0
         movf 	EEDATA,w  	;write verify
    	 bsf  	STATUS,RP0
    	 bsf  	EECON1,RD
    	 bcf  	STATUS,RP0
    	 subwf 	EEDATA,w
    	 btfss  STATUS,Z
    	 goto 	eewrite 	;retry
	 	return              	;retfie does it

;;;;;;;eeprom read routine,w contains address to read

eeread   movwf 	EEADR
         bsf 	STATUS,RP0
         bsf 	EECON1,RD
         bcf 	STATUS,RP0
         movf	EEDATA,w
         return

del500	movlw	.25		;half second start-up delay
		movwf	findcnt
del5	call	debdel
		decfsZ	findcnt,f
		goto	del5
		return

debdel	movlw	.20		;debounce delay
		movwf	delcnt1
deb1	call	del
		decfsZ	delcnt1,f
		goto	deb1
		return

del 	clrf 	delcnt
del1	nop
		decfsZ	delcnt,f
		goto	del1
		return

		end
