;*****************************************************************************        
;
;   Module:     display.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 5/10/03                                                  
;
;               Functions to implement access to the LCD 
;
;*****************************************************************************        




;*****************************************************************************        
;
;   Function :  dspHWInit
;               Configures the Ports to allow the LCD to operate
;               The LCD remains powered off
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspHWInit
    clrf    PORTA        ; ALL PORT output should output Low.
    clrf    PORTD
    
    bsf     STATUS, RP0    ; Select bank 1
    movlw   0x0F0        ; RA3-0 outputs, RA4 inputs
    movwf   TRISA
    movlw   0x000        ; RB7-0 outputs
    movwf   TRISD

    bcf     STATUS, RP0    ; Select bank 0

    clrf    lcdCtrl    ; This is a mask of the pin data
    return



;*****************************************************************************        
;
;   Function :  dspPwrOff
;               Removes power from the LCD, putting it into low power mode
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspPwrOff
    clrf    PORTD
    clrf    lcdCtrl
    movfw   lcdCtrl
    movwf   PORTA 
    return
    
    
    
;*****************************************************************************        
;
;   Function :  dspPwrOn
;               Applies power to the LCD, Performing initial setup
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspPwrOn
    clrf    lcdCtrl   
    bsf     lcdCtrl, LCD_PWR
    movfw   lcdCtrl
    movwf   PORTA
    
    ; Display needs 14ms following power up - give it 50ms to be sure
    movlw   D'5'
    call    uiWait10ms
    
    movlw   0x038            ; 8-bit-interface, 2-lines
    call    dspPutCmd

    movlw   0x00C
    call    dspPutCmd       ; disp on, no cursor            
    return



;*****************************************************************************        
;
;   Function :  lcdbusy
;               This call blocks until the busy flag in the LCD is clear
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
lcdbusy
    bsf     STATUS,RP0    ; Select Register page 1
    movlw   0x0FF        ; Set PORTB for input
    movwf   LCD_DATA_TRIS
    bcf     STATUS, RP0    ; Select Register page 0
    
    bcf     lcdCtrl, LCD_RS; Set LCD for command mode
    movfw   lcdCtrl
    movwf   PORTA
    bsf     lcdCtrl, LCD_RW; Setup to read busy flag
    movfw   lcdCtrl
    movwf   PORTA
    bsf     lcdCtrl, LCD_E    ; LCD E-line High
    movfw   lcdCtrl
    movwf   PORTA
    movf    LCD_DATA, W    ; Read busy flag + DDram address
    movwf   lcdTmp2
    bcf     lcdCtrl, LCD_E    ; LCD E-line Low
    movfw   lcdCtrl
    movwf   PORTA
    movfw   lcdTmp2
    andlw   0x80        ; Check Busy flag, High = Busy
    btfss   STATUS, Z
    goto    lcdbusy
            
    bcf     lcdCtrl, LCD_RW
    movfw   lcdCtrl
    movwf   PORTA
    bsf     STATUS, RP0    ; Select Register page 1
    clrf    LCD_DATA_TRIS    ; Set PORTB for output
    bcf     STATUS, RP0    ; Select Register page 0
    return
        
        
        
;*****************************************************************************        
;
;   Function :  dspClear
;               This call clears the display and returns the cursor position
;               to top left.
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspClear
    movlw   0x001
    call    dspPutCmd
    return
    
    

;*****************************************************************************        
;
;   Function :  dspHome
;               This call returns the cursor position to top left.
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspHome
    movlw   0x002
    call    dspPutCmd
    return
        


;*****************************************************************************        
;
;   Function :  dspLine2
;               This call positions the cursor at the beginning of the second
;               line
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspLine2
    movlw   0x0c0               ; pos 40h = 01000000
    call    dspPutCmd
    return



;*****************************************************************************        
;
;   Function :  dspPutChar
;               This call writes a character to the current cursor position.
;
;   Input:      Character in W
;
;   Output:     None
;
;*****************************************************************************        
dspPutChar
    movwf   lcdTmp    ; Character to be sent is in W
    call    lcdbusy        ; Wait for LCD to be ready
    bcf     lcdCtrl, LCD_RW; Set LCD in read mode
    movfw   lcdCtrl
    movwf   PORTA
    bsf     lcdCtrl, LCD_RS; Set LCD in data mode
    movfw   lcdCtrl
    movwf   PORTA
    bsf     lcdCtrl, LCD_E    ; LCD E-line High
    movfw   lcdCtrl
    movwf   PORTA
    movf    lcdTmp, W
    movwf   LCD_DATA    ; Send data to LCD
    bcf     lcdCtrl, LCD_E    ; LCD E-line Low
    movfw   lcdCtrl
    movwf   PORTA
    return
        


;*****************************************************************************        
;
;   Function :  dspPutCmd
;               writeLCDRaw
;               Sends a command to the LCD. writeLCDRaw does it without 
;               checking the busy status
;              
;   Input:      Command to write is in W
;
;   Output:     None
;
;*****************************************************************************        
dspPutCmd
    movwf   lcdTmp              ; Command to be sent is in W
    call    lcdbusy             ; Wait for LCD to be ready
    goto    dp001
    
writeRawLCD
    movwf   lcdTmp    
    
dp001
    bcf     lcdCtrl, LCD_RW
    movfw   lcdCtrl
    movwf   PORTA
    bcf     lcdCtrl, LCD_RS
    movfw   lcdCtrl
    movwf   PORTA
    bsf     lcdCtrl, LCD_E
    movfw   lcdCtrl
    movwf   PORTA
    movf    lcdTmp, W
    movwf   LCD_DATA    
    bcf     lcdCtrl, LCD_E    
    movfw   lcdCtrl
    movwf   PORTA
    return  
