;*************************************
;
;
; Slave Display for The Scorer
;
; 13 January 04
;
;*************************************
#define	page0	bcf STATUS,RP0	; page register defines
#define	page1	bsf STATUS,RP0
;#define test_data
;#define debug

#define led	PORTA,3		; on led
#define team	PORTA,4		; bit that's tested to see what team the
				; slave is

org		0x00

		goto	start	; reset vector - off to start

org		0x04
		call	interrupt ; interrupt despatcher
		retfie
ifdef debug			; for simulator (can't do common anode)
				; so use common cathode patterns

pattern		andlw	0x0f	; protect the range in case of odd data
		addwf	PCL	; table look up
				; for segment pattern
		retlw	0x7e;0
		retlw	0x0c;1
		retlw	0xb6;2
		retlw	0x9e;3
		retlw	0xcc;4
		retlw	0xda;5
		retlw	0xfa;6
		retlw	0x0e;7
		retlw	0xfe;8
		retlw	0xde;9
		retlw	0xf2;10 E
		retlw	0xf0;11 t
		retlw	0x7c;12 U
		retlw	0x00;13 ' '
		retlw	0x72;14 C
		retlw	0xee;15 R
else

pattern		andlw	0x0f	; table for common anode
		addwf	PCL
	
		retlw	0x80;0
		retlw	0xf2;1
		retlw	0x48;2
		retlw	0x60;3
		retlw	0x32;4
		retlw	0x24;5
		retlw	0x04;6
		retlw	0xf0;7
		retlw	0x00;8
		retlw	0x20;9
		retlw	0x0c;10 E
		retlw	0x0e;11 t
		retlw	0x82;12 U
		retlw	0xfe;13 ' '
		retlw	0x8c;14 C
		retlw	0x10;15 R

endif

start		call 	init		; go set up ports and stuff
	
loop		nop			; main loop - just call routines

		call	display		; for the display and
		call	led_manager	; led
		
		goto	loop
		
display		clrf	PORTB		; all segments off
		
		btfss	team		; test the team
		goto	t2		; and set indirect reg for memloc
		
		movlw	0x20		; 0x20 if team 1 (team bit = 1)
		movwf	FSR
		goto	do_display
		
t2		movlw	0x22		; or 0x22 if team 2 (team bit = 0)
		movwf	FSR
		
do_display	bsf	PORTA,0		; turn digit 1 anode  on
		
		movfw	INDF		; get the first digit from memloc
		call	pattern		; convert it
		movwf	PORTB		; and apply to PORTB
		call	delay		; wait a while
		bcf	PORTA,0		; turn digit 1 anode off
		
		bsf	PORTA,1		; and digit 2 anode on
		incf	FSR		; point at the next digit data
		
		movfw	INDF		; get it
		call	pattern		; convert it
		movwf	PORTB		; and output for a 
		call	delay		; short while
		bcf	PORTA,1		; before turning the anode off
		
		return

;******************************************
;
; led manager
;
;******************************************

led_manager	btfsc	leds,2		; check need to flash the led
		goto	flash_start	; bit 2 set so yes
		
		btfss	leds,0		; or bit 0 set so yes
		goto	flash_done	; no LEDs need flashing so done
		
flash_start	btfss	flags,t0	; flash timer increment set?
		goto	done_leds	; no so done
		
		bcf	flags,t0	; yes, so reset the flag
		incf	intcount	; increase the counter
		
		movlw	12		; check for 12 counts
		subwf	intcount,w
		btfss	STATUS,Z	; done?
		goto	done_leds	; no so finish this time
		
		clrf	intcount	; yes, so reset the count
		
		btfss	team		; are we team 1 or 2
		goto	test_t2_flash
		
		btfsc	leds,2		; team 1 so test p1 flash
		goto	flash		; set so go flash

test_t2_flash	btfss	leds,0		; test team 2 
		goto	flash_done	; no flash so off and away
		
flash:		
		btfss	led		; is the LED on?
		goto	turn_on		; no, so go and turn it on
		
		bcf	led		; it's on so turn it off
		goto	done_leds	; and finish
		
turn_on		bsf	led		; LED is off so turn it on
		goto	done_leds	; and finish

flash_done	btfss	team		; are we team 1 or 2 (turn on/off)
		goto	next_team	
		
		btfss	leds,3		; check LED on/off flag for team
		goto	led_off		; flag is 0 so make sure off
		bsf	led		; should be on so turn it on
		goto	done_leds	; and finished
		
next_team	btfss	leds,1		; same as above for next team's flag
		goto	led_off
		bsf	led
		goto	done_leds
		
led_off		bcf	led		; turn off
		
done_leds	return			; and back

;******************************************
;
; set ports up and stuff
;
;******************************************		
	
init	clrf	PORTA		; clear ports in case of bother
	clrf 	PORTB
		
	movlw	0x07		; disable analogue inputs on PORTA
	movwf	CMCON

	page1
	movlw	0x01
	movwf	TRISB		; b is comms in
	
	movlw	0x10		; a4 is p1/t2 sensor so make it input
	movwf	TRISA
	
	movlw	0x04		; set up the option register
	OPTION
	
	page0
	
	movlw	0x20		; clear the digit data stores
	movwf	digit
	
	movlw	0x1f		; set the pointer for ind addressing
	movwf	FSR
	
	movlw	0x05		; 5 locations to do
	movwf	Temp
	movlw	0x00		; get 0
	
clear_data:
	
	incf	FSR		; increase the pointer
	movwf	INDF		; and store it
	
	decfsz	Temp		; count down
	
	goto	clear_data	; and loop if not done
	
	clrf	flags		; clear the flags and stuff
	clrf	leds
	clrf	intcount
	
	call 	delay		; and wait a while

ifdef test_data
	call	tempdata	; get debugging data if needed
	call	flash_test
else
	nop			; or do nothing
endif
	
	bsf	PORTA,2		; on and healthy led on	
	
	bsf	INTE		; enable PORTB interrupts,
	bsf	T0IE		; timer interrupts
	bsf	GIE		; and interrupts generally
	
	return
	
		
;*********************************************************
;
; Delays
;
;
;*******************************************************

		
halfdelay	movlw	halfcycle	; get the delay count 
		movwf	DelayIndex	; save it
DelayLoop	decfsz	DelayIndex	; countdown
		goto	DelayLoop	; and loop
		return
		
fulldelay	movlw	fullcycle	; bigger delay as above 
		movwf	DelayIndex
DelayLoop2	decfsz	DelayIndex
		goto	DelayLoop2
		return

		
delay		movlw	gendelay	; and another delay
		movwf	Temp2
dly1		decfsz	Temp2
		goto	dly1
		
		return
		
	
;***********************************
;
;
;   interrupt - get a character and deal with timer 0 tick
;
;
;***********************************

interrupt	page0
		bcf	GIE		; turn interrupts off
		btfsc	GIE		; and make absolutely sure
		goto	interrupt
		
		movwf	safe_w		; store away the registers
		swapf	STATUS,W
		movwf	safe_s
		
		btfss	INTF		; is it a receive interrupt?
		goto	test_t0		; no so test timer overflow
		
		clrf	RxByte		; yes so get ready to receive
		movlw	8
		movwf	Bitcount	; set up the bit counter
		call	halfdelay	; wait a half cycle
		btfsc	SerPort, RxBit	; 1 or 0?
		goto	end_int		; 1 so was a glitch
		
RxLoop		call	fulldelay	; 0 so wait a complete bit length
		bcf	STATUS,C	; then clear the carry
		btfsc	SerPort, RxBit	; and test the input
		bsf	STATUS,C	; 1 so set the carry flag
		rrf	RxByte		; and shift it to the right
		decfsz	Bitcount	; 8 bits done?
		goto	RxLoop		; no so round again
		
WaitEnd		call	fulldelay	; yes, so wait for stop bit		
		
end_int		movfw	RxByte		; get the character and see if it
		sublw	0x61,W		; was 'A'
		btfss	STATUS,Z
		
		goto	real_data	; no (subtraction non-zero)
		movlw	0x1f		; yes - start character so
		movwf	recdigit	; set the address pointer
		bsf	flags,RxOn	; and receiving flag
		goto	all_done	; then finish
			
real_data	nop
		btfss	flags,RxOn	; in receiving mode?
		goto	all_done	; no so end
		
		incf	recdigit	; set memory pointer
		movlw	0x24		; last location?
		subwf	recdigit,W
		btfss	STATUS,Z
		goto	save_char	; no so save
		
		bcf	flags,RxOn	; yes so clear receive flag
		
save_char	movfw	recdigit	; get the pointer
		movwf	FSR		; set register pointer
		movfw	RxByte		; get the character
	
		andlw	0x1f		; and mask
				
		movwf	INDF		; and finally save it
		goto	all_done
		
test_t0		btfss	T0IF		; was a timer thing?
		goto	all_done	; no so finsih
		
		bcf	T0IF		; yes so clear the interrupt flag
		bsf	flags,t0	; and set the tick flag

all_done	swapf	safe_s,w	; standard register restore
		movwf	STATUS
		movfw	safe_w
		
		bcf	INTF		; clear the interrupt flag (again)
		bsf	GIE		; enable interrupts
		
		return			; and back
		
		
;*******************************************************
;
; set up some test data
;
;*******************************************************

tempdata	movlw	0x01		; 1s for player 1
		movwf	0x20
		movwf	0x21
		movlw	0x02		; 2s for player 2
		movwf	0x22
		movwf	0x23

		return
		
flash_test	bsf	leds,0		; set the flash bits
		bsf	leds,2
		return
		
		end
