'PICAXE-18X VERSION plus ASSEMBLY CODE - 'alarmcode-mph1'

'AlarmSwitch - Vesion 3 of codelock switch progam by Alex Chadwick.
'Lock useage: Code entry: Press # then the four digit code.
'(When the chip is first progammed, the code is 1234.)
'Then press * to change the code, or # to unlock.
'If you press *:
	'Press # then the new four digit code.
'If you press #:
	'The output to RLA1 goes high until # is pressed.
	'The program then goes back to where the first digit
	'is about to be entered.
'If you enter the wrong code three times in a row, the siren
'sounds untill a code is entered or 30 seconds.

'b0 Has the code been set already?
'b1 digit
'b2 entry
'b3 = siren sounding b3 = 1
'b5 alarm counter 1
'b6 alarm counter 2
'b7 entry counter
'b8 fail amounts
'b9 write counter
'b10 codeset mode
'b11 alarm set (1=yes, 0=no)
'EEPROM allocations
'0 has code been set?
'1 digit 1
'2 digit 2
'3 digit 3
'4 digit 4
'5 entry 1
'6 entry 2
'7 entry 3
'8 entry 4
'10 codeset mode

						'This part of the progam runs if the lock
	read 0,b0				'has never been used...
	if b0 = 1 then start
	write 0,1
	write 1,1
	write 2,2
	write 3,3
	write 4,4				'...right down to here.

resetsiren:
	let b3 = 0

start:
	high 3
	if pin0 = 1 then continue		'do loop to check for # button
	if pin7=1 then breakin			'detects forced entry
	let b5 = b5 + 1
	if b5>250 then changecount
	goto start				'when # is pressed, check numbers

continue:
	let b7 = 0				'reset entry counter
nextb7:						'SCAN STARTS HERE
	let b7 = b7 + 1
	if b7 > 4 then sort
gosub beep
	let b9 = b7 + 4
entry1:
	let b5 = b5 + 1				'alarm counter
	if b5 > 250 then changecount
e1return:
	low 1
	low 2
	low 3
	high 0
	if pin2 = 1 then e1one1
	if pin1 = 1 then e1two1
	if pin0 = 1 then e1three1
	pause 10
	goto e1row2

e1one1:	write b9,1
	goto nextb7
e1two1:	write b9,2
	goto nextb7
e1three1:
	write b9,3
	goto nextb7
e1row2:
	low 0
	high 1
	if pin2 = 1 then e1one2
	if pin1 = 1 then e1two2
	if pin0 = 1 then e1three2
	pause 10
	goto e1row3

e1one2:	write b9,4
	goto nextb7
e1two2:	write b9,5
	goto nextb7
e1three2:
	write b9,6
	goto nextb7

e1row3:
	low 1
	high 2
	if pin2 = 1 then e1one3
	if pin1 = 1 then e1two3
	if pin0 = 1 then e1three3
	pause 10
	goto e1row4

e1one3:	write b9,7
	goto nextb7
e1two3:	write b9,8
	goto nextb7
e1three3:
	write b9,9
	goto nextb7

e1row4:
	low 2
	high 3
	if pin1 = 1 then e1two4
	pause 10
	goto entry1

e1two4:	write b9,0
	goto nextb7				'SCAN ENDS HERE



'b1 is digit
'b2 is entry
sort:						'sort here
	if b10 = 1 then codeset
	read 1,b1
	read 5,b2
	if b2 = b1 then sort2
	goto fail
sort2:
	read 2,b1
	read 6,b2
	if b2 = b1 then sort3
	goto fail
sort3:
	read 3,b1
	read 7,b2
	if b2 = b1 then sort4
	goto fail
sort4:
	read 4,b1
	read 8,b2
	if b2 = b1 then sort5
	goto fail
sort5:
	high 7
	pause 100
	low 7
	pause 100
	high 7
	pause 100
	low 7
	pause 100
	high 7
	pause 100
	low 7

operation:
	low 5
	if b11 = 1 then relock
	low 0
	low 1
	low 2
	high 3
	if pin2 = 1 then codechange		'checks * button to change code
	if pin0 = 1 then unlock			'checks # button to unlock
	goto operation


fail:
	if b3 = 1 then skiplo			'prevents siren stopping too soon
	high 5
	wait 1
	low 5
skiplo:	let b8 = b8 + 1
	if b8 = 3 then honk
	goto start

codechange:
	let b10 = 1
	high 7
	pause 100
	low 7
	pause 300
	write 0,1
	goto start

codeset:
	let b10 = 0
	pause 200

	read 5,b2
	let b1 = b2
	write 1,b1

	read 6,b2
	let b1 = b2
	write 2,b1

	read 7,b2
	let b1 = b2
	write 3,b1

	read 8,b2
	let b1 = b2
	write 4,b1

	let b0 = 0
	write 0,1
	high 7
	pause 200
	low 7
	goto start

honk:	let b5 = 0
	let b6 = 0
	let b3 = 1			'tells system that siren is on
	high 5
	let b8 = 0
	goto start			'was entry1

unlock:
	let b8 = 0
	high 6				'relay on
	high 7				'bleep on
	pause 1000
	low 7				'bleep off
	let b11 = 1			'indicates alarm set
	goto start

relock:
	low 6				'relay off
	low 3
	high 7				'bleep on
	pause 100
	low 7				'bleep off
	pause 100
	let b11 = 0			'indicates alarm not set
	goto start

changecount:
	let b5 = 0
	let b6 = b6 + 1
	if b6 > 32 then alarmoff	'this value times to 10s approx
	goto start

alarmoff:
	low 5				'turn off siren
	let b6 = 0
	goto start

beep:
	high 7				'bleep
	pause 100
	low 7
	pause 100
	return

breakin:
	if b11 = 0 then start		'skip if system not set
	high 5				'turn on siren
	let b3 = 1			'tells system siren is on
	goto start



