#include "C:\\Program Files\\Fed\\Pixie\\Projects\\NIMV9\\nim_Auto.h"
#include <maths.h>

//
//
// Nim machine version 2. Drives 4 columns of LEDs.
// Contains variable difficulty and interrupt driven sounder.
//
//
// D Coward 2003
//
// Version History
// ===============
//
//   Date		Version		Comment
//	1/12/02		1.0		Basic game display/moves/logic
//	1/1/03		2.0		Variable diff and interupt sound added
//	17/10/03	2.1		Modified for use with v9.10
//




//
// function declarations (nb othrs defined in app designer)
//

void game_reset();
void copy_piles();
void comp_turn();
void Sound(int duration, int frequency);
void KeyPress();
void rev_copy();
void random_move();
void restore();
int xor();
int total();

//
// variable defintions
//

unsigned char i,j,k,memloc,active_pile,turn_on=0, set_up=1;
unsigned char lights_on, lights[8], slow, slow1, slow2;
unsigned char LEDOnOff, LEDOnOff1, LEDOnOff2, iwin=0, uwin=0, game_on=0;
char pile[5], go[5];
int key,sum, count3=0, count5=0, count50=0, tot;
unsigned char intcount, random, sticks,test1;
unsigned char set_sticks, set_diff, diff;
int Sound_len, clock_count, frequency;

//
// This file includes all user definable routines. It may be changed at will 
as
// it will not be regenerated once the application has been generated for 
the
// first time.
//

//*******************************************************************************
//
// Insert your interrupt handling code if required here.
// Note quick interrupts are used so code must be simple
// See the manual for details of quick interrupts.
//

void UserInterrupt()
{
	// Insert your code here
	// [No interupts]

#asmline goto UserIntReturn	; PIC Assembler - go back to interrupt routine
}


//*******************************************************************************
//
// Insert your initialisation code if required here.
// Note that when this routine is called Interrupts will not be enabled - 
the
// Application Designer will enable them before the main loop
//

void UserInitialise()
{
ADCON1=7;					// make PORTA all digital
TRISA=0;					// set up alll except PORTD
TRISE=0;					// as outputs
TRISC=0;
TRISB=0;

lights[0]=0;					// set up the patterns of
lights[1]=0x01;				// LEDs for each number
lights[2]=0x03;
lights[3]=0x07;
lights[4]=0x0f;
lights[5]=0x1f;
lights[6]=0x3f;
lights[7]=0x7f;

game_reset();					// set things up

PORTA=0;					// clear the ports
PORTC=0;
PORTE=0;
PORTB=0;

}

//
// function to reset the variables
//

void game_reset()
{
set_up=1;
iwin=0;
uwin=0;
set_diff=0;
diff=0;
game_on=0;
active_pile=0;

pile[1]=1;
pile[2]=0;
pile[3]=0;
pile[4]=0;
}


//*******************************************************************************
//
// Insert your main loop code if required here. This routine will be called
// as part of the main loop code
//

void UserLoop()
{
srand(T0ExtCount);		// seed the random number generator
}

//
// Main display management loop. Manages 4x7 multiplexed LEDs
//

void UpDate()
{
PORTC=PORTC&(0x00<<i);			// turn off the column just in case

if (set_diff) PORTB=lights[diff];	// get level if in set diff mode
else
  {
   lights_on=(pile[i+1];		// or else get the light in pile i

   if ((i==(active_pile-1))&&(count3==1)) {lights_on--;} // if flash
   							 // reduce number of
   PORTB=lights[lights_on];				 // lights and then
  }							 // send to PORTB

PORTC=PORTC|(0x01<<i);			// now turn the column on

i++;					// move to the next column

if (i==4) i=0;				// back to start if all columns done
}

//
// Trivial routine to make a noise using a ceramic resonator
// makes a square wave on a port controlled by clock_count (duration)
// and frequency (on/off period) variables. Called on t0/2 interrupts.
//

void Sounder()
{
if (Sound_len>0) {intcount=0; Sound_len=0;}	// reset the interrupt counter
if (clock_count>0)				// if some clocks left to do
{
  intcount++;					// count interrupts
  if (intcount&frequency) SoundOutPort|=(1<<SoundOutBit);	// toggle the port
  							// every 'frequency'
  							// interrupts.
  else SoundOutPort&=~(1<<SoundOutBit);
  clock_count--;				// reduce the count
  if (clock_count==0) SoundOutPort&=~(1<<SoundOutBit); // make sure port is 
off
}
}

//
// sets up the sound variables
//

void Sound(int duration, int freq)
{
Sound_len=1;		// flag to turn on
frequency=freq;	// set frequency (can be type 1 or 2 or 4)
clock_count=(duration*4)/frequency; // how long to go on for?
}

//
// responds to button presses
//

void KeyPress()
{
key=KP4Value+1;	// get the key number right
Sound(10,2);		// make sound of frequency 2 for about 10ms.

if ((set_up==1)&&(key>0)&&(key<5)&&(set_diff==0)) // check valid pile key if
						   // in setup mode
  {
   if (pile[key]<7) pile[key]++;		   // add to pile
   return;
  }

if (KP4Value==0x0f)	// done key so check mode and behave accordingly
  {
   if (set_diff) {set_diff=0; return;}	// exit set diff mode
   if (game_on) {active_pile=0; comp_turn();return;}	// machine go
   if (set_up)		// in setup mode so
   {
    turn_on=1;		// make it the players' turn
    set_up=0;		// turn off setup mode and
    setupPort&=~(1<<setupBit);    // LED
    game_on=1;		// set game in progress flag


    memloc=0;		// save the game data in EEPROM
    for (j=0; j<5; j++) {WriteEEData(memloc, pile[j]); memloc++;}
    WriteEEData(memloc, diff);
    return;
   }
  }

  if ((turn_on>0)&&(key>0)&&(key<5))	// turn_on is special flag - first
  {					// check key is one that works a column
   if (turn_on==1) 			// if turn_on is 1
    {
     if (pile[key]>0) {active_pile=key; turn_on++;}	// set the active pile
     else return;					// and increase turn_on
    }

   if (turn_on>1)			// turn on is more than one
    {
     if ((active_pile==key)&(pile[key]>0)) // so check same pile as before
      {					   // and still things in it
       pile[key]--;			   // if so take on away
       if (pile[active_pile]==0)	   // zero yet?
        {
         if(total()==0) {uwin=1; game_on=0;	// yes so check total
        }					// if none left, stop game
         					// and signal player won
         else {turn_on=0; comp_turn(); return;	// stop player turn
         					// and get machine to go
        }
      }
    }
   else
    Sound(100,4);	// wrong pile or nothing left so make an error sound
   }
}

  if (KP4Value==0x0e)	// set difficulty key
   {
    if (set_up)		// check in set up mode
     {
      if (set_diff==0) {set_diff=1; return;}	// and set 'set diff' flag
      else {if (diff<7) diff++;}		// or increase difficulty
     }						// if in set diff already
   }

  if (KP4Value==0x0c) game_reset();	// reset

  if (KP4Value==0x0d) restore();	// restore

}

//
// function to generate a move. This only works out what the target position 
is
// next function does move mechanics
//

void comp_turn()
{
k=1;		// local counting variable

turn_on=0;	// players' turn off

if (diff==1) {random_move(); goto got_move;}	// if easy make a random move
if (diff==7) goto full_on;			// if hard calculate

if (rand()&0x06>diff) {random_move(); goto got_move;} // if the current 
random
						       // number is more than
						       // the diff level, move
						       // at random
full_on:

copy_piles();		// do a working copy

work_out:

  if (go[k]>0) go[k]--;	// if objects left, take one away
  else goto next_pile;	// or use the next pile
  sum=xor();		// magic sum zero?

  if (sum==0) goto got_move;  // yes so move
  else goto work_out;	      // no so try again

next_pile:
  if (k<4) {k++; copy_piles(); goto work_out;}	// try again on next pile
  else random_move();		// or none left so move at random

got_move:			// arrive here when move is found

for (k=1; k<5; k++) 		// and find out which pile to take things from
  {if (pile[k]!=go[k]) active_pile=k; count50=0;}
}

//
// function to turn of the lights one by one. called from t0/256 interrupt.
//

void comp_move()
{
if ((turn_on==0)&&(game_on==1)) // is it machines move?
  {
   if (pile[active_pile]==go[active_pile]) // finished so set up player turn
    {active_pile=0;turn_on=1;return;}

   if (count50>50)		// counter to slow things up. do things
    {				// every 50 interupts
     count50=0;
     Sound(15,1);		// make a beep
     pile[active_pile]--;	// take one away
     {
      if (pile[active_pile]==0)	// last in pile?
      {
       if (total()==0) {iwin=1; game_on=0;} // yes, so check for winner
      }
     }
    }
   else return;			// not reached slow count yet
   }
}

//
// copy piles into go[] matrix to work on
//

void copy_piles()
{
for (j=0; j<5; j++) {go[j]=pile[j];}
}

//
// do the magic sum
//

int xor()
{
return (go[1]^go[2]^go[3]^go[4]);
}

//
// add the piles together
//

int total()
{
return (pile[1]+pile[2]+pile[3]+pile[4]);
}

//
// copy from working matrix to real one
//

void rev_copy()
{
for (j=0; j<5; j++) {pile[j]=go[j];}
}

//
// function to  move at random
//

void random_move()
{
copy_piles();			// make a working copy

random0:
  active_pile=(rand()&0x03)+1;	// choose a pile number at random

if (go[active_pile]>0)		// any sticks left?
  {
   random1:			// yes, so
   sticks=(rand()&0x05)+1;	// choose a random number of them
   if ((go[active_pile]>sticks)||(go[active_pile]==sticks))
   {go[active_pile]=go[active_pile]-sticks; return;}	// and take them off
   else goto random1;					// if possible or
  }							// try again
else goto random0;		// none in that pile so have another go
}

//
// get the values back from EEPROM and set flags to starting conditions
//

void restore()
{
memloc=0;
for (j=0; j<5; j++) {pile[j]=ReadEEData(memloc); memloc++;}
diff=ReadEEData(memloc);
set_up=1; iwin=0; uwin=0;turn_on=0; game_on=0; set_diff=0; active_pile=0;
}

//
// flashy thing. called from t0/256
//

void flash()
{
count50++;		// increase slow counter used by comp_move()

if (count5==5) {count5=0;}	// increase the every 5 call counter
else count5++;			// or reset if needed

if (count3==3) {count3=0;}	// increase the every 3 call counter
else count3++;			// or reset if needed

if ((turn_on)&&(game_on))	// in game and players' turn?
  {
   if (count5==1)		// yes so see if 5 calls have elapsed
    {
     if (LEDOnOff) {urgoPort&=~(1<<urgoBit); LEDOnOff=0;} // and flash the 
urgo
     else {urgoPort|=(1<<urgoBit); LEDOnOff=1;}		  // LED
    }
  }
else urgoPort&=~(1<<urgoBit);	// not in game or players's turn so turn LED 
off

if (iwin) {PICwinPort|=(1<<PICwinBit);}	// light the iwin light if machine
else PICwinPort&=~(1<<PICwinBit);		// is a winner

if (uwin) {youwinPort|=(1<<youwinBit);}	// light the uwin light if the 
player
else youwinPort&=~(1<<youwinBit);		// won

if (set_up)			// setup mode?
  {				// yes so
   if (count3==1)		// see if 3 calls have elapsed
    {
     if (LEDOnOff1) {setupPort&=~(1<<setupBit); LEDOnOff1=0;} // and flash 
the
     else {setupPort|=(1<<setupBit); LEDOnOff1=1;}	      // setup LED
    }
  }

if (set_diff)			// set diff mode?
  {				// yes so
   if (count3==1)		// see if 3 calls have elapsed and
    {
     if (LEDOnOff2) {youwinPort&=~(1<<youwinBit); LEDOnOff2=0;} // flash the 
uwin
     else {youwinPort|=(1<<youwinBit); LEDOnOff2=1;}	    // LED as well
    }
  }
}

