; TK3TUT9.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; using single switch on Port A to increment Port B LED count
; showing how bit testing can be used to test switch status
   
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
COUNT           EQU H'20'               ; name location H'20' as variable called COUNT

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5
                 
                clrf PORTA
                clrf PORTB
                clrf COUNT
                BANK1
                movlw B'00000001'       ; RA0 as input
                movwf TRISA
                clrf TRISB
                BANK0
                 
LOOP            btfss PORTA,0           ; test bit 0 of Port A, is it set (= 1)?
                goto LOOP               ; no, it's = 0, so got back to LOOP
                incf COUNT,F            ; yes, it's = 1 so increment count
                movf COUNT,W            ; get COUNT value
                movwf PORTB             ; output it to PORTB
                goto LOOP               ; repeat
                 
                end                     ; final statement
