; TK3TUT36.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2 (prev tut37)
                 
; shows use of SLEEP

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
DELAY1          EQU H'20'
DELAY2          EQU H'21'
                 
                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA
                movlw B'00000001'
                movwf TRISB
                movlw B'11000111'       ; set timer to max (1:256 = TMR0 value)
                movwf OPTION_REG        ; (light pull-ups off - bit 7 high)
                BANK0

                clrf DELAY1
                clrf DELAY2

                movlw B'10010000'
                movwf INTCON
                 
MAIN            decfsz DELAY1,F         ; just slows down program for sake of demo
                goto MAIN
                decfsz DELAY2,F
                goto MAIN
                 
                movlw 2
                addwf PORTB,F           ; increment PORTB from bit 1 onwards
                btfss STATUS,C          ; is carry set (has PORTB rolled over)?
                goto BYPASS             ; no
                bsf PORTA,0             ; yes, set RA0,
                sleep                   ; now go to sleep and wait till RB0 switch
                                        ; is pressed
BYPASS          bcf INTCON,1            ; clears external interrupt flag
                bcf PORTA,0             ; clear RA0
                goto MAIN
                 
                end 			; final line
