; TK3TUT33.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; Illustrating use of EEPROM read/write

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

INDF            EQU 0			; indirect register
OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
FSR             EQU 4                   ; indirect register pointer
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
EEDATA          EQU 8
EECON1          EQU 8
EEADR           EQU 9
EECON2          EQU 9
INTCON          EQU H'0B'               ; INTCON register
                 
STORE           EQU H'20'               ; general store
VALUE0          EQU H'21'               ; example value stores/counters
VALUE1          EQU H'22'
VALUE2          EQU H'23'
RSLINE          EQU H'24'               ; bit 4 RS line flag for LCD
CLKCNT		EQU H'25'
STORE1          EQU H'26'               ; general store
LOOP		EQU H'27'
LOOPA		EQU H'28'

W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
WR              EQU 1                   ;eeprom write initiate flag
WREN            EQU 2                   ;eeprom write enable flag
RD              EQU 0                   ;eeprom read enable flag
                 


                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1                   ; set for BANK 1
                movlw B'00001111'
                movwf TRISA             ; set Port A RA0-3 for input
                clrf TRISB              ; set all Port B for output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                goto SETUP
                 
TABLCD          addwf PCL,F             ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end initialisation table

HEXTABLE	andlw B'00001111'
	        addwf PCL,F
		retlw '0'
		retlw '1'
		retlw '2'
		retlw '3'
		retlw '4'
		retlw '5'
		retlw '6'
		retlw '7'
		retlw '8'
		retlw '9'
		retlw 'A'
		retlw 'B'
		retlw 'C'
		retlw 'D'
		retlw 'E'
		retlw 'F'
                 
SETUP           call PAUSIT             ; perform first 1/5th sec delay

LCDSET          clrf LOOP               ; clr LCD set-up loop
                clrf RSLINE             ; clear RS line for instruction send
LCDST2          movf LOOP,W             ; get table address
                call TABLCD             ; get set-up instruction
                call LCDOUT             ; perform it
                incf LOOP,F             ; inc loop
                btfss LOOP,3            ; has last LCD set-up instruction now been done?
                goto LCDST2             ; no
                call PAUSIT             ; yes, perform second 1/5th sec delay
                                        ; to allow final LCD command to occur
                                        ; (it takes longer than the rest)
                 
GETVALUES       movlw 0			; get values from eeprom address 0 to 2
		call GETPRM		; store into VALUE
		movwf VALUE0
                movlw 1
		call GETPRM
		movwf VALUE1
                movlw 2
		call GETPRM
		movwf VALUE2
		call SHOWVALS		; show values


MAIN		call PAUSIT		; 1/5th sec pause
		btfsc PORTA,0		; is SW0 pressed?
		goto INCVAL0		; yes
		btfsc PORTA,1		; no, is SW1 pressed?
		goto INCVAL1		; yes
		btfsc PORTA,2		; no, is SW2 pressed?
		goto INCVAL2		; yes
		btfsc PORTA,3		; no, is SW3 pressed?
		goto STOREIT		; yes
		goto MAIN		; no

INCVAL0		incf VALUE0,F		; inc VALUEs as called and then show
		call SHOWVALS
		goto MAIN
INCVAL1		incf VALUE1,F
		call SHOWVALS
		goto MAIN
INCVAL2		incf VALUE2,F
		call SHOWVALS
		goto MAIN

STOREIT		movf VALUE0,W		; store all VALUEs into EEPROM
		movwf STORE1
		movlw 0
		call SETPRM
		movf VALUE1,W
		movwf STORE1
		movlw 1
		call SETPRM
		movf VALUE2,W
		movwf STORE1
		movlw 2
		call SETPRM

                movlw B'11001000'       ; set LCD screen address
                call LCDLIN		; show STORED
                movlw 'S'
                call LCDOUT
                movlw 'T'
                call LCDOUT
                movlw 'O'
                call LCDOUT
                movlw 'R'
                call LCDOUT
                movlw 'E'
                call LCDOUT
                movlw 'D'
                call LCDOUT

WAITSW		btfsc PORTA,3		; wait until switch released
		goto WAITSW

                movlw B'11001000'       ; set LCD screen address
                call LCDLIN		; clear STORED
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
		goto MAIN

SHOWVALS        movlw B'10000000'       ; set LCD screen address
                call LCDLIN
                movlw 'V'
                call LCDOUT
                movlw 'A'
                call LCDOUT
                movlw 'L'
                call LCDOUT
                movlw '0'
                call LCDOUT
                movlw ' '
                call LCDOUT
		swapf VALUE0,W
		call HEXTABLE
		call LCDOUT
		movf VALUE0,W
		call HEXTABLE
		call LCDOUT
		
	        movlw B'10001000'       ; set LCD screen address
                call LCDLIN
                movlw 'V'
                call LCDOUT
                movlw 'A'
                call LCDOUT
                movlw 'L'
                call LCDOUT
                movlw '1'
                call LCDOUT
                movlw ' '
                call LCDOUT
		swapf VALUE1,W
		call HEXTABLE
		call LCDOUT
		movf VALUE1,W
		call HEXTABLE
		call LCDOUT

	        movlw B'11000000'       ; set LCD screen address
                call LCDLIN
                movlw 'V'
                call LCDOUT
                movlw 'A'
                call LCDOUT
                movlw 'L'
                call LCDOUT
                movlw '2'
                call LCDOUT
                movlw ' '
                call LCDOUT
		swapf VALUE2,W
		call HEXTABLE
		call LCDOUT
		movf VALUE2,W
		call HEXTABLE
		call LCDOUT
        	return

LCDLIN          bcf RSLINE,4            ; sets LCD command/line
                call LCDOUT             ; and outputs cmmand code to LCD
                bsf RSLINE,4            ; set RS flag
	        return

LCDOUT          movwf STORE             ; temp store data
                movlw 50                ; set minimum time between sending full bytes to
                movwf LOOPA             ; LCD - value of 50 seems OK for this prog with
DELAY           decfsz LOOPA,F          ; XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY              ; keep decrementing LOOPA until zero
                call SENDIT             ; send MSB
                call SENDIT             ; send LSB
                return 
                 
SENDIT          swapf STORE,F           ; swap data nibbles
                movf STORE,W            ; get data byte
                andlw 15                ; get nibble from byte (LSB)
                iorwf RSLINE,W          ; OR the RS bit
                movwf PORTB             ; output the byte
                bsf PORTB,5             ; set E line high
                bcf PORTB,5             ; set E line low
                return 
                 
PAUSIT          movlw 5                 ; set delay counter to 5
                movwf CLKCNT            ; (for 1/25th sec x 5)
                clrf INTCON             ; clear interupt flag
PAUSE                                   ; initial 1/5th sec wait before setting up LCD
                btfss INTCON,2          ; has a timer time-out been detected?
                goto PAUSE              ; no
                bcf INTCON,2            ; yes
                decfsz CLKCNT,F         ; dec counter, is it zero?
                goto PAUSE              ; no
                return                  ; yes

                                        ;...............
                 
                                        ;WRITE DATA TO EEPROM ROUTINE:
                 
                                        ;This routine is entered with W holding
                                        ;the eeprom byte address at which data
                                        ;is to be stored. The data to be stored
                                        ;is held in STORE1.

SETPRM          movwf EEADR             ;Now copy W into EEADR to set eeprom address
                BANK1 
                bsf EECON1,WREN         ;enable write flag
                BANK0 
                movf STORE1,W           ;get data value from STORE1 and hold in W
                movwf EEDATA            ;copy W into eeprom data byte register
                 
MANUAL          BANK1                   ;these next 12 lines are according to
                movlw H'55'             ;Microchip manual dictated factors
                movwf EECON2            ;they cause the action required by
                movlw H'AA'             ;by the eeprom to store the data in EEDATA
                movwf EECON2            ;at the address held by EEADR.
                bsf EECON1,WR           ;set the ``perform write'' flag
                 
CHKWRT          btfss EECON1,4          ;wait until bit 4 of EECON1 is set
                goto CHKWRT
                bcf EECON1,WREN         ;disable write
                bcf EECON1,4            ;clear bit 4 of EECON1
                BANK0 
                bcf INTCON,6            ;clear bit 6 of INTCON
                return                  ;and return
                 
                                        ;..........
                 
                                        ;READ DATA FROM EEPROM ROUTINE:
                 
                                        ;This routine is entered with W holding
                                        ;the eeprom byte address to be read.

GETPRM          movwf EEADR             ;Now copy W into EEADR to set eeprom address
                BANK1                   ;
                bsf EECON1,RD           ;enable read flag
                BANK0 
                movf EEDATA,W           ;read eeprom data now in EEDATA into W
                return                  ;and return

		END
