; TK3TUT31.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; as TK3TUT30 but now with switch setting of time

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

INDF            EQU 0			; indirect register
OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
FSR             EQU 4                   ; indirect register pointer
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
                 
LOOP            EQU H'20'               ; loop counter 1 - general
CLKCNT          EQU H'21'               ; pre-counter for CLOCK
CLKSEC          EQU H'22'               ; CLOCK main counter - secs
CLKMIN          EQU H'23'               ; CLOCK - mins
CLKHRS          EQU H'24'               ; CLOCK - hours
STORE1          EQU H'25'               ; general store 1
STORE2          EQU H'26'               ; general store 2
RSLINE          EQU H'27'               ; RS line flag for LCD
HLFSEC          EQU H'28'               ; half-second counter
EVENT           EQU H'29'               ; flag for hrs/mins switch press
LOOPA           EQU H'2A'               ; loop counter 2 - for LCD only

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00001111'
                movwf TRISA             ; Port A4 as output, A0-A3 as input
                clrf TRISB		; PORTB as output
                movlw B'10000101'       ; set timer ratio 1:64
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                goto SETUP
                 
TABLCD          addwf PCL,F             ;LCD initialisation table
                retlw B'00110011'       ;initialise lcd - first byte
                retlw B'00110011'       ;2nd byte (repeat of first)
                retlw B'00110010'       ;set for 4-bit operation
                retlw B'00101100'       ;set for 2 lines
                retlw B'00000110'       ;set entry mode to increment each address
                retlw B'00001100'       ;set display on, cursor off, blink off
                retlw B'00000001'       ;clear display
                retlw B'00000010'       ;return home, cursor & RAM to zero
                                        ;end inititalisation table
                 
MESSAG          addwf PCL,F
                retlw 'T'
                retlw 'I'
                retlw 'M'
                retlw 'E'
                retlw ' '
                retlw 'N'
                retlw 'O'
                retlw 'W'
                 
CHKVAL          addwf PCL,F
                retlw B'01011001'       ;59 secs max
                retlw B'01011001'       ;59 mins max
                retlw B'00100011'       ;23 hours max
                 
SETUP           call PAUSIT             ;1/5 sec delay
                 
LCDSET          clrf LOOP               ;clr LCD set-up loop
                clrf RSLINE             ;clear RS line for instruction send
LCDST2          movf LOOP,W             ;get table address
                call TABLCD             ;get set-up instruction
                call LCDOUT             ;perform it
                incf LOOP,F             ;inc loop
                btfss LOOP,3            ;has last LCD set-up instruction now been done?
                goto LCDST2             ;no
                call PAUSIT             ;1/5 sec delay
                 
LCDMSG          clrf LOOP               ;clear loop
                bsf RSLINE,4            ;set RS for data send
LCDMS2          movf LOOP,W             ;get table address
                call MESSAG             ;get message letter
                call LCDOUT             ;show it
                incf LOOP,F             ;inc loop
                btfss LOOP,3            ;has last LCD letter been sent?
                goto LCDMS2             ;no
                 
                clrf CLKSEC             ;clear seconds counter
                clrf CLKMIN             ;clear minutes counter
                clrf CLKHRS             ;clear hours counter
                 
                movlw 25                ;initial basic CLKCNT val for secs timing
                movwf CLKCNT
                 
MAIN            btfss INTCON,2          ;has a timer time-out been detected?
                goto MAIN               ;no
                bcf INTCON,2            ;yes
                call CLKADD             ;do time
                goto MAIN
                 
CLKADD          decfsz CLKCNT,F         ;increment system clock counter. Is it = 0?
                return                  ;no
                 
                movlw 25                ;reset start value of CLKCNT
                movwf CLKCNT
                call GETKEY             ;check switch status
                incf HLFSEC,F           ;inc half sec counter
                btfsc HLFSEC,0          ;is half second bit clear (= 0)?
                call CLKIT              ;no, it's = 1, so update secs etc
                return                  ;yes, so don't update secs etc
                 
CLKIT           movlw CLKSEC            ;get address of CLKSEC
                movwf FSR               ;move it into indirect reg
                movlw 3                 ;set loop to 3
                movwf LOOP
                clrf STORE1
                 
ADDCLK          incf INDF,F             ;inc units - all in BCD
                movlw 6
                addwf INDF,W            ;if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf INDF              ;yes

ADDCL2          movf STORE1,W           ;now check if value > allowed value
                call CHKVAL
                movwf STORE2
                movf INDF,W
                subwf STORE2,F          ;is count =<  than allowed?
                btfsc STATUS,C
                goto CLKSHW             ;yes
                clrf INDF               ;no, it's greater, so clear it
                incf STORE1,F           ;and add 1 to time loop & byte
                incf FSR,F
                decfsz LOOP,F           ;dec loop, is it = 0?
                goto ADDCLK             ;no
                 
CLKSHW          btfsc PORTA,4           ;is SA4 (secs) pressed?
                clrf CLKSEC             ;yes, reset secs
                movlw B'11000000'       ;show time
                call LCDLIN             ;set address for line 2 (address 64)
                movf CLKHRS,W           ;get hrs
                call LCDFRM             ;format and send it
                movlw ':'               ;insert colon
                call LCDOUT
                movf CLKMIN,W           ;get mins
                call LCDFRM
                movlw '.'               ;decimal point
                call LCDOUT
                movf CLKSEC,W           ;get secs
                 
LCDFRM          movwf STORE2            ;split & format decimal byte for LCD
                swapf STORE2,W          ;get tens nibble
                andlw 15
                iorlw 48                ;ASCII convert it
                call LCDOUT             ;send it
                movf STORE2,W           ;get units
                andlw 15
                iorlw 48                ;ASCII convert it
                 
LCDOUT          movwf STORE1            ;temp store data for LCD
                movlw 20                ;set minimum time between sending full bytes to
                movwf LOOPA             ;LCD - value of 20 seems OK for this prog with
DELAY           decfsz LOOPA,F          ;XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY
                call SENDIT             ;send MSB, then (by default) send LSB
                 
SENDIT          swapf STORE1,F          ;get and send data nibble
                movf STORE1,W
                andlw 15
                iorwf RSLINE,W          ;OR the RS bit
                movwf PORTB             ;output the byte
                bsf PORTB,5             ;set E high
                bcf PORTB,5             ;set E low
                return 
                 
LCDLIN          bcf RSLINE,4            ;sets LCD command/line
                call LCDOUT
                bsf RSLINE,4            ;set RS flag
                return 
                 
GETKEY          btfss PORTA,3           ;is SA3 (hrs) pressed?
                goto CHKSW2             ;no
                bsf EVENT,0             ;yes, flag to show hours switch press received
                movlw CLKHRS            ;get address of hours byte
                goto TIMSET             ;goto time setting routine
                 
CHKSW2          btfss PORTA,2           ;is SA2 (mins) pressed?
                return                  ;no
                clrf EVENT              ;yes
                movlw CLKMIN            ;get address mins byte
                 
TIMSET          movwf FSR               ;store address
                btfsc PORTA,0           ;is SA0 pressed (minus)?
                goto SUBTIM             ;yes
                btfss PORTA,1           ;no, is SA1 pressed (plus)?
                return                  ;no
                 
ADDTIM          incf INDF,F             ;yes, inc val at that address
                movlw 6                 ;check if units >9
                addwf INDF,W            ;if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf INDF              ;yes
                incf EVENT,W            ;get switch press flag
                call CHKVAL             ;get max value allowed
                movwf STORE2            ;store it
                movf INDF,W             ;get time byte val
                subwf STORE2,F          ;is time count =<  than allowed?
                btfss STATUS,C          ;
                clrf INDF               ;no, time byte is greater, so clear byte
                goto CLKSHW             ;show time setting
                 
SUBTIM          movlw 1                 ;subtract 1 (DECF does not set STATUS,DC!)
                subwf INDF,F            ;dec val at that address
                btfss STATUS,C          ;is there a byte borrow?
                goto SUBSET             ;yes
                btfsc STATUS,DC         ;no, is there a digit borrow?
                goto ENDSUB             ;no
                movf INDF,W             ;yes
                andlw B'11110000'       ;reset units nibble to 0
                iorlw 9                 ;OR units nibble with 9
                movwf INDF              ;put answer back into time val
                goto ENDSUB             ;bypass next part
SUBSET          incf EVENT,W            ;inc switch press flag for table
                call CHKVAL             ;get max val
                movwf INDF              ;reset time byte with max val
ENDSUB          goto CLKSHW             ;display time setting
                 
PAUSIT          movlw 10                ;1/5th sec wait set
                movwf CLKCNT
                clrf INTCON             ;clear interupt flag
PAUSE                                   ;initial 1/5th sec wait before setting up LCD
                btfss INTCON,2          ;has a timer time-out been detected?
                goto PAUSE              ;no
                bcf INTCON,2            ;yes
                decfsz CLKCNT,F         ;dec loop, is it zero?
                goto PAUSE              ;no
                return                  ;yes
                 
                end                     ;final line
