; TK3TUT25.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; Use of Timer with set rate, with BCD to 59 counting on LEDs
; with intermediate 1/25 counter
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag

CLKCNT          EQU H'20'               ; clock division counter
CLKSEC          EQU H'21'               ; clock seconds counter

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA		; PORTA as output
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)
                 
                movlw 25                ; set CLKCNT to 25
                movwf CLKCNT
                clrf CLKSEC             ; clear seconds
                bcf INTCON,2            ; clear time-out flag
                 
MAIN            btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no
                bcf INTCON,2            ; yes, clear flag
                decfsz CLKCNT,F         ; dec CLKCNT (1/25 divider), is it zero?
                goto MAIN               ; no
                movlw 25                ; yes, reset it to 25
                movwf CLKCNT
                incf CLKSEC,F           ; inc secs
                movf CLKSEC,W           ; check for secs val greater than 9
                addlw 6
                btfss STATUS,DC         ; is there a digit carry (>15)?
                goto OUTPUT             ; no, bypass next part
                movwf CLKSEC            ; yes, move new val to secs
                movlw B'01100000'       ; load W with BCD 60
                xorwf CLKSEC,W          ; alternative way of checking instead of adding
                btfsc STATUS,Z          ; is CLKSEC = 60 (has XOR found equality, Z=1)?
                clrf CLKSEC             ; yes, clear secs
OUTPUT          movf CLKSEC,W           ; get secs val
                movwf PORTB             ; send to PORTB
                goto MAIN               ; go back to reading time-out bit
                 
                end                     ; final line
