; TK3TUT22.ASM 26FEB03 - JOHN BECKER - EPE PIC TUTOR V2
; showing how 2 switches on Port A can cause a note on Port A,
; one switch causing a fixed note, the other causing a modulated note
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
                 
NOTE            EQU H'20'               ; note counter
FREQ            EQU H'21'               ; note tuning value
MODLAT          EQU H'22'               ; modulation counter
DELAY  		EQU H'23'		; delay counter

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00001111'       ; RA4 as output, RA0-RA3 as input
                movwf TRISA
                clrf TRISB		; PORTB as output
                BANK0

ENTRY           movlw 80                ; load Working reg with value of 80
                movwf NOTE              ; copy it into NOTE
                movwf FREQ              ; and into FREQ. It sets the tuning frequency
                movlw 128               ; move 128 into W
                movwf MODLAT            ; set modulation counter with value of 128
		movlw 64                ; move 64 into W
		movwf DELAY             ; set delay counter with value of 64
                 
GETKEY          comf PORTA,W            ; copy inversion of Port A into W
                andlw B'00000011'       ; AND it with 00000011
                xorlw B'00000011'       ; XOR with bits 0 & 1
                btfsc STATUS,Z          ; is answer = 0? (are SW0 and SW1 unpressed?)
                goto GETKEY             ; yes, neither pressed so keep on reading Port A
                decfsz NOTE,F           ; no, now decrement NOTE counter. Is it now = 0?
                goto GETKEY             ; no, so again read Port A
                movf FREQ,W             ; yes, so first load W with value held in FREQ
                btfsc PORTA,1           ; is SW1 pressed (Port A pin 1 = 0)?
                goto OUTPUT             ; no, so bypass modulation (with freq val in W)
		decfsz DELAY,F		; yes, so decrement DELAY, is it zero?
		goto GK2		; no
		bsf DELAY,6		; yes, so reset to 64
                decfsz MODLAT,F         ; dec MODLAT counter, is it = 0
                goto GK2                ; no, so bypass modulation reset
		bsf MODLAT,7		; yes, so reset to 128
GK2             addwf MODLAT,W          ; add modulation value to W
                 
OUTPUT          movwf NOTE              ; copy W into NOTE
                movlw B'00010000'       ; move 00010000 into W
                addwf PORTA,F           ; increment Port A bit 4
                goto GETKEY             ; go back to reading Port A
                 
                end                     ; final statement
