; TK3TUT19.ASM 02JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; showing how Indirect Addressing lets shorter coding allow 4 switches on
; Port A to create 4 single notes on Port A RA4
; using unnamed file addresses
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

INDF            EQU 0                   ; register used when calling Indirect address
PCL             EQU 2                   ; Program Counter
STATUS          EQU 3                   ; STATUS register
FSR             EQU 4                   ; register which holds Indirect address
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag

NOTE1           EQU H'20'               ; H'20' to H'23' reserved for 4 notes
LOOPA           EQU H'24'               ; loop counter
STORE           EQU H'25'               ; general store
COUNT           EQU H'26'               ; general counter

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                goto PRESET
                 
TABLE           andlw B'00000011'       ; AND W with 00000011
                addwf PCL,F             ; add it to the program counter
                retlw 10                ; NOTE1 value
                retlw 20                ; NOTE2 value
                retlw 40                ; NOTE3 value
                retlw 80                ; NOTE4 value
                 
PRESET          clrf PORTA
		clrf PORTB
                BANK1
		movlw B'00001111'       ; set PORTA RA0-RA3 for input RA4 for output
                movwf TRISA             
                clrf TRISB
                BANK0
                 
SETUP           movlw 4                 ; move 4 into W (4 notes)
                movwf LOOPA             ; copy W into LOOPA
                clrf COUNT              ; clear COUNT
                movlw NOTE1             ; move address of NOTE1 into W
                movwf FSR               ; copy W into Indirect address reg
                 
SETUP1          movf COUNT,W            ; copy COUNT into W reg
                call TABLE              ; get data from table
                movwf INDF              ; copy it into reg pointed to by FSR
                incf FSR,F              ; inc FSR address
                incf COUNT,F            ; inc COUNT
                decfsz LOOPA,F          ; dec LOOPA, is it zero?
                goto SETUP1             ; no, so repeat loop from SETUP1
                 
GETKEY          movf PORTA,W            ; get switch data from Port A
		andlw B'00001111'	; extract bits 3-0
                movwf STORE             ; copy it into STORE
                movlw 4                 ; move 4 into W
                movwf LOOPA             ; copy W into LOOPA
                 
ROTATE          btfsc STORE,3           ; is bit 3 of STORE clear (= 0)?
                goto PLAY               ; no, it's = 1 so go to PLAY
                bcf STATUS,C            ; clear Carry flag
                rlf STORE,F             ; yes, so rotate (shift) left STORE by 1 place
                decfsz LOOPA,F          ; dec LOOPA, is it zero?
                goto ROTATE             ; no, so repeat loop from ROTATE
                goto GETKEY             ; yes, so go back to GETKEY
                 
PLAY            decf LOOPA,W            ; copy contents of LOOPA into W and dec W by 1
                addlw NOTE1             ; add the address of NOTE1 to W
                movwf FSR               ; copy W into Indirect address reg
                decfsz INDF,F           ; dec the contents of the reg pointed to by FSR
                                        ; are the contents of this reg now = 0?
                goto GETKEY             ; no, so go back to GETKEY
                decf LOOPA,W            ; copy contents of LOOPA into W and dec W by 1
                call TABLE              ; get reset value for NOTE pointed to by FSR
                movwf INDF              ; copy W into that NOTE address
                 
OUTPUT          movlw B'00010000'	; move 16 into W (00010000)
                addwf PORTA,F           ; increment the count at Port A pin 4
                goto GETKEY             ; go back to GETKEY
                 
                end                     ; final statement
