; TK3TUT15.ASM 02JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; showing how a switch on RA0 can cause a note on RA4
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag

NOTE            EQU H'20'               ; note counter
FREQ            EQU H'21'               ; note tuning value

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00000001'       ; RA0 as input
                movwf TRISA
                clrf TRISB
                BANK0
                 
SOUND           movlw 80                ; load W with value of 80
                                        ; (try using different values to change note)
                movwf NOTE              ; copy it into NOTE
                movwf FREQ              ; and into FREQ. It sets the tuning frequency
                 
GETKEY          btfss PORTA,0           ; get data on Port A, is switch SW0 pressed?
                goto GETKEY             ; no, so keep on reading Port A
                decfsz NOTE,F           ; yes, now decrement NOTE counter. Is it now = 0?
                goto GETKEY             ; no, so again read Port A
                movf FREQ,W             ; yes, so first load W with value held in FREQ
                movwf NOTE              ; and copy it into NOTE
                movlw B'00010000'       ; move 16 into W (00010000)
                addwf PORTA,F           ; now add to Port A to increment bit 4
                goto GETKEY             ; and go back to reading Port A
                 
                end                     ; final statement
