; Program 3
; Switch on LED if RB0 interrupt

	list	p=16F84,r=dec
	__config	h'3FF3'

; Macros

#define BANK0   BCF 0x03,5
#define BANK1   BSF 0x03,5

; Equates for registers

	include	p16f84.inc

; Data locations

SAVEW:	equ	0x20		; preserve W during interrupts
SAVES:	equ	0x21		; preserve STATUS during interrupts
COUNT:	equ	0x22		; count of timer ticks
ICOUNT:	equ	0x23		; number of interrupts
EBYTE:	equ	0x24		; byte read from EEPROM
DELAY:	equ	0x25		; delay loop counter

; code
	org	0
	goto	init		; reset vector
	org	4
 	goto	ISR      	; Interrupt vector
	org	5

; initialise PIC

init:	clrf	PORTA		; initialise all port outputs to zero
	clrf	PORTB
	BANK1
	clrf	TRISA		; RA0 - RA4 all outputs
 	movlw	b'00000001'	; RB0 input, rest outputs
	movwf	TRISB
	movlw	b'00000111'	; enable PORTB pullups, falling edge RB0, PSA to TMR, prescale /256
	movwf	OPTION_REG
	BANK0

; interrupt setup

	bsf	INTCON,INTE	; enable INTF interrupt
	bsf	INTCON,GIE	; enable global interrupts

; data initialisation

	bsf	PORTA,0		; turn on the led

; main loop

main:	clrf	COUNT		; clear ticks count
	clrf	TMR0		; clear internal clock count-up
A2:	bcf	INTCON,T0IF	; clear the TMR0 wrapped flag
A1:	btfss	INTCON,T0IF	; has TMR0 wrapped yet?
	goto	A3		; no, go back and wait for it to wrap
	incf	COUNT,F		; bump count of wraps
	movlw	10		; about 10 bumps/sec at 2MHz clock
B1:	xorwf	COUNT,W		; sets Z if COUNT = W 
B2:	btfss	STATUS,Z	; test Z
	goto	A2		; Z not set so COUNT != 10
	bcf	PORTA,0		; wraps COUNT = 10 so switch off led
	goto	main		; and repeat main loop

; code to read a byte from EEPROM

A3:	movlw	0		; EEPROM address 0
	movwf	EEADR		; into the address reg
	BANK1
	bsf	EECON1,RD	; initiate read
	BANK0
	movf	EEDATA,W	; copy EEPROM data to W
	movwf	EBYTE		; and store in main memory
	movlw	250		; a short delay loop
	movwf	DELAY		; load the delay counter
A4:	incf	DELAY,F		; bump delay counter
	btfss	STATUS,Z	; and test if it's zero
	goto	A4		; it's not so spin
	goto	A1		; go back and wait for TMR0 to wrap

; Interrupt service routine

ISR:	movwf	SAVEW		; save W 
	swapf	STATUS,W
	movwf	SAVES		; save STATUS
	BANK0			; ensure bank 0 is set
	btfss	INTCON,INTF	; test INTF
	goto	POP		; not an INTF interrupt

; there is an INTF interrupt
	
	incf	ICOUNT,F	; bump count of interrupts
	bsf	PORTA,0		; turn on the led
	bcf	INTCON,INTF	; clear the interrupt
POP:	swapf	SAVES,W		; restore STATUS
	movwf	STATUS
	swapf	SAVEW,F		; restore W
	swapf	SAVEW,W
	retfie			; exit ISR

	end			; of program

