;Generation of 50/60Hz outputs using TMR0
;Uses 3.6864MHz xtal
;for PIC16F84, config is: osc=xt, wdt=on, put=on.

#define page0 BCF status,5
#define page1 BSF status,5

portA:  .EQU $05        
trisA:  .EQU $05        
portB:  .EQU $06        
trisB:  .EQU $06        
status: .EQU $03   
option: .EQU $01        
intcon: .EQU $0B        
tmr0:   .EQU $01        
w:      .EQU $00        
f:      .EQU $01        
ctr1:   .equ $0C        
ref:    .equ $10        

        .org $0004
        goto start   ;go to start on interrupt
        .org $0005
;---------------------------------------------------------    
;initialise the system for operation
        clrf portA
        clrf portB
        page1
        movlw %11001101
        movwf trisB             ;RB1,4 and 5 are outputs
        movlw %01000101         ;set up rttc clock source
        movwf option            ;and prescaler options
        page0                   ;and pull-ups on
        clrf intcon             ;no interrupts enabled yet
        movlw %00100010         ;preload output pattern file
        movwf ref               ;and copy to storage file
;---------------------------------------------------------    
;this section uses tmr0 to generate 120/100Hz interrupts
;arrives at label start following interrupt
start:  clrwdt                ;reset the watchdog timer
        page1                 ;get timer capacitor discharging
        bcf trisA,4
        page0
        bcf portA,4
        btfss portB,3         ;50Hz requested?
        goto FHz
;this is the bit for 60Hz - 120Hz interrupts
SHz:    movlw 16      ;fine tune with loop
        movwf ctr1
lpa:    decfsz ctr1,f
        goto lpa
        movlw 137             ;preload and start tmr0
        movwf tmr0            
        goto re_en
;this is the bit for 50Hz - 100Hz interrupts
FHz:    movlw 15              ;fine tune with loop
        movwf ctr1
lpb:    decfsz ctr1,f
        goto lpb
        nop                   ;ultra-fine tune with nops
        nop
        movlw 113             ;preload and start tmr0
        movwf tmr0            
;and here the interrupt enables are reset
re_en:  bcf intcon,2          ;reset TMR0 overflow bit
        bsf intcon,5          ;re-enable TMR0 interrupt bit
        bsf intcon,7          ;re-enable global interrupt
;---------------------------------------------------------    
;generate required outputs
        page1            ;start RA4 CR timing process
        bsf trisA,4
        page0
        movlw %00110010  ;change output states
        xorwf ref,w      
        movwf ref        ;store them
        movwf portB      ;and copy to port B
lpc:    btfss portA,4    ;loop until RA4 CR timer is high
        goto lpc
        movlw %00000010        
        andwf portB,f    ;then ensure only RB1 can be high
lpd:    goto lpd         ;done, now wait for the next interrupt
;---------------------------------------------------------
        .END
