;DEMO30.ASM demo for using banks & blocks with PIC16F87x devices 27AUG00

;PIC16F877-4, 3.2768MHz, WDT OFF, POR ON, XTAL XS

;Config register bits (all PIC TOOLKIT MK2 defaults)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

#DEFINE PAGE0 BCF $03,5  ; clear STATUS bit 5 (RP0)
#DEFINE PAGE1 BSF $03,5  ; set   STATUS bit 5 (RP0)
#DEFINE RP1LO BCF $03,6  ; clear STATUS bit 6 (RP1)
#DEFINE RP1HI BSF $03,6  ; set   STATUS bit 6 (RP1)
#DEFINE BLOCK0 BCF $03,7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF $03,7 ; set   STATUS bit 7 (IRP)

INDF:   .EQU $00      ; indirect access register     (Bank 0, 1, 2, 3)
OPTION: .EQU $01      ; OPTION register                    (Bank 1, 3)
PCL:    .EQU $02      ; PCL register                 (Bank 0, 1, 2, 3)
STATUS: .EQU $03      ; STATUS register              (Bank 0, 1, 2, 3)
FSR:    .EQU $04      ; indirect addressing register (Bank 0, 1, 2, 3)
PORTB:  .EQU $06      ; PORT B data input/output register  (Bank 0, 2)
TRISB:  .EQU $06      ; data direction register for PORT B (Bank 1, 3)
PORTD:  .EQU $08      ; PORT B data input/output register  (Bank 0, 2)
TRISD:  .EQU $08      ; data direction register for PORT B (Bank 1, 3)
INTCON: .EQU $0B      ; INTCON register              (Bank 0, 1, 2, 3)

;registers in $70 to $7F (accessible from Bank 0, 1, 2, 3)

LOOP1:  .EQU $70      ; input byte counter
LOOPA:  .EQU $71      ; for LCD use
LOOPB:  .EQU $72      ; for LCD use
STORE:  .EQU $73      ; for LCD use
RSLINE: .EQU $74      ; for LCD use
SLOWIT: .EQU $75      ; pause counter
FSRSTORE: .EQU $76    ; temp store for FSR
VALUE:  .EQU $77      ; simulation counter

MEM1:   .EQU $20      ; first data memory location for Bank 0 (at $20)
                      ; extends to MEM64 at $5F (Bank 0 $5F)
MEM65:  .EQU $20      ; first data memory location for Bank 1 (at $A0)
                      ; extends to MEM128 at $5F (Bank 1 $DF)
MEM129: .EQU $20      ; first data memory location for Bank 2 (at $120)
                      ; extends to MEM192 at $5F (Bank 2 $15F)
MEM193: .EQU $20      ; first data memory location for Bank 3 (at $1A0)
                      ; extends to MEM256 at $5F (Bank 2 $1DF)

; locations in BLOCK 1, BANK 3

COUNTER1: .EQU $10    ; counter used in decimalisation
COUNTER2: .EQU $11    ; counter used in decimalisation
COUNT0:   .EQU $12    ; holds binary val to be decimalised LSB
COUNT1:   .EQU $13    ; holds binary val to be decimalised NSB
COUNT2:   .EQU $14    ; holds binary val to be decimalised MSB
DIGIT1:   .EQU $15    ; decimalised digit 1
DIGIT2:   .EQU $16    ; decimalised digit 2
DIGIT3:   .EQU $17    ; decimalised digit 3
DIGIT4:   .EQU $18    ; decimalised digit 4
DIGIT5:   .EQU $19    ; decimalised digit 5
DIGIT6:   .EQU $1A    ; decimalised digit 6
DIGIT7:   .EQU $1B    ; decimalised digit 7
DIGIT8:   .EQU $1C    ; decimalised digit 8

C:      .EQU 0        ; CARRY flag
Z:      .EQU 2        ; ZERO flag
W:      .EQU 0        ; Working register flag
F:      .EQU 1        ; File register flag

        .ORG 4        ; interrupt jump address
        GOTO START    ; interrupt vector address
        .ORG 5        ; start of program commands address

        GOTO START

TABLCD: ADDWF PCL,F     ; LCD initialisation table
        RETLW %00110011 ; initialise lcd - first byte
        RETLW %00110011 ; 2nd byte (repeat of first)
        RETLW %00110010 ; set for 4-bit operation
        RETLW %00101100 ; set for 2 lines
        RETLW %00000110 ; set entry mode to increment each address
        RETLW %00001100 ; set display on, cursor off, blink off
        RETLW %00000001 ; clear display
        RETLW %00000010 ; return home, cursor & RAM to zero
                        ; end initialisation table

START:    PAGE1          ; set for bank 1
          RP1LO
          CLRF TRISB     ; set PORT B for all outputs (%00000000)
          MOVLW 255      ; set PORT D for all inputs (%11111111)
          MOVWF TRISD
          MOVLW %00000110 ; pull up Rs on (bit 7 lo), timer 1/25
          MOVWF OPTION   ; set timer (with 3.2768MHz xtal)
          PAGE0          ; set for Bank 0

SETUP:    CALL PAUSIT    ;1/5 sec delay
          CLRF RSLINE

LCDSET:   CLRF LOOPB     ; clr LCD set-up loop
LCDST2:   MOVF LOOPB,W   ; get table address
          CALL TABLCD    ; get set-up instruction
          CALL LCDLIN    ; perform it
          INCF LOOPB,F   ; inc loop
          BTFSS LOOPB,3  ; has last LCD set-up instruction now been done?
          GOTO LCDST2    ; no
          CALL PAUSIT    ; 1/5 sec delay

          CLRF VALUE     ; clear simulation value
          CLRF LOOP1     ; clear loop counter

          BLOCK0         ; set for Block 0
          MOVLW MEM1     ; get address MEM1 (1st byte of 1st batch of 64)
          CALL GETBATCH  ; input & store 64 values from PORTB
          MOVLW MEM65    ; get address MEM65 (1st byte of 2nd batch)
          IORLW 128      ; set bit 7 high (%10000000 = 128 = $80)
          CALL GETBATCH  ; input & store 64 values from PORTB
          BLOCK1         ; set for Block 1
          MOVLW MEM129   ; get address MEM129 (1st byte of 3rd batch)
          CALL GETBATCH  ; input & store 64 values from PORTB
          MOVLW MEM193   ; get address MEM193 (1st byte of 4th batch)
          IORLW 128      ; set bit 7 high (%10000000 = 128 = $80)
          CALL GETBATCH  ; input & store 64 values from PORTB

          MOVLW 0        ; display letter "S" for start to prove LCD ok
          CALL LCDLIN1   ; set LCD for cell 0 line 1
          BSF RSLINE,4
          MOVLW 'S'      ; show S on screen
          CALL LCDOUT
          GOTO PART2

GETBATCH: MOVWF FSR      ; load FSR with value brought in on W
          BSF LOOP1,6    ; loop value to 64 (it was previously cleared)
GETIT:    MOVF VALUE,W   ; simulated value to store into memory banks
          MOVWF INDF     ; store at address pointed to by FSR
          INCF FSR,F     ; increment address held by FSR
          INCF VALUE,F   ; increment simulation value
          DECFSZ LOOP1,F ; decrement loop counter, is it zero?
          GOTO GETIT     ; no, continue sampling
          RETURN         ; end of sub-routine

;...........

PART2:    BLOCK0         ; set for Block 0
          MOVLW MEM1     ; get address MEM1 (1st byte of 1st batch of 64)
          CALL SHWBATCH  ; display values held in Bank 0 Block 0

          MOVLW 6        ; display "E" for end to show routine completed
          CALL LCDLIN1   ; set LCD for cell 6 line 1
          BSF RSLINE,4
          MOVLW 'E'      ; show E on screen
          CALL LCDOUT

HOLD:     GOTO HOLD      ; hold indefinately

SHWBATCH: MOVWF FSR      ; load FSR with value brought in on W
          MOVLW 64
          MOVWF LOOP1    ; set loop value to 64

GETVAL:   MOVF FSR,W     ; temp store FSR
          MOVWF FSRSTORE
          MOVF INDF,W    ; get value from address pointed to by FSR

          PAGE1          ; decimalisation variables held in BANK3
          RP1HI
          MOVWF COUNT0   ; put into LSB counter for decimalisation
          CLRF COUNT1    ; clear NMSB counter
          CLRF COUNT2    ; clear MSB counter
          BLOCK1
          CALL DECIMAL   ; perform decimalistion
          BLOCK0
          PAGE0          ; set for bank 2 for LCD output via PORTB
                         ; which can be accessed via Bank 0 or Bank 2
                         ; accessing via Bank 2 in this instance saves
                         ; two commands per Digit get/LCD write routine

          MOVF FSRSTORE,W ; recall previous FSR
          MOVWF FSR
          MOVLW 2        ;
          CALL LCDLIN1   ; set LCD address to line 1 cell 2
          BSF RSLINE,4

          PAGE1          ; Bank 3
          MOVF DIGIT3,W  ; get decimal digit 3
          IORLW 48
          PAGE0          ; Bank 2
          CALL LCDOUT    ; output decimalised value

          PAGE1          ; Bank 3
          MOVF DIGIT2,W  ; get decimal digit 2
          IORLW 48
          PAGE0          ;
          CALL LCDOUT    ; output decimalised value

          PAGE1          ; Bank 3
          MOVF DIGIT1,W  ; get decimal digit 1
          IORLW 48
          PAGE0          ;
          CALL LCDOUT    ; output decimalised value

          CALL PAUSIT2   ; pause for a while
          INCF FSR,F     ; increment address held by FSR
          DECFSZ LOOP1,F ; decrement loop counter, is it zero?
          GOTO GETVAL    ; no, continue sampling
          PAGE0          ; finally set for Bank 0
          RP1LO
          RETURN         ; end of sub-routine


;............. Modified BIN-DEC ROUTINE from Peter Hemsley 07JUN00
;              converts 24-bit binary (3 bytes) to decimal

DECIMAL:                 ; decimalise binary number ALL VALS IN BANK3
                         ; on entry COUNT0-2 holds number to be decimalised
                         ; answer goes into DIGIT1-8

BINDEC: CALL CLRDIG      ; reset DIGITs
        MOVLW 24         ; 24 bits to do
        MOVWF COUNTER1
        GOTO SHIFT1

ADJBCD  MOVLW DIGIT1
        IORLW %10000000
        MOVWF FSR        ; pointer to digits
        MOVLW 7          ; 7 digits to do (Digit 8 never >4)
        MOVWF COUNTER2   ; if Digit > 4 then digit = digit + 3
        MOVLW 3          ; check for Digit > 4 by adding 3 to it
ADJLOOP: ADDWF INDF,F    ; and test bit 3 of result
        BTFSS INDF,3     ; is it greater than 7?
        SUBWF INDF,F     ; restore to original
        INCF FSR,F       ; next digit
        DECFSZ COUNTER2,F
        GOTO ADJLOOP

SHIFT1: CALL SLCNT       ; shift MSB into Carry

SLDEC:  MOVLW DIGIT1     ; shift Carry and Digits 1 bit left
        IORLW %10000000
        MOVWF FSR        ; pointer to digits
        MOVLW 8          ; 8 Digits to do
        MOVWF COUNTER2

SLDLOOP:                 ; after RLF if bit 4 is set then shift 1
        RLF INDF,F       ; into LSB of next Digit else shift 0
        BTFSC INDF,4     ; test for BCD carry
        BSF STATUS,C     ; set Carry for next Digit (cleared by RLF)
        BCF INDF,4       ; clear BCD overflow (if any)
        INCF FSR,F       ; next Digit
        DECFSZ COUNTER2,F
        GOTO SLDLOOP

        DECFSZ COUNTER1,F ; next bit
        GOTO ADJBCD
        RETURN

SLCNT:  RLF COUNT0,F      ; LSB
        RLF COUNT1,F      ; shift left count 0-2
        RLF COUNT2,F      ; MSB
        RETURN

CLRDIG: CLRF DIGIT1       ; LSD
        CLRF DIGIT2
        CLRF DIGIT3
        CLRF DIGIT4
        CLRF DIGIT5
        CLRF DIGIT6
        CLRF DIGIT7
        CLRF DIGIT8       ; MSD
        RETURN

PAUSIT: MOVLW 5
        MOVWF SLOWIT
        CLRF INTCON
PAUSE:  BTFSS INTCON,2
        GOTO PAUSE
        BCF INTCON,2
        DECFSZ SLOWIT,F
        GOTO PAUSE
        RETURN

PAUSIT2: MOVLW 25
        MOVWF SLOWIT
        CLRF INTCON
PAUSE2: BTFSS INTCON,2
        GOTO PAUSE2
        BCF INTCON,2
        DECFSZ SLOWIT,F
        GOTO PAUSE2
        RETURN

LCDLIN1: IORLW %10000000
         GOTO LCDLIN
LCDLIN2: IORLW %11000000
LCDLIN:  BCF RSLINE,4

LCDOUT: MOVWF STORE
        MOVLW 50
        MOVWF LOOPA
DELAY:  DECFSZ LOOPA,F
        GOTO DELAY
        CALL SENDIT
SENDIT: SWAPF STORE,F
        MOVF STORE,W
        ANDLW 15
        IORWF RSLINE,W
        MOVWF PORTB
        BSF PORTB,5
        BCF PORTB,5
        RETURN
