// This handles the low level data steams for the IR/RF remote
// link to Digibox     

// Functions available from this routine are

// button();			This sends the corresponding number
// power();			This turns off the digibox
// sky(); 		 	function of the "sky" button on remote.
// backup(); 			function of the "backup" button on remote

// ***********************************************************************
// This routine sends out a burst of 16 clock cycles in length.
// if "value" 1 then 16 pulses sent 
// if 0 then no pulses but a delay equivalent to 16 clock cycles
// the clock signal is the xtal freq/100 = 35.79khz
int clock(int value)
{int count;
 output_bit(data_control_out,value);
 count=0;
 while(count<15)
   {
    while(input(clock_in))   
     {}
    count++;
    while(!input(clock_in))  
     {}
    } 
 return;
}

// ***********************************************************************
// routine to send 8 bytes of data
int send_bytes(int byte_val)
{int tmp=0;

 for(tmp=0;tmp<8;tmp++)
  {
   if((byte_val&0x80)>0)
    clock(1);
   else
    clock(0);
   byte_val=byte_val*2;
  }
 return;
}
// ***********************************************************************
int preamble(void)
{// the bytes of the remote control data that is constant.
 send_bytes(0x0F);
 send_bytes(0xCA);
 send_bytes(0x93);
 send_bytes(0x55);
 send_bytes(0x55);
 send_bytes(0x55);
 return;
}
// ***********************************************************************
// The button marked with the sky symbol on the remote.
// data sent three times
int sky(void)
{int tmp=0;
 for(tmp=0;tmp<3;tmp++)
  {lcd_gotoxy(15,2);lcd_putc(">>");
   preamble();
   send_bytes(0x95);
   send_bytes(0x55);
   output_bit(data_control_out,0);
   delay_ms(120);
   lcd_gotoxy(15,2);lcd_putc("  ");
   }
  delay_ms(120);
 return;
}
// ***********************************************************************
// Backup button
int backup(void)
{lcd_gotoxy(15,2);lcd_putc(">>");
 preamble();
 send_bytes(0x95);
 send_bytes(0x5A);
 output_bit(data_control_out,0);
 delay_ms(120);
 lcd_gotoxy(15,2);lcd_putc("  ");
 return;
}
// ***********************************************************************
int button(int knob)
{// the remote data that is specific to each different button

 lcd_gotoxy(15,2);lcd_putc(">>");
 preamble();
 send_bytes(0x55);
 if(knob==0x00) {send_bytes(0x55);}	//button 0
 if(knob==0x01) {send_bytes(0x56);}	//button 1
 if(knob==0x02) {send_bytes(0x59);}	//button 2
 if(knob==0x03) {send_bytes(0x5A);}	//button 3
 if(knob==0x04) {send_bytes(0x65);}	//button 4
 if(knob==0x05) {send_bytes(0x66);}	//button 5
 if(knob==0x06) {send_bytes(0x69);}	//button 6
 if(knob==0x07) {send_bytes(0x6A);}	//button 7
 if(knob==0x08) {send_bytes(0x95);}	//button 8
 if(knob==0x09) {send_bytes(0x96);}	//button 9
 if(knob==0x0A) {send_bytes(0xA5);}	//power button
 output_bit(data_control_out,0);	//turn off pulses
 delay_ms(150);
 lcd_gotoxy(15,2);lcd_putc("  ");
 return;
}
// ***********************************************************************
int power(void)
{// switch the power button
 button(0x0A);
 return;
}
// ***********************************************************************
