///////////////////////////////////////////////////////////////////////////
////                           4x4KBD.C                                ////
////                  Generic keypad scan driver                       ////
////                                                                   ////
////  kbd_init()   Must be called before any other function.           ////
////                                                                   ////
////  c = kbd_getc()   Will return a key value if pressed or /0 if not ////
////                   This function should be called frequently so as ////
////                   not to miss a key press.                        ////
////                                                                   ////
///////////////////////////////////////////////////////////////////////////
////        (C) Copyright 1996,1997 Custom Computer Services            ////
//// This source code may only be used by licensed users of the CCS C   ////
//// compiler.  This source code may only be distributed to other       ////
//// licensed users of the CCS C compiler.  No other use, reproduction  ////
//// or distribution is permitted without written permission.           ////
//// Derivative programs created using this software in object code     ////
//// form are not restricted in any way.                                ////
////////////////////////////////////////////////////////////////////////////

// The following defines the keypad layout on port B  
#byte kbd = 6   // Keypad is connected to port B (address 6)

//Keypad connection:   (for example column 0 is B2)
//                Bx:

#define COL0 (1 << 4)
#define COL1 (1 << 5)
#define COL2 (1 << 6)
#define COL3 (1 << 7)

#define ROW0 (1 << 0)
#define ROW1 (1 << 1)
#define ROW2 (1 << 2)
#define ROW3 (1 << 3)

#define ALL_ROWS (ROW0|ROW1|ROW2|ROW3)
#define ALL_PINS (ALL_ROWS|COL0|COL1|COL2|COL3)

#byte port_b = 6

// Keypad layout:
char const KEYS[4][4] = {{'1','4','7','F'},
                         {'2','5','8','0'},
                         {'3','6','9','E'},
                         {'A','B','C','D'}};


void kbd_init() 
{
#ifdef __PCM__
    port_b_pullups(true);   // If not PCM be sure to use external pullups
#endif

#ifndef KBD_DEBOUNCE_FACTOR
 #define KBD_DEBOUNCE_FACTOR 10   // Set this number to apx n/333 where
#endif                            // n is the number of times you expect
                                  // to call kbd_getc each second
}


char kbd_getc( ) {
   static byte kbd_call_count;
   static short int kbd_down;
   static char last_key;
   static byte col;

   byte kchar;
   byte row;

   port_b_pullups(true);

   kchar='\0';
   if(++kbd_call_count>KBD_DEBOUNCE_FACTOR) {
       switch (col) {
         case 0   : set_tris_b(ALL_PINS&~COL0);
                    kbd=~COL0&ALL_PINS;
                    break;
         case 1   : set_tris_b(ALL_PINS&~COL1);
                    kbd=~COL1&ALL_PINS;
                    break;
         case 2   : set_tris_b(ALL_PINS&~COL2);
                    kbd=~COL2&ALL_PINS;
                    break;
         case 3   : set_tris_b(ALL_PINS&~COL3);
                    kbd=~COL3&ALL_PINS;
                    break;
       }

       if(kbd_down) {
         if((kbd & (ALL_ROWS))==(ALL_ROWS)) {
           output_bit(backlight,1);
           light=lamp_period;   //used to time key functions
           lite =lite_period;   //used to switch backligh
	   kbd_down=false;
           kchar=last_key;
           last_key='\0';
         }
       } else {

          if((kbd & (ALL_ROWS))!=(ALL_ROWS)) {
             if((kbd & ROW0)==0)
               row=0;
             else if((kbd & ROW1)==0)
               row=1;
             else if((kbd & ROW2)==0)
               row=2;
             else if((kbd & ROW3)==0)
               row=3;
             last_key =KEYS[row][col];
             kbd_down = true;
          } else {
             ++col;
             if(col==4)
               col=0;
          }
       }
      kbd_call_count=0;
   }
   port_b_pullups(false);
  set_tris_b(ALL_PINS);
  return(kchar);
}

