;Sixteen channel 2-wire transmitter IC1, 5mS delay
;For PIC16F84
;A.J.Flind, 4/4/99
;xtal 4MHz
;Watchdog timer ON
;Startup timer ON

#DEFINE page0 BCF status,5              
#DEFINE page1 BSF status,5              
		
status:   .EQU $03        ;general equates
portA:    .EQU $05        
trisA:    .EQU $05        
portB:    .EQU $06        
trisB:    .EQU $06        
pcl:      .EQU $02        
rtcc:     .EQU $01        
option:   .EQU $01        
intcon:   .EQU $0B        
f:        .EQU $01        
w:        .EQU $00        
z:        .EQU $02        
c:        .EQU $00                


count:    .EQU $0C        ;program specific equates
dcount:   .EQU $0D
sw1:      .EQU $0E
sw2:      .EQU $0F
dcount2:  .EQU $10

	.org $0004      ;interrupt vector
	.org $0005      ;start of program
	
start:	page1               
	movlw %00010011     
	movwf trisA         ;RA2,3 output, RA0,1,4, input
	movlw 255
	movwf trisB         ;RB0-7 input
	movlw %01111111
	movwf option        ;pull-ups on, watchdog set up
	page0
;==============================================          
	clrwdt              ;clear watchdog timer
	clrf sw1            ;initialise two files
	clrf sw2
	movlw 7             ;initial delay to ensure sync
	movwf dcount        ;of transmitters. Set for 5 or 10mS
jmp0:	movlw 237           ;as required.
	movwf dcount2       
jmp1:	decfsz dcount2,f    ;use 7 and 237 for 5mS
	goto jmp1           ;use 13 and 255 for 10mS 
	decfsz dcount,f     
	goto jmp0

jmp2:	movlw 255           ;monitor RA0 for silence >1.8mS
	movwf count
jmp3:	btfss portA,0
	goto jmp2
	nop
	nop
	decfsz count,f
	goto jmp3
	
	page1               
	bcf trisA,0
	page0
	bsf portA,0         ;mute the local rx
	
;==============================================          
	movlw 255           ;get remote switch pattern
	movwf sw2           ;set all of sw2 high (all "off")
	page1               ;make RA1 output
	bcf trisA,1
	page0
	bcf portA,1         ;pulse it low
	call dly135
	page1               ;return RA1 to input
	bsf trisA,1
	page0
	call dly50          ;wait 50uS
	btfss portA,1       ;check RA1 state
	bcf sw2,0           ;if it's low, clear sw2,0 ("on")
	call dly98          ;wait 100uS
	btfss portA,1       ;continue for remaining 7 bits
	bcf sw2,1
	call dly98
	btfss portA,1
	bcf sw2,2
	call dly98
	btfss portA,1
	bcf sw2,3
	call dly98
	btfss portA,1
	bcf sw2,04
	call dly98
	btfss portA,1
	bcf sw2,5
	call dly98
	btfss portA,1
	bcf sw2,6
	call dly98
	btfss portA,1
	bcf sw2,7
	call dly98          ;sw2 now contains remote switches.
	
	movf portB,w        ;get own switch pattern
	movwf sw1           ;put it into file sw1
	
	nop                 ;here beginneth transmission
	nop                 ;of the first 8 switches
	call pulse          ;first clock pulse
	nop
	nop
	nop
	btfss sw1,0         ;if switch was on (low) send pulse
	call pulse
	btfsc sw1,0         ;if not send space
	call space
	nop
	nop
	call pulse          ;continue for remaining 7 switches
	nop
	nop
	nop
	btfss sw1,1
	call pulse
	btfsc sw1,1
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw1,2
	call pulse
	btfsc sw1,2
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw1,3
	call pulse
	btfsc sw1,3
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw1,4
	call pulse
	btfsc sw1,4
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw1,5
	call pulse
	btfsc sw1,5
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw1,6
	call pulse
	btfsc sw1,6
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw1,7
	call pulse
	btfsc sw1,7
	call space
	
	nop                 ;repeat for next 8 switches
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,0
	call pulse
	btfsc sw2,0
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,1
	call pulse
	btfsc sw2,1
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,2
	call pulse
	btfsc sw2,2
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,3
	call pulse
	btfsc sw2,3
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,4
	call pulse
	btfsc sw2,4
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,5
	call pulse
	btfsc sw2,5
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,6
	call pulse
	btfsc sw2,6
	call space
	nop
	nop
	call pulse
	nop
	nop
	nop
	btfss sw2,7
	call pulse
	btfsc sw2,7
	call space          ;all 16 switches now sent

	page1
	bsf trisA,0
	page0               ;cancel local RX muting
	
	goto start          ;and do it all again
;============================================== 
pulse:	call pdlya          ;bipolar pulse output pattern
	bcf portA,2         ;takes exactly 1mS
	call pdlyb
	bsf portA,2
	call pdlyc
	bsf portA,3
	call pdlyb
	bcf portA,3
	call pdlya
	return
;==============================================          
space:	movlw 4             ;quiescent output state
	movwf dcount        ;for exactly 1mS
spca:	movlw 81
	movwf dcount2
spcb:	decfsz dcount2,f
	goto spcb
	decfsz dcount,f
	goto spca
	nop
	nop
	nop
	return
;============================================== 
pdlya:	movlw 27            ;used by "pulse"
	movwf dcount
paa:	decfsz dcount,f
	goto paa
	nop
	return
;==============================================          
pdlyb:	movlw 103           ;used by "pulse"
	movwf dcount
pba:	decfsz dcount,f
	goto pba
	nop
	nop
	return
;==============================================          
pdlyc:	movlw 59            ;used by "pulse"
	movwf dcount
pca:      decfsz dcount,f
	goto pca
	return
;==============================================          
dly50:	movlw 15            ;used in "send"
	movwf dcount
d50a:     decfsz dcount,f
	goto d50a
	return
;==============================================          
dly98:	movlw 31            ;used in "send"
	movwf dcount
d98a:     decfsz dcount,f
	goto d98a
	return
;==============================================
dly135:	movlw 43            ;used in "send"
	movwf dcount
d135a:	decfsz dcount,f
	goto d135a
	nop
	return
;============================================== 
	.END


