;timegen.asm        

	LIST    C=120 
	LIST    P=16C84

;date   12/10/98


;program with   osc hs
;               wdt on
;               put on
;               cp  off    



;setup of address registers

;file registers        ;bank

INDF:	EQU 00h        ;0 & 1
TMR:    EQU 01h        ;0
OPTIO:  EQU 01h        ;1
PCL:    EQU 02h        ;0 & 1
STATUS: EQU 03h        ;0 & 1
FSR:    EQU 04h        ;0 & 1
PORTA:  EQU 05h        ;0
TRISA:  EQU 05h        ;1
PORTB:  EQU 06h        ;0
TRISB:  EQU 06h        ;1
EEDATA: EQU 08h        ;0
EECON1: EQU 08h        ;1
EEADR:  EQU 09h        ;0
EECON2: EQU 09h        ;1
PCLATH: EQU 0Ah        ;0 & 1
INTCON: EQU 0Bh        ;0 & 1


W:      EQU 0  ;Result to go into working register (accumulator)
F:      EQU 1  ;Result to go into a file register.

;STATUS FLAGS

C:      EQU 0  ;Carry flag  (located in STATUS register)
CY:	EQU 0  ;  "
DC:     EQU 1  ;Digit carry            "
Z:      EQU 2  ;Zero flag              "
PD:     EQU 3  ;Power Down bit         "
TO:     EQU 4  ;Time-out bit           "
RP0:	EQU 5


;INTCON FLAGS
TOIF:	EQU 2  ;tmr0 int INTCON reg  
INTF:	EQU 1  ;Int interrupt flag
GIE:    EQU 7  ;GIE bit in INTCON reg

;EEprom switches
rd      EQU     0   
wr      EQU     1
wren    EQU     2
wrerr	EQU	3
eeif	EQU	4

;EE memory 1,000,000 write cycles
EMIN    equ     00h-19h	;YRS low 5 bits
EHRS    equ     21h
EDAY    equ     22h
EMTH    equ     23h
EYRS    equ     24h
EYRSH	equ	25h
ELINE	equ	26h
EFLAG2  equ	27h
ETRIM	equ	28h
ECHK1	equ	29h
ECHK2	equ	2Ah

;RAM

SAVEW1  equ     0Ch
SAVEPS1 equ     0Dh

SEC     equ     0Eh	
MIN     equ     0Fh	
HRS     equ     10h	 
DAY     equ     11h	
MTH     equ     12h	
YRS     equ     13H	
YRSH    equ     14h
LINE    equ     15h
FLAG2   equ     16h
TRIM    equ     17h 

CALIB2	equ	18h
CALIB1 	equ     19h
CALIB3  equ     1Ah 
SWTIMER equ     1Bh
MODETM  equ     1Ch
LINECNT equ     1Dh
POINTER equ     1EH      
COUNT   equ     1Fh
OFFSET  equ     20h
SHIFT   equ     21h
SHFT1   equ     22H
SHIFTCNT equ    23h
LINEN   equ     24h
FLAG    equ     25h
CAMMODE equ     26h
CLOCK1  equ     27h
MODE    equ     28h
CAM     equ     29h
MAINTM  equ     2Ah
LTIME  	equ    	2Bh
TEMP    equ     2Ch
TEMP1	equ	2Dh	

PSTORE	equ	2Eh	
CHARW   equ     2Fh	
    
    
    
BLANKADR        equ     0A0h
FADR    	equ     0B0h
CADDR   	equ     0C0h
COLONADR        equ     0D0h
SLASHADR        equ     0E0h
NEGADR		equ	0F0h

CHARWID         equ     8   

BLANK   equ     0AAh


;PORTA bits


A8      equ     0       ;out
A9      equ     1       ;out
A10     equ     2       ;out
sp	equ     3       ;out
SW      equ     4       ;in


;PORTB bits

SYNCINT equ     0h      ;in
ENVIDO  equ     1h      ;out
VID     equ     2h      ;out
CNTCK   equ     3h      ;out/in during screen update
FRAME   equ     4h      ;in
CNTRES  equ     5h      ;out
WE      equ     6h      ;out 
CS      equ     7h      ;out

;FLAG bits
;0      1=wrram, 0=readram
;1      1= > 256 lines
;2      
;3      SW pressed
;4      
;5      line 256 count
;6      time cy-inctime routine
;7      enable inctime every second

;FLAG2 bits
;0      character height bit0
;1      character height bit1
;2      inverse video
;3      display camera number
;4      swap day/month
;5     
;6      time display
;7      date display


ei      MACRO
	bsf     INTCON,7
	ENDM

di      MACRO
	bcf     INTCON,7
	ENDM


push1   MACRO
	movwf   SAVEW1          ;save W
	swapf   STATUS,w        ;move status without altering flags
	movwf   SAVEPS1         ;save STATUS
	ENDM

pop1    MACRO
	swapf   SAVEPS1,w
	movwf   STATUS          ;restore STATUS
	swapf   SAVEW1
	swapf   SAVEW1,w        ;restore W without altering flags
	ENDM



#DEFINE	BANK0	bcf	STATUS,5
#DEFINE	BANK1   bsf	STATUS,5


org     0h
	goto    begin


org     4h      ;interupt vector
	goto    interrupt



;initialisation


begin
    
    
;setup Ra and Rb inputs and outputs

	BANK1           	;Defined above.
        movlw   b'00010001'
        movwf   TRISB     	;Configure port B

        movlw   b'10000'
        movwf   TRISA     	;A0-A4 as output, A4=o/p
        
        movlw   b'11000111'     ;select no pullups, rising edge,
        movwf   OPTIO		;prescaler 1:256 on tmr0
        BANK0			;(inc tmr0 every 0.4x256us=102.4us)

;setup interrupt
       
	movlw   b'00010000'     ;enable intf only (video line sync)
	movwf   INTCON

;clear video ram memory
	
	call	CLRRAM
	
;initialise reg files 0Ch to 2Fh to 0

        movlw 	0Ch		
        movwf 	FSR		;point at lowest file reg
resr    clrf 	INDF		;clear file register
        incf 	FSR		;point to next
        movf	FSR,w
        xorlw	30h		;exit if past file 2Fh
        btfss	STATUS,Z
        goto resr        
		
	clrf    PORTA
	clrf    PORTB

	movlw   .7
	movwf   CALIB1
	movlw   .38
	movwf   CALIB2
	movwf	CALIB3
	movwf	CLOCK1
	
getsets	movlw	EDAY		;get time/date/settings from eeprom
	call	read
	movwf	DAY
	call	rubtest
	sublw	31h		;c=0 if day>31	
	btfsc	STATUS,CY
	goto	gmth	
	movlw	1
	movwf	DAY
	
gmth	movlw	EMTH
	call	read
	movwf	MTH
	call	rubtest
	sublw	12h		;c=0 if mth>12	
	btfsc	STATUS,CY
	goto	gyrs
	movlw	01h
	movwf	MTH
			
gyrs	movlw	EYRS
	call	read
	movwf	YRS
	call	rubtest		;can be 00 to 99
		
	movlw	EYRSH
	call	read
	movwf	YRSH
	xorlw	19h
	btfsc	STATUS,Z
	goto	ghrs
	movf	YRSH,w
	xorlw	20h
	btfsc	STATUS,Z
	goto	ghrs
	movlw	19h
	movwf	YRSH
	movlw	98h
	movwf	YRS

ghrs	movlw	EHRS
	call	read
	movwf	HRS
	call	rubtest
	sublw	23h		;c=0 if hrs>23	
	btfss	STATUS,CY
	clrf	HRS

gmin	movf	YRS,w
	andlw	1Fh		;select lsb = address for min in eeprom
	call	read
	movwf	MIN
	call	rubtest
	sublw	59h		;c=0 if min>59	
	btfss	STATUS,CY
	clrf	MIN

	
	movlw	ETRIM
	call	read
	movwf	TRIM
	
	movlw	EFLAG2
	call	read
	movwf	FLAG2
	
	movlw	ELINE
	call	read
	movwf	LINE
	
	movlw	.35
	subwf	LINE,w		;clr line if > 256 + 35
	btfsc	STATUS,CY
	clrf 	LINE
	
	;write security echk1,2 and save everything back to eeram 

	
	movlw	ECHK2
	movwf	EEADR	;echk2
	movlw	0AAh
	movwf	EEDATA
	call	eesav1		
	
	decf	EEADR	;echk1
	movlw	55h
	movwf	EEDATA
	call	eesav1
	
	movlw	ETRIM
	movwf	EEADR
	movlw	TRIM
	movwf	FSR			
savelp	movf	INDF,w
	movwf	EEDATA
	call	eesave					
	decf	EEADR													
	decf	FSR
	movf	FSR,w
	xorlw	EHRS-1
	btfss	STATUS,Z
	goto	savelp						
									
	movf	YRS,w
	andlw	1Fh
	movwf	EEADR
	movf	MIN,w
	movwf	EEDATA
	call	eesave
	ei
	

;========================================================= 

;main program

main    clrwdt     


ramwr 	btfss   PORTB,FRAME    ;bypass if FRAME sync low
	goto    ramend

compile
	btfss   FLAG,0          ;write to ram if 1   
	goto    ramend


	movf    PSTORE,w
	movwf	PORTA
	movwf	POINTER
	
	sublw	6
	bc	comp2		;clear if pointer>6
	clrf	PSTORE
	clrf	PORTA
	clrf	POINTER
comp2
	BANK1           	;Defined above.
        movlw   b'00010001'
        movwf   TRISB  
	BANK0
	
comp1	bsf     PORTB,CNTRES   ;ram address reset
	bcf     PORTB,CNTRES   ;remove ram address reset

	call    wrline

	incf	PSTORE
	
	call	READCAM
	bcf     FLAG,0          ;tell interrupt its ok to read ram
	
ramend  BANK1           	;Defined above.
        bsf	TRISB,2		;vid=i/p
	BANK0


;check for switch press

switch  btfsc   PORTA,SW
	goto    swoff

swon   

	movlw   .15
	movwf   MODETM          ;setup modetimer to 15 secs - MODE will
				;be reset to 0 15secs after last key press

	bsf     FLAG,3          ;tell SWTIMER to inc in timer routine  
	movlw   .96             ;SWTIMER is inc every 26ms in timer routine
	subwf   SWTIMER,w       ;cy set if SWTIMER>2.5 SEC
	bnc     swexit          ;no

fivsc   movlw   .48
	movwf   SWTIMER         ;2x speed up MODE switch

	incf    MODE
	movlw   .14
	subwf   MODE,w          ;cy set if MODE>13
	bnc     swexit          ;exit
	clrf    MODE            ;clear MODE
	goto    swexit1


swoff   btfss   FLAG,3
	goto    swexit
	
	bcf     FLAG,3          ;stop SWTIMER from incrementing 
	movlw   .2
	subwf   SWTIMER,w       ;cy set if SWTIMER >=2
	bnc     swexit1
	movlw   .50
	subwf   SWTIMER,w       ;cy set if SWTIMER>=50 (1SEC)
	bc      swexit1
       
	call    addtime         ;inc appropriate time

swexit1 clrf    SWTIMER  

swexit



timer:	

	;TMR0 and PRESCALER form a 16 bit counter incremented 
	;every 0.4us(10MHz xtal)
	;TMR0 will therefore overflow every 0.4x256x256 = 26.2144ms=clock1
	;1 sec = 38.147 x clock1
	;INTCON bit 2 used to indicate overflow
	
	btfss	INTCON,2	;has timer0 overflowed ?
	goto	extime1		;no
	bcf	INTCON,2	;clear flag
	
	;here every 26ms
									
	decfsz   CLOCK1           
	goto	extime   
	  
	;here every second
	
	movlw   .38            ;38 CLOCK1=1SEC
	movwf   CLOCK1
	
	;modify counter to achieve 1sec/day accuracy (assume 0ppm xtal)
							
	decfsz  CALIB1         ;inc CLOCK1 every 7 secs
	goto	inctime	       ;i.e 39 overflows, so in 7secs
	movlw   .7             ;use 7x38+1=267 overflows =
	movwf   CALIB1         ;267 x 26.2144ms = 6.9992448sec
	incf    CLOCK1            
	decfsz	CALIB2				
	goto	inctime		;every 35x 7sec periods add another CLOCK1
	movlw	.35		;desired= 35x7=245 sec
	movwf	CALIB2		;actual 35 x 6.9992448 +0.0262144= 244.99978sec
	incf    CLOCK1 		;1 day=86400sec
				;actual = 86399.923sec,so gains less
				;than 100 msec/day
				

inctime	
	movf    MODETM,w        ;dec MODE timer every SEC
	btfss   STATUS,Z
	decf    MODETM
	
	call    incsec
	btfss   FLAG,6
	goto    extime
				;here every minite
  	
  	decfsz	CALIB3		;every 38 min add or subtract trim value
	goto	incm1		;to CLOCK1. This relates to sec/day 
	movlw	.38
	movwf	CALIB3
	movlw	9		;w=trim-9 (F7 to 09 = -9 to +9)
	subwf	TRIM,w		;add or subrtact trim value
	addwf	CLOCK1		;adjust CLOCK1 every 38 minites
	
incm1  	call    incmin
	btfss   FLAG,6
	goto    extime
	
   	call    inchrs
	btfss   FLAG,6
	goto    extime
	
	call    incday
	btfss   FLAG,6
	goto    extime
	
	call    incmth
	btfss   FLAG,6
	goto    extime
	
	call    incyrs
	
extime  
					
	btfsc   FLAG,3          ;inc SWTIMER if switch pressed
	incf    SWTIMER         ;every 26ms

	movf    MODETM,w        ;clear MODE if MODE timer=0
	btfss   STATUS,Z  

	goto	extime1
	
	movf	MODE,w
	btfss	STATUS,Z
	call	CLRRAM		;clrram when mode first goes to 0
	clrf    MODE
	
extime1	goto    main


;=======================================================

;subroutines

CLRRAM:	
	di

	BANK1           	;Defined above.
        bcf	TRISB,2		;vid=o/p  
	BANK0	
	
	bsf	PORTB,CNTRES
	bcf	PORTB,CNTRES	;reset counter address
	clrf	PORTA		;set address to 0h

clram1	movlw	.43	
	movwf	COUNT
		
clram2	clrf	SHIFT
	
	
	
	call	WRRAM2
	decfsz	COUNT
	goto	clram2	
	
nextl	bsf	PORTB,CNTRES
	bcf	PORTB,CNTRES

	incf	PORTA
	movf	PORTA,w
	andlw	0Fh
	xorlw	8
	btfss	STATUS,Z
	goto	clram1

clrend	clrf	PORTA
	BANK1           	;Defined above.
        bsf	TRISB,2		;vid=i/p  
	BANK0	
	ei
	return


READCAM:

	;read active camera
	
	clrf	PORTA		;set all port A bits = 0 
	bsf	STATUS,RP0
	movlw   b'11111'
	movwf   TRISA          ;set a4,3,2,1,0 to inputs
	bcf	STATUS,RP0
	nop
	nop
	nop
	movf    PORTA,w
	andlw	0Fh
	movwf   CAMMODE
	andlw   7               ;
	movwf   CAM
	incf 	CAM		;change from 0-7 to 1-8
	bsf	STATUS,RP0
	movlw   b'10000'
	movwf   TRISA          ;set a0,1,2 back to outputs
	bcf	STATUS,RP0
	clrf	PORTA
	return       
	



wrline:  
	movlw	CHARWID
	movwf	CHARW
	
	call    wrblank
	
	movf	MODE,w
	btfsc	STATUS,Z
	goto	dispnow	
	sublw	7
	btfss	STATUS,CY	;c=1 if w<=7
	goto	dispnow
	
	movlw	CHARWID-1
	movwf	CHARW
	
	movlw	FADR
	call	wrram
	swapf	MODE,w
	call	wrram
 
 	movf	MODE,w
 	xorlw	7
 	btfss	STATUS,Z
 	goto	doblk
 
 		;here if function 7		
 	movlw	.9
 	subwf	TRIM,w		;w= trim-9
 	movwf	FSR		;temp save
 	btfss	FSR,7		;negative ?
 	goto	trimpos		;no positive
 	
 	
 	movlw   NEGADR
	call    wrram		;print - 
 	
 	comf	FSR
 	incf	FSR		;negate
 	goto	trimp	
 	 	
trimpos	call    wrspace	
trimp	swapf	FSR,w
	call	wrram
		
doblk	call    wrspace
	call    wrblank


dispnow	call    wrspace
		
	movf	FLAG2,w
	andlw	b'11000000'
	btfsc	STATUS,Z
	bsf	FLAG2,6		;ensure time or date or both on
	
	btfss	FLAG2,6
	goto	dispdate
	
	movf    MODE,w
	xorlw   8
	bnz     dohrs
	movlw   BLANK
	btfss   CLOCK1,3
dohrs   movf	HRS,w
	movwf   TEMP
	call    wrram           ;write msd to ram
	swapf   TEMP,w
	call    wrram           ;write lsd to ram

	movlw   COLONADR
	call    wrram

	movf    MODE,w
	xorlw   9
	bnz     domin
	movlw   BLANK
	btfss   CLOCK1,3
domin   movf	MIN,w
	movwf   TEMP
	call    wrram           ;write msd to ram
	swapf   TEMP,w
	call    wrram           ;write lsd to ram


	movlw   COLONADR
	call    wrram

	movf    MODE,w
	xorlw   .10
	bnz     dosec
	movlw   BLANK
	btfss   CLOCK1,3
dosec   movf    SEC,w
	movwf   TEMP
	call    wrram           ;write msd to ram
	swapf   TEMP,w
	call    wrram           ;write lsd to ram

	
	call    wrspace
	call    wrspace
	
dispdate
	
	btfss	FLAG2,7
	goto	disprest
	
	btfsc	FLAG2,4		;0=dd/mm  , 1=mm/dd
	goto	dmth
	
	
dday	movf    MODE,w
	xorlw   .11
	bnz     doday
	movlw   BLANK
	btfss   CLOCK1,3
doday   movf	DAY,w
	movwf   TEMP
	call    wrram           ;write msd to ram
	swapf   TEMP,w
	call    wrram           ;write lsd to ram

	movlw   SLASHADR
	call    wrram

	btfsc	FLAG2,4		;0=dd/mm  , 1=mm/dd
	goto	ddend
	
dmth	movf    MODE,w
	xorlw   .12
	bnz     domth
	movlw   BLANK
	btfss   CLOCK1,3
domth   movf	MTH,w
	movwf   TEMP
	call    wrram           ;write msd to ram
	swapf   TEMP,w
	call    wrram           ;write lsd to ram
		
	movlw   SLASHADR
	call    wrram

	btfsc	FLAG2,4		;0=dd/mm  , 1=mm/dd
	goto	dday

ddend	movf    MODE,w
	xorlw   .13
	bnz     doyrsh
	movlw   BLANK
	btfss   CLOCK1,3
doyrsh  movf	YRSH,w
	movwf   TEMP
	call    wrram           ;write msd to ram
	swapf   TEMP,w
	call    wrram           ;write lsd to ram

	movf    MODE,w
	xorlw   .13
	bnz     doyrs
	movlw   BLANK
	btfss   CLOCK1,3
doyrs	movf	YRS,w
	movwf   TEMP
	call    wrram           ;write msd to ram
	swapf   TEMP,w
	call    wrram           ;write lsd to ram
	
	
	
disprest
	movlw   BLANKADR
	call    wrram
	movlw   BLANKADR
	call    wrram
	

lastwr	btfss	FLAG2,3
	goto	blanks
	
wrcam	movlw   CADDR
	call    wrram
	
	movlw	NEGADR
	btfsc	CAMMODE,3
	movlw   SLASHADR
	call    wrram
	
	swapf   CAM,w           ;1 to 8
	call    wrram

	call    wrspace
	call    wrblank
	return
		
blanks	call	wrblank
	call	wrblank
	call	wrblank
	call	wrblank
	call	wrblank
	return
			
wrblank	movlw   BLANKADR
	call    wrramblk
	return

wrspace	movlw   BLANKADR
	call    wrram
	return
	   

wrramblk
	andlw   0f0h            ;select top nibble
	call    segment
	movwf   SHIFT
	goto	WRRAM2
	
wrram	andlw   0f0h            ;select top nibble
	call    segment
	movwf   SHIFT	
	btfss	FLAG2,2
	goto	WRRAM2
	comf	SHIFT		;invert

WRRAM2	clrwdt 
	movf	CHARW,w
	movwf   SHIFTCNT
wrram1  bcf     PORTB,VID
	btfsc   SHIFT,7
	bsf     PORTB,VID      ;copy top of SHIFT to VID ram 
	
		
	bcf	PORTB,CS
	bcf     PORTB,WE

	bsf     PORTB,WE       ;write to video ram
	bsf	PORTB,CS

	bsf     PORTB,CNTCK    ;inc ram address
	bcf     PORTB,CNTCK
	rlf     SHIFT           ;SHIFT next bit into bit 5    
	decfsz  SHIFTCNT
	goto    wrram1
	return
;***************************************************************




incsec  incf    SEC
	bcf     FLAG,6    
	movf    SEC,w
	andlw   0fh
	xorlw   0ah
	bnz     sc1
	movlw   6
	addwf   SEC
sc1     movf    SEC,w
	xorlw   60h
	bnz     sc2
	clrf    SEC
	bsf     FLAG,6
sc2     return          ;FLAG.6 set if carry to next digit 



incmin  bcf     FLAG,6  
	incf    MIN
	movf    MIN,w
	andlw   0fh
	xorlw   0ah
	bnz     mn1
	movlw   6
	addwf   MIN
mn1     movf    MIN,w
	sublw	59h	;c=0 if min>59
	bc      mn2
	clrf    MIN
	bsf     FLAG,6  
mn2     movf    MIN,w   ;save in eeprom
	movwf   EEDATA
	movf	YRS,w
	andlw	1Fh	;distribute min to eeprom 00 to 09 locations	
	movwf   EEADR
	call    eesave
	return          ;FLAG set if carry to next digit 


inchrs  bcf     FLAG,6  
	incf    HRS
	movf    HRS,w
	andlw   0fh
	xorlw   0ah
	bnz     hr1
	movlw   6
	addwf   HRS
hr1     movf    HRS,w
	sublw   23h	;c=0 if hrs>23
	bc      hr2
	clrf    HRS
	bsf     FLAG,6  
hr2     movf    HRS,w   ;save in eeprom
	movwf   EEDATA
	movlw   EHRS
	movwf   EEADR
	call    eesave
	return          ;FLAG set if carry to next digit 
		    
	
incday  bcf     FLAG,6  
	incf    DAY
	movf    DAY,w
	andlw   0fh
	xorlw   0ah
	bnz     dy1
	movlw   6
	addwf   DAY
dy1     call    mthdays         ;get no of days in month     
dy3     addlw   1
	subwf   DAY,w           ;cy set if DAY >= no of days in month
	bnc     dy4
	movlw   1
	movwf   DAY
	bsf     FLAG,6
dy4     movf    DAY,w   ;save in eeprom
	movwf   EEDATA
	movlw   EDAY
	movwf   EEADR
	call    eesave
	return          ;FLAG set if carry to next digit 


incmth  bcf     FLAG,6  
	incf    MTH
	movf    MTH,w
	andlw   0fh
	xorlw   0ah
	bnz     mt1
	movlw   6
	addwf   MTH
mt1     movf    MTH,w
	sublw	12h	;c=0 if mth>12
	bc      mt2
	movlw   1
	movwf   MTH
	bsf     FLAG,6
mt2     movf    MTH,w   ;save in eeprom
	movwf   EEDATA
	movlw   EMTH
	movwf   EEADR
	call    eesave
	return          ;FLAG set if carry to next digit 


incyrs 	incf    YRS
	movf    YRS,w
	andlw   0fh
	xorlw   0ah
	bnz     yr1
	movlw   6
	addwf   YRS
yr1     movf    YRS,w
	xorlw   0a0h
	bnz     yr2
	clrf    YRS
	movlw	20h
	movwf	YRSH
yr2 	movf	YRS,w
	xorlw	97h
	bnz	yr3    
	movlw	19h
	movwf	YRSH	
yr3	movf    YRS,w   ;save in eeprom
	movwf   EEDATA
	movlw   EYRS
	movwf   EEADR
	call    eesave
	movf    YRSH,w   ;save in eeprom
	movwf   EEDATA
	movlw   EYRSH
	movwf   EEADR
	call    eesave
	return          ;FLAG set if carry to next digit 



rubtest:
	;test for rubbish and reset
	;enter with data in w
	;return with modified data (01h) in w if necessary
	
	movwf   FSR
	
	andlw   0fh
	sublw   9               ;cy=0 if lsb>9
	btfss   STATUS,CY
	goto	set1
	movf    FSR,w
	andlw   0f0h
	sublw   90h             ;cy=0 if msb>9
	btfsc   STATUS,CY
	goto	rubend
set1	clrf    FSR
	incf	FSR
rubend	movf	FSR,w	
	return



interrupt:

	push1
	bcf     STATUS,RP0      ;set page 0     (10) 
	bcf     PORTB,ENVIDO
	bsf	PORTB,CS

framech btfsc   PORTB,FRAME
	goto    cnt1

	btfsc	FLAG,2
	goto	exit1
	bsf	FLAG,2

	bsf	PORTB,CS	
	bsf     FLAG,0          ;tell main to write ram  
	bcf     FLAG,1		;prevent ram read
	bcf     FLAG,5          ;greater than ff lines
	clrf    LINECNT         ;set LINECNT to 0 at FRAME sync
 	clrf    POINTER         ;point at top segment
	clrf    PORTA          	;point to lowest ram block
	bsf     PORTB,CNTRES   	;ram address reset 
	goto    exit1

cnt1   	bcf	FLAG,2
	btfss   FLAG,1		
	goto    linestart	;check for line to start reading ram
	
	
	BANK1           	;Defined above.
        movlw   b'00011101'	;ck to input-allow gated osc to ck
        movwf   TRISB  		;vid=i/p
	BANK0	
	
	bsf     PORTB,CNTRES	;ok to read ram out to display
	bcf     PORTB,CNTRES   	;allow gated osc to clock address
	bcf	PORTB,CS	;enable ram
	bsf     PORTB,ENVIDO	;enable ram output
				
	movlw	.34		;45us timer
	movwf	LTIME	
cnt111	decfsz	LTIME
	goto	cnt111
	bcf     PORTB,ENVIDO	;disable ram output
	bsf	PORTB,CS
	decfsz	LINEN
	goto	cnt11
	
	movf	FLAG2,w
	andlw	3
	movwf	LINEN
	incf	LINEN		;linen=1to4
	incf    PORTA  
cnt11	movf	PORTA,w
	andlw	7
	xorlw	7
	btfsc   STATUS,Z
	bcf     FLAG,1
	goto    exit1
	
linestart
	incf    LINECNT
	movf    LINECNT,w
	
	btfsc   FLAG,5
	goto    testa
	
	xorlw   0ffh
	bnz     exit1
	bsf     FLAG,5
	goto    exit1


testa  	xorwf	LINE,w		;compare with LINE value
	bnz     exit1

	btfsc   FLAG,0          ;test if ok to read ram
	goto    exit1           ;FLAG0 = 1 so no
	
	bsf     PORTB,CNTRES   ;reset counter
	bcf     PORTB,ENVIDO	;disable ram output
	bsf     FLAG,1         ;start outputting from ram   
	clrf    PORTA          ;point to lowest ram block
	
exit1   pop1
	bcf     INTCON,1
	retfie

funct1:	
	movf	FLAG2,w
	andlw	3
	xorlw	3
	btfsc	STATUS,Z
	goto	fun1a
	incf	FLAG2
	goto	fun1b		;			
fun1a	movlw	b'11111100'
	andwf	FLAG2
fun1b	goto	savef2	


funct2:		
	incf	LINE
	movlw	.35
	subwf	LINE,w		;clr line if > 256 + 35
	btfsc	STATUS,CY
	clrf 	LINE
	movf    LINE,w   ;save in eeprom
	movwf   EEDATA
	movlw   ELINE
	movwf   EEADR
	call    eesave
	return
	

funct3:	
	btfsc	FLAG2,2
	goto	fun3a
	bsf	FLAG2,2
	goto	fun3b
fun3a	bcf	FLAG2,2
fun3b	goto	savef2
	

funct4:	movlw	b'01000000'	
	addwf	FLAG2		;inc bits 7,6
	movlw	b'11000000'
	andwf	FLAG2,w
	btfsc	STATUS,Z
	bsf	FLAG2,6
	call	CLRRAM
	goto	savef2
	
	
funct5:
	btfsc	FLAG2,4
	goto	fun5a
	bsf	FLAG2,4
	goto	fun5b
	
fun5a	bcf	FLAG2,4
fun5b	movf    FLAG2,w   ;save in eeprom
	goto	savef2
		
funct6:
	btfsc	FLAG2,3
	goto	fun6a
	bsf	FLAG2,3
	goto	fun6b
	
fun6a	bcf	FLAG2,3
fun6b	call	CLRRAM
savef2	movf    FLAG2,w   ;save in eeprom
	movwf   EEDATA
	movlw   EFLAG2
	movwf   EEADR
	call    eesave	
	return	
	
funct7:	;trim = 0 to 18, equiv to -9 to +9
	incf	TRIM		;
	movlw	.19
	subwf	TRIM,w		;clr trim if >18
	btfsc	STATUS,CY
	clrf 	TRIM
	movf    TRIM,w   ;save in eeprom
	movwf   EEDATA
	movlw   ETRIM
	movwf   EEADR
	call    eesave
	return
	
	ORG     0300h

segment                         ;w= 16 x value

	movwf   OFFSET          ;save in OFFSET

seg1
	movlw   03h
	movwf   PCLATH          ;select 3rd page for computed goto


	rrf     OFFSET,w        ;w=CHAR x 8
	andlw   b'01111000'     ;mask in good data
	addwf   POINTER,w
	addwf   PCL             ;jump to OFFSET and return value
	
	
	retlw   0      
	retlw   b'01111110'     ;0
	retlw   b'01100110'
	retlw   b'01100110'
	retlw   b'01100110'
	retlw   b'01111110'
	retlw   0
	retlw   0

	retlw   0      
	retlw   b'00011000'     ;1
	retlw   b'00011000'
	retlw   b'00011000'
	retlw   b'00011000'
	retlw   b'00011000'
	retlw   0
	retlw   0
	
	retlw   0     
	retlw   b'01111110'     ;2
	retlw   b'00000110'
	retlw   b'01111110'
	retlw   b'01100000'
	retlw   b'01111110'
	retlw   0
	retlw   0

	retlw   0    
	retlw   b'01111110'     ;3
	retlw   b'00000110'
	retlw   b'01111110'
	retlw   b'00000110'
	retlw   b'01111110'
	retlw   0
	retlw   0

	retlw   0    
	retlw   b'01100110'    ;4
	retlw   b'01100110'
	retlw   b'01111110'
	retlw   b'00000110'
	retlw   b'00000110'
	retlw   0
	retlw   0
		
	retlw   0    
	retlw   b'01111110'     ;5
	retlw   b'01100000'
	retlw   b'01111110'
	retlw   b'00000110'
	retlw   b'01111110'
	retlw   0         
	retlw   0
	
	retlw   0    
	retlw   b'01111110'     ;6
	retlw   b'01100000'
	retlw   b'01111110'
	retlw   b'01100110'
	retlw   b'01111110'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   b'01111110'     ;7
	retlw   b'00000110'
	retlw   b'00001100'
	retlw   b'00011000'
	retlw   b'00110000'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   b'01111110'     ;8
	retlw   b'01100110'
	retlw   b'01111110'
	retlw   b'01100110'
	retlw   b'01111110'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   b'01111110'     ;9
	retlw   b'01100110'
	retlw   b'01111110'
	retlw   b'00000110'
	retlw   b'00000110'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   0               ;A=BLANK
	retlw   0
	retlw   0
	retlw   0
	retlw   0
	retlw   0
	retlw   0

	
	retlw   0    
	retlw   b'01111110'     ;B=F
	retlw   b'01100000'
	retlw   b'01111110'
	retlw   b'01100000'
	retlw   b'01100000'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   b'00111110'     ;C=C
	retlw   b'01100000'
	retlw   b'01100000'
	retlw   b'01100000'
	retlw   b'00111110'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   b'00000000'     ;D=COLON
	retlw   b'00011000'
	retlw   b'00000000'
	retlw   b'00011000'
	retlw   b'00000000'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   b'00000000'     ;E=DASH
	retlw   b'00001100'
	retlw   b'00011000'
	retlw   b'00110000'
	retlw   b'00000000'
	retlw   0
	retlw   0
	
	retlw   0    
	retlw   b'00000000'     ;F=false data
	retlw   b'00000000'
	retlw   b'01111110'
	retlw   b'00000000'
	retlw   b'00000000'
	retlw   0
	retlw   0

    
; *   ****   ****      *   ****   ****  ****  ****  ****   ****
; *      *      *     **   *      *        *  *  *  *  *   *  *  *    *
; *   ****   ****    * *   ****   ****    *   ****  ****   *  *      *
; *   *         *   ****      *   *  *   *    *  *     *   *  *  *  *
; *   ****   ****      *   ****   ****  *     ****  ****   ****



mthdays
	movlw   03h
	movwf   PCLATH          ;select 3rd page for computed goto
	
	swapf   YRS,w
	andlw   0fh             ;w=high byte
	movwf   TEMP            
	addwf   TEMP,w
	addwf   TEMP,w
	addwf   TEMP,w
	addwf   TEMP,w
	addwf   TEMP,w
	addwf   TEMP,w
	addwf   TEMP,w
	addwf   TEMP,w
	addwf   TEMP,w
	movwf   TEMP            ;TEMP=msb*10
	movf    YRS,w
	andlw   0fh
	addwf   TEMP,w          ;w=binary years
	andlw   03h             ;set z if bits0,1=00 = leap year
	bnz     days1
	
	movf    MTH,w
	xorlw   2               ;feb?
	btfsc   STATUS,Z        
	retlw   29h             ;yes so return 29 days on leap year
	

days1   movlw   13h
	subwf   MTH,w           ;cy if MTH>=13
	movf    MTH,w
	btfsc   STATUS,CY
	movlw   01h
	
	addwf   PCL             ;jump to OFFSET and return value
	

	retlw   31h     ;dummy
	retlw   31h     ;jan
	retlw   28h     ;feb
	retlw   31h     ;mar
	retlw   30h     ;apr
	retlw   31h     ;may
	retlw   30h     ;jun
	retlw   31h     ;jul
	retlw   31h     ;aug
	retlw   30h     ;sep
	retlw   0
	retlw   0
	retlw   0
	retlw   0
	retlw   0
	retlw   0
	retlw   31h     ;oct
	retlw   30h     ;nov
	retlw   31h     ;dec



addtime:                 ;inc clock digit according to MODE
	movlw   03h
	movwf   PCLATH          ;select 3rd page for computed goto
	movf    MODE,w
	addwf   PCL
	return                  ;MODE 0
	
	goto	funct1		;MODE 1
	goto	funct2		;MODE 2
	goto	funct3		;MODE 3
	goto	funct4		;MODE 4
	goto	funct5		;MODE 5
	goto	funct6		;MODE 6
	goto	funct7		;MODE 7
	
	goto    inchrs          ;MODE 8
	goto    incmin          ;MODE 9
	goto    incsec          ;MODE 10
	
	goto    incday          ;MODE 11
	goto    incmth          ;MODE 12
	goto    incyrs          ;MODE 13
	


eesave:    ;eesave data in eeprom
	
	clrwdt
	movf	EEADR,w		
	movwf	TEMP1	
	movf	EEDATA,w
	movwf	TEMP
	
	movlw	ECHK1
	call	read		;should return 55h
	xorlw	55h
	btfss	STATUS,Z
	return
	movlw	ECHK2
	call	read		;should return AAh
	xorlw	0AAh
	btfss	STATUS,Z
	return

	movf	TEMP1,w
	movwf	EEADR
	movf	TEMP,w
	movwf	EEDATA
	
eesav1	bsf	FLAG,0
	bcf	FLAG,1
	bsf     STATUS,RP0
	bcf     EECON1,eeif	;clear int flag
	bsf     EECON1,wren     ;enable write
	nop
	di
	movlw   55h             ;write init sequence
	movwf   EECON2
	movlw   0AAh
	movwf   EECON2
	bsf     EECON1,wr       ;set wr to begin write
	ei
wrwait  clrwdt                  ;clear watchdog
	btfss   EECON1,eeif     ;test for completion
	goto    wrwait
	bcf     EECON1,wren
	bcf     EECON1,eeif     ;dissable write
	bcf     STATUS,RP0      ;set page 0
	return


read    ;read data from eeprom adr in w-returns data in w
	
	movwf	EEADR		;setup address
	bsf     STATUS,RP0
	bsf     EECON1,rd
	bcf     STATUS,RP0
	movf	EEDATA,w	;return data
	return




	end
