;SUN640.ASM 15APR99 - EPE MUSICAL SUNDIAL - COPYRIGHT JOHN BECKER
;SUNDIAL WITH CHIMES, PIPS, SUNSHINE TUNE

;THIS HAS BEEN AMENDED SLIGHTLY SINCE GOING TO PRESS WITH EPE JUNE '99 ISSUE
;IT HAS HAD A FEW EXTRA COMMANDS ADDED TO ALLOW THE SUNDIAL TO BE MONITORED
;MORE EASILY BY FORTHCOMING PIC DATA LOGGER
;MOST LCD CALLS HAVE NOW BEEN "REMMED" 

;Program written in TASM

;Use PIC16C84-10/P or PIC16F84-10/P
;Initialise PIC for 10MHz crystal, WDT off, POR on

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:   .EQU $00
TMR0:   .EQU $01
OPTION: .EQU $01
PCL:    .EQU $02
STATUS: .EQU $03
FSR:    .EQU $04
PORTA:  .EQU $05
TRISA:  .EQU $05
PORTB:  .EQU $06
TRISB:  .EQU $06
EEDATA: .EQU $08
EECON1: .EQU $08
EEADR:  .EQU $09
EECON2: .EQU $09
PCLATH: .EQU $0A
INTCON: .EQU $0B

LOOPA:  .EQU $0C        ;loop counter
FREQ1:  .EQU $0D        ;frequency store 1
FREQ2:  .EQU $0E        ;frequency store 2
FREQ3:  .EQU $0F        ;frequency store 3
FREQ4:  .EQU $10        ;frequency store 4
NOTE10: .EQU $11        ;note 1 main counter
NOTE11: .EQU $12        ;note 1 second counter
NOTE20: .EQU $13        ;note 2 main counter
NOTE21: .EQU $14        ;note 2 second counter
NOTE30: .EQU $15        ;note 3 main counter
NOTE31: .EQU $16        ;note 3 second counter
NOTE40: .EQU $17        ;note 4 main counter
NOTE41: .EQU $18        ;note 4 second counter
REG1:   .EQU $19        ;register for output value to PORTA

TOTAL1: .EQU $1A        ;total of LDR counts LSB
TOTAL2: .EQU $1B        ;total of LDR counts MSB
MASK:   .EQU $1C        ;mask to inhibit note if its freq = 0

COUNT0: .EQU $1D        ; general counter
COUNT1: .EQU $1E        ; general counter
COUNT2: .EQU $1F        ; general counter
MIN1:   .EQU $20        ; minimum value register
LDRCNT: .EQU $21        ; least-illuminated LDR
STORE1: .EQU $22        ; misc store
SUNAV1: .EQU $23        ; sunshine average count LSB
CHECK1: .EQU $24        ; counter for checking sampling uniformity
DIFF1:  .EQU $25        ; difference between values reg
PRVHRS: .EQU $26        ; store for LDR number found
STORE3: .EQU $27        ; misc store
STORE4: .EQU $28        ; misc store
LOOPC:  .EQU $29        ; loop used in LDR reading
RSLINE: .EQU $2A        ; bit 4 = RS line flag for LCD monitoring
PRVCNT: .EQU $2B        ; store used in checking for transient counts
BINARY1: .EQU $2C       ; store for outputting count val as pips
spare1: .EQU $2E        ;
TEST1:  .EQU $2F        ; test flags for switches during setting up

;.......... REPEATED ADDRESSES FOR LCD USE

ANSA1:  .EQU $0D
ANSA2:  .EQU $0E
ANSA3:  .EQU $0F
ANSA4:  .EQU $10
ANSA5:  .EQU $11
TOP1:   .EQU $12
TOP2:   .EQU $13
LOOPB:  .EQU $14
NEGTIV: .EQU $15
MISC1:  .EQU $16
MISC2:  .EQU $17
STORE2: .EQU $18

W:      .EQU 0
F:      .EQU 1

C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2
GIE:    .EQU 7  ;global interrupt bit

WR:     .EQU 1  ;eeprom write initiate flag
WREN:   .EQU 2  ;eeprom write enable flag
RD:     .EQU 0  ;eeprom read enable flag
                            
; TABLE OF NOTE VALUES      ; ideal      actual  next nearest
A0:     .EQU 218            ; 220.000Hz  220.2
AS0:    .EQU 206            ; 233.082Hz  233.1
B0:     .EQU 194            ; 246.941Hz  247.5
C0:     .EQU 184            ; 261.625Hz  260.8   183=262.3
CS0:    .EQU 173            ; 277.182Hz  277.4   172=279
D0:     .EQU 164            ; 293.664Hz  292.6   163=294.5
DS0:    .EQU 154            ; 311.126Hz  311.6
E0:     .EQU 146            ; 329.627Hz  328.6   145=330.9
F0:     .EQU 137            ; 349.229Hz  350.2   138=347.6
FS0:    .EQU 130            ; 369.994Hz  369.0   129=371.8
G0:     .EQU 122            ; 391.995Hz  393.1   123=389.9
GS0:    .EQU 115            ; 415.304Hz  416.5   116=413.4
A1:     .EQU 109            ; 440.000Hz  439.9   108=443.9
AS1:    .EQU 103            ; 466.163Hz  465.4   102=469.9
B1:     .EQU 97             ; 493.883Hz  494.0
C1:     .EQU 92             ; 523.251Hz  520.8   91=526.6
CS1:    .EQU 86             ; 554.364Hz  557.0
D1:     .EQU 82             ; 587.328Hz  584.1
DS1:    .EQU 77             ; 622.252Hz  621.9
E1:     .EQU 73             ; 659.254Hz  655.8
F1:     .EQU 68             ; 698.458Hz  703.8
FS1:    .EQU 65             ; 739.988Hz  736.2
G1:     .EQU 61             ; 783.990Hz  784.2
GS1:    .EQU 57             ; 830.608Hz  839.0
A2:     .EQU 54             ; 880.000Hz  885.2
AS2:    .EQU 51             ; 932.326Hz  937.0
B2:     .EQU 48             ; 987.766Hz  995.2
C2:     .EQU 46             ; 1046.50Hz  1038.2

        .ORG $0004      ;Interrupt vector address
        GOTO START      ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory
        GOTO START

TIMVAL: addwf PCL,F     ; convert LDR value to clock value for pips
        retlw 0         ; never accessed
        retlw 5         ; 1
        retlw 6         ; 2
        retlw 7         ; 3
        retlw 8         ; 4
        retlw 9         ; 5
        retlw 10        ; 6
        retlw 11        ; 7
        retlw 12        ; 8

        retlw 1         ; 9
        retlw 2         ; 10
        retlw 3         ; 11
        retlw 4         ; 12
        retlw 5         ; 13
        retlw 6         ; 14
        retlw 7         ; 15
        retlw 8         ; 16

LDRVAL: addwf PCL,F     ; convert IC1/IC2 pins to suit PCB LDR test order
        retlw 0         ; no definite min/max
        retlw 7         ; 0 X0 IC1
        retlw 4         ; 1 X4 IC1
        retlw 5         ; 2 X2 IC1
        retlw 3         ; 3 X6 IC1
        retlw 6         ; 4 X1 IC1
        retlw 1         ; 5 X5 IC1
        retlw 8         ; 6 X3 IC1
        retlw 2         ; 7 X7 IC1

        retlw 15        ; 0 X0 IC2
        retlw 14        ; 1 X1 IC2
        retlw 13        ; 2 X2 IC2
        retlw 16        ; 3 X3 IC2
        retlw 12        ; 4 X4 IC2
        retlw 9         ; 5 X5 IC2
        retlw 11        ; 6 X6 IC2
        retlw 10        ; 7 X7 IC2

CHIMES: addwf PCL,F
        retlw C1        ;ding
        retlw F0        ;dong
        retlw G0        ;ding
        retlw C0        ;dong
        retlw 0
        retlw C0        ;dong
        retlw G0        ;ding
        retlw A1        ;ding
        retlw F0        ;dong
        retlw 0

MUSIC1: addwf PCL,F     ;notes table
BAR1:   retlw F1        ;YOU
        retlw 40        ;
BAR2:   retlw C1        ;ARE 
        retlw 40        ;
BAR3:   retlw D1        ;MY
        retlw 40        ;
BAR4:   retlw E1        ;SUN-
        retlw 40        ;
BAR5:   retlw E1        ;SHINE
        retlw 42        ;
BAR6:   retlw 0         ;pause
        retlw 42        ;

BAR7:   retlw E1        ;MY
        retlw 40        ;
BAR8:   retlw DS1       ;ON-
        retlw 40        ;
BAR9:   retlw E1        ;LY
        retlw 40        ;
BAR10:  retlw C1        ;SUN-
        retlw 40        ;
BAR11:  retlw C1        ;SHINE
        retlw 60        ;
BAR12:  retlw 0         ;pause
        retlw 42        ;

BAR13:  retlw C1        ;YOU
        retlw 40        ;
BAR14:  retlw D1        ;MAKE
        retlw 40        ;
BAR15:  retlw E1        ;ME
        retlw 40        ;
BAR16:  retlw F1        ;HAP-
        retlw 40        ;
BAR17:  retlw A2        ;PY
        retlw 60        ;
BAR18:  retlw 0         ;pause
        retlw 42        ;

BAR19:  retlw A2        ;WHEN
        retlw 40        ;
BAR20:  retlw G1        ;SKIES
        retlw 40        ;
BAR21:  retlw F1        ;ARE
        retlw 40        ;
BAR22:  retlw E1        ;GREY
        retlw 60        ;
BAR23:  retlw 0         ;pause
        retlw 42        ;

BAR24:  retlw C1        ;YOU'LL
        retlw 40        ;
BAR25:  retlw D1        ;NE-
        retlw 40        ;
BAR26:  retlw E1        ;VER
        retlw 40        ;
BAR27:  retlw F1        ;KNOW
        retlw 40        ;
BAR28:  retlw A2        ;DEAR
        retlw 60        ;
BAR29:  retlw 0         ;pause
        retlw 42        ;

BAR30:  retlw A2        ;HOW
        retlw 40        ;
BAR31:  retlw G1        ;MUCH
        retlw 40        ;
BAR32:  retlw F1        ;I
        retlw 40        ;
BAR33:  retlw E1        ;LOVE
        retlw 40        ;
BAR34:  retlw C1        ;YOU
        retlw 60        ;
BAR35:  retlw 0         ;pause
        retlw 42        ;

BAR36:  retlw C1        ;PLEASE
        retlw 40        ;
BAR37:  retlw D1        ;DON'T
        retlw 40        ;
BAR38:  retlw E1        ;TAKE
        retlw 80        ;
BAR39:  retlw F1        ;MY
        retlw 40        ;
BAR40:  retlw D1        ;SUN-
        retlw 40        ;
BAR41:  retlw D1        ;SHINE
        retlw 80        ;
BAR42:  retlw E1        ;A-
        retlw 40        ;
BAR43:  retlw C1        ;WAY
        retlw 80        ;

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end initialisation table

TBDEC1: addwf PCL,F     ;table for decimalisation lsb
        retlw $0A       ;lsb of 10
        retlw $64       ;lsb of 100
        retlw $E8       ;lsb of 1000
        retlw $10       ;lsb of 10000

TBDEC2: addwf PCL,F     ;table for decimalisation msb
        retlw 0         ;msb of 10
        retlw 0         ;msb of 100
        retlw $03       ;msb of 1000
        retlw $27       ;msb of 10000

MESSAG: addwf PCL,F
        retlw 'S'
        retlw 'U'
        retlw 'N'
        retlw 'D'
        retlw 'I'
        retlw 'A'
        retlw 'L'
        retlw ' '

;.............

START:  clrf PORTB
        clrf PORTA
        PAGE1
        movlw %11000000
        movwf TRISB     ;RB0-RB5 as output, RB6-RB7 as input
        movlw %00010000
        movwf TRISA     ;RA4 as input, RA0-RA3 as output
        movlw %00000110 ;set timer ratio 1:128  - pull ups on
        movwf OPTION          
        PAGE0

CLRINT: bcf INTCON,GIE   ;disable all interrupts
        btfsc INTCON,GIE ;are all interrupts disabled?
        goto CLRINT      ;no, try again
        
SETUP:  call PAUSIT      ;delay
        clrf SUNAV1
        clrf TEST1

SWITCH: btfss PORTB,6    ;is TEST switch 3 on (= 0)?
        goto TESTIT      ;yes - perpetual loop for VCO setting
        btfsc PORTB,7    ;is TEST switch 4 on (= 0)?
        goto LCDPRT      ;no
        bsf TEST1,0      ;yes - set perpetual loop for checking LDRs

ENDSW:  comf PORTB,W     ;wait until switches released (=11)
        andlw %11000000
        btfss STATUS,Z
        goto ENDSW

LCDPRT: PAGE1
        clrf TRISB       ;RB0-RB7 as output
        PAGE0

        call PAUSIT      ;delay
LCDSET: clrf LOOPB       ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOPB,W     ;get table address
        call TABLCD      ;get set-up instruction
        call LCDLIN      ;perform it
        incf LOOPB,F     ;inc loop
        btfss LOOPB,3    ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        call PAUSIT      ;delay
        call PAUSIT      ;delay

LCDMSG: clrf LOOPB      ;clear loop
        bsf RSLINE,4    ;set RS for data send
LCDMS2: movf LOOPB,W    ;get table address
        call MESSAG     ;get message letter
        call LCDOUT     ;show it
        incf LOOPB,F    ;inc loop
        btfss LOOPB,3   ;has last LCD letter been sent?
        goto LCDMS2     ;no
        
;.............

MAIN:   movlw %01000000 ;main loop
        movwf LOOPC     ;reset loop with IC1 on (RB7 low), IC2 off (RB6 hi)
        clrf LDRCNT
        clrf REG1       ;used as main flag for inversion monitoring
        clrf TOTAL1
        clrf TOTAL2
        movlw 255
        movwf MIN1
        
MAIN2:  movf LOOPC,W    ;set RB0-RB2 with IC1/IC2 LDR address
        andlw %11001111
        movwf PORTB
        clrf COUNT0
        clrf COUNT1
        clrf COUNT2
        call DIAL       ; get LDR
        call GETMIN     ; check for minimum
        
;        call SHWCNT     ; LCD call - show count  (4th top)
;        call SHWMIN     ; LCD call - show mininum val (3rd top)
;        call SHWLOOP    ; LCD call - show loop and LDR (1 & 2 top)
        movf LOOPC,W    ; reset RB0-RB2 after LCD routines
        andlw %11001111
        movwf PORTB

        btfss TEST1,0   ;is test flag set?
        goto MAIN2B     ;no
        call PIPEX      ;sound marker for test seq
        call PAUSIT     ;pause for viewing
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT

MAIN2B: incf LOOPC,F
        btfss LOOPC,3   ; is LOOPB = 8?
        goto MAIN2A     ; no                       
        bsf LOOPC,7     ; yes, set IC1 off (RB7 hi)
        bcf LOOPC,6     ; and set IC2 on (RB6 low)

MAIN2A: btfss LOOPC,4   ; is loop = 16?
        goto MAIN2      ; no

;        movlw %10001111 ; reset LOGFLG (for PIC Data Logger use) ***
;        movwf LOGFLG

        movf LDRCNT,W   ; check results of LDR sweep
        btfsc STATUS,Z  ; is LDRCNT = 0
        goto MAIN3      ; yes
        
        call LDRVAL     ; no, so convert LDRCNT to LDR number
        movwf LDRCNT
;        call SHWHRS     ; LCD CALL - show hours value

GETTOT: bcf STATUS,C    ; check if min count < (average + margin)
        rrf TOTAL2,F    ; divide TOTAL by 16 to get average
        rrf TOTAL1,F
        bcf STATUS,C
        rrf TOTAL2,F
        rrf TOTAL1,F
        bcf STATUS,C
        rrf TOTAL2,F
        rrf TOTAL1,F
        bcf STATUS,C
        rrf TOTAL2,F
        rrf TOTAL1,F

TTLCHK: movf TOTAL1,W
        movwf DIFF1
        movf MIN1,W
        subwf DIFF1,F
;        call SHWTOT     ; LCD CALL

TTLCK2: movlw 30        ; fixed offset value  ...01jan99
        subwf DIFF1,W   ; subtract it from difference (is diff greater than
        btfss STATUS,C  ; bias? i.e. is there a borrow?)
        goto MAIN3      ; yes, there is a borrow so diff is too small

        btfsc TEST1,0   ; is TEST bit 0 = 1?
        goto TTLCK3     ; yes

        movf PRVHRS,W
        xorwf LDRCNT,W  ; is LDRCNT = previous LDRCNT for hours?
        btfsc STATUS,Z
        goto MAIN3      ; yes

        movf PRVCNT,W   ; is LDRCNT = immediately-previous LDRCNT?
        xorwf LDRCNT,W  ; (2 equal LDR vals needed) 
        btfss STATUS,Z
        goto MAIN3      ; no
        
TTLCK3: call MUSIC2     ; yes, play hours music
        goto MAIN4

MAIN3:  call SUNSHINE
MAIN4:  movf LDRCNT,W
        movwf PRVCNT

        movlw %01000000 ; reset IC1 on (RB7 low), IC2 off (RB6 hi)
        movwf PORTB
        goto MAIN

;..................

DIAL:   movlw 77        ;routine for reading LDRs
        movwf LOOPA     ;sets total loop timing for about 1 second
        clrf COUNT0
        bcf INTCON,2
DIAL0:  BTFSS INTCON,2  ;has a timer time-out been detected?
        GOTO DIAL0      ;no (the pause keeps sample times equal)
        bsf PORTB,4     ; set trigger flag for external testing ***
        bcf INTCON,2
DIAL1:  movf PORTA,W
        andlw %00010000
        movwf STORE1
        xorwf COUNT0,W  ;is PORTA bit 4 = COUNT0 bit 4?
        btfsc STATUS,Z
        goto DIAL2      ;yes
        incfsz COUNT1,F ;no
        goto DIAL2 
        incf COUNT2,F

DIAL2:  movf STORE1,W
        movwf COUNT0
        BTFSS INTCON,2  ;has a timer time-out been detected?
        GOTO DIAL1      ;no
        bcf INTCON,2
        decfsz LOOPA,F
        goto DIAL1
        bcf PORTB,4     ; clear trigger flag for external testing ***

DIAL4:  BCF INTCON,2    ;wait till end of next time-out
DIAL5:  BTFSS INTCON,2  ;has a timer time-out been detected?
        GOTO DIAL5      ;no (the pause keeps sample times equal)

        bcf STATUS,C
        rrf COUNT2,F    ;divide count by 4 to make just 1 byte
        rrf COUNT1,F    ;(full count never goes above about 440Hz max)
        bcf STATUS,C    ;(which equals 880 logic cganges registered)
        rrf COUNT2,F    ;(dividing by 4 brings it down to 220 max)
        rrf COUNT1,F
        
        movf COUNT1,W   ;add count to TOTAL
        addwf TOTAL1,F
        btfsc STATUS,C
        incf TOTAL2,F
        movf COUNT2,W
        addwf TOTAL2,F
        return

;............

GETMIN: movf MIN1,W     ; get minimum LDR value
        subwf COUNT1,W  ; is COUNT less than MIN?
        btfsc STATUS,C
        return          ; no
        movf COUNT1,W   ; yes
        movwf MIN1      ; store it
        incf LOOPC,W    ; inc C so that LDRCNT is only 0 if no diff found
        andlw %00011111
        movwf LDRCNT    ; and store as LDR count
        return

;........

MUSIC2: btfsc TEST1,0   ; is TEST bit 0 = 1?
        goto MUS2       ; yes
        call DINGS      ; no, sound chimes
        call PAUSIT     ; pause
        call PAUSIT

MUS2:   call PIPIT      ; sound pips (qty depends on LDR result)
        btfsc TEST1,0   ; is TEST bit 0 = 1?
        goto MUS3       ; yes
        call PAUSIT
        call PAUSIT
        call PAUSIT
        clrf LOOPA      ; play full tune
        movlw 43
        movwf COUNT0
        call TUNE
        
MUS3:   movf LDRCNT,W   ; update last hours played register
        movwf PRVHRS
;        movf LOOPC,W    ;reset RB0-RB2 with IC1/IC2 LDR address
;        andlw %11001111
;        movwf PORTB
        return

;...........

TUNE:   clrf REG1
        clrf NOTE11
        clrf NOTE21
        clrf NOTE31
        clrf NOTE41

TUNE2:  movf LOOPA,W    ;get freq values and put into counters
        call MUSIC1     ;NB only 1 note at a time is called for this routine
        movwf FREQ1     ;and put into 1st 2 chans
        movwf NOTE10
        movwf FREQ2
        movwf NOTE20
        addlw 1
        movwf FREQ3     ;and its freq raised slightly for other 2 chans
        movwf NOTE30
        movwf FREQ4
        movwf NOTE40 
        
        incf LOOPA,W
        call MUSIC1
        movwf STORE4    ;get timing value
MASK2:  movlw %00001111 ;set mask for output if freq > 0
        movwf MASK
        movf FREQ1,F
        btfsc STATUS,Z
        clrf MASK
        
        call PLAYIT
        movlw 2
        addwf LOOPA,F
        decfsz COUNT0,F
        goto TUNE2
        return
        
;...............

PLAYIT:                   ;play the 4 notes as a chord
N10:    decfsz NOTE10,F 
        goto N11
        movf FREQ1,W
        movwf NOTE10
        incf NOTE11,F
N11:    rrf NOTE11,W
        rlf REG1,F

N20:    decfsz NOTE20,F
        goto N21
        movf FREQ2,W
        movwf NOTE20
        incf NOTE21,F
N21:    rrf NOTE21,W
        rlf REG1,F

N30:    decfsz NOTE30,F
        goto N31
        movf FREQ3,W
        movwf NOTE30
        incf NOTE31,F
N31:    rrf NOTE31,W
        rlf REG1,F

N40:    decfsz NOTE40,F
        goto N41
        movf FREQ4,W
        movwf NOTE40 
        incf NOTE41,F
N41:    rrf NOTE41,W
        rlf REG1,F

OUTPUT: movf REG1,W
        andwf MASK,W    ;mask off for freq values = 0
        movwf PORTA
        btfss INTCON,2
        goto N10
        bcf INTCON,2
        decfsz STORE4,F ;decrement timing value
        goto N10
        return

;..........

PAUSIT: movlw 16        ; wait approx 1/5 sec
        movwf LOOPA          
        clrf INTCON
PAUSE:  btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz LOOPA,F  ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

;............

DINGS:  clrf LOOPA      ; chimes setup and play
        movlw 10
        movwf COUNT0
        clrf REG1
        clrf NOTE11
        clrf NOTE21
        clrf FREQ2
        clrf FREQ3
        clrf FREQ4

DINGS2: movlw 48        ; reset note duration counter
        movwf STORE4

DINGS3: movf LOOPA,W    ; get freq values and put into counters
        call CHIMES
        movwf FREQ1     
        movwf NOTE10
        movwf FREQ2
        movwf NOTE20
        movlw %00001100 ; use outputs 3 & 4 only
        movwf MASK      ; (keeps it quieter than main tune)
        movf FREQ1,F
        btfsc STATUS,Z
        clrf MASK        
        call PLAYIT     ; play note
        incf LOOPA,F
        decfsz COUNT0,F
        goto DINGS2
        return

;...........

PIPIT:  movf LDRCNT,W   ; play pips - quantity depends on LDRCNT
        call TIMVAL
        movwf COUNT0
        clrf COUNT1     ; counter used for pip pair determination

PIPIT2: movlw 15        ; reset note duration counter
        movwf STORE4
        movlw C1        ; pip freq
        movwf FREQ1
        movwf NOTE10
        movwf FREQ2
        movwf NOTE20

        movlw %00001100 ; use outputs 3 & 4 only
        movwf MASK      ; (keeps it quieter than main tune)
        clrf REG1
        clrf NOTE11
        clrf NOTE21
        call PLAYIT     ; play pip
PIPIT3: movlw 45        ; set pause length depending on which pip of pairs
        btfss COUNT1,0  
        movlw 15
        movwf STORE4
        clrf MASK
        call PLAYIT     ; play pause
        incf COUNT1,F
        decfsz COUNT0,F
        goto PIPIT2
        return

;............

SUNSHINE: btfsc TEST1,0   ; is TEST bit 0 = 1?
          return          ; yes
          movf TOTAL1,W   ; monitor if sunshine is increasing/decreasing
          subwf SUNAV1,W  ; subtract TOTAL1 from SUNAV1
          btfsc STATUS,C  ; is there a borrow?
          goto CLOUD      ; no

BRIGHT: movwf STORE1     ; yes, Total is greater than AV
        comf STORE1,W    ; invert answer
        addlw 1
        andlw %11110000  
        btfsc STATUS,Z   ; is difference greater than 15?
        return           ; no 
        clrf LOOPA       ; yes, its brightening
        movlw 11         ; play first 11 notes of tune
        goto CHANGE      ; (You are my sunshine, My only sunshine)
        
CLOUD:  andlw %11110000  ; is diff greater than 15?
        btfsc STATUS,Z
        return           ; no 
        movlw 58         ; yes, its clouding
        movwf LOOPA
        movlw 14         ; play last 14 notes of tune
       ;(How much I love you, Please don't take my sunshine away)

CHANGE: movwf COUNT0     ; play the tune section
        call TUNE
        movf TOTAL1,W    ; update AV to new TOTAL
        movwf SUNAV1
        return

;....................

; ROUTINE FOR SETTING VCO FREQUENCY DURING TESTING - PERPETUAL LOOP

TESTIT: clrf STORE4     ;reset note duration counter
        movlw A1        ;test note freq
        movwf FREQ1
        movwf NOTE10
        movlw %00001000
        movwf MASK
        clrf REG1
        clrf NOTE11
        call PLAYIT     ;play note
        goto TESTIT

;........................................................

; THE REMAINING ROUTINES ARE THE AUTHOR'S OWN TEST ROUTINES
; WHICH PROVIDED LCD MONITORING DURING DEVELOPMENT
; AND INCLUDE A DECIMALISATION PROCESS. CALLS TO THESE ROUTINES
; ARE STILL EMBODIED IN THE MAIN PROGRAM BUT DO NOT INTERFERE WITH ITS
; RUNNING AS THEY HAVE A SEMICOLON IN FRONT OF THE CALLS
; AN LCD MAY BE CONNECTED TO THE PCB RB0-RB5 PINS AS SHOWN IN
; THE EPE PIC TUTORIAL ARTICLES (SEE MAY '98) AND THE SEMICOLONS REMOVED
; IF THESE ROUTINES ARE DELETED ALL CALLS TO THEM FROM THE MAIN
; PROGRAM MUST BE DELETED AS WELL (UNLESS THEIR SEMICOLONS ARE RETAINED)

LCD28:  movlw %11001000       ; select LCD pixel start
        goto LCDLIN           ; (not all routes used)
LCD24:  movlw %11000101
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD23:  movlw %11000010
        goto LCDLIN
LCD215: movlw %11001111
        goto LCDLIN

LCD11:  movlw %10001011
        goto LCDLIN
LCD8:   movlw %10001000
        goto LCDLIN
LCD6:   movlw %10000110
        goto LCDLIN
LCD5:   movlw %10000101
        goto LCDLIN
LCD3:   movlw %10000010
        goto LCDLIN
LCD2:   movlw %10000001
        goto LCDLIN
LCD1:   movlw %10000000

LCDLIN: BCF RSLINE,4          ;clear RS flag - sets LCD command/line

LCDOUT: MOVWF STORE1          ;temp store data for LCD
        MOVLW 60              ;set min time between sending full bytes to LCD
        MOVWF LOOPA
DELAY:  DECFSZ LOOPA,F
        GOTO DELAY            
        CALL SENDIT           ;send MSB
        CALL SENDIT           ;send LSB
        BSF RSLINE,4          ;set RS flag (default is flag set)
        return

SENDIT: SWAPF STORE1,F        ;get and send data nibble
        MOVF STORE1,W         
        ANDLW 15              
        IORWF RSLINE,W        ;OR the RS bit
        MOVWF PORTB           ;output the byte
        BSF PORTB,5           ;set E high
        nop
        nop
        BCF PORTB,5           ;set E low
        nop
        MOVLW 60
        MOVWF LOOPA
DELAYX: DECFSZ LOOPA,F
        GOTO DELAYX            

        RETURN

;.............

DECIMAL: clrf ANSA1
         clrf ANSA2
         clrf ANSA3
         clrf ANSA4
         clrf ANSA5
         movwf FSR

         movf INDF,W           ;check for zero value
         incf FSR,F
         iorwf INDF,W
         btfsc STATUS,Z
         goto DEC4
         
         movf INDF,W           ;copy value into TOP
         movwf TOP2
         decf FSR,F
         movf INDF,W
         movwf TOP1
         movlw 4
         movwf LOOPB
         movlw ANSA5
         movwf FSR

DECA1:   clrf STORE2
         decf LOOPB,W
         call TBDEC1
         movwf MISC1
         decf LOOPB,W
         call TBDEC2
         movwf MISC2
         call ADDIT
         movwf INDF
         decf FSR,F
         decfsz LOOPB,F
         goto DECA1
         movf TOP1,W
         movwf INDF

DECA2:   addlw 6
         btfss STATUS,DC
         goto DEC4
         clrf INDF
         incf FSR,F
         incf INDF,F
         movf INDF,W
         goto DECA2

ADDIT:   call INVERT           ;invert to allow adding
ADDIT2:  incf STORE2,F
         movf MISC1,W
         addwf TOP1,F
         movlw 1
         andwf STATUS,W
         addwf MISC2,W
         addwf TOP2,F
         btfss STATUS,C
         goto ADDIT2
                              
         call INVERT           ;invert to allow adding
         movf MISC1,W          ;subtract last addition value
         addwf TOP1,F
         btfsc STATUS,C
         incf TOP2,F
         movf MISC2,W
         addwf TOP2,F
         decf STORE2,W
         return

DEC4:    clrf STORE1         ;blank leading zeros
         movlw 4
         movwf LOOPB
         movlw ANSA5
         movwf FSR

DEC5:    movf INDF,W
         btfss STATUS,Z
         goto DEC6
         movlw ' '
         movwf INDF
         decf FSR,F
         incf STORE1,F
         decfsz LOOPB,F
         goto DEC5
         
DEC6:    movf STORE1,W    ;store value of last leading zero
         iorwf NEGTIV,F
         movlw 5
         movwf LOOPB
         movlw ANSA5
         movwf FSR

DEC7:    movf INDF,W
         btfss INDF,5     ;is it a blank (32)?
         iorlw 48         ;no, so it's a numeral
         call LCDOUT
         decf FSR,F
         decfsz LOOPB,F
         goto DEC7
         return

INVERT:  comf TOP1,F           
         incf TOP1,F
         btfsc STATUS,Z
         decf TOP2,F
         comf TOP2,F
         return

;..................

SHWLOOP: call LCD1      ;show loop count in hex - line 1 1st number
        movf LOOPC,W
        andlw %00001111
        call HEXSHW

SHWLDR: movlw ' '       ; line 1 2nd number
        call LCDOUT
        incf LOOPC,W    ; show LDR number loop count represents
        andlw %00011111
        call LDRVAL
        goto HEXSHW

SHWMIN: call LCD3
        movf MIN1,W     ; show min count read - line 1 3rd number
        movwf STORE3
        clrf STORE4
        movlw STORE3
        goto DECIMAL

SHWCNT: call LCD6
        movf COUNT1,W   ; show count - line 1 4th number
        movwf STORE3
        movf COUNT2,W
        movwf STORE4
        movlw STORE3
        goto DECIMAL

SHWHRS: call LCD21      ; line 2 - 1st number
        movf LDRCNT,W   ;show LDR number
        call HEXSHW
        movlw ' '
        call LCDOUT

        movf LDRCNT,W   ;show hour that LDR number represents
        call TIMVAL
        goto HEXSHW

SHWTOT: movf TOTAL1,W
        movwf STORE3
        clrf STORE4
        movlw STORE3
        call DECIMAL
        
        movf DIFF1,W
        movwf STORE3
        clrf STORE4
        movlw STORE3
        goto DECIMAL

HEXSHW: addlw 6         ;convert 1 to 16 to hex
        btfss STATUS,DC
        goto HEX2
        addlw 49        ;A-G
        goto LCDOUT
HEX2:   addlw 42        ;numeral
        goto LCDOUT

PIPEX:  movlw 15        ; sound single pip - for test seq
        movwf STORE4    ; reset note duration counter
        movf LOOPC,W
        andlw %00111111
        btfsc STATUS,Z
        bsf STORE4,5    ; longer note if loop=0
        movlw C0        ; pip freq
        movwf FREQ1
        movwf NOTE10
        movwf FREQ2
        movwf NOTE20
        movlw %00001100 ; use outputs 3 & 4 only
        movwf MASK      ; (keeps it quieter than main tune)
        clrf REG1
        clrf NOTE11
        clrf NOTE21
        call PLAYIT     ; play pip
        return

        .END            ;Final command 


