;LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER

; Version V1.2 29OCT99
; Suffix W added at orig lines (in V1.0) 595, 696, 1632, 1637 (prev V1.1)
; Ability to change & show channel recordings at 1 sec intervals
;   irrespective of sample rate added
; Sample quantity maximum range amended to exclude erroneous 32K max
;   max limit now 16K samples (32K bytes = 256K EEPROM bits = 24LC256 chip)
; Sample value of 256 added
; Erroneous display of RATE & MEM values on RESET amended
; Also note that QBasic prog amended to prevent OVERFLOW situation

;PIC16F877, 3.2768MHz, WDT OFF, POR ON

;Config register bits (PIC Toolkit Mk2 defaults):
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:    .EQU $00  ;page 0, 1, 2, 3
TMR0:    .EQU $01  ;page 0, 2
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1

PCLATH:  .EQU $0A  ;page 0, 1, 2, 3
INTCON:  .EQU $0B  ;page 0, 1, 2, 3

PIR1:    .EQU $0C  ;page 0
PIE1:    .EQU $0C  ;page 1
EEDATA:  .EQU $0C  ;page 2
EECON1:  .EQU $0C  ;page 3
         
PIR2:    .EQU $0D  ;page 0
PIE2:    .EQU $0D  ;page 1
EEADR:   .EQU $0D  ;page 2
EECON2:  .EQU $0D  ;page 3

TMR1L:   .EQU $0E  ;page 0
PCON:    .EQU $0E  ;page 1
EEDATH:  .EQU $0E  ;page 2

TMR1H:   .EQU $0F  ;page 0
EEADRH:  .EQU $0F  ;page 2

T1CON :  .EQU $10  ;page 0

TMR2:    .EQU $11  ;page 0
SSPCON2: .EQU $11  ;page 1

T2CON:   .EQU $12  ;page 0
PR2:     .EQU $12  ;page 1

SSPBUF:  .EQU $13  ;page 0
SSPADD:  .EQU $13  ;page 1

SSPCON:  .EQU $14  ;page 0
SSPSTAT: .EQU $14  ;page 1

CCPR1L:  .EQU $15  ;page 0
CCPR1H:  .EQU $16  ;page 0
CCP1CON: .EQU $17  ;page 0

RCSTA:   .EQU $18  ;page 0
TXSTA:   .EQU $18  ;page 1

TXREG:   .EQU $19  ;page 0
SPBRG:   .EQU $19  ;page 1

RCREG:   .EQU $1A  ;page 0
CCPR2L:  .EQU $1B  ;page 0
CCPR2H:  .EQU $1C  ;page 0
CCP2CON: .EQU $1D  ;page 0

ADRESH:  .EQU $1E  ;page 0
ADRESL:  .EQU $1E  ;page 1

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

LOOP:   .EQU $20
LOOPA:  .EQU $21
CLKCNT: .EQU $22
STORE1: .EQU $23
STORE:  .EQU $24
RSLINE: .EQU $25
STORE2: .EQU $26
STORE3: .EQU $27
STORE4: .EQU $28
CHAN:   .EQU $29

WORK1:  .EQU $30        ;working store 1
WORK2:  .EQU $31        ;working store 2
WORK3:  .EQU $32        ;working store 3
WORK4:  .EQU $33        ;working store 4

DEC1:   .EQU $34        ;decimalisation byte 1 & other uses
DEC2:   .EQU $35        ; byte 2
DEC3:   .EQU $36        ; byte 3
DEC4:   .EQU $37        ; byte 4
DEC5:   .EQU $38        ; byte 5
ANSA1:  .EQU $39        ;decimalisation answer store 1 & other uses
ANSA2:  .EQU $3A        ; answer 2
ANSA3:  .EQU $3B        ; answer 3
ANSA4:  .EQU $3C        ; answer 4
ANSA5:  .EQU $3D        ; answer 5
SLOWIT: .EQU $3E        ; counter for pause
POINT:  .EQU $3F        ; decimal point flag

RUNIT:  .EQU $40        ; flag for run/stop
CLKSEC: .EQU $41        ;CLOCK main counter - secs
CLKMIN: .EQU $42        ;CLOCK - mins
CLKHRS: .EQU $43        ;CLOCK - hours
HLFSEC: .EQU $44        ;

EEPROM:   .EQU $45            ; bit buffer
BYCNT:    .EQU $46            ; byte counter for read mode
EXTSW:    .EQU $47            ; flag for external clock response status
DATAI:    .EQU $48            ; data input register
DATAO:    .EQU $49            ; data output register
SLAVE:    .EQU $4A            ; device address (1010xxx0)
TXBUF:    .EQU $4B            ; transmit buffer
COUNT:    .EQU $4C            ; bit counter
BCOUNT:   .EQU $4D            ; byte counter
LOOPS:    .EQU $4E            ; delay loop counter
LOOPS2:   .EQU $4F            ; delay loop counter
POLLCNT:  .EQU $50            ; data polling counter
MEMHI:    .EQU $51            ; msb val to be sent to eeprom chip
MEMLO:    .EQU $52            ; lsb val to be sent to eeprom chip
WADDRH:   .EQU $53            ; msb of eeprom chip write address
WADDRL:   .EQU $54            ; lsb of eeprom chip write address
RADDRH:   .EQU $55            ; msb of eeprom chip read address
RADDRL:   .EQU $56            ; lsb of eeprom chip read address
SWITCH1:  .EQU $57            ; S1 - start stop switch
SHWCHN:   .EQU $58            ; chan for which data to be shown
TEMPHI:   .EQU $59            ; temp store for R/Waddress high
TEMPLO:   .EQU $5A            ; temp store for R/Waddress low
SAMSEC:   .EQU $5B            ; sample rate seconds value
SAMCNT:   .EQU $5C            ; sample rate count value
MEMCNT:   .EQU $5D            ; counter for serial memory size flag
MEMFUL:   .EQU $5F            ; memory full flag
EXTCLK:   .EQU $60            ; external clock control flag
ABORT:    .EQU $61            ; flag for channel absent for PC transfer
LIMIT:    .EQU $62            ; sample limit value
FLAG64:   .EQU $63            ; flag for rollover to 64K

               ; locations up to $7F are available


             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

DI:       .EQU $07            ; eeprom input bit
DO:       .EQU $06            ; eeprom output bit
SDATA:    .EQU $04            ; serial EE data line (PORTC)
SCLK:     .EQU $03            ; serial EE clock line (PORTC)

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

RD:     .EQU 0  ;EECON1 reg eeprom read enable flag
WR:     .EQU 1  ;EECON1 reg eeprom write initiate flag
WREN:   .EQU 2  ;EECON1 reg eeprom write enable flag

RP0:    .EQU 5           ;STATUS reg
RP1:    .EQU 6           ;STATUS reg
EEPGD:  .EQU 7           ;EECON1 reg 
ADIE:   .EQU 6           ;PIE1 reg
ADIF:   .EQU 6           ;PIR1 reg
PEIE:   .EQU 6           ;INTCON reg
GIE:    .EQU 7           ;INTCON reg
GO:     .EQU 2           ;ADCON0 reg
ADFM:   .EQU 128         ;ADCON1 reg ;... prev 32 ("A" version chip)
EEIF:   .EQU 4           ;PIR2 reg 

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

TABLCD: ADDWF PCL,F
        retlw %00110011
        retlw %00110011
        retlw %00110010
        retlw %00101100
        retlw %00000110
        retlw %00001100
        retlw %00000001
        retlw %00000010

TBDEC1:                 ;table for decimalisation lsb
        ADDWF PCL,F     ;add program counter
        retlw $10       ;lsb of 10000
        retlw $E8       ;lsb of 1000
        retlw $64       ;lsb of 100
        retlw $0A       ;lsb of 10

TBDEC2:                 ;table for decimalisation msb
        ADDWF PCL,F     ;add program counter
        retlw $27       ;msb of 10000
        retlw $03       ;msb of 1000
        retlw 0         ;msb of 100
        retlw 0         ;msb of 10

MSG1:   ADDWF PCL,F     ;add program counter
        retlw 'R'
        retlw 'A'
        retlw 'T'
        retlw 'E'
        retlw '='
        retlw ' '
        retlw ' '
        retlw 's'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

MSG2:   ADDWF PCL,F     ;add program counter
        retlw 'C'
        retlw 'O'
        retlw 'U'
        retlw 'N'
        retlw 'T'
        retlw 'E'
        retlw 'R'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

HOLD:   ADDWF PCL,F     ;add program counter
        retlw 'H'
        retlw 'O'
        retlw 'L'
        retlw 'D'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '

SEND:   ADDWF PCL,F     ;add program counter
          retlw 'S'
          retlw 'E'
          retlw 'N'
          retlw 'D'
          retlw ' '
          retlw 'P'
          retlw 'C'
          retlw ' '
          retlw '9'
          retlw 'k'
          retlw '6'
          retlw ' '
          retlw 'B'
          retlw 'A'
          retlw 'U'
          retlw 'D'

CHANEL:   ADDWF PCL,F     ;add program counter
          retlw 'C'
          retlw 'H'
          retlw 'A'
          retlw 'N'
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '

ENDMSG:   ADDWF PCL,F     ;add program counter
          retlw 'E'
          retlw 'N'
          retlw 'D'
          retlw ' '
          retlw 'S'
          retlw 'E'
          retlw 'N'
          retlw 'D'
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '

MEMORY:   ADDWF PCL,F     ;add program counter
          retlw $00       ;FREE RUN
          retlw $01       ;4K bits = 512 bytes = 256 samples
          retlw $02       ;8K bits = 1024 bytes = 512 samples
          retlw $04       ;16K bits = 2048 bytes = 1024 samples
          retlw $08       ;32K bits = 4096 bytes = 2048 samples
          retlw $10       ;64K bits = 8192 bytes = 4096 samples 
          retlw $20       ;128K bits = 16384 bytes = 8192 samples
          retlw $40       ;256K bits = 32768 bytes = 16384 samples

FILLED:   ADDWF PCL,F     ;add program counter
          retlw 'M'
          retlw 'E'
          retlw 'M'
          retlw ' '
          retlw 'F'
          retlw 'U'
          retlw 'L'
          retlw 'L'

FREE:     ADDWF PCL,F     ;add program counter
          retlw 'F'
          retlw 'R'
          retlw 'E'
          retlw 'E'
          retlw ' '
          retlw 'R'
          retlw 'U'
          retlw 'N'

START:  clrf PORTB
        clrf PORTC
        clrf PORTD
        PAGE1
        movlw 255
        movwf TRISA
        clrf PORTB
        MOVLW %10100111
        movwf TRISC         ;PORTC 3,4,6 as output, 1,2,3,5,7 as input
        clrf TRISD          ;all PORTD as output
        movlw ADFM          ;set RHS justify, and all PORTA as analog inputs
        movwf ADCON1
        movlw %00000101     ; timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0

        clrf RUNIT
        clrf CHAN
        call PAUSIT
        clrf HLFSEC
        clrf CLKSEC
        clrf CLKMIN
        clrf CLKHRS
        clrf SHWCHN
        clrf INTCON
        clrf FLAG64
        clrf SAMCNT
        clrf SAMSEC

LCDSET: clrf LOOP
        clrf RSLINE
LCDST2: movf LOOP,W
        call TABLCD
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto LCDST2
        call PAUSIT

        call LCD1
        bsf RSLINE,4
        clrf LOOP
OPEN1:  movf LOOP,W
        call MSG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto OPEN1

        call LCD21
        bsf RSLINE,4
        clrf LOOP
OPEN2:  movf LOOP,W
        call MSG2
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto OPEN2

        movlw 2           ;get sampling rate      ;29OCT99
        call PRMGET                               ;29OCT99
        movwf SAMSEC                              ;29OCT99
        movlw 3           ;get memory size flag   ;29OCT99
        call PRMGET                               ;29OCT99
        movwf MEMCNT                              ;29OCT99

SWSET:  btfsc PORTC,2       ; is Reset switch (S3) on?
        call RESET1         ; yes

GETADR: movlw 0             ;get last address used for EEPROM chip(s)
        call PRMGET
        movwf WADDRH
        movlw 1
        call PRMGET
        movwf WADDRL
        movlw 2           ;get sampling rate
        call PRMGET
        movwf SAMSEC
        movlw 1      ;set SAMCNT so sample is taken at end of 1st sec
        movwf SAMCNT
        movlw 3           ;get memory size flag
        call PRMGET
        movwf MEMCNT
        call MEMORY
        movwf LIMIT
        call SHWMEM
        movlw 4           ;get memory full flag
        call PRMGET
        movwf MEMFUL

        bcf EXTCLK,0
        movf SAMSEC,W     ;is SAMSEC = 63?
        xorlw 63
        btfsc STATUS,Z
        bsf EXTCLK,0      ;yes so set EXTCLK control flag

SHWCNT: call LCD29
        bsf RSLINE,4
        clrf STATUS,C
        rrf WADDRH,W
        movwf ANSA2
        rrf WADDRL,W
        movwf ANSA1
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        bcf POINT,0
        movlw ANSA1     ;address 1st byte of val to decimalise
        call PREPRP     ;decimalise and prepare for screen

        call LCD28
        bsf RSLINE,4
        movlw 'A'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        call SHWRAT     ;show sample rate

        movlw 25        ;reset start value of CLKCNT
        movwf CLKCNT

        call SETBAUD

WAITSW: movf PORTC,W
        andlw %00000010
        btfss STATUS,Z
        goto WAITSW

        btfsc MEMFUL,0
        goto FULLUP
        btfsc EXTCLK,0   ;is ext clock flag set?
        goto GETEXT

INTRPT: btfss INTCON,2  ;has a timer time-out been detected?
        goto INTRPT     ;no
        bcf INTCON,2    ;yes
        call CLKIN
        goto INTRPT

SWITCH: btfss PORTC,0   ;is S1 (Run) on?
        goto SW2        ;no
        bsf RUNIT,0     ;yes
        return

SW2:    btfss RUNIT,0   ;detects when RUN/STOP switch is switched to STOP
        goto SW3
        bcf PORTC,6     ;clear outputs to PC
        bcf RUNIT,0     
        movlw 5
        movwf CLKSEC    ;CLKSET just used as loop here
SW2A:   call ADCSET     ;write 5 zero double-bytes to each chan
        decfsz CLKSEC,F
        goto SW2A
        movlw 25
        movwf CLKSEC

        movf WADDRH,W   ;and store current write address to EEPROM chip
        movwf STORE1    ;at moment of switch-off
        movlw 0
        call SETPRM
        movf WADDRL,W
        movwf STORE1
        movlw 1
        call SETPRM
        call HOLDIT
        return

SW3:    btfsc PORTC,1
        call SENDPC
        return

CLKIN:  call SWITCH
        btfss RUNIT,0
        return

        decfsz CLKCNT,F ;increment clock routine. Is it = 0?
        return          ;no

CLKADD: movlw 25         ;reset start value of CLKCNT
        movwf CLKCNT
        call GETSAM      ;get sample
CLKAD2: incf HLFSEC,F
        btfsc HLFSEC,0   ;is half sec bit 0 clear?
        return

;......NEW SECTION ADDED 29OCT99

        btfss PORTC,2   ;yes, so is channel change on?
        goto SECCLK     ;no
        incf SHWCHN,F   ;yes, so inc chan number to be displayed on LCD
        bcf SHWCHN,3
        movf SHWCHN,W
        movwf CHAN

        bcf POINT,0      ;clear decimal point
        call READ
        movf MEMLO,W
        movwf ANSA1
        incf ANSA1,W
        btfsc STATUS,Z
        clrf ANSA1
        movf MEMHI,W
        movwf ANSA2
        incf ANSA2,W
        btfsc STATUS,Z
        clrf ANSA2

        call LCD1
        BSF RSLINE,4
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        movlw ANSA1     ;address 1st byte of val to decimalise
        call PREPRP     ;decimalise and prepare for screen

        call LCD1
        BSF RSLINE,4
        incf CHAN,W
        iorlw 48
        call LCDOUT

;...........

SECCLK: movlw CLKSEC
        movwf FSR
        movlw 3
        movwf LOOPA

ADDCLK: incf INDF,F     ;inc units
        movlw 6
        addwf INDF,W    ;if 6 is added is there a digit carry?
        btfss STATUS,DC
        goto CHKH24     ;no
        movwf INDF      ;yes
        movlw 160
        addwf INDF,W    ;if 160 is added is there a carry
        btfss STATUS,C  ;(adding 160 checks if tens of units = 6)
        goto CHKH24     ;no
        clrf INDF       ;yes
        incf FSR,F
        decfsz LOOPA,F
        goto ADDCLK

CHKH24: movlw 220       ;is clock = 24 hrs? (adding 220 checks it)
        addwf CLKHRS,W
        btfsc STATUS,C
        clrf CLKHRS
        call TIMSHW     ;show immediate elapsed time

ENDCLK: return

GETSAM: movf SAMSEC,F   ;is sample rate set to 0?
        btfsc STATUS,Z
        goto GETSM2     ;yes, so half sec sampling needed
        btfss HLFSEC,0   ;is half sec bit 0 clear?
        return
        goto GETSM1

GETEXT: call SWITCH
        btfss RUNIT,0
        goto GETEXT
        btfss PORTC,7   ;test bit 7 of Port C, is it set? ...c
        goto TSTPRV     ;no, it's = 0 so go to TSTPRV
        bcf EXTSW,0     ;clear bit 0 of EXTSW
        goto ENDTST

TSTPRV: btfsc EXTSW,0   ;test bit 0 of SWITCH, is it clear?
        goto ENDTST     ;no, it's = 1 so go to ENDTST
        bsf EXTSW,0     ;yes, it's = 0 so set bit 0 of SWITCH
        call GETSM2     ;and get samples
ENDTST: goto GETEXT


GETSM1: decfsz SAMCNT,F ;dec sample timer, is it = 0?
        return          ;no
GETSM2:; btfss PORTC,2   ;yes, so is channel change on? THESE 4 DELETED
       ; goto GETADC     ;no                                    29OCT99
       ; incf SHWCHN,F   ;yes, so inc chan number to be displayed on LCD
       ; bcf SHWCHN,3

GETADC: call ADCSET     ;take samples
        movf SAMSEC,W
        movwf SAMCNT
        return

ADCSET: clrf CHAN,F
ADCST2: bcf STATUS,C
        rlf CHAN,W           ;get channel code
        movwf STORE
        rlf STORE,F
        rlf STORE,F
        movlw %10000001      ;clock Fosc/32, Channel CHAN, A/D on
        iorwf STORE,W
        movwf ADCON0         ;set A/D chan
ADCST3: clrf STORE3
ADCST4: decfsz STORE3,F
        goto ADCST4

SAMPLE: bcf PIR1,ADIF        ;clear A/D interrupt flag bit
        bsf ADCON0,GO

        clrf STORE3
WAIT1:  decfsz STORE3,F
        goto WAIT1

WAITAD: btfsc ADCON0,GO
        goto WAITAD

        movf WADDRH,W   ;temp store EEPROM address for use by WRBYTE
        movwf TEMPHI
        movf WADDRL,W
        movwf TEMPLO
        btfsc RUNIT,0   ;is RUNIT = 1 (normal running)?
        goto GETVAL     ;yes

        clrf MEMHI      ;no, the 5 zero end-section bytes are being stored
        clrf MEMLO
        clrf ANSA1
        clrf ANSA2
        goto WRMSB

GETVAL: movf ADRESH,W
        movwf ANSA2
        movwf MEMHI     ;msb data value to be sent to EEPROM chip
        PAGE1
        movf ADRESL,W
        PAGE0
        movwf ANSA1
        movwf MEMLO     ;lsb data value to be sent to EEPROM chip

WRMSB:  movf MEMHI,W
        call WRBYTE

        incfsz TEMPLO,F
        goto WRLSB
        incf TEMPHI,F
WRLSB:  movf MEMLO,W
        call WRBYTE

        movf CHAN,W      ;is channel now = chan to be viewed on LCD?
        xorwf SHWCHN,W
        btfss STATUS,Z
        goto INCCHN      ;no

        bcf POINT,0      ;clear decimal point
        call LCD1
        BSF RSLINE,4
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        movlw ANSA1     ;address 1st byte of val to decimalise
        call PREPRP     ;decimalise and prepare for screen

        call LCD1
        BSF RSLINE,4
        incf CHAN,W
        iorlw 48
        call LCDOUT

        movf WADDRH,W   ;temp set read address
        movwf RADDRH,F
        movf WADDRL,W
        movwf RADDRL,F

        bcf STATUS,C    ;divide address by 2 for display
        rrf WADDRH,W
        movwf ANSA2
        rrf WADDRL,W
        movwf ANSA1
        call LCD29
        BSF RSLINE,4
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        movlw ANSA1     ;address 1st byte of val to decimalise
        call PREPRP     ;decimalise and prepare for screen
        call READ       ;read and show recording

INCCHN: incf CHAN,F     ;inc channel number
        btfss CHAN,3    ;is it less than 8?
        goto ADCST2     ;yes
        movlw 2         ;no so add 2 to Write address ready for next batch
        addwf WADDRL,F
        btfss STATUS,C  ;...c  29OCT99
        goto INC2       ; 29OCT99

        incfsz WADDRH,F ; 29OCT99
        goto INC1       ; 29OCT99
        movlw 1         ; 29OCT99
        movwf FLAG64    ; 29OCT99
        goto INC2       ; 29OCT99
INC1:   clrf FLAG64     ; 29OCT99

INC2:   movf LIMIT,W     ;is LIMIT = 0?
        btfsc STATUS,Z
        return           ;yes - return when in FREE RUN mode

        btfsc FLAG64,0   ;is 64K flag set?
        goto INC3        ;yes; rollover to 64K has occured, so MEM FULL

        bcf STATUS,C     ;no
        rrf WADDRH,W     ;is count = LIMIT
        xorwf LIMIT,W
        btfss STATUS,Z   
        return           ;no

INC3: ;  movf WADDRH,W
        decf WADDRH,F   ; 29OCT99
        movf WADDRH,W
        movwf STORE1    ;yes, store current write address to EEPROM chip
        movlw 0
        call SETPRM
        decf WADDRL,F   ; 29OCT99
        decf WADDRL,F   ; 29OCT99
        movf WADDRL,W

        movwf STORE1
        movlw 1
        call SETPRM
        movlw 1         ;store memory full flag
        movwf STORE1
        movlw 4
        call SETPRM     ;show memory full message
        goto FULLUP

;..............

DECIML:                 ;decimalise binary number
                        ;copy source into working area
                        ;source address is brought in on W
                        ;DEC1-5 becomes source
                        ;answer goes into ANSA
        call COPYFD     ;copy data at FSR into DEC
        clrf STORE1
        clrf LOOPA
        call CLRANS

        movlw ANSA4     ;set answer store address
        movwf FSR

DCML0:  movf LOOPA,W
        call TBDEC1     ;subtract lsb from source value
        subwf DEC1,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no
        movlw 1
        subwf DEC2,F    ;yes so decrement next byte
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no
        movlw 1         ;yes
        subwf DEC3,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no

DCML3:  movf LOOPA,W    ;yes, so re-add last table values lsb
        call TBDEC1
        addwf DEC1,F
        btfss STATUS,C  ;is there a carry?
        goto DCML5      ;no so exit loop
        incf DEC2,F     ;yes so inc next byte
        btfss STATUS,Z  ;is there a carry? (is it zero)
        goto DCML5      ;no so exit loop
        incf DEC3,F     ;yes
        goto DCML5      ;exit loop

DCML1:  movf LOOPA,W
        call TBDEC2     ;subtract msb from source value
        subwf DEC2,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML2      ;no
        movlw 1
        subwf DEC3,F    ;yes so decrement next byte
        btfss STATUS,C  ;is there a borrow?
        goto DCML4      ;yes

DCML2:  incfsz STORE1,F ;inc counter & continue looping till zero
        goto DCML0

DCML4:  movf LOOPA,W    ;re-add last table values lsb
        call TBDEC1
        addwf DEC1,F
        btfss STATUS,C  ;is there a carry?
        goto DCML4A     ;no so add msb
        incf DEC2,F     ;yes so inc next byte
        btfsc STATUS,Z  ;is there a carry? (is it zero)
        incf DEC3,F     ;yes, so inc next byte

DCML4A: movf LOOPA,W    ;re-add last table values msb
        call TBDEC2
        addwf DEC2,F
        btfsc STATUS,C  ;is there a carry?
        incf DEC3,F     ;yes, so inc next byte

DCML5:  movf STORE1,W   ;store counter and loop for next values
        movwf INDF
        clrf STORE1
        decf FSR,F
        incf LOOPA,F
        btfss LOOPA,2   ;is it = 4?
        goto DCML0      ;no

DCML6:  movlw 15        ;compact answers into 3 bytes
        andwf ANSA1,F
        andwf ANSA2,F
        andwf ANSA3,F
        swapf ANSA1,F
        movf DEC1,W
        iorwf ANSA1,F
        swapf ANSA3,W
        iorwf ANSA2,F
        movf ANSA4,W
        movwf ANSA3
        movlw 6
        addwf ANSA3,W
        btfsc STATUS,DC
        movwf ANSA3
        return

COPYFD: movwf FSR       ;copy data at FSR to DEC - 3 bytes
        movf INDF,W     ;DO NOT CALL CLRDEC with this
        movwf DEC1      ;for reasons unknown it does not work then!
        incf FSR,F
        movf INDF,W
        movwf DEC2
        incf FSR,F
        movf INDF,W
        movwf DEC3
        clrf DEC4
        clrf DEC5
        return

CLRANS: clrf ANSA1
        clrf ANSA2
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        return

PREPRP: call DECIML     ;convert to decimal. Answer in ANSA
        movlw ANSA1
        call PRPSHW
        goto SCREEN

PRPSHW: movwf FSR       ;prepare dual BCD data for single byte showing
        movwf STORE1
        movlw WORK2
        movwf STORE2
        movlw 3
        movwf LOOPA

PREP2:  movf STORE1,W
        movwf FSR
        movf INDF,W
        movwf STORE3
        movf STORE2,W
        movwf FSR
        movf STORE3,W
        andlw 15
        iorlw 48        ;OR decimal 48
        movwf INDF
        incf STORE2,F
        incf FSR,F
        swapf STORE3,W
        andlw 15
        iorlw 48        ;OR decimal 48
        movwf INDF
        incf STORE2,F
        incf STORE1,F
        decfsz LOOPA,F
        goto PREP2

        btfsc POINT,0   ;is decimal point needed?
        goto PREP31     ;yes
        movlw 32
        movwf WORK1
        goto PREP3      ;no
PREP31: movf WORK2,W
        movwf WORK1
        movf WORK3,W
        movwf WORK2
        movlw 46        ;decimal point
        movwf WORK3

PREP3:  movlw 128
        btfss POINT,0
        movlw ' ' 
        movwf STORE1
        btfss STORE1,7  ;is it 128?
        movwf DEC3
        movlw ' '
        movwf DEC4
        return

SCREEN: movlw 8
        movwf LOOP
        movlw WORK1
        addlw 7
        movwf FSR

SCRN2:  movf INDF,W
        call LCDOUT
        decf FSR,F
        decfsz LOOP,F
        goto SCRN2
        return

CLRWRK: clrf WORK1
        clrf WORK2
        clrf WORK3
        clrf WORK4
        return

CLRDEC: clrf DEC1
        clrf DEC2
        clrf DEC3
        clrf DEC4
        clrf DEC5
        return

TIMSHW: call LCD8       ;show TIME
        BSF RSLINE,4
        movlw CLKSEC    ;address of seconds
        bsf POINT,0
        call PRPSHW     ;prepare byte data
        movf DEC3,W
        movwf DEC4
        movf DEC2,W
        movwf DEC3
        movlw 58        ;colon
        movwf DEC2
        goto SCREEN

PAUSIT: movlw 10
        movwf SLOWIT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

LCD1:   movlw %10000000
        goto LCDLIN
LCD6:   movlw %10000101
        goto LCDLIN
LCD8:   movlw %10001000
        goto LCDLIN
LCD9:   movlw %10001001
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD26:  movlw %11000101
        goto LCDLIN
LCD28:  movlw %11001000
        goto LCDLIN
LCD29:  movlw %11001001
LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT
SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        BCF PORTB,5
        RETURN

;CONVERTED MPASM FILE C:\ASMCNV\2WDPOLL.ASM
;       TO TASM  FILE C:\PIC\2WDPOLL.ASM 03-12-1999 19:28:42

          ;***************************************************************
          ;       Byte Write Routine with data polling
          ;***************************************************************

WRBYTE:   movwf DATAO         ;entry with val to sent in W, stored to DATAO

          bcf STATUS,C
          rlf CHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE

BYTE:     CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; move slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF TEMPHI,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF TEMPLO,W       ; send address low byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF DATAO,W        ; move data byte
          MOVWF TXBUF         ; to tranmit buffer
          CALL TX             ; and transmit it
          CALL BSTOP          ; generate stop bit

          MOVLW 40            ; now start polling for a low ack bit
          MOVWF POLLCNT       ; set max number of times to poll
POLL:     CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf CHAN,W
          iorlw %10100000     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it
          BTFSS EEPROM,DI     ; was the ack bit low?
          GOTO EXITPOLL       ; yes, do another byte
          DECFSZ POLLCNT,F    ; is poll counter down to zero?
          GOTO POLL           ; no, poll again.
EXITPOLL: return

          ;**************************************************************
          ;       Start Bit Subroutine - generates a start bit
          ;       (Low going data line while clock is high)
          ;**************************************************************

BSTART:   BSF PORTC,SDATA    ; make sure data is high
          PAGE1
          MOVLW %10100111
          MOVWF TRISC         ; set data and clock lines for output
          PAGE0
          BCF PORTC,SCLK     ; make sure clock is low
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          BCF PORTC,SDATA    ; data line goes low during
                              ; high clock for start bit
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          NOP                 ; timing adjustment
          BCF PORTC,SCLK     ; start clock train
          NOP                 
          NOP                 
          RETLW 0             

          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP:    PAGE1
          MOVLW %10100111
          MOVWF TRISC         ; set data/clock lines as outputs
          PAGE0
          BCF PORTC,SDATA    ; make sure data line is low
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SDATA    ; data goes high while clock high
                              ; for stop bit
          NOP                 
          NOP                 
          BCF PORTC,SCLK     ; set clock low again
          NOP                 
          NOP                 
          NOP                 
          RETLW 0             

            ;*************************************************************
            ;       BITOUT routine takes one bit of data in 'do' and
            ;       transmits it to the serial EE device
            ;*************************************************************

BITOUT:   PAGE1
          MOVLW %10100111
          MOVWF TRISC
          PAGE0
          BTFSS EEPROM,DO    ; check for state of data bit to xmit
          GOTO BITLOW        ;
          BSF PORTC,SDATA    ; set data line high
          GOTO CLKOUT        ; go toggle the clock

BITLOW:   BCF PORTC,SDATA    ; output a low bit
CLKOUT:   BSF PORTC,SCLK     ; set clock line high
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          BCF PORTC,SCLK     ; return clock line low
          RETLW 0             

          ;**************************************************************
          ;       BITIN routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN:    BSF EEPROM,DI       ; assume input bit is high
          PAGE1
          MOVLW %10110111     ; make sdata an input line
          MOVWF TRISC
          PAGE0
          BSF PORTC,SDATA    ; set sdata line for input
          BSF PORTC,SCLK     ; set clock line high
          NOP                ; just sit here fractionally
          NOP                 
          NOP                 
          NOP                 
          NOP
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI      ; input bit was low
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX:       MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP:     BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; otherwise data bit =1
          CALL BITOUT         ; serial data out
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP           ; no - go again
          CALL BITIN          ; read ack bit
          RETLW 0             

                              
;CONVERTED MPASM FILE C:\ASMCNV\2WSEQR.ASM
;       TO TASM  FILE C:\PIC\2WSEQR.ASM 03-12-1999 19:29:04

          ;************************************************************
          ;       2-Wire Sequential Read Program
          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP2:   PAGE1
          MOVLW %10100111     ;
          MOVWF TRISC         ; set data/clock lines as outputs
          PAGE0
          BCF PORTC,SDATA     ; make sure data line is low
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SCLK      ; set clock high
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SDATA     ; data goes high while clock high
          NOP                 ; for stop bit
          NOP                 
          BCF PORTC,SCLK      ; set clock low again
          NOP                 
          NOP                 
          NOP                 
          RETLW 0             

          ;**************************************************************
          ;       BITIN2 routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN2:   BSF EEPROM,DI       ; assume input bit is high
          PAGE1
          MOVLW %10110111     ; make sdata an input line
          MOVWF TRISC
          PAGE0
          BSF PORTC,SCLK      ; set clock line high
          NOP                 ; just sit here a sec
          NOP                 
          NOP                 
          NOP                 
          NOP                 ;
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI       ; input bit was low, set 'di' accordingly
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0             

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX2:      MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP2:    BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; no, set it high
          CALL BITOUT         ; send the bit to serial EE
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP2          ; no - go again
          CALL BITIN2         ; read ack bit
          BTFSC EEPROM,DI     ; check ack bit
          NOP
          RETLW 0             

          ;****************************************************************
          ;       Receive data Routine
          ;****************************************************************

RX:       MOVLW 8             ; set # bits to 8
          MOVWF COUNT         
          CLRF DATAI          ; clear input register
          BCF STATUS,0        ; make sure carry bit is low
RXLP:     RLF DATAI,F         ; rotate DATAI 1 bit left
          CALL BITIN2         ; read a bit
          BTFSC EEPROM,DI     
          BSF DATAI,0         ; set bit 0 if necessary
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO RXLP           ; no, do another
          RETLW 0             

          ;**************************************************************
          ;       READ (sequential read routine)
          ;**************************************************************

READ:     call LCD21
          BSF RSLINE,4

          MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          bcf STATUS,C
          rlf CHAN,W
          iorlw %10100000     ; set slave address and write mode

          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf CHAN,W
          iorlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE:    CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf ANSA1
          movwf MEMLO         ;data low byte
          clrf ANSA3
          clrf ANSA4
          clrf ANSA5
          movlw ANSA1     ;address 1st byte of val to decimalise
          call PREPRP     ;decimalise and prepare for screen
          movlw ' '
          call LCDOUT
          call LCD21
          BSF RSLINE,4
          movlw 'R'
          call LCDOUT
          return

LOWACK:   movf DATAI,W
          movwf ANSA2
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE          ; and read another byte

;*************** OUTPUT TO PC SERIAL PORT

SENDPC:   movf LIMIT,W       ;is LIMIT = 0
          btfsc STATUS,Z
          goto SEND3         ;yes

          movf WADDRH,W      ;no, is count = 0?
          xorwf WADDRL,W
          btfsc STATUS,Z
          return             ;yes

SEND3:    clrf ABORT         ;clear abort flag for IC not present channel
          call LCD1          ;no
          bsf RSLINE,4
          clrf LOOP
SEND1:    movf LOOP,W
          call SEND
          call LCDOUT
          incf LOOP,F
          btfss LOOP,4
          goto SEND1

          call LCD21
          bsf RSLINE,4
          clrf LOOP
SEND2:    movf LOOP,W
          call CHANEL
          call LCDOUT
          incf LOOP,F
          btfss LOOP,3
          goto SEND2

          clrf CHAN
LINK1:    clrf RADDRH
          clrf RADDRL
          movf LIMIT,W       ;is LIMIT = 0?
          btfss STATUS,Z
          goto LINK2         ;no

          call LCD28
          bsf RSLINE,4
          movlw $3F          ;yes
          movwf TEMPHI       ;set counter for (nearly) 16K double bytes
          movwf ANSA2
          movlw 243
          movwf TEMPLO
          movwf ANSA1

          clrf ANSA5
          clrf ANSA4
          clrf ANSA3

          movlw ANSA1
          call PREPRP
          goto LINK3

LINK2:    bcf STATUS,C
          rrf WADDRH,W       ;number of double bytes to be read
          movwf TEMPHI
          rrf WADDRL,W
          movwf TEMPLO

LINK3:    call LCD26
          bsf RSLINE,4
          incf CHAN,W
          addlw 48
          call LCDOUT

          movlw 0            ;send 3 sets of zero
          call SERIAL1
          movlw 0
          call SERIAL1
          movlw 0
          call SERIAL1
          movlw 0
          call SERIAL1
          movlw 0
          call SERIAL1
          movlw 0
          call SERIAL1

          movf SAMSEC,W     ;send sample rate value
          call SERIAL1
          movlw 0
          call SERIAL1

PCLINK:   call READ2
          movf MEMHI,W      ;is value greater than 1024?
          andlw %11111100
          btfsc STATUS,Z
          goto PCLNK2       ;no

PCLNK7:   incf ABORT,F      ;no
          btfsc ABORT,5     ;is abort flag = 32 ?
          goto PCLNK4       ;yes, abort this channel
PCLNK6:   clrf MEMHI        ;no, set both bytes to 0
          clrf MEMLO
          goto PCLNK3

PCLNK2:   bcf STATUS,C
          rlf MEMLO,W
          rlf MEMHI,F

PCLNK3:   movf MEMLO,W
          andlw 127
          call SERIAL1
          movf MEMHI,W
          andlw 127
          call SERIAL1

          movlw 2
          addwf RADDRL,F    ;yes, inc read address by 2
          btfsc STATUS,C
          incf RADDRH,F

          decfsz TEMPLO,F  ;dec counter, is it = 0?
          goto PCLINK      ;no
          movf TEMPHI,F    ;is TEMPHI=0
          btfsc STATUS,Z
          goto PCLNK4      ;yes
          decf TEMPHI,F    ;no, repeat for next address
          goto PCLINK

PCLNK4:   movlw 127        ;send end sync marker
          call SERIAL1
          movlw 127
          call SERIAL1
          clrf ABORT

          call PAUSE5
          incf CHAN,F      ;inc chan to be read
          btfss CHAN,3     ;is it = 8
          goto LINK1       ;no

          clrf LOOP        ;send 8 * end sync marker
PCLNK5:   movf LOOP,W      ;in case serial prog has not read all 8 channels
          movlw 127        ;in error situation - purely a precaution
          call SERIAL1
          movlw 127
          call SERIAL1
          incf LOOP,F
          btfss LOOP,3
          goto PCLNK5

ENDREAD:  call LCD1
          bsf RSLINE,4
          clrf LOOP
END1:     movf LOOP,W
          call ENDMSG
          call LCDOUT
          incf LOOP,F
          btfss LOOP,4
          goto END1

WAITEND:  btfsc PORTC,1
          goto WAITEND
          call HOLDIT
          return

READ2:    MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          bcf STATUS,C
          rlf CHAN,W
          iorlw %10100000     ; set slave address and write mode

          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf CHAN,W
          iorlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE2:   CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK2         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf MEMLO         ;data low byte
          return

LOWACK2:  movf DATAI,W
          movwf ANSA2
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE2         ; and read another byte
        
;**************

SETBAUD:  PAGE1
          movlw 21            ;BRG for 9600baud from 3.2768MHz, brgh=1
          movwf SPBRG

          movlw %00000100     ;set sync=0, brgh=1
          movwf TXSTA

          movlw %10000111     ;set output reg (RC6 is the pin)
          movwf TRISC
          bcf PIE1,4          ;clear interrupt bit (bit TXIE)
          PAGE0

          movlw %10000000     ;set SPEN Bit of RCSTA reg
          movwf RCSTA

          PAGE1
          bsf TXSTA,5         ;enable transmission (bit TXEN)
          PAGE0
          return

SERIAL1:  btfss PIR1,4  ;wait for TXIF bit 4 to go high (showing TXREG empty)
          goto SERIAL1
          nop
          movwf TXREG         ;put val in TXREG ready for transmission
          return

PAUSE5: movlw 50
        movwf SLOWIT
        clrf INTCON
PAUS5:  btfss INTCON,2
        goto PAUS5
        BCF INTCON,2
        decfsz SLOWIT,F
        goto PAUS5
        return

;WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices
;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

;..........

;READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices
;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

RESET1: call LCD29
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        call SHWRAT

WAITS3: btfsc PORTC,2       ;wait until S3 released
        goto WAITS3
        call PAUSIT         ;pause for switch bounce

WAITS1: btfsc PORTC,0       ;is S1 (end reset) pressed?
        goto RESET2         ;yes
        btfsc PORTC,1       ;is S2 (inc sample rate) pressed?
        call INCRAT         ;yes
        btfsc PORTC,2       ;is S3 (dec sample rate) pressed?
        call DECRAT         ;yes
        goto WAITS1

RESET2:; call LCD9           ;......12
       ; bsf RSLINE,4
        call SHWMEM

WAITS1A: btfss PORTC,0      ;is S1 (end mem size) off?
        goto RESET3         ;yes
        btfsc PORTC,1       ;is S2 (inc mem size) pressed?
        call INCMEM         ;yes
        btfsc PORTC,2       ;is S3 (dec mem size) pressed?
        call DECMEM         ;yes
        goto WAITS1A

RESET3: movlw 0             ; reset EEPROM address
        movwf STORE1
        call SETPRM
        movlw 1
        call SETPRM
        movf SAMSEC,W       ;store sample rate
        movwf STORE1
        movlw 2
        call SETPRM

        movf MEMCNT,W       ;store memory size
        movwf STORE1
        movlw 3
        call SETPRM

        clrf STORE1         ;reset MEMFUL flag
        movlw 4
        call SETPRM

WAITIT: movf PORTC,W        ;wait till all switches released
        andlw %00000111
        btfss STATUS,Z
        goto WAITIT
        call HOLDIT
        return

INCRAT: incf SAMSEC,F       ;inc rate
        bcf SAMSEC,6        ;keep rate to less than 64
        bcf SAMSEC,7
        call SHWRAT
        goto WAIT2

DECRAT: decf SAMSEC,F       ;dec rate
        bcf SAMSEC,6        ;keep rate to less than 64
        bcf SAMSEC,7
        call SHWRAT

WAIT2:  call PAUSIT      ;wait
        call PAUSIT      ;wait 
        return

SHWRAT: call LCD6
        bsf RSLINE,4

        bcf EXTCLK,0
        movf SAMSEC,W     ;is SAMSEC = 63?
        xorlw 63
        btfss STATUS,Z
        goto SHWR2        ;no
        bsf EXTCLK,0      ;yes so set EXTCLK control flag
        movlw 'E'
        call LCDOUT
        movlw 'X'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        return

SHWR2:  movf SAMSEC,W    ;get sample rate
        btfsc STATUS,Z   ;is is zero
        goto SHWRT2      ;yes
        movwf ANSA1      ;no
        clrf ANSA2
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        movlw ANSA1
        call DECIML
        movlw ANSA1
        call PRPSHW
        movf WORK3,W
        andlw %00001111
        btfss STATUS,Z
        goto SHWRT3
        movlw ' '
        goto SHWRT4
SHWRT3: iorlw 48
SHWRT4: call LCDOUT
        movf WORK2,W
        iorlw 48
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

SHWRT2: movlw '.'
        call LCDOUT
        movlw '5'
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

SHWRA2: movlw ' '
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'X'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

INCMEM: incf MEMCNT,F       ;inc memory flag
        bcf MEMCNT,3        ;keep flag to less than 8
        call SHWMEM
        goto WAIT3

DECMEM: decf MEMCNT,W       ;dec rate
        andlw 7             ;keep rate to less than 8
        movwf MEMCNT
        call SHWMEM

WAIT3:  call PAUSIT      ;wait
        call PAUSIT      ;wait 
        return

SHWMEM: call LCD9         ;...12
        bsf RSLINE,4

        clrf ANSA5
        clrf ANSA4
        clrf ANSA3
        clrf ANSA1
        clrf POINT
        movf MEMCNT,W     ;get memory size flag
        btfsc STATUS,Z    ;is it = 0?
        goto FRERUN      ;yes
        call MEMORY
        movwf ANSA2
        movlw ANSA1
        call PREPRP
        call LCD8         ;......12
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw '='
        call LCDOUT
        return

FRERUN: call LCD8       ;.......LCD12
        bsf RSLINE,4
        clrf LOOP
FRERN2: movf LOOP,W
        call FREE
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto FRERN2
        return

HOLDIT: call LCD21
        bsf RSLINE,4
        clrf LOOP
HOLD2:  movf LOOP,W
        call HOLD
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto HOLD2
        movlw 'A'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        return

FULLUP: call LCD21
        bsf RSLINE,4
        clrf LOOP
FILL2:  movf LOOP,W
        call FILLED
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto FILL2
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT

FILL3:  btfss PORTC,1
        goto FILL3
        call SENDPC     ;down load is only option available when MEM full
        goto FULLUP     ;holds for ever until RESET called at S1 switch on

         .END

