'TY2KJ001 21FEB99 - EPE TEACH-IN 2000 V1.1 amended 22JUN00
SCREEN 9: COLOR 15, 1
DIM cap(55), res(217), decival%(12), v%(1000)
DIM cap$(55), res$(217), zener$(16)
DIM npn%(1700), dot%(200)
DIM h%(1000), menu$(40): version$ = "V1.1": ' CLS

DATA "TRANSFORMERS - PRINCIPLE          0 TY2KJ001"
DATA "RECTIFIER - HALF-WAVE             1 TY2KJ001"
DATA "RECTIFIER - FULL-WAVE BI-PHASE    2 TY2KJ001"
DATA "RECTIFIER - FULL-WAVE BRIDGE      3 TY2KJ001"
DATA "NEGATIVE AND DUAL-RAIL SUPPLIES   5 TY2KJ001"
DATA "POWER SUPPLY MISCELLANY           4 TY2KJ001"
DATA "MAIN MENU                         6 TY2KMENU"
DATA *

GOSUB clearit: GOSUB dotmake: LOCATE 10, 35: PRINT "SETTING UP"

LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15
CONST pi = 3.141592653589# / 180
LOCATE 10, 35: PRINT "          "

setmenu: READ menu$(a): IF menu$(a) <> "*" THEN a = a + 1: GOTO setmenu
maxmenu = a - 1: menucolumn = CINT(maxmenu / 2) + 1: l = LEN(menu$(0)) - 10
menu$(a) = ""

menu: GOSUB clearit: COLOR 14
LOCATE 2, 23: PRINT "TEACH-IN 2000 POWER SUPPLY MENU "; version$: COLOR 15
LINE (154 + 16, 35 - 26)-(456 + 16 - 14 + 10, 63 - 30), 15, B
LINE (157 + 16, 38 - 26)-(453 + 16 - 14 + 10, 60 - 30), 15, B
PAINT (155 + 16, 36 - 26), 7, 15: COLOR 11

FOR a = 0 TO menucolumn - 1: LOCATE a + 4, 4: PRINT LEFT$(menu$(a), l)
LOCATE a + 4, 43: PRINT LEFT$(menu$(a + menucolumn), l): NEXT

COLOR 14: LOCATE 23, 19: PRINT "SELECT WITH CURSOR ARROWS THEN PRESS <ENTER>"
COLOR 14: LOCATE 24, 27: PRINT "M"; : COLOR 11: PRINT " AND "; : COLOR 14
PRINT "Q "; : COLOR 11: PRINT "ALSO CALL MAIN MENU"; : LOCATE 1, 1

ac = (band \ menucolumn) * 39 + 3: dn = band MOD menucolumn + 3
GOSUB highlight

getkey: a$ = INKEY$: IF a$ = "" THEN GOTO getkey
IF UCASE$(a$) = "M" THEN CHAIN "TY2KMENU"
IF UCASE$(a$) = "Q" THEN CHAIN "TY2KMENU"
IF a$ = CHR$(13) THEN GOTO 20
a$ = UCASE$(MID$(a$, 2)): IF a$ = "" THEN GOTO getkey
IF a$ = "M" THEN band = band + menucolumn: GOTO 10:  'right
IF a$ = "K" THEN band = band - menucolumn: GOTO 10: 'left
IF a$ = "P" THEN band = band + 1: GOTO 10: 'down
IF a$ = "H" THEN band = band - 1: GOTO 10: 'up
IF a$ = "G" THEN band = 0: GOTO 10: 'home
IF a$ = "O" THEN band = maxmenu: GOTO 10: 'end
IF a$ = "Q" THEN band = menucolumn - 1: GOTO 10: 'page down
IF a$ = "I" THEN band = 0: GOTO 10: 'page up
GOTO getkey

10 : IF band > maxmenu THEN band = maxmenu ELSE IF band < 0 THEN band = 0

GOSUB highlight: ac = (band \ menucolumn) * 39 + 3
dn = band MOD menucolumn + 3: GOSUB highlight: GOTO getkey

20 : menu$ = RIGHT$(menu$(band), 8): menu = VAL(RIGHT$(menu$(band), 10))
menupath = menu + 1

30 : IF menupath = 7 THEN CHAIN "TY2KMENU"
ON menupath GOTO 100, 200, 300, 400, 500, 600: ' mainmenu

'....................

100 : 'BASIC TRANSFORMER PRINCIPLE
GOSUB clearit
voltspri = 240: voltssec = 240: turnsratio = 1: turnssec = 1: turnspri = 1
ratio = turnssec / turnspri: bias = 56

COLOR 10: LOCATE 2, 30: PRINT "TRANSFORMER PRINCIPLE"
COLOR 11: LOCATE 2, 6: PRINT "INPUT VOLTAGE AC"
LOCATE 2, 60: PRINT "OUTPUT VOLTAGE AC"
LOCATE 4, 31: PRINT "TURNS RATIO"; : COLOR 14: PRINT " PRI:SEC"
LOCATE 5, 43: PRINT turnspri; ":"; turnssec
COLOR 11: LOCATE 7, 29: PRINT "V PRI (RMS)   V SEC (RMS)"
COLOR 14: LOCATE 8, 30: PRINT voltspri; "Vac"
LOCATE 8, 44: PRINT voltspri * ratio; "Vac"

COLOR 10: LOCATE 20, 37: PRINT "CONTROLS:":
COLOR 14: LOCATE 21, 29: PRINT "* / + -"; : COLOR 11: PRINT " PRIMARY VOLTAGE"
LOCATE 22, 33: COLOR 14
PRINT CHR$(24); " "; CHR$(25); : COLOR 11: PRINT " TURNS RATIO"
COLOR 14: LOCATE 23, 33: PRINT "M  "; : COLOR 11: PRINT " MENU"

COLOR 14: ac = 42: dn = 9: GOSUB coil
COLOR 14: LOCATE 17, 31: PRINT "ISOLATING TRANSFORMER"
COLOR 11: LOCATE dn + 3, 30: PRINT "PRIMARY"
LOCATE dn + 4, 30: PRINT "WINDING"
LOCATE dn + 5, 30: PRINT "(INPUT)"
LOCATE dn + 3, 45: PRINT "SECONDARY"
LOCATE dn + 4, 45: PRINT "WINDING"
LOCATE dn + 5, 45: PRINT "(OUTPUT)"

yj = 182: yy = yj: x1 = 14: x2 = 446: y1 = 141
LINE (x1, yj - y1 - 14)-(x1 + 180, yj + y1), 15, B: 'box 1
LINE (x2 - 1, yj - y1 - 14)-(x2 + 180, yj + y1), 15, B: 'box 3

yj = yj + 70 - 21: angle = 0
vp = voltspri / 2.5: IF vp > 140 THEN vp = 140
vs = voltssec / 2.5: IF vs > 140 THEN vs = 140
GOSUB sine: prevsine = sine1 * vp + bias: y2 = sine1 * vp + bias

110 : 'primary
vp = voltspri / 2.5: IF vp > 133 THEN vp = 133
vs = voltssec / 2.5: IF vs > 133 THEN vs = 133
IF vs = 133 THEN col = 13 ELSE col = 0
COLOR col: LOCATE 3, 59: PRINT "MAX SCREEN ALLOWS"
IF vp = 133 THEN col = 13 ELSE col = 0
COLOR col: LOCATE 3, 5: PRINT "MAX SCREEN ALLOWS"

prevx = x1 + 1: FOR x = 1 TO 179: GOSUB sine: y2 = sine1 * vp + bias
LINE (x + x1, yy - y1 + 1)-(x + x1, yy + y1 - 1), 0
LINE (prevx, yj - prevsine)-(x + x1, yj - y2), 10
prevx = x + x1: prevsine = y2: NEXT

'secondary
prevx = x2: y3 = sine1 * vs + bias
prevsine2 = y3: FOR x = 0 TO 179: GOSUB sine: y3 = sine1 * vs + bias
LINE (x + x2, yy - y1 + 1)-(x + x2, yy + y1 - 1), 0
LINE (prevx, yj - prevsine2)-(x + x2, yj - y3), 10
prevx = x + x2: prevsine2 = y3: NEXT

z$ = INKEY$: IF z$ = "" THEN GOTO 110
IF UCASE$(z$) = "M" THEN GOTO menu
IF z$ = "+" THEN voltspri = voltspri + 1: GOTO 130
IF z$ = "-" THEN voltspri = voltspri - 1: GOTO 130
IF z$ = "*" THEN voltspri = voltspri + 10: GOTO 130
IF z$ = "/" THEN voltspri = voltspri - 10: GOTO 130

IF UCASE$(MID$(z$, 2)) = "H" THEN GOTO 125
IF UCASE$(MID$(z$, 2)) = "P" THEN GOTO 120
GOTO 110

120 :
turnsratio = turnsratio + 1: turnssec = turnssec - 1
IF turnsratio >= 1 THEN turnspri = turnsratio: turnssec = 1
IF turnsratio = 0 THEN turnssec = 1: turnspri = 1: turnsratio = 1
GOTO 130

125 :
turnsratio = turnsratio - 1: turnspri = turnspri - 1
IF turnsratio <= 1 THEN turnssec = ABS(turnsratio): turnspri = 1
IF turnsratio = 0 THEN turnssec = 1: turnspri = 1: turnsratio = -1

130 : COLOR 14
IF voltspri > 500 THEN voltspri = 500
IF voltspri < 1 THEN voltspri = 1

ratio = turnssec / turnspri: IF ratio <> .5 THEN GOTO 140
col = 0: GOSUB rightcoil
t1 = 9: dn = 10: col = 15: GOSUB rightcoil
LOCATE 17, 31: PRINT "STEP-DOWN TRANSFORMER"

140 : IF ratio <> 1 THEN 150
col = 0: GOSUB rightcoil: GOSUB leftcoil
t1 = 13: dn = 9: col = 15: GOSUB rightcoil: GOSUB leftcoil
LOCATE 17, 31: PRINT "ISOLATING TRANSFORMER"

150 : IF ratio <> 2 THEN GOTO 160
col = 0: GOSUB leftcoil: t1 = 9: dn = 10: col = 15: GOSUB leftcoil
LOCATE 17, 31: PRINT " STEP-UP TRANSFORMER "

160 : tn$ = RIGHT$("    " + STR$(turnspri), 4) + " :" + STR$(turnssec) + "  "
LOCATE 5, 41: PRINT tn$: LOCATE 8, 30: PRINT voltspri; "VAC  "
voltssec = CINT(voltspri * ratio)
LOCATE 8, 44: PRINT voltssec; "VAC  "; : COLOR 15: GOTO 110

sine: sine1 = SIN(angle * pi): angle = angle + 4
IF angle > 360 THEN angle = angle - 360
RETURN

'..........

200 : 'HALF-WAVE RECTIFIER
GOSUB clearit
volts = 1: volts2 = volts * 70: bias = 70: vx = 12
COLOR 10: LOCATE 2, 26: PRINT "HALF-WAVE RECTIFIER"
COLOR 14: LOCATE 3, 21: PRINT "PEAK OUTPUT Vdc = Vac x 1.414"

COLOR 11: LOCATE 4, 16: PRINT "(MINUS THE DIODE DROP OF TYPICALLY 0.7V)"
LOCATE 5, 17: PRINT "Vac IN THIS CONTEXT = Vrms @ 50Hz/60Hz"
COLOR 14: LOCATE 6, 22: PRINT "MAX OUTPUT Idc = Iac x 0.28"
LOCATE 8, 21: PRINT "Example for Vac = 12V:"
LOCATE 9, 18: PRINT "Peak Vdc = 12 x 1.414 - 0.7 = 16.3V"

COLOR 14: LOCATE 2, 3: PRINT "T-F SEC Vac"
LOCATE 2, 58: PRINT "RECTIFIER OUTPUT Vdc": COLOR 15

LOCATE 7, 16: PRINT "+VE": LOCATE 12, 16: PRINT "0V"
LOCATE 17, 16: PRINT "-VE": LOCATE 7, 52 - 5: PRINT "PEAK Vdc": '"+VE":
LOCATE 12, 53: PRINT "0V": COLOR 11: LOCATE 14, 21: PRINT "PRI"
COLOR 14: LOCATE 14, 49: PRINT "RL"

COLOR 15: LOCATE 11, 47: PRINT "Vdc": COLOR 14
LOCATE 11, 33: PRINT "a": LOCATE 11, 39: PRINT "k"
COLOR 15: LOCATE 17, 47: PRINT "0V"
COLOR 10: LOCATE 22, 21: PRINT "CONTROLS: "; : COLOR 11: PRINT " MENU ";
COLOR 14: PRINT "M   "; : COLOR 11: PRINT "CAPACITOR "; : COLOR 14
PRINT "C": COLOR 11: LOCATE 23, 21: PRINT "DC VOLTAGE CALC ";
COLOR 14: PRINT "* / + -": COLOR 11
LOCATE 24, 19: PRINT "ANY OTHER KEY SHIFTS WAVEFORM RIGHT"; : LOCATE 1, 1
COLOR 10: LOCATE 19, 19: PRINT "         RIPPLE Hz = AC Hz"

ac = 28: dn = 10: GOSUB coil: col = 0: GOSUB rightcoil
t1 = 9: dn = 11: col = 15: GOSUB rightcoil

LINE (31 * 8 + 4, 11 * 14 + 6)-(31 * 8 + 4, 16 * 14 - 6), 15: ' Vac arrows
LINE (31 * 8, 11 * 14 + 10)-(31 * 8 + 4, 11 * 14 + 6), 15
LINE -(31 * 8 + 8, 11 * 14 + 10), 15
LINE (31 * 8, 16 * 14 - 10)-(31 * 8 + 4, 16 * 14 - 6), 15
LINE -(31 * 8 + 8, 16 * 14 - 10), 15

COLOR 11: LOCATE 11, 29: PRINT "SEC": COLOR 14: LOCATE 14, 31: PRINT "Vac"
GOSUB capadd: cap = 3

y = 182: yy = y: x1 = 14: x2 = 446: y1 = 141
LINE (x1, y - y1 - 14)-(x1 + 90, y + y1), 15, B: 'box 1
LINE (x2 - 1, y - y1 - 14)-(x2 + 180, y + y1), 15, B: 'box 3
LINE (x1 + 140, y - 50)-(x2 - 40, y + 66), 15, B: 'box 2

y = 155: x3 = 270: LINE (x3, y - 8)-(x3 + 20, y + 2), 14: 'diode symbol
LINE -(x3, y + 12), 14: LINE -(x3, y - 8), 14: PAINT (x3 + 1, y + 2), 14, 14
LINE (x3 + 20, y - 8)-(x3 + 22, y + 12), 14, BF

COLOR 11: ac = (46 * 8) + 8
dn = 13 * 14: LINE (ac, dn - 24)-(ac, dn): 'resistor
dn = dn + 2: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 2: LINE -(ac, dn)
dn = dn + 14: LINE -(ac, dn + 4):

LINE (x3 - 30, y + 2)-(x3, y + 2), 14: 'diode centre line
LINE (x3 + 22, y + 2)-(x3 + 118, y + 2), 14

CIRCLE (ac, 12 * 14 - 11), 3, 15: PAINT (ac, 12 * 14 - 11), 15
CIRCLE (ac, dn + 5), 3, 15: PAINT (ac, dn + 5), 15
LINE (x3 - 30, dn + 5)-(x3 + 118, dn + 5), 14

PUT (cx + 30, cy - 14), v%, XOR: y = 231: angle = 0

LINE (90 + x1, y - bias - volts2)-(98 + x1, y - bias - volts2), 14
LINE (90 + x1, y - bias)-(98 + x1, y - bias), 14
LINE (90 + x1, y - bias + volts2)-(98 + x1, y - bias + volts2), 14

LINE (x2 - 8, y - bias - volts2)-(x2, y - bias - volts2), 14
LINE (x2 - 8, y - bias)-(x2, y - bias), 14

GOSUB sine: prevsine = sine1 * volts2 + bias
y2 = sine1 * volts2 + bias: GOSUB rippletext

210 : prevx = x1 + 1: FOR x = 1 TO 89: GOSUB sine
y2 = sine1 * volts2 + bias
LINE (x + x1, yy - y1 - 13)-(x + x1, yy + y1 - 1), 0
LINE (prevx, y - prevsine)-(x + x1, y - y2), 11
prevx = x + x1: prevsine = y2: NEXT

220 : prevx = x2: IF cap = 1 THEN sine1 = 1
y3 = sine1 * volts2 + bias: IF sine1 < 0 THEN y3 = bias
prevsine2 = y3: IF angle > 45 AND angle < 90 THEN sine2 = sine1
y4 = sine2 * volts2 + bias: FOR x = 0 TO 179: GOSUB sine
IF cap = 1 THEN sine1 = 1: GOTO 221
IF angle > 45 AND angle < 92 THEN sine2 = sine1: GOTO 221
IF angle = 92 THEN peak = 1
sine2 = peak: peak = peak - (1 / 270)

221 : y3 = sine1 * volts2 + bias: IF sine1 < 0 THEN y3 = bias
y4 = sine2 * volts2 + bias
LINE (x + x2, yy - y1 + 48)-(x + x2, yy - 14), 0
IF cap < 2 THEN LINE (prevx, y - prevsine2)-(x + x2, y - y3), 15
IF cap = 2 THEN LINE (prevx, y - prevsine4)-(x + x2, y - y4), 15
prevx = x + x2: prevsine2 = y3: prevsine4 = y4: NEXT

205 : z$ = INKEY$: IF z$ = "" THEN GOTO 205
IF UCASE$(z$) = "M" THEN GOTO menu
IF UCASE$(z$) = "C" THEN GOSUB rippletext
IF z$ = "+" THEN vx = vx + 1: GOTO 216
IF z$ = "-" THEN vx = vx - 1: GOTO 216
IF z$ = "*" THEN vx = vx + 10: GOTO 216
IF z$ = "/" THEN vx = vx - 10: GOTO 216
GOTO 210

216 : IF vx < 1 THEN vx = 1 ELSE IF vx > 1000 THEN vx = 1000
vx$ = RTRIM$(STR$(vx)) + "V:   ": LOCATE 8, 38: PRINT vx$
vdc = CINT((vx * 1.414 - .7) * 10) / 10: COLOR 14: LOCATE 9, 18
vx$ = "Peak Vdc =" + STR$(vx) + " x 1.414 - 0.7 ="
vx$ = LEFT$(vx$ + RTRIM$(STR$(vdc)) + "V         ", 38): PRINT vx$: GOTO 205

230 : COLOR 11: cap = (cap + 1) AND 3: IF cap = 3 THEN cap = 0
IF cap < 2 THEN PUT (cx - 2, cy - 14), v%, XOR
IF cap = 1 THEN GOTO 232

IF cap = 0 THEN GOTO 231
COLOR 14: LOCATE 8 - 3, 59: PRINT "  UNDER-SMOOTHED:"
COLOR 11: LOCATE 9 - 3, 59: PRINT "WITH RIPPLE VOLTAGE": COLOR 14
LOCATE 14, 57: PRINT "EXCESSIVE RIPPLE CAN  "
LOCATE 15, 57: PRINT "USUALLY BE REDUCED BY "
LOCATE 16, 57: PRINT "INCREASING CAP VALUE  "
LOCATE 17, 57: PRINT "(OR REDUCING THE LOAD) ": GOTO 210

231 : COLOR 14: LOCATE 8 - 3, 58: PRINT "    UNSMOOTHED DC "
LOCATE 9 - 3, 59: PRINT "                   "
LOCATE 14, 57: PRINT "SMOOTHING IS ACHIEVED "
LOCATE 15, 57: PRINT "BY ADDING A CAPACITOR "
LOCATE 16, 57: PRINT "  OF SUITABLE VALUE   "
LOCATE 17, 57: PRINT "TYPICALLY 4700 F x Idc": LOCATE 17, 71: PRINT CHR$(230)
GOTO 210

232 : LOCATE 8 - 3, 58: PRINT "  IDEAL SMOOTHING":
LOCATE 9 - 3, 59: PRINT "                ": COLOR 14
LOCATE 14, 57: PRINT " BUT IT IS SELDOM AS  "
LOCATE 15, 57: PRINT "    GOOD AS THIS!     "
LOCATE 16, 57: PRINT "   PRESS <C> AGAIN    "
LOCATE 17, 57: PRINT "                      ": GOTO 210

capadd: cx = 312: cy = 154 + 14
LINE (cx + 8, cy - 10)-(cx + 8, cy + 14), 14
LINE (cx + 8, cy + 29)-(cx + 8, cy + 53), 14
LINE (cx, cy + 14)-(cx + 16, cy + 19), 14, B
LINE (cx, cy + 23)-(cx + 16, cy + 28), 14, BF
CIRCLE (cx + 8, cy - 11), 3, 15: PAINT (cx + 8, cy - 11), 15, 15
CIRCLE (cx + 8, cy + 53), 3, 15: PAINT (cx + 8, cy + 53), 15, 15
GET (cx - 2, cy - 14)-(cx + 18, cy + 58), v%
PUT (cx - 2, cy - 14), v%, XOR: RETURN

'....................

300 : 'FULL-WAVE BI-PHASE RECTIFIER
GOSUB clearit
volts = 1: volts2 = volts * 70: bias = 70: vx = 12
COLOR 10: LOCATE 2, 22: PRINT "FULL-WAVE BI-PHASE RECTIFIER"
COLOR 14: LOCATE 3, 22: PRINT "PEAK OUTPUT Vdc = Vac x 0.71"
LOCATE 8, 21: PRINT "Example for Vac = 12V:"
LOCATE 9, 19: PRINT "Peak Vdc = 12 x 0.71 - 0.7 = 8.5V"

COLOR 11: LOCATE 4, 16: PRINT "(MINUS THE DIODE DROP OF TYPICALLY 0.7V)"
LOCATE 5, 17: PRINT "Vac IN THIS CONTEXT = Vrms @ 50Hz/60Hz"
COLOR 14: LOCATE 6, 26: PRINT "MAX OUTPUT Idc = Iac"

COLOR 14: LOCATE 2, 3: PRINT "REC INPUT Vac"
LOCATE 2, 58: PRINT "RECTIFIER OUTPUT Vdc": COLOR 15

LOCATE 7, 16: PRINT "+VE": LOCATE 12, 16: PRINT "0V"
LOCATE 17, 16: PRINT "-VE": LOCATE 7, 47: PRINT "PEAK Vdc":
LOCATE 12, 53: PRINT "0V"
COLOR 10: LOCATE 19, 19: PRINT "2 LINKED SECONDARIES OF EQUAL VALUE"
COLOR 11: LOCATE 20, 19: PRINT "       RIPPLE Hz = AC Hz x 2"

COLOR 15: LOCATE 11, 47: PRINT "Vdc": LOCATE 17, 47: PRINT "0V"
COLOR 10: LOCATE 22, 21: PRINT "CONTROLS: "; : COLOR 11: PRINT " MENU ";
COLOR 14: PRINT "M   "; : COLOR 11: PRINT "CAPACITOR "; : COLOR 14
PRINT "C": COLOR 10
LOCATE 23, 21: PRINT "DC VOLTAGE CALC "; : COLOR 14: PRINT "* / + -"
COLOR 11
LOCATE 24, 19: PRINT "ANY OTHER KEY SHIFTS WAVEFORM RIGHT"; : LOCATE 1, 1

ac = 28: dn = 10: GOSUB coil: col = 0: GOSUB rightcoil
t1 = 5: dn = 10: col = 15: GOSUB rightcoil
t1 = 5: dn = 14: col = 15: GOSUB rightcoil: GOSUB capadd: cap = 3

LINE (34 * 8 + 4, 11 * 14 + 6)-(34 * 8 + 4, 16 * 14 - 6), 15: ' Vac arrows
LINE (34 * 8, 11 * 14 + 10)-(34 * 8 + 4, 11 * 14 + 6), 15
LINE -(34 * 8 + 8, 11 * 14 + 10), 15
LINE (34 * 8, 16 * 14 - 10)-(34 * 8 + 4, 16 * 14 - 6), 15
LINE -(34 * 8 + 8, 16 * 14 - 10), 15

COLOR 10: LOCATE 12, 30: PRINT "SEC": LOCATE 16, 30: PRINT "SEC"
COLOR 14: LOCATE 13, 34: PRINT "Vac": LOCATE 14, 49: PRINT "RL"

y = 182: yy = y: x1 = 14: x2 = 446: y1 = 141
LINE (x1, y - y1 - 14)-(x1 + 90, y + y1), 15, B: 'box 1
LINE (x2 - 1, y - y1 - 14)-(x2 + 180, y + y1), 15, B: 'box 3
LINE (x1 + 140, y - 50)-(x2 - 40, y + 66), 15, B: 'box 2

y = 155: x3 = 290
LINE (x3, y - 8)-(x3 + 20, y + 2), 14: 'diode symbol top
LINE -(x3, y + 12), 14: LINE -(x3, y - 8), 14: PAINT (x3 + 1, y + 2), 14, 14
LINE (x3 + 20, y - 8)-(x3 + 22, y + 12), 14, BF

LINE (x3, y + 55)-(x3 + 20, y + 65), 14: 'diode symbol bot
LINE -(x3, y + 75), 14: LINE -(x3, y + 55), 14
PAINT (x3 + 1, y + 65), 14, 14
LINE (x3 + 20, y + 55)-(x3 + 22, y + 75), 14, BF

COLOR 11: ac = (46 * 8) + 8: 'resistor
dn = (12 + 1) * 14: LINE (ac, dn - 12 - 12)-(ac, dn)
dn = dn + 2: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 2: LINE -(ac, dn)
dn = dn + 14: LINE -(ac, dn + 4)

LINE (x3 - 26, y + 2)-(x3, y + 2), 14: 'diode centre line, top
LINE (x3 + 22, y + 2)-(x3 + 118 - 16, y + 2), 14

LINE (x3 - 26, y + 2)-(x3 - 26, y - 12), 14: ' TF link lines
LINE (x3 - 26, y - 12)-(x3 - 50, y - 12), 14
LINE (x3 - 50, y + 24)-(x3 - 50, y + 44), 14
LINE (x3 - 50, y + 34)-(x3 + 46, y + 34), 14
LINE -(x3 + 46, y + 66), 14
CIRCLE (x3 - 50, y + 34), 3, 15: PAINT (x3 - 50, y + 34), 15

LINE (x3 - 26, y + 66)-(x3 - 26, y + 80), 14
LINE (x3 - 26, y + 80)-(x3 - 50, y + 80), 14

CIRCLE (ac, 12 * 14 - 11), 3, 15: PAINT (ac, 12 * 14 - 11), 15
CIRCLE (ac, dn + 5), 3, 15: PAINT (ac, dn + 5), 15
LINE (x3 - 26, dn + 5)-(x3, dn + 5), 14: 'D2 in line
LINE (x3 + 18, dn + 5)-(x3 + 34, dn + 5), 14: 'D2 out line
LINE -(x3 + 34, dn - 58), 14: 'D2 up line
CIRCLE (x3 + 34, dn - 59), 3, 15: PAINT (x3 + 34, dn - 59), 15

LINE (x3 + 46, dn + 5)-(x3 + 102, dn + 5), 14: '0V out line

PUT (cx + 30, cy - 14), v%, XOR: y = 231: angle = 0

LINE (90 + x1, y - bias - volts2)-(98 + x1, y - bias - volts2), 14
LINE (90 + x1, y - bias)-(98 + x1, y - bias), 14
LINE (90 + x1, y - bias + volts2)-(98 + x1, y - bias + volts2), 14

LINE (x2 - 8, y - bias - volts2)-(x2, y - bias - volts2), 14
LINE (x2 - 8, y - bias)-(x2, y - bias), 14

GOSUB sine: prevsine = sine1 * volts2 + bias
y2 = sine1 * volts2 + bias: GOSUB rippletext

310 : prevx = x1 + 1: FOR x = 1 TO 89: GOSUB sine: y2 = sine1 * volts2 + bias
LINE (x + x1, yy - y1 - 13)-(x + x1, yy + y1 - 1), 0
LINE (prevx, y - prevsine)-(x + x1, y - y2), 11
prevx = x + x1: prevsine = y2: NEXT

320 : prevx = x2: IF cap = 1 THEN sine1 = 1
y3 = ABS(sine1) * volts2 + bias: prevsine2 = y3
IF (angle MOD 180) > 67 AND (angle MOD 180) < 90 THEN sine2 = ABS(sine1)
y4 = sine2 * volts2 + bias

FOR x = 0 TO 179: GOSUB sine: IF cap = 1 THEN sine1 = 1: GOTO 321
IF (angle MOD 180) > 67 AND (angle MOD 180) < 92 THEN sine2 = (sine1): GOTO 321
IF (angle MOD 180) = 92 THEN peak = 1
sine2 = peak: peak = peak - (1 / 270)

321 : y3 = ABS(sine1) * volts2 + bias: y4 = ABS(sine2) * volts2 + bias
LINE (x + x2, yy - y1 + 1 + 47)-(x + x2, yy - 14), 0
IF cap < 2 THEN LINE (prevx, y - prevsine2)-(x + x2, y - y3), 15
IF cap = 2 THEN LINE (prevx, y - prevsine4)-(x + x2, y - y4), 15
prevx = x + x2: prevsine2 = y3: prevsine4 = y4: NEXT

305 : z$ = INKEY$: IF z$ = "" THEN GOTO 305
IF UCASE$(z$) = "M" THEN GOTO menu
IF UCASE$(z$) = "C" THEN GOSUB rippletext
IF z$ = "+" THEN vx = vx + 1: GOTO 316
IF z$ = "-" THEN vx = vx - 1: GOTO 316
IF z$ = "*" THEN vx = vx + 10: GOTO 316
IF z$ = "/" THEN vx = vx - 10: GOTO 316
GOTO 310

316 : IF vx < 1 THEN vx = 1 ELSE IF vx > 1000 THEN vx = 1000
vx$ = RTRIM$(STR$(vx)) + "V:   ": LOCATE 8, 38: PRINT vx$
vdc = CINT((vx * .71 - .7) * 10) / 10: COLOR 14: LOCATE 9, 19
vx$ = "Peak Vdc =" + STR$(vx) + " x 0.71 - 0.7 ="
vx$ = LEFT$(vx$ + RTRIM$(STR$(vdc)) + "V      ", 37): PRINT vx$: GOTO 305

rippletext:
330 : COLOR 11: cap = (cap + 1) AND 3: IF cap = 3 THEN cap = 0
IF cap < 2 THEN PUT (cx - 2 + 32, cy - 14), v%, XOR
IF cap = 1 THEN GOTO 332

IF cap = 0 THEN GOTO 331
COLOR 14: LOCATE 8 - 3, 59: PRINT "  UNDER-SMOOTHED:"
COLOR 11: LOCATE 9 - 3, 59: PRINT "WITH RIPPLE VOLTAGE": COLOR 14
LOCATE 14, 57: PRINT "EXCESSIVE RIPPLE CAN "
LOCATE 15, 57: PRINT "USUALLY BE REDUCED BY"
LOCATE 16, 57: PRINT "INCREASING CAP VALUE "
LOCATE 17, 57: PRINT "(OR REDUCING THE LOAD)"
LOCATE 18, 57: PRINT "                      ": RETURN

331 : COLOR 14: LOCATE 8 - 3, 58: PRINT "    UNSMOOTHED DC "
LOCATE 9 - 3, 59: PRINT "                   "
LOCATE 14, 57: PRINT "SMOOTHING IS ACHIEVED "
LOCATE 15, 57: PRINT "BY ADDING A CAPACITOR "
LOCATE 16, 57: PRINT "  OF SUITABLE VALUE   ": LOCATE 17, 57
IF menupath = 2 THEN PRINT "TYPICALLY 4700 F x Idc"
IF menupath = 3 OR menupath = 4 THEN PRINT "TYPICALLY 2200 F x Idc"

LOCATE 17, 71: PRINT CHR$(230): COLOR 11
LOCATE 18, 57: PRINT "       PRESS <C>      ": COLOR 14
LOCATE 20, 57: PRINT "CAP VOLTAGE SHOULD BE "
LOCATE 21, 57: PRINT "RATED AROUND 2 x Vdc  ": RETURN

332 : LOCATE 8 - 3, 58: PRINT "  IDEAL SMOOTHING":
LOCATE 9 - 3, 59: PRINT "                ": COLOR 14
LOCATE 14, 57: PRINT " BUT IT IS SELDOM AS  "
LOCATE 15, 57: PRINT "    GOOD AS THIS!     ": COLOR 11
LOCATE 16, 57: PRINT "   PRESS <C> AGAIN    "
LOCATE 17, 57: PRINT "                      "
LOCATE 18, 57: PRINT "                      ": RETURN

'...........

400 : 'FULL-WAVE BRIDGE RECTIFIER
GOSUB clearit
volts = 1: volts2 = volts * 70: bias = 70: vx = 12
COLOR 10: LOCATE 2, 22: PRINT " FULL-WAVE BRIDGE RECTIFIER"
COLOR 14: LOCATE 3, 22: PRINT "PEAK OUTPUT Vdc = Vac x 1.414"
LOCATE 8, 21: PRINT "Example for Vac = 12V:"
LOCATE 9, 18: PRINT "Peak Vdc = 12 x 1.414 - 1.4 = 15.7V"

COLOR 11: LOCATE 4, 16: PRINT "(MINUS THE DIODE DROP OF TYPICALLY 1.4V)"
LOCATE 5, 17: PRINT "Vac IN THIS CONTEXT = Vrms @ 50Hz/60Hz"
COLOR 14: LOCATE 6, 23: PRINT "MAX OUTPUT Idc = Iac x 0.62"

COLOR 14: LOCATE 2, 3: PRINT "REC INPUT Vac"
LOCATE 2, 58: PRINT "RECTIFIER OUTPUT Vdc": COLOR 15

LOCATE 7, 16: PRINT "+VE": LOCATE 12, 16: PRINT "0V"
LOCATE 17, 16: PRINT "-VE": LOCATE 7, 52 - 5: PRINT "PEAK Vdc"
LOCATE 12, 53: PRINT "0V"
COLOR 11: LOCATE 20, 19: PRINT "       RIPPLE Hz = AC Hz x 2"

COLOR 15: LOCATE 13, 48: PRINT "Vdc": COLOR 14
COLOR 15: LOCATE 18, 49: PRINT "0V"
COLOR 10: LOCATE 22, 21: PRINT "CONTROLS: "; : COLOR 11: PRINT " MENU ";
COLOR 14: PRINT "M   "; : COLOR 11: PRINT "CAPACITOR "; : COLOR 14
PRINT "C": COLOR 10
LOCATE 23, 21: PRINT "DC VOLTAGE CALC "; : COLOR 14: PRINT "* / + -"
COLOR 11
LOCATE 24, 19: PRINT "ANY OTHER KEY SHIFTS WAVEFORM RIGHT"; : LOCATE 1, 1

ac = 28: dn = 10: GOSUB coil: col = 0: GOSUB rightcoil
t1 = 13: dn = 10: col = 15: GOSUB rightcoil
GOSUB capadd: cap = 3: cy = cy + 32

LINE (30 * 8, 10 * 14 + 6)-(30 * 8, 17 * 14 - 6), 15:  ' Vac arrows
LINE (30 * 8 - 4, 10 * 14 + 10)-(30 * 8, 10 * 14 + 6), 15
LINE -(30 * 8 + 4, 10 * 14 + 10), 15
LINE (30 * 8 - 4, 17 * 14 - 10)-(30 * 8, 17 * 14 - 6), 15
LINE -(30 * 8 + 4, 17 * 14 - 10), 15

COLOR 14: LOCATE 13, 30: PRINT "Vac": LOCATE 16, 49: PRINT "RL"

y = 182: yy = y: x1 = 14: x2 = 446: y1 = 141
LINE (x1, y - y1 - 14)-(x1 + 90, y + y1), 15, B: 'box 1
LINE (x2 - 1, y - y1 - 14)-(x2 + 180, y + y1), 15, B: 'box 3
LINE (x1 + 140, y - 50)-(x2 - 40, y + 80), 15, B: 'box 2

y = 155: x3 = 298
LINE (x3 + 50 - 20, y + 34)-(x3 - 4, y), 11: 'top right diagonal
LINE -(x3 - 38, y + 34), 11: 'top left diagonal
LINE -(x3 - 4, y + 68), 11: 'bot left diagonal
LINE -(x3 + 30, y + 34), 11: 'bot right diagonal

y = 155: x3 = 298
LINE (x3 + 16, y + 6)-(x3 + 16, y + 20), 14: 'diode top right
LINE -(x3 + 2, y + 20), 14: LINE -(x3 + 16, y + 6), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y + 27)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 15), 14
LINE -(x3 + 11, y + 29), 14
LINE -(x3 + 9, y + 27), 14
PAINT (x3 + 12, y + 27), 14, 14

x3 = 264: y = 164
LINE (x3 + 16, y + 20)-(x3 + 16, y + 6), 14: 'diode top left
LINE -(x3 + 2, y + 6), 14: LINE -(x3 + 16, y + 20), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y - 1)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 11), 14
LINE -(x3 + 11, y - 3), 14
LINE -(x3 + 9, y - 1), 14
PAINT (x3 + 12, y - 1), 14, 14

x3 = 298: y = 198
LINE (x3 + 16, y + 20)-(x3 + 16, y + 6), 14: 'diode bot right
LINE -(x3 + 2, y + 6), 14: LINE -(x3 + 16, y + 20), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y - 1)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 11), 14
LINE -(x3 + 11, y - 3), 14
LINE -(x3 + 9, y - 1), 14
PAINT (x3 + 12, y - 1), 14, 14

y = 189: x3 = 264
LINE (x3 + 16, y + 6)-(x3 + 16, y + 20), 14: 'diode bot left
LINE -(x3 + 2, y + 20), 14: LINE -(x3 + 16, y + 6), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y + 27)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 15), 14
LINE -(x3 + 11, y + 29), 14
LINE -(x3 + 9, y + 27), 14
PAINT (x3 + 12, y + 27), 14, 14

y = 155: x3 = 298
COLOR 14: ac = (46 * 8) + 8
dn = 15 * 14 + 4: LINE (ac, dn - 24)-(ac, dn - 4): 'resistor
dn = dn + 2: LINE -(ac + 4, dn - 4): dn = dn + 4: LINE -(ac - 4, dn - 4)
dn = dn + 4: LINE -(ac + 4, dn - 4): dn = dn + 4: LINE -(ac - 4, dn - 4)
dn = dn + 4: LINE -(ac + 4, dn - 4): dn = dn + 2: LINE -(ac, dn - 4)
dn = dn + 14: LINE -(ac, dn + 4)

LINE (x3 + 30, y + 34)-(x3 + 102, y + 34), 11:  ' +V out
LINE (x3 - 58, y - 12)-(x3 - 4, y - 12), 11: ' TF link lines top
LINE -(x3 - 4, y + 2), 11
LINE (x3 - 58, y + 80)-(x3 - 4, y + 80), 11: ' TF link lines bot
LINE -(x3 - 4, y + 66), 11

LINE (x3 - 38, y + 34)-(x3 - 46, y + 34), 11: '0V left
LINE -(x3 - 46, y + 98), 11: '0V down
LINE -(x3 + 102, y + 98), 11: '0V out line

CIRCLE (ac, 15 * 14 - 21), 3, 15: PAINT (ac, 15 * 14 - 21), 15
CIRCLE (ac, dn + 5), 3, 15: PAINT (ac, dn + 5), 15

CIRCLE (x3 - 4, dn - 91), 3, 15: PAINT (x3 - 4, dn - 91), 15
CIRCLE (x3 - 4, dn - 28), 3, 15: PAINT (x3 - 4, dn - 28), 15
CIRCLE (x3 - 38, dn - 59), 3, 15: PAINT (x3 - 38, dn - 59), 15
CIRCLE (x3 + 28, dn - 59), 3, 15: PAINT (x3 + 28, dn - 59), 15

PUT (cx + 30, cy - 14), v%, XOR: y = 231: angle = 0

LINE (90 + x1, y - bias - volts2)-(98 + x1, y - bias - volts2), 14
LINE (90 + x1, y - bias)-(98 + x1, y - bias), 14
LINE (90 + x1, y - bias + volts2)-(98 + x1, y - bias + volts2), 14

LINE (x2 - 8, y - bias - volts2)-(x2, y - bias - volts2), 14
LINE (x2 - 8, y - bias)-(x2, y - bias), 14

GOSUB sine: prevsine = sine1 * volts2 + bias
y2 = sine1 * volts2 + bias: GOSUB rippletext

410 : prevx = x1 + 1: FOR x = 1 TO 89: GOSUB sine
y2 = sine1 * volts2 + bias
LINE (x + x1, yy - y1 + 1 - 14)-(x + x1, yy + y1 - 1), 0
LINE (prevx, y - prevsine)-(x + x1, y - y2), 11
prevx = x + x1: prevsine = y2: NEXT

420 : prevx = x2: IF cap = 1 THEN sine1 = 1
y3 = ABS(sine1) * volts2 + bias: prevsine2 = y3
IF (angle MOD 180) > 67 AND (angle MOD 180) < 90 THEN sine2 = ABS(sine1)
y4 = sine2 * volts2 + bias:

FOR x = 0 TO 179: GOSUB sine: IF cap = 1 THEN sine1 = 1: GOTO 421
IF (angle MOD 180) > (45 + 22) AND (angle MOD 180) < 92 THEN sine2 = (sine1): GOTO 421
IF (angle MOD 180) = 92 THEN peak = 1
sine2 = peak: peak = peak - (1 / 270)

421 : y3 = ABS(sine1) * volts2 + bias: y4 = ABS(sine2) * volts2 + bias
LINE (x + x2, yy - y1 + 1 + 47)-(x + x2, yy - 14), 0
IF cap < 2 THEN LINE (prevx, y - prevsine2)-(x + x2, y - y3), 15
IF cap = 2 THEN LINE (prevx, y - prevsine4)-(x + x2, y - y4), 15
prevx = x + x2: prevsine2 = y3: prevsine4 = y4: NEXT

405 : z$ = INKEY$: IF z$ = "" THEN GOTO 405
IF UCASE$(z$) = "M" THEN GOTO menu
IF UCASE$(z$) = "C" THEN GOSUB rippletext
IF z$ = "+" THEN vx = vx + 1: GOTO 416
IF z$ = "-" THEN vx = vx - 1: GOTO 416
IF z$ = "*" THEN vx = vx + 10: GOTO 416
IF z$ = "/" THEN vx = vx - 10: GOTO 416
GOTO 410

416 : IF vx < 1 THEN vx = 1 ELSE IF vx > 1000 THEN vx = 1000
vx$ = RTRIM$(STR$(vx)) + "V:   ": LOCATE 8, 38: PRINT vx$
vdc = CINT((vx * 1.414 - 1.4) * 10) / 10: COLOR 14: LOCATE 9, 18
vx$ = "Peak Vdc =" + STR$(vx) + " x 1.414 - 1.4V ="
vx$ = LEFT$(vx$ + RTRIM$(STR$(vdc)) + "V      ", 37): PRINT vx$: GOTO 405

'.....................

clearit: LINE (6, 6)-(633, 343), 0, BF: RETURN

coil: x = ac * 8: y = dn * 14 + 7
angle1 = 315: angle2 = 45: s = angle1 * pi: e = angle2 * pi
LINE (x - 20, y - 4)-(x - 20, y + 86), 14
LINE (x - 16, y - 4)-(x - 16, y + 86), 14
LINE (x - 12, y - 4)-(x - 12, y + 86), 14
col = 15: t1 = 13: GOSUB leftcoil
t1 = 13: col = 15: GOSUB rightcoil: RETURN

leftcoil: x = (ac - 4) * 8: y = dn * 14 + 7
angle1 = 270 - 45: angle2 = 90 + 45: s = angle1 * pi: e = angle2 * pi
LINE (x - 6, y - 4)-(x - 16, y - 4), col
B = 7: FOR a = 1 TO t1: CIRCLE (x, y), 7, col, s, e, .72: y = y + B: NEXT
LINE (x - 6, y - 3)-(x - 16, y - 3), col: RETURN

rightcoil: x = ac * 8: y = dn * 14 + 7
angle1 = 270 + 45: angle2 = 90 - 45: s = angle1 * pi: e = angle2 * pi
LINE (x + 6, y - 4)-(x + 16, y - 4), col
B = 7: FOR a = 1 TO t1: CIRCLE (x, y), 7, col, e, s, .72: y = y + B: NEXT
LINE (x + 6, y - 3)-(x + 16, y - 3), col: RETURN

hold: IF INKEY$ = "" THEN GOTO hold ELSE RETURN

'...........

500 : GOSUB clearit: COLOR 10: LOCATE 2, 29: PRINT "POWER SUPPLY MISCELLANY"
COLOR 10: LOCATE 24, 23: PRINT " MENU "; : COLOR 14: PRINT "<M>";
COLOR 11: PRINT "     NO OTHER CONTROLS";
COLOR 11: LOCATE 4, 7: PRINT "ZENER BUFFER": COLOR 10

LOCATE 6, 6: PRINT "Vdc IN": LOCATE 20, 7: PRINT "0V":
LOCATE 19, 9: PRINT "C1 C2":

LOCATE 9, 9: PRINT "R1": LOCATE 14, 4: PRINT "D1"
LOCATE 11, 18: PRINT "TR1": LOCATE 16, 16: PRINT "Vout"
COLOR 15: LOCATE 17, 15: PRINT "LOAD"
COLOR 11: LOCATE 21, 5: PRINT "Vout = Zener"
LOCATE 22, 5: PRINT "voltage - 0.7V"

COLOR 14: y = 174 - 56 + 8: x3 = 276 - (28 * 8)
LINE (x3 - 8, y + 70)-(x3 + 8, y + 70): 'ZENER symbol
LINE -(x3, y + 56): LINE -(x3 - 8, y + 70): PAINT (x3 + 1, y + 68), 14, 14
LINE (x3 + 10, y + 56)-(x3 - 8, y + 56): LINE -(x3 - 12, y + 60)
LINE -(x3 - 11, y + 60): LINE -(x3 - 8, y + 57): LINE -(x3 + 10, y + 57)

COLOR 14: ac = 7 * 8 - 4: dn = 8 * 14 - 2
LINE (ac, dn - 10 - 14)-(ac, dn): 'resistor R1
dn = dn + 2: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 2: LINE -(ac, dn)
dn = dn + 14: LINE -(ac, dn + 120)

COLOR 14: ac = 14 * 8 + 2: dn = 13 * 14 + 6: 'load lines
LINE (ac, dn - 14)-(ac, dn + 33)
LINE (ac - 62, dn + 60)-(ac, dn + 60): LINE -(ac, dn + 52)

cx = 64: cy = 189: 'cap C1
LINE (cx + 8, cy - 32)-(cx + 8, cy + 14), 14
LINE (cx + 8, cy + 29)-(cx + 8, cy + 59), 14
LINE (cx, cy + 14)-(cx + 16, cy + 19), 14, BF
LINE (cx, cy + 23)-(cx + 16, cy + 28), 14, BF

cx = 86: cy = 189: 'cap C2
LINE (cx + 8, cy + 14)-(cx + 8, cy - 2), 14
LINE -(cx + 27, cy - 2), 14
LINE (cx + 8, cy + 29)-(cx + 8, cy + 59), 14
LINE (cx, cy + 14)-(cx + 16, cy + 19), 14, BF
LINE (cx, cy + 23)-(cx + 16, cy + 28), 14, BF

GOSUB npntran

ac = 2 * 8: dn = 2 * 14 + 7: ax = 21 * 8: dx = 23 * 14 - 7
LINE (ac, dn)-(ax, dx), 15, B: ' box 1

505 : z$ = INKEY$: IF z$ = "" THEN GOTO 505
IF UCASE$(z$) = "M" THEN GOTO menu
GOTO 505

npntran: col = 14
ac = 12: ltab = ac + 2: ttab = 7.5 + .5
LOCATE ttab + 2, ltab + 2: PRINT "c"
LOCATE ttab + 3, ltab - 3: PRINT "b"
LOCATE ttab + 5, ltab + 2: PRINT "e"
v = ltab * 8 + 2: h = ttab * 14 + 8: w = 16: x = 16
PSET (v - 61, h - 22), col: LINE -(v, h - 22), col: h = h + x + 4
LINE -(v, h), col: h = h + x: v = v - w
LINE -(v, h), col: h = h + x: v = v + w
LINE -(v, h), col: h = h + x

h = h - 32: v = v - 8
LINE (v - 8, h)-(v - 54, h), col: 'base
CIRCLE (v + 3, h), 18, 14, , , 1: '.72
CIRCLE (v - 54, h - 58), 3, 15: PAINT (v - 54, h - 58), 15
CIRCLE (v - 54, h), 3, 15: PAINT (v - 54, h), 15
CIRCLE (v - 54, h + 92), 3, 15: PAINT (v - 54, h + 92), 15

CIRCLE (v - 34, h), 3, 15: PAINT (v - 34, h), 15
CIRCLE (v - 34, h + 92), 3, 15: PAINT (v - 34, h + 92), 15
CIRCLE (v - 12, h + 92), 3, 15: PAINT (v - 12, h + 92), 15
CIRCLE (v + 8, h + 31), 3, 15: PAINT (v + 8, h + 31), 15
CIRCLE (v + 8, h + 63), 3, 15: PAINT (v + 8, h + 63), 15
CIRCLE (v + 8, h + 86), 3, 15: PAINT (v + 8, h + 86), 15

v = v + 8: h = h + 8: LINE (v, h)-(v, h + 7), 14
LINE -(v - 8, h + 7), 14: LINE -(v, h - 1), 14: PAINT (v - 4, h + 5), 14, 14
PAINT (v - 1, h + 3), 14, 14
GET (ltab * 8 - 52, ttab * 14 - 2)-(ltab * 8 + 28, ttab * 14 + 70), npn%

regulator:
COLOR 11: LOCATE 4, 25: PRINT "FIXED VOLTAGE REGULATOR": COLOR 10
LOCATE 6, 25: PRINT "Vdc                Vout"
COLOR 10: LOCATE 7, 25: PRINT " C1                C2"
LOCATE 8, 32: PRINT "IC1": LOCATE 9, 25: PRINT " 0V"
COLOR 14: LOCATE 6, 32: PRINT "IN  OUT": LOCATE 7, 34: PRINT "COM"

COLOR 11: LOCATE 10, 25: PRINT "Type examples 1A:": COLOR 14
LOCATE 11, 25: PRINT "7805  +5V   7806  +6V"
LOCATE 12, 25: PRINT "7808  +8V   7809  +9V"
LOCATE 13, 25: PRINT "7812  +12V  7815  +15V"
COLOR 11: LOCATE 14, 25: PRINT "Type examples 100mA:": COLOR 14
LOCATE 15, 25: PRINT "78L05 +5V   78L06 +6V"
LOCATE 16, 25: PRINT "78L08 +8V   78L09 +9V"
LOCATE 17, 25: PRINT "78L12 +12V  78L15 +15V": COLOR 11
LOCATE 19, 25: PRINT "Also in -VE versions:": COLOR 14
LOCATE 20, 25: PRINT "Prefix 79 instead of 78"
COLOR 11: LOCATE 21, 25: PRINT "Typical cap values:": COLOR 14
LOCATE 22, 25: PRINT "C1 330n  C2 100n"
COLOR 10: LOCATE 18, 25: PRINT "Vdc must be >= Vout +2V"

ac = 23 * 8: dn = 2 * 14 + 7
LINE (ac, dn)-(ac + 196, dn + 280), 15, B: ' reg box 1
LINE (ac + 60, dn + 33)-(ac + 124, dn + 64), 15, B: ' reg box 2
LINE (ac + 36, dn + 41)-(ac + 60, dn + 41), 15, B: ' vin
LINE (ac + 124, dn + 41)-(ac + 152, dn + 41), 15: 'vout
LINE (ac + 36, dn + 83)-(ac + 152, dn + 83), 15: '0V
LINE (ac + 91, dn + 65)-(ac + 91, dn + 83), 15: 'com

cx = ac + 38: cy = dn + 41: 'cap C1
LINE (cx + 8, cy)-(cx + 8, cy + 8), 14
LINE (cx + 8, cy + 23)-(cx + 8, cy + 42), 14
LINE (cx, cy + 8)-(cx + 16, cy + 13), 14, BF
LINE (cx, cy + 17)-(cx + 16, cy + 22), 14, BF
cx = ac + 134: 'cap C2
LINE (cx + 8, cy)-(cx + 8, cy + 8), 14
LINE (cx + 8, cy + 23)-(cx + 8, cy + 42), 14
LINE (cx, cy + 8)-(cx + 16, cy + 13), 14, BF
LINE (cx, cy + 17)-(cx + 16, cy + 22), 14, BF
PUT (ac + 43, dn + 37), dot%, OR
PUT (ac + 43, dn + 79), dot%, OR
PUT (ac + 139, dn + 37), dot%, OR
PUT (ac + 139, dn + 79), dot%, OR
PUT (ac + 88, dn + 79), dot%, OR

'.........

autotran:
COLOR 11: LOCATE 4, 57: PRINT "AUTOTRANSFORMER": COLOR 10
LOCATE 6, 61: PRINT "TAP 3"
LOCATE 8, 61: PRINT "TAP 2"
LOCATE 10, 54: PRINT "AC supply in"
LOCATE 12, 61: PRINT "TAP 1"
LOCATE 15, 54: PRINT "AC supply in": COLOR 11
LOCATE 17, 51: PRINT "TAP 1  AC reduction"
LOCATE 18, 51: PRINT "TAP 2  AC increase"
LOCATE 19, 51: PRINT "TAP 3  AC greater increase": COLOR 10
LOCATE 21, 51: PRINT "NOTE:"; : COLOR 14: PRINT " Autotransformers do"
LOCATE 22, 51: PRINT "not provide mains isolation"

ac = 49 * 8 + 4: dn = 2 * 14 + 7
LINE (ac, dn)-(ac + 224, dn + 280), 15, B: ' box
COLOR 14: ac = 72: dn = 5

x = ac * 8: y = dn * 14 + 11
angle1 = 315: angle2 = 45: s = angle1 * pi: e = angle2 * pi
LINE (x - 20, y - 4)-(x - 20, y + 122), 14
LINE (x - 16, y - 4)-(x - 16, y + 122), 14
LINE (x - 12, y - 4)-(x - 12, y + 122), 14

col = 15: t1 = 18: x = (ac - 4) * 8: y = dn * 14 + 11
angle1 = 270 - 45: angle2 = 90 + 45: s = angle1 * pi: e = angle2 * pi
LINE (x - 6, y - 4)-(x - 16, y - 4), col
B = 7: FOR a = 1 TO t1: CIRCLE (x, y), 7, col, s, e, .72: y = y + B: NEXT
LINE (x - 6, y - 3)-(x - 16, y - 3), col

ac = 64 * 8 + 10: dn = 5 * 14 + 7
LINE (ac, dn)-(ac + 8, dn), 15: ' tap 3
LINE (ac, dn + 28)-(ac + 16, dn + 28), 15: ' tap 2
LINE (ac, dn + 56)-(ac + 16, dn + 56), 15: ' ac in 1
LINE (ac, dn + 84)-(ac + 16, dn + 84), 15: ' tap 1
LINE (ac, dn + 127)-(ac + 8, dn + 127), 15: ' ac in 2
RETURN

'........

dotmake: CIRCLE (103, 104), 3, 15: PAINT (103, 104), 15, 15
GET (100, 100)-(108, 108), dot%: GOSUB clearit: RETURN

'........

600 : GOSUB clearit
COLOR 10: LOCATE 2, 22: PRINT "NEGATIVE AND DUAL-RAIL POWER SUPPLIES"
COLOR 10: LOCATE 18, 69: PRINT "MENU "; : COLOR 14: PRINT "<M>";
COLOR 11: LOCATE 20, 69: PRINT "NO OTHER": LOCATE 21, 69: PRINT "CONTROLS"
COLOR 10: LOCATE 11, 8: PRINT "NEGATIVE HALF-WAVE"
COLOR 14: LOCATE 12, 4: PRINT "Vdc = -(Vac x 1.414 - 0.7)"
COLOR 11: LOCATE 7, 4: PRINT "PRI": COLOR 14: LOCATE 7, 27: PRINT "RL"
LOCATE 4, 27: PRINT "0V": LOCATE 10, 26: PRINT "-VE"
GOSUB capadd2

y = 82: yy = y: x1 = 14: x2 = 242
LINE (x1, y - 50)-(x2, y + 94), 15, B: 'box

ac = 11: dn = 3: GOSUB coil: col = 0: GOSUB rightcoil
t1 = 9: dn = 4: col = 15: GOSUB rightcoil

ac = 14: dn = 4: ' Vac arrows
LINE (ac * 8 + 4, dn * 14 + 6)-(ac * 8 + 4, (dn + 5) * 14 - 6), 15
LINE (ac * 8, dn * 14 + 10)-(ac * 8 + 4, dn * 14 + 6), 15
LINE -(ac * 8 + 8, dn * 14 + 10), 15
LINE (ac * 8, (dn + 5) * 14 - 10)-(ac * 8 + 4, (dn + 5) * 14 - 6), 15
LINE -(ac * 8 + 8, (dn + 5) * 14 - 10), 15
COLOR 11: LOCATE 4, 13: PRINT "SEC"
COLOR 14: LOCATE 7, 15: PRINT "Vac"

y = 155 - 42 + 8: x3 = 270 - 136: 'diode symbol
LINE (x3 + 20, y - 8)-(x3, y + 2), 14: LINE -(x3 + 20, y + 12), 14
LINE -(x3 + 20, y - 8), 14: PAINT (x3 + 19, y + 2), 14, 14
LINE (x3, y - 8)-(x3 - 2, y + 12), 14, BF

COLOR 11: ac = 24 * 8 + 8: dn = 6 * 14
LINE (x3 - 30, dn - 25)-(x3 + 118 - 32, dn - 25), 14: '0V
LINE (ac, dn - 24)-(ac, dn): 'resistor
dn = dn + 2: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 2: LINE -(ac, dn)
dn = dn + 14: LINE -(ac, dn + 4)

LINE (x3 - 30, y + 2)-(x3, y + 2), 14: 'diode centre line
LINE (x3 + 22, y + 2)-(x3 + 86, y + 2), 14

CIRCLE (ac, 5 * 14 - 11), 3, 15: PAINT (ac, 5 * 14 - 11), 15
CIRCLE (ac, dn + 5), 3, 15: PAINT (ac, dn + 5), 15

605 : z$ = INKEY$: IF z$ = "" THEN GOTO 605
IF UCASE$(z$) = "M" THEN GOTO menu
GOTO 605

'........

capadd2: cx = 164: cy = 70
LINE (cx + 8, cy - 10)-(cx + 8, cy + 14), 14
LINE (cx + 8, cy + 29)-(cx + 8, cy + 53), 14
LINE (cx, cy + 14)-(cx + 16, cy + 19), 14, B
LINE (cx, cy + 23)-(cx + 16, cy + 28), 14, BF
CIRCLE (cx + 8, cy - 11), 3, 15: PAINT (cx + 8, cy - 11), 15, 15
CIRCLE (cx + 8, cy + 53), 3, 15: PAINT (cx + 8, cy + 53), 15, 15
GET (cx - 2, cy - 14)-(cx + 18, cy + 58), v%

'..........BI-PHASE

ac = 11: dn = 14: GOSUB coil: col = 0: GOSUB rightcoil
t1 = 5: col = 15: GOSUB rightcoil
t1 = 5: dn = 18: col = 15: GOSUB rightcoil

ac = 16: dn = 15: ' Vac arrows
LINE (ac * 8 + 4, dn * 14 + 6)-(ac * 8 + 4, (dn + 5) * 14 - 6), 15
LINE (ac * 8, dn * 14 + 10)-(ac * 8 + 4, dn * 14 + 6), 15
LINE -(ac * 8 + 8, dn * 14 + 10), 15
LINE (ac * 8, (dn + 5) * 14 - 10)-(ac * 8 + 4, (dn + 5) * 14 - 6), 15
LINE -(ac * 8 + 8, (dn + 5) * 14 - 10), 15

COLOR 11: LOCATE 16, 13: PRINT "SEC": LOCATE 20, 13: PRINT "SEC"
COLOR 14: LOCATE 17, 16: PRINT "Vac": LOCATE 18, 32: PRINT "RL"
COLOR 11: LOCATE 18, 4: PRINT "PRI":
COLOR 10: LOCATE 22, 5: PRINT "NEGATIVE FULL-WAVE BI-PHASE"
COLOR 14: LOCATE 23, 6: PRINT "Vdc = -(Vac x 0.71 - 0.7)"
LOCATE 15, 32: PRINT "0V": LOCATE 21, 31: PRINT "-VE"

y = 188: x1 = 14: x2 = 274: LINE (x1, y)-(x2, y + 143), 15, B: 'box

y = 211: x3 = 155: 'diode symbol top
LINE (x3 + 20, y - 8)-(x3, y + 2), 14: LINE -(x3 + 20, y + 12), 14
LINE -(x3 + 20, y - 8), 14: PAINT (x3 + 19, y + 2), 14, 14
LINE (x3, y - 8)-(x3 - 2, y + 12), 14, BF

y = 273: x3 = 155: 'diode symbol bot
LINE (x3 + 20, y - 8)-(x3, y + 2), 14: LINE -(x3 + 20, y + 12), 14
LINE -(x3 + 20, y - 8), 14: PAINT (x3 + 19, y + 2), 14, 14
LINE (x3, y - 8)-(x3 - 2, y + 12), 14, BF: y = y - 62

COLOR 11: ac = (29 * 8) + 8
dn = (16 + 1) * 14: LINE (ac, dn - 12 - 12)-(ac, dn): 'resistor
dn = dn + 2: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 2: LINE -(ac, dn)
dn = dn + 14: LINE -(ac, dn + 4):

LINE (x3 - 26, y + 2)-(x3, y + 2), 14: 'diode centre line, top
LINE (x3 + 22, y + 2)-(x3 + 102, y + 2), 14

LINE (x3 - 26, y + 2)-(x3 - 26, y - 12), 14: ' TF link lines
LINE (x3 - 26, y - 12)-(x3 - 50, y - 12), 14
LINE (x3 - 50, y + 24)-(x3 - 50, y + 44), 14
LINE (x3 - 50, y + 34)-(x3 + 46, y + 34), 14
LINE -(x3 + 46, y + 66), 14: 'sec link

CIRCLE (x3 - 50, y + 34), 3, 15: PAINT (x3 - 50, y + 34), 15

LINE (x3 - 26, y + 66)-(x3 - 26, y + 80), 14
LINE (x3 - 26, y + 80)-(x3 - 50, y + 80), 14

CIRCLE (ac, dn + 5), 3, 15: PAINT (ac, dn + 5), 15
LINE (x3 - 26, dn + 5)-(x3, dn + 5), 14: 'D2 in line
LINE (x3 + 18, dn + 5)-(x3 + 34, dn + 5), 14: 'D2 out line
LINE -(x3 + 34, dn - 58), 14: 'D2 up line
CIRCLE (x3 + 34, dn - 59), 3, 15: PAINT (x3 + 34, dn - 59), 15

LINE (x3 + 46, dn + 5)-(x3 + 102, dn + 5), 14: '0V out line
cy = cy + 154: cx = cx + 16
PUT (cx + 30, cy - 14), v%, XOR: y = 231: angle = 0
PUT (237, 209), dot%, OR

'............

COLOR 10: LOCATE 16, 39: PRINT "NEGATIVE FULL-WAVE BRIDGE": COLOR 11
LOCATE 17, 38: PRINT "As for Positive Full-Wave"
LOCATE 18, 38: PRINT "Bridge but with +VE used"
LOCATE 19, 38: PRINT "as 0V, and 0V used as -VE": COLOR 14
LOCATE 21, 43: PRINT "AC  BRIDGE   0V"
LOCATE 22, 43: PRINT "AC  CIRCUIT  -VE"
y = 188: x1 = 284: x2 = 528
LINE (x1, y + 21)-(x2, y + 143), 15, B: 'box

y = 272: x1 = 364: x2 = x1 + 62
LINE (x1, y)-(x2, y + 46), 15, B: 'box
LINE (x1 - 8, y + 15)-(x1, y + 15), 15
LINE (x1 - 8, y + 29)-(x1, y + 29), 15
LINE (x2, y + 15)-(x2 + 8, y + 15), 15
LINE (x2, y + 29)-(x2 + 8, y + 29), 15

'...........

'dual-rail supply

a = 30 + 4: B = 11
COLOR 14: LOCATE 16 - B, 39 + a: PRINT "RL+"
COLOR 11: LOCATE 16 - B, 13 + a: PRINT "SEC"
LOCATE 20 - B, 13 + a: PRINT "SEC"
COLOR 14: LOCATE 20 - B, 39 + a: PRINT "RL-"
COLOR 11: LOCATE 18 - B, 4 + a: PRINT "PRI"
COLOR 10: LOCATE 24 - B - 1, 5 + a - 2: PRINT "DUAL-RAIL SUPPLY"
COLOR 14: LOCATE 25 - B - 1, 6 + a + 4: PRINT "+Vdc =   Vac x 0.71 - 1.4"
LOCATE 25 - B, 6 + a + 4: PRINT "-Vdc = -(Vac x 0.71 - 1.4)"

cx = cx + 350: cy = cy - 176: GOSUB capadd3

y = 32: yy = y: x1 = 284: x2 = 614
LINE (x1, y)-(x2, y + 172), 15, B: 'box

ac = 45: dn = 3: GOSUB coil: col = 0: GOSUB rightcoil
t1 = 5: col = 15: GOSUB rightcoil
t1 = 5: dn = 7: col = 15: GOSUB rightcoil

ac = 50: dn = 3: ' Vac arrows
LINE (ac * 8 + 4, dn * 14 + 6)-(ac * 8 + 4, (dn + 7) * 14 - 6), 15
LINE (ac * 8, dn * 14 + 10)-(ac * 8 + 4, dn * 14 + 6), 15
LINE -(ac * 8 + 8, dn * 14 + 10), 15
LINE (ac * 8, (dn + 7) * 14 - 10)-(ac * 8 + 4, (dn + 7) * 14 - 6), 15
LINE -(ac * 8 + 8, (dn + 7) * 14 - 10), 15
a = 30 + 4: B = 11: LOCATE 13 - B + 4, 30 + a - 14: PRINT "Vac"

a = -16: B = -2: x3 = 448 - a: y = 55 - B
LINE (x3 + 30, y + 34)-(x3 - 4, y), 11: 'top right diagonal
LINE -(x3 - 38, y + 34), 11: 'top left diagonal
LINE -(x3 - 4, y + 68), 11: 'bot left diagonal
LINE -(x3 + 30, y + 34), 11: 'bot right diagonal

LINE (x3 + 16, y + 6)-(x3 + 16, y + 20), 14: 'diode top right
LINE -(x3 + 2, y + 20), 14: LINE -(x3 + 16, y + 6), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y + 27)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 15), 14: LINE -(x3 + 11, y + 29), 14
LINE -(x3 + 9, y + 27), 14: PAINT (x3 + 12, y + 27), 14, 14

x3 = 414 - a: y = 64 - B
LINE (x3 + 16, y + 20)-(x3 + 16, y + 6), 14: 'diode top left
LINE -(x3 + 2, y + 6), 14: LINE -(x3 + 16, y + 20), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y - 1)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 11), 14: LINE -(x3 + 11, y - 3), 14
LINE -(x3 + 9, y - 1), 14: PAINT (x3 + 12, y - 1), 14, 14

x3 = 448 - a: y = 98 - B
LINE (x3 + 16, y + 20)-(x3 + 16, y + 6), 14: 'diode bot right
LINE -(x3 + 2, y + 6), 14: LINE -(x3 + 16, y + 20), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y - 1)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 11), 14: LINE -(x3 + 11, y - 3), 14
LINE -(x3 + 9, y - 1), 14: PAINT (x3 + 12, y - 1), 14, 14

x3 = 414 - a: y = 89 - B
LINE (x3 + 16, y + 6)-(x3 + 16, y + 20), 14: 'diode bot left
LINE -(x3 + 2, y + 20), 14: LINE -(x3 + 16, y + 6), 14
PAINT (x3 + 15, y + 12), 14, 14
LINE (x3 + 9, y + 27)-(x3 + 23, y + 13), 14: 'diode bar
LINE -(x3 + 25, y + 15), 14: LINE -(x3 + 11, y + 29), 14
LINE -(x3 + 9, y + 27), 14: PAINT (x3 + 12, y + 27), 14, 14

x3 = 448 - a: y = 55 - B
COLOR 11: ac = 70 * 8 + 2
dn = 4 * 14 + 8: LINE (ac, dn - 18)-(ac, dn - 4): 'resistor top
dn = dn + 2: LINE -(ac + 4, dn - 4): dn = dn + 4: LINE -(ac - 4, dn - 4)
dn = dn + 4: LINE -(ac + 4, dn - 4): dn = dn + 4: LINE -(ac - 4, dn - 4)
dn = dn + 4: LINE -(ac + 4, dn - 4): dn = dn + 2: LINE -(ac, dn - 4)
dn = dn + 14: LINE -(ac, dn + 4)

dn = 8 * 14 + 5: LINE (ac, dn - 18)-(ac, dn - 4): 'resistor bot
dn = dn + 2: LINE -(ac + 4, dn - 4): dn = dn + 4: LINE -(ac - 4, dn - 4)
dn = dn + 4: LINE -(ac + 4, dn - 4): dn = dn + 4: LINE -(ac - 4, dn - 4)
dn = dn + 4: LINE -(ac + 4, dn - 4): dn = dn + 2: LINE -(ac, dn - 4)
dn = dn + 14: LINE -(ac, dn + 4)

COLOR 14
LINE (x3 + 30, y + 34)-(x3 + 38, y + 34), 14: ' +V out right
LINE -(x3 + 38, y - 12), 14: ' +V out up
LINE -(x3 + 106, y - 12), 14: ' +V out

LINE (x3 - 88, y - 12)-(x3 - 4, y - 12), 14: ' TF link lines top
LINE -(x3 - 4, y + 2), 14
LINE (x3 - 88, y + 80)-(x3 - 4, y + 80), 14: ' TF link lines bot
LINE -(x3 - 4, y + 66), 14
LINE (x3 - 87, y + 24)-(x3 - 87, y + 44), 14: 'sec link
LINE (x3 - 87, y + 34)-(x3 - 71, y + 34), 14: 'sec out
LINE -(x3 - 71, y + 90), 14: 'sec down
LINE -(x3 + 48, y + 90), 14: 'sec right
LINE -(x3 + 48, y + 48), 14: 'sec up
LINE -(x3 + 74, y + 48), 14: 'sec to caps
LINE (x3 + 74, y + 34)-(x3 + 98, y + 34), 14: ' caps to res
LINE (x3 + 98, y + 48)-(x3 + 106, y + 48), 14: '0V out

LINE (x3 - 38, y + 34)-(x3 - 46, y + 34), 14: '-VE left
LINE -(x3 - 46, y + 98), 14: '-VE down
LINE -(x3 + 106, y + 98), 14: '-VE out line

PUT (x3 + 71, y + 94), dot%, OR
PUT (x3 + 71, y + 44), dot%, OR
PUT (x3 + 71, y + 30), dot%, OR
PUT (x3 + 71, y - 16), dot%, OR
PUT (x3 - 90, y + 30), dot%, OR

PUT (x3 + 95, y - 16), dot%, OR
PUT (x3 + 95, y + 30), dot%, OR
PUT (x3 + 95, y + 44), dot%, OR
PUT (x3 + 95, y + 94), dot%, OR

dn = 11 * 14 - 4
CIRCLE (x3 - 4, dn - 91), 3, 15: PAINT (x3 - 4, dn - 91), 15
CIRCLE (x3 - 4, dn - 28), 3, 15: PAINT (x3 - 4, dn - 28), 15
CIRCLE (x3 - 38, dn - 59), 3, 15: PAINT (x3 - 38, dn - 59), 15
CIRCLE (x3 + 28, dn - 59), 3, 15: PAINT (x3 + 28, dn - 59), 15

cx = cx - 24 - 8: cy = cy + 54
PUT (cx + 30, cy - 14), v%, OR

a = 42: B = 11
LOCATE 15 - B, 32 + a: PRINT "+VE":
LOCATE 19 - B, 32 + a - 1: PRINT "0V":
LOCATE 23 - B, 32 + a: PRINT "-VE"

cx = (30 + a) * 8 + 4: cy = (14 - B) * 14
GET (cx, cy)-(cx + 30, cy + 16), v%
PUT (cx, cy), v%, XOR
PUT (cx - 8, cy - 4), v%, OR
GET (cx, cy + 110)-(cx + 30, cy + 126), v%
PUT (cx, cy + 110), v%, XOR
PUT (cx - 8, cy + 104), v%, OR:

GET (cx - 8, cy + 12)-(cx + 30, cy + 28), v%
PUT (cx - 8, cy + 12), v%, XOR
PUT (cx - 8, cy + 18), v%, OR
GET (cx - 8, cy + 69)-(cx + 30, cy + 85), v%
PUT (cx - 8, cy + 69), v%, XOR
PUT (cx - 8, cy + 73), v%, OR: RETURN

capadd3:
LINE (cx + 8, cy - 2)-(cx + 8, cy + 14), 14
LINE (cx + 8, cy + 29)-(cx + 8, cy + 53), 14
LINE (cx, cy + 14)-(cx + 16, cy + 19), 14, B
LINE (cx, cy + 23)-(cx + 16, cy + 28), 14, BF
GET (cx - 2, cy - 14)-(cx + 18, cy + 58), v%: RETURN

highlight:
ax = ac * 8 - 1: dx = dn * 14 + 1: ay = (ac + 33) * 8: dy = dx + 14 - 2
GET (ax, dx)-(ay, dy), h%: PUT (ax, dx), h%, PRESET: RETURN

