; 3rd iteration of RXR software.
; Recieves 418 Mhz info, decodes data and calculates CRC then
; transmits RS232 Serial comms to PC at 9600,N,8,1
; James Humphris
; 5th Feb 1998.
; Version 3.01

	list P=PIC16C71
	include "P16C71.INC"

; Bits required for use as follows :

Intcon		equ 0B	; Interrupt register
Status		equ 3	; Status Register
PortB		equ 6	; Port B
c		equ 0 	; Carry bit
z		equ 2	; zero flag

RXRInput	equ 0	; RB0
RXRStatusLED	equ 7	; RB7 (Yellow)
RS232Output	equ 5	; RB5 
RS232Status 	equ 6	; RB6 (Green)
TXByte 		equ 20	; Register for TXbyte.
intindex1	equ 21	; delay register 1
intindex2	equ 22	; delay register 2
Bitcounter 	equ 23	; bit counter register
Temp		equ 24	; temp reg
RXBytedata	equ 25  ; recieved data register
common		equ 26	; packet size register
CRCByte		equ 27  ; CRC Result register
CRCStore	equ 28	; CRC Null register
CRCWorking	equ 29	; CRC working register
CRCCounter	equ 2A	; CRC byte counter
CRCBitNumber	equ 2B	; CRC bit number

	org 0x000		; Organise code as appropiate

; Initialise and Setup ports

	CLRF	Intcon			; No interrupts
	CLRF 	Status
	BSF	Status, RP0		; Select register bank 0
	CLRF	PortB			; Port B = 0
	MOVLW	0x01
	MOVWF	TRISB			; Setup all outputs apart from RXR Input
	BCF	Status,RP0
	BSF	PortB,RS232Status	; Switch off LED's
	BSF	PortB,RXRStatusLED	; Switch off LED's

	MOVLW	0x0F			; Wait for a while to settle system
loop2:	MOVWF	common			; to PC to settle TX, RX
	MOVLW	0xFF
	MOVWF	TXByte
	call 	TransmitByte
	decfsz	common
	goto 	loop2		

	MOVLW	0x48				; Say Hello.
	MOVWF	TXByte
	call 	TransmitByte
	MOVLW	0x65
	MOVWF	TXByte
	call 	TransmitByte
	MOVLW	0x6C
	MOVWF	TXByte
	call 	TransmitByte
	MOVLW	0x6C
	MOVWF	TXByte
	call 	TransmitByte
	MOVLW	0x6F
	MOVWF	TXByte
	call 	TransmitByte
	MOVLW	0x2E
	MOVWF	TXByte
	call 	TransmitByte
	nop					; null

Wait:		BCF	Status,z		; Clear zero flag
		CALL 	RXByte			; Get byte
		MOVFW	RXBytedata		
		MOVWF	TXByte
		MOVLW	0x55		
		SUBWF	RXBytedata		; subtract the 55 from rx byte 
		SKPZ				; transmit packet if 55 received
		goto 	Wait			; otherwise wait for next sync byte
		Call	TransmitByte		; Tell me what the Trigger byte is.
		
		MOVLW	0x00			; CRC only operates on 7 data bits !!
		MOVWF	CRCByte			; Setup CRC byte to zero
		MOVWF	CRCStore		; Set Store to zero
		MOVWF	CRCWorking		; Set working to zero

		MOVLW	0x07			
		MOVWF	common
nextbyte:	CALL	RXByte			; get byte
		MOVFW	RXBytedata		; transfer byte
		MOVWF	TXByte		
		call	TransmitByte		; send byte
		decfsz  common			; seven bytes been sent ?
		goto 	nextbyte		; no, send next byte
		MOVLW	0x06			; yes, calculate final CRC
		MOVWF	CRCBitNumber
		MOVLW	0x00	
		MOVWF	CRCWorking
		call 	CRC			; finish off CRC procedure
		MOVFW	CRCByte
		MOVWF	CRCStore		; Store RX CRCbyte temporarily
		call	RXByte			; Recieve TX CRC byte
		MOVFW	RXBytedata
		MOVWF	TXByte
		call	TransmitByte		; Transmit TX CRC byte
		MOVFW	CRCStore		; Retrieve RX CRCbyte
		MOVWF	TXByte
		call	TransmitByte		; Transmit RX CRCbyte
		call	delaybit		; Wait for a while
		nop				; null
		goto    Wait			; wait for next sync pulse

TransmitByte:

	BCF	PortB, RS232Status	; Switch on RS232 LED
	BCF	Status,RP0		; Select register bank 1
	MOVLW	0x08			; set eight data bits
	MOVWF	Bitcounter
	BCF	PortB,RS232Output	; Set beginning of start bit
	call 	delaybit
	
nextbit:
	RRF 	TXByte			; rotate TX byte.
	BTFSC	Status,c		; Test carry clear
	BSF	PortB,RS232Output	; Set bit if carry set	
	BTFSS	Status,c		; Test carry set
	BCF	PortB,RS232Output	; Clear bit if carry clear
	call 	delaybit		; wait between bits sent
	decfsz	Bitcounter		; test number of bits sent
	goto 	nextbit			; Jump if eight bits sent
	BSF	PortB,RS232Output	; Set beginning of start bit
	Call	delaybit		; Wait for duration of stop bit
	
	call	delaybit
	BSF	PortB,RS232Status	; Switch off RS232 LED
		
		return	


RXByte:		NOP
		BCF	Status,c	; Clear carry
		MOVLW	0x08		; set eight data bits
		MOVWF	Bitcounter
		CLRF	RXBytedata	; clear buffer
nextbit2:	BTFSS 	PortB,RXRInput	; wait for positive edge (crude)
		goto 	nextbit2
		call    delayRXbit	; wait for half bit
		call 	delayRXbit	; wait for half bit
		BCF	PortB,RXRStatusLED	; Switch on RX LED	
nextbit3:	call 	delayRXbit	; wait for half a bit time
		BTFSC	PortB,RXRInput	; Test input level
		BSF	Status,c	; set bit to one
		BTFSS   PortB,RXRInput  ; Test input level
		BCF	Status,c	; set bit to zero
		RRF	RXBytedata	; rotate for next bit
		call	delayRXbit	; wait for rest of bit time
		decfsz	Bitcounter	; test number of bits sent
		goto 	nextbit3	; Jump if eight bits sent
		BSF	PortB,RXRStatusLED	; Switch off RX LED	
		MOVLW	0x09
		MOVWF	CRCBitNumber
		MOVFW	RXBytedata
		MOVWF	CRCWorking
		call	CRC		; Calculate CRC
		return

CRC:		BCF	Status,C	; Clear carry ready for CRC
		MOVFW	CRCBitNumber	; Calculate CRC on recieved byte
		MOVWF	intindex1	; Setup eight bytes
NextCRCBit:	DECF	intindex1
		SKPNZ	
		goto    EndOfCRC	; end
		RLF	CRCWorking		
		RLF	CRCByte		; Transfer MSB into CRC byte
		BTFSS	CRCByte,4	; Test Pop ! bit
		Goto 	NextCRCBit	; If Pop bit '0' goto next bit
		MOVLW	0x17		; If Pop bit '1' Move Poly into W
		XORWF	CRCByte		; XOR Poly and CRCByte
		Goto	NextCRCBit	
EndOfCRC:	return			; do nothing
			

;-------------------------------------------------------------------------------------------
;delay routines

delaybit:				; A bit is 96 instructions long.
		movlw 	0x0C		; This routine delays for 90 instructions.
		movwf 	intindex2
		
redelay14:	movlw 	0x01		
		movwf	intindex1

delay14:	decfsz 	intindex1
		goto 	delay14
	
delay25:	decfsz	intindex2
		goto 	redelay14
		return


; A byte received on the serial line will have the following  form:
;------|________| bit 0 | bit 1 | .... | bit 7 |------------
; Stop    Start             Data                Stop bit			


;Delay routines:
;-----------------------------------------------------------------------------------
delayRXbit:				; A bit is 3087 instructions long at 300bps.
		movlw 	0x29		; This routine delays for 1535 instructions.
		movwf 	intindex2	; in order to sample approx half way through
					; bit transmission.
redelay24:	movlw 	0x0B		
		movwf	intindex1

delay24:	decfsz 	intindex1
		goto 	delay24
	
		decfsz	intindex2
		goto 	redelay24
		return

Shortdelay:
		movlw 	0x0A		; This routine delays for 345 instructions.
		movwf 	intindex2
		
redelay07:	movlw 	0x0A		
		movwf	intindex1

delay07:	decfsz 	intindex1
		goto 	delay07
	
		decfsz	intindex2
		goto 	redelay07
		return
end
