

list P=16C84 

;***** Infra-red remote controlled pre-amp V 3.1 12,05,97 *****
;***** Copyright M. O. Skeete 1996
;***** Tidied up for public viewing

;*****          RA0     RA1     Device          *****
;*****          0       0       Tv              *****
;*****          1       0       Preamp          *****
;*****          *       1       Video           *****

;Use 10k resistors to connect RA0 & RA1 to 0 or 5 volts

include "p16cxx.inc"
include "p16cxxd.inc"

; Interrupt timings calculated for use with RC5 code.
; With a 4mhz clock each instruction takes 1uS
; if the prescaler is divided by 8 then the RTCC will increment
; every 8 uSecs
; 8 * 167 = 1.3335  Msecs = three quarter bit time
; 256  - 167 = 89
; 8 * 111  = 0.888  Msecs = half bit time
; 256  - 111  = 145
; 
; debouce = 226 ,, decrement every 0.888 milliseconds
; debouce will equal 0 every 200.688 milliseconds

ns1331          equ D'89'       ; Values for RTCC register
ns883           equ D'145'      ; 
ms200           equ D'226'      ; Value for debouce register
		

volume          equ 10
bass            equ 11
treble          equ 12
balance         equ 13
input           equ 14
mute            equ 15

ptr             equ 16          ; points to EE and or FILE address
ir_temp         equ 17h
l_comm          equ 18h         ; last command code stored here
I_temp          equ 19h         ; GIE status stored here during read and write 
W_temp          equ 1Ah         ; W register stored here during interrupt
S_temp          equ 1Bh         ; STATUS register stored here during interrupt

				; flags stored in I_temp
GIE_R           equ 00h         ; GIE status during EEDATA READ 
GIE_W           equ 01h         ; GIE status during EEDATA WRITE


ir_address      equ 1Ch
ir_command      equ 1Dh
ir_counter      equ 1Eh
ir_flags        equ 1Fh

ir_pin          equ 00h         ; signals from infra-red sensor received
				; on this pin


decode          equ 00h         ; Flags stored in ir_flags;
half01          equ 02h
c_ctrl_bit      equ 05h         ; Current control bit
l_ctrl_bit      equ 06h         ; Last control bit
auto_repeat     equ 07h         ; bit set if key is auto_repeating

RC5_tv          equ D'00'       ; Address code for RC5 Television
RC5_video       equ D'05'       ; Address code for RC5 video recorder
RC5_preamp      equ D'16'       ; Address code for RC5 Preamplifier

RC5_mute        equ D'13'       ; RC5 command codes
RC5_volume_up   equ D'16'      
RC5_volume_dw   equ D'17'
RC5_bright_up   equ D'18'
RC5_bright_dw   equ D'19'
RC5_colour_up   equ D'20'
RC5_colour_dw   equ D'21'
RC5_bass_up     equ D'22'
RC5_bass_dw     equ D'23'
RC5_treble_up   equ D'24'
RC5_treble_dw   equ D'25'
RC5_balance_rt  equ D'26'
RC5_balance_lt  equ D'27'
RC5_pause       equ D'48'
RC5_fast_rew    equ D'50'
RC5_fast_for    equ D'52'
RC5_play        equ D'53'
RC5_stop        equ D'54'
RC5_record      equ D'55'

RC5_bits        equ D'13'       ; 14 bits minus first start bit
RC5_add_bits    equ D'06'       ; 13 bits minus second start bit
				; one control bit and five address bits






;**** LMC1983 Programming codes

lm_input                equ 40h
lm_loudness             equ 41h
lm_bass                 equ 42h
lm_treble               equ 43h
lm_left_vol             equ 44h
lm_right_vol            equ 45h
lm_mode                 equ 46h
lm_read                 equ 47h         ; only use with open drain/collector outputs

lm_left_mono            equ 04h
lm_stereo               equ 05h         ; input modes
lm_right_mono           equ 06h

lm_tone_max             equ 0Ch        
lm_vol_min              equ 28h         ; 0 = maximum volume 40 = minimum volume
lm_select_max           equ 02h
lm_mute_code            equ 03h

lm_address              equ 20h
lm_data                 equ 21h
lm_bits                 equ 22h

lm_data_pin             equ 01h        
lm_id_pin               equ 02h
lm_clk_pin              equ 03h

led_pin                 equ 02h         ; l.e.d pin 
relay_pin               equ 03h         ; relay pin
eq_flat_pin             equ 04h         ; high level on this pin sets e.q flat

debouce                 equ 23h

delay01                 equ 24h
delay02                 equ 25h

ir_add_code             equ 26h         ; Tv = 0 ; Video = 5 ; Preamp = 16
ir_volume_up            equ 27h         ;
ir_volume_dw            equ 28h         ;
ir_bass_up              equ 29h         ;
ir_bass_dw              equ 2Ah         ;
ir_treble_up            equ 2Bh         ;
ir_treble_dw            equ 2Ch         ;
ir_mute                 equ 2Dh         ;

org 00h         ; Start address for the PIC1684
		; execution starts here
goto init
		
org 04h         ; Start address of Interrupt routine ;INT84
		; interrupt routine version 1.1
			
		movwf W_temp            ; save W register
		swapf STATUS, W         ; save SATUS register
		movwf S_temp
		bcf INTCON, T0IF        ; clear RTCC interrupt flag
		movlw ns883             ; reload RTCC register
		movwf TMR0              ;
		decf debouce, F

; **** code for version 2 goes here ******
; 14,2,96 ; routine called every half bit time
; 08,3,96 ; 5:00am worked for the first time in the flesh

; decode RC5 signal

		btfss ir_flags,decode           ; if decoding hasn't started
		goto ret                        ; then return
		
		movf ir_counter, W              ; if counter==0 then set
		btfsc STATUS, Z                 ; counter to 13
		movlw RC5_bits
		movwf ir_counter
		
		btfsc ir_flags,half01           ; if first half already
		goto second_bit                 ; measured do second half
		
		movf PORTB, W                   ; measure first half
		andlw 01h                       ; mask bits except bit 0 (ir_pin)
		movwf ir_temp                   ; store bit
		bsf ir_flags, half01            ; set flag to say first half measured
		goto ret

second_bit      bcf ir_flags, half01            ; reset flag
		movf PORTB, W                   ; measure second half
		andlw 01h               
		xorwf ir_temp, W                ; compare first and second half
		btfsc STATUS, Z                 ; if (first==second) then error
		goto ir_error

		bcf STATUS, C           
		btfsc ir_temp, ir_pin
		bsf STATUS, C
		rlf ir_command                  ; store bit in command register
		decf ir_counter                 ; and decrement bit counter

		movlw RC5_add_bits              ; if five address bits are stored then
		xorwf ir_counter, W             ; move them from the
		btfss STATUS, Z                 ; command register into the
		goto finished_yet               ; address register
		
		movf ir_command, W
		bcf ir_flags, c_ctrl_bit
		btfsc ir_command, c_ctrl_bit
		bsf ir_flags, c_ctrl_bit        ; save control bit

		andlw 1Fh                       ; mask start and control bits
		movwf ir_address
		clrf ir_command
		goto ret

finished_yet    movf ir_counter, F              ; if (counter==0) then
		btfss STATUS, Z
		goto ret
		
		movf ir_address, W              ; check if address matches
		xorwf ir_add_code, W
		btfss STATUS, Z
		goto ir_error

ir_execute      bsf PORTA, led_pin              ; turn l.e.d. on
		movlw ms200                     ; reload debouce register
		movwf debouce
				
		movf ir_command, W              ; compare current command with
		xorwf l_comm, W                 ; last command
		btfss STATUS, Z
		goto save_ctrl_bit
		
same_comm       movlw 60h                        
		andwf ir_flags, F
		btfsc STATUS, Z                 ; last and current bits == 0
		bsf ir_flags, auto_repeat 
		
		xorwf ir_flags, W
		btfsc STATUS, Z                 ; last and current bits == 1 
		bsf ir_flags, auto_repeat

save_ctrl_bit   bcf ir_flags, l_ctrl_bit
		btfsc ir_flags, c_ctrl_bit
		bsf ir_flags, l_ctrl_bit

		movf ir_command, W
		movwf l_comm                    ; save current command
		
		movf ir_volume_up, W            ; test command code and execute
		xorwf ir_command, W             ; appropriate command
		btfsc STATUS, Z
		call volume_up
		
		movf ir_volume_dw, W
		xorwf ir_command, W
		btfsc STATUS, Z
		call volume_down

		movf ir_bass_up, W
		xorwf ir_command, W
		btfsc STATUS, Z
		call bass_up

		movf ir_bass_dw, W
		xorwf ir_command, W
		btfsc STATUS, Z
		call bass_down

		movf ir_treble_up, W
		xorwf ir_command, W
		btfsc STATUS, Z
		call treble_up

		movf ir_treble_dw, W
		xorwf ir_command, W
		btfsc STATUS, Z
		call treble_down

		movf ir_mute, W
		xorwf ir_command, W
		btfsc STATUS, Z
		call mute_on_off

		movf ir_command, F              ; ignore key "0"
		btfsc STATUS, Z
		goto ir_error
		movlw 04                        ; check keys "1" - "3"
		subwf ir_command, W
		btfsc STATUS, C
		goto ir_error
		
		decf ir_command, W              ; set input to key pressed
		movwf input
		movlw input
		movwf FSR
		call store
		movf input, W
		movwf lm_data
		movlw lm_input
		movwf lm_address
		call transmit

ir_error        clrf ir_counter                 ; reset ir registers if
		clrf ir_address                 ; there is an error or after
		clrf ir_command                 ; a command is executed
		movlw 040h
		andwf ir_flags, F               ; keep control bit information

ret             swapf S_temp, W                 ; restore STATUS register
		movwf STATUS
		swapf W_temp, F                 ; restore w register
		swapf W_temp, W
		retfie                          ; return form interrupt

; read the contents of EEPROM pointed to by EEADR register 
; Value left in EEDATA register
read_mem        bcf I_temp, GIE_R       ; save INTCON, GIE state
		btfsc INTCON, GIE
		bsf I_temp, GIE_R
		bcf INTCON, GIE         ; disable interrupts
		bsf STATUS, RP0         ; change to page 1
		bsf EECON1, RD          ; initiate read
		bcf STATUS, RP0         ; Change to page 0
		btfsc I_temp, GIE_R     ; enable interrupts if neccessary
		bsf INTCON, GIE         ; 
		return                  

; write the value in EEDATA register to EEPROM location EEADR
write_mem       bcf I_temp, GIE_W       ; save INTCON, GIE state
		btfsc INTCON, GIE
		bsf I_temp, GIE_W
		bcf INTCON, GIE         ; disable all interrupts
		bsf STATUS, RP0         ; change to page 1
		bsf EECON1, WREN        ; enable writing
		movlw 55h               ; do write
		movwf EECON2
		movlw 0AAh
		movwf EECON2
		bsf EECON1, WR
ee_wait         btfsc EECON1, WR        ; wait until write is complete
		goto ee_wait
		bcf EECON1, EEIF        ; clear write_complete flag
		bcf EECON1, WREN        ; disable writing    
		bcf STATUS, RP0         ; change to page 0
		btfsc I_temp, GIE_W     ; enable interrupts if neccessary
		bsf INTCON, GIE         ; 
		return

; initialization routine

init            bsf STATUS, RP0         ; change to page 1
		movlw 0F1h              ; Port_B 1 - 3 outputs ; RB0 input
		movwf TRISB             ; Port_B 4 -7 input
		movlw 10h               ; Port_A 0 - 3 outputs
		movwf TRISA             ; Port_A 4 input
		movlw 02h               ; setup prescaler to divide
		movwf OPTION_REG        ; internal clock by 8
		bcf STATUS, RP0         ; back to page 0
		movlw 0Eh
		movwf PORTB             ; set portb output pins high
		clrf PORTA              ; set porta output pins low
		bsf PORTA, led_pin      ; flash led after power on
		movlw ms200             ; debouce value
		movwf debouce
		clrf ir_flags           ; clear a few registers
		clrf ir_address
		clrf ir_command
		clrf ir_counter

		movlw volume            ; load previous settings from memory
		movwf FSR 
		movwf ptr               ; init ptr for later use
load_next       call restore            ; copy EE data to file register
		incf FSR, F             ; Move to next address
		movf FSR, W             ; test for last one (mute)
		xorlw ptr               ; ptr=mute+1
		btfss STATUS, Z         ; skip if Z, else loop
		goto load_next

		movlw 0FFh
		movwf l_comm

wait            movlw 0FFh              ; Wait for LMC1983 to reset
		movwf delay01
del01           movlw 0FFh
		movwf delay02
del02           decfsz delay02
		goto del02
		decfsz delay01, F
		goto del01

		;bsf PORTA, relay_pin    ; turn relay on

init_LMC1983    movlw lm_mode           ; use stereo input mode     
		movwf lm_address
		movlw lm_stereo
		movwf lm_data
		call transmit
		
		movlw lm_left_vol
		movwf lm_address
		movf volume, W
		movwf lm_data
		call transmit

		movlw lm_right_vol
		movwf lm_address
		movf volume, W
		movwf lm_data
		call transmit

		movlw lm_bass
		movwf lm_address
		movf bass, W
		movwf lm_data
		call transmit

		movlw lm_treble
		movwf lm_address
		movf treble, W
		movwf lm_data
		call transmit

		movlw lm_input
		movwf lm_address
		movf input, W
		movwf lm_data
		call transmit

choose_address  bsf STATUS, RP0         ; change to page 1
		bsf TRISA, 0            ; use RA0 as an input
		bsf TRISA, 1            ; use RA1 as an input
		nop                     ; 
		nop                     ; 
		bcf STATUS, RP0         ; back to page 0
		btfsc RA1               ; 5 volts video
		goto video
		btfss RA0               ; 0 volts tv // 5 volts preamp
		goto tv
		goto preamp
tv              movlw RC5_tv
		movwf ir_add_code
		movlw RC5_volume_up
		movwf ir_volume_up
		movlw RC5_volume_dw
		movwf ir_volume_dw
		movlw RC5_colour_up
		movwf ir_bass_up
		movlw RC5_colour_dw
		movwf ir_bass_dw
		movlw RC5_bright_up
		movwf ir_treble_up
		movlw RC5_bright_dw
		movwf ir_treble_dw
		movlw RC5_mute
		movwf ir_mute
		goto  tidy_up
video           movlw RC5_video
		movwf ir_add_code
		movlw D'04'
		movwf ir_volume_up
		movlw D'07'
		movwf ir_volume_dw
		movlw D'05'
		movwf ir_bass_up
		movlw D'08'
		movwf ir_bass_dw
		movlw D'06'
		movwf ir_treble_up
		movlw D'09'
		movwf ir_treble_dw
		movlw D'00'
		movwf ir_mute
		goto  tidy_up
preamp          movlw RC5_preamp
		movwf ir_add_code
		movlw RC5_volume_up
		movwf ir_volume_up
		movlw RC5_volume_dw
		movwf ir_volume_dw
		movlw RC5_bass_up
		movwf ir_bass_up
		movlw RC5_bass_dw
		movwf ir_bass_dw
		movlw RC5_treble_up
		movwf ir_treble_up
		movlw RC5_treble_dw
		movwf ir_treble_dw
		movlw RC5_mute
		movwf ir_mute
		goto tidy_up

tidy_up         bsf STATUS, RP0         ; change to page 1
		bcf TRISA, 0            ; use RA0 as an output
		bcf TRISA, 1            ; use RA1 as an output
		bcf STATUS, RP0         ; back to page 0
		movlw ns883
		movwf TMR0
		bsf INTCON, T0IE        ; unmask RTCC interrupt
		bsf INTCON, GIE         ; enable interrupts 
		goto main               ; start main program

; main section of code
; test infra-red pin and read keys every 100ms

main            btfsc ir_flags, decode  ; test remote
		goto test_keys
		btfsc PORTB, ir_pin     ; if an infra signal is detected
		goto test_keys          ; then synchronise interrupts to 
		movlw ns1331            ; start of signal and wait three
		movwf TMR0              ; quarter bit time before next
		bsf ir_flags, decode    ; interrupt

test_keys       movf debouce, F         ; goto main if debouce <> 0
		btfss STATUS, Z
		goto main

		bcf PORTA, led_pin      ; make sure l.e.d. is off
		
		bcf RA0                 ; read first set of keys
		
		btfss RB4               ; test each normally high
		call volume_up          ; pin and call appropriate
		btfss RB5               ; routine if pin is low
		call bass_up
		btfss RB6
		call treble_up
		btfss RB7
		call select_right
sr_wait         btfss RB7
		goto sr_wait
		
		bsf RA0
		bcf RA1                 ; read second set of keys
		
		btfss RB4
		call volume_down
		btfss RB5
		call bass_down
		btfss RB6
		call treble_down
		btfss RB7
		call select_left
sl_wait         btfss RB7
		goto sl_wait
		bsf RA1

		movlw ms200             ; reload debouce register
		movwf debouce
		
		btfss PORTA, eq_flat_pin
		goto main

eq_flat         movlw 06h
		movwf bass
		movwf treble
		movlw bass
		movwf FSR
		call store
		movlw treble
		movwf FSR
		call store

		movlw lm_bass
		movwf lm_address
		movf bass, W
		movwf lm_data
		call transmit

		movlw lm_treble
		movwf lm_address
		movf treble, W
		movwf lm_data
		call transmit
		goto main

; *********** End of Main Program **********

; store the register pointed to by the file register in EE 
store           movf INDR, W
		movwf EEDATA
		movf FSR, W
		movwf EEADR
		call write_mem
		return

; restore the register pointed to by the file register from EE
restore                 
		movf FSR, W
		movwf EEADR
		call read_mem
		movf EEDATA, W
		movwf INDR
		return


volume_up       movf volume, F
		btfss STATUS, Z
		decf volume,F
		goto volume_end

volume_down     movlw lm_vol_min
		xorwf volume, W
		btfss STATUS, Z
		incf volume, F

volume_end      movlw volume
		movwf FSR
		call store
		
		movlw lm_left_vol
		movwf lm_address
		movf volume, W
		movwf lm_data
		call transmit

		movlw lm_right_vol
		movwf lm_address
		movf volume, W
		movwf lm_data
		call transmit

		return
	
bass_up         movlw lm_tone_max
		xorwf bass, W
		btfss STATUS, Z
		incf bass, F
		goto bass_end

bass_down       movf bass, F
		btfss STATUS, Z
		decf bass, F
		
bass_end        movlw bass
		movwf FSR
		call store
		
		movlw lm_bass
		movwf lm_address
		movf bass, W
		movwf lm_data
		call transmit
		return

treble_up       movlw lm_tone_max
		xorwf treble, W
		btfss STATUS, Z
		incf treble, F
		goto treble_end
		
treble_down     movf treble, F
		btfss STATUS, Z
		decf treble, F
		
treble_end      movlw treble
		movwf FSR
		call store
		
		movlw lm_treble
		movwf lm_address
		movf treble, W
		movwf lm_data
		call transmit
		return

select_left     movf input, F
		btfss STATUS, Z
		decf input, F
		goto select_end

select_right    movlw lm_select_max
		xorwf input, W
		btfss STATUS, Z
		incf input, F

select_end      movlw input
		movwf FSR
		call store
		
		movlw lm_input
		movwf lm_address
		movf input, W
		movwf lm_data
		call transmit
		return








mute_on_off     btfsc ir_flags, auto_repeat
		return
		movlw lm_mute_code      ; if the mute is on then
		xorwf input, W          ; turn it off
		btfss STATUS, Z
		goto  mute_on

mute_off        movf mute, W
		movwf input             ; input=mute
		goto mute_end
		
mute_on         movf input, W           ; else turn the mute on     
		movwf mute              ; mute=input
		movlw lm_mute_code      ; input=mute_code
		movwf input

mute_end        movlw input
		movwf FSR
		call store
		
		movlw mute
		movwf FSR
		call store
		
		movlw lm_input
		movwf lm_address
		movf input, W
		movwf lm_data
		call transmit
		return



















;******                 transmit a command to the LMC1983 ********
;                       lm_address holds the function address and
;                       lm_data holds the data on entry 

transmit        bcf PORTB, lm_id_pin    ; set id line low
		movlw 08h               ; 8 bits to transmit
		movwf lm_bits
lm_loop_01      bcf PORTB, lm_clk_pin   ; set clock line low
		bcf PORTB, lm_data_pin
		btfsc lm_address, 0     ; set up the data line   
		bsf PORTB, lm_data_pin
		bsf PORTB, lm_clk_pin   ; set clock high to latch data
		rrf lm_address          ; shift right
		decf lm_bits            ; decrease count
		btfss STATUS, Z         ; test for zero
		goto lm_loop_01         ; transmit next bit
		bsf PORTB, lm_id_pin    ; set id line high
		; now transmit the data
		movlw 08h               ; 8 bits to transmit
		movwf lm_bits
lm_loop_02      bcf PORTB, lm_clk_pin   ; set clock line low
		bcf PORTB, lm_data_pin
		btfsc lm_data, 0        ; set the data line up   
		bsf PORTB, lm_data_pin
		bsf PORTB, lm_clk_pin   ; set clock high to latch data
		rrf lm_data             ; shift right
		decf lm_bits            ; decrease count
		btfss STATUS, Z         ; test for zero
		goto lm_loop_02         ; transmit next bit
		bsf PORTB, lm_data_pin  ; make sure data line is high
		
		movlw 02h
		movwf delay01
lm_loop_03      decfsz delay01, F
		goto lm_loop_03         ; wait at least 6 uSecs
					; then send end of transmission pulse
 
		bcf PORTB, lm_id_pin    ; set id line low

		nop
		nop
		nop                     ; wait at least 3 uSecs
		nop
		nop

		bsf PORTB, lm_id_pin    ; id high ,, end of transmission pulse

		return
END
