                ;FREQ.ASM (PULSE.ASM) - PIC16F84 - Richard Hinckley
                ;Version 15 - 13/02/2000
    ; Amended by EPE JMB 19JAN01 for ":multiply error" line 856
    ; written in TASM

;To change for a 16 char x 2 line LCD, search for each instance of
;S1LINELCD and delete everything after that to E1LINELCD

;-----------------------GENERAL DEFINITIONS--------------------------
#DEFINE	PAGE0	bcf $03,5
#DEFINE	PAGE1	bsf $03,5

W:		.EQU	0
F:		.EQU	1
INDF:		.EQU	$00
TMRO:		.EQU	$01
OPTION:		.EQU	$01
PCL:		.EQU	$02
STATUS:		.EQU	$03
C:		.EQU	0
DC:		.EQU	1
Z:		.EQU	2
FSR:		.EQU	$04
PORTA:		.EQU	$05
TRISA:		.EQU	$05
PORTB:		.EQU	$06
TRISB:		.EQU	$06
EEDATA:		.EQU	$08
EECON1:		.EQU	$08
RD:		.EQU	0
WR:		.EQU	1
WREN:		.EQU	2
WRERR:		.EQU	3
EEIF:		.EQU	4
EEADR:		.EQU	$09
EECON2:		.EQU	$09
PCLATH:		.EQU	$0A
INTCON:		.EQU	$0B
;-----------INTERRUPTS------------------
RBIF:		.EQU	0
BUTIPFL:	.EQU	0
INTF:		.EQU	1
JIPFL:		.EQU	1
TOIF:		.EQU	2
TIMIPFL:	.EQU	2
RBIE:		.EQU	3
BUTIPEN:	.EQU	3
INTE:		.EQU	4
JIPEN:		.EQU	4
TOIE:		.EQU	5
TIMIPEN:	.EQU	5
EEIE:		.EQU	6
GIE:		.EQU	7
;-----------LCD DEFINITIONS-------------
V1:		.EQU	$0C
LCV:		.EQU	$0D
LCCLK:		.EQU	$0E
LCST		.EQU	$0F
LCRS:		.EQU	$20
LCPORTO:	.EQU	$05
LCPORTE:	.EQU	$06
LCRSPIN:	.EQU	4
LCEPIN:		.EQU	6
;-----------SPECIFIC DEFINITIONS--------
;----PORTA-PINS-----
MSAPIN:		.EQU	0		;O/P: Mark/Space "A" pin
MSBPIN:		.EQU	1		;O/P: Mark/Space "B" pin
SECPIN:		.EQU	2		;O/P: Pin controlling "1" second pulse for Freq measure
WPIN:		.EQU	3		;O/P: Pin controlling pulse width measurement
;----PORTB-PINS-----
JPIN:		.EQU	0		;I/P: Receives pulses from Counter
EOPPIN		.EQU	1		;I/P: Indicates end of pulse from "D" Flip-Flops
CAPEN		.EQU	2		;O/P: Pin switches on Cap measurement
RSTPIN:		.EQU	4		;O/P: Pin forces reset of Counter & "D" Flip-Flops
CPIN:		.EQU	5		;O/P: Pin controlling Counter "clocking"
BUTPIN:		.EQU	7		;I/P: Pin receiving pulses of the mode select Button
;-----------OTHER STORAGE--------------
MODE:		.EQU	$21		;Contains mode - 0=Freq, 1=Mark, 2=Space
FLAGS:		.EQU	$22		;Contains flags controlling program flow
SECEND:		.EQU	0		;0=1 second period incomplete, 1=complete
FTIME:		.EQU	1		;0=First-time-through of Timer interrupt, 1=not FTT
FJ:		.EQU	2		;0=FTT of Counter Complete, 1=not FTT
LONGDF:		.EQU	3		;1= Button pressed in LONGD subroutine

DP:		.EQU	$23		;Holds position of Decimal Point during output
FLAGS2:		.EQU	$2A		;Used in Capactor measure
CAL		.EQU	0
MSD:		.EQU	$24		;Now used as general work store
CARRY:		.EQU	$24		;Holds carry in multiple byte arithmetic
PWR2J:		.EQU	$25		;Power of 2 in the J register
PWR10:		.EQU	$26		;Power of 10 of BCD number in P or Q
OLDBUT:		.EQU	$27		;Copy of the last button setting
PWR2K:		.EQU	$28		;Power of 2 in the K register
PWR2L:		.EQU	$29		;Power of 2 in the L register

J0:		.EQU	$31		
J1:		.EQU	$32		
J2:		.EQU	$33		
J3:		.EQU	$34		
J4:		.EQU	$35		

K0:		.EQU	$36
K1:		.EQU	$38
K2:		.EQU	$3A
K3:		.EQU	$3C
K4:		.EQU	$3E

L0:		.EQU	$37
L1:		.EQU	$39
L2:		.EQU	$3B
L3:		.EQU	$3D
L4:		.EQU	$3F

P0:		.EQU	$36		
P1:		.EQU	$38		
P2:		.EQU	$3A		
P3:		.EQU	$3C		
P4:		.EQU	$3E		
P5:		.EQU	$40		
P6:		.EQU	$42		
P7:		.EQU	$44		
P8:		.EQU	$46		
P9:		.EQU	$48		
P10:		.EQU	$4A		
P11:		.EQU	$4C		
P12:		.EQU	$4E		

Q0:		.EQU	$37		
Q1:		.EQU	$39		
Q2:		.EQU	$3B		
Q3:		.EQU	$3D		
Q4:		.EQU	$3F		
Q5:		.EQU	$41		
Q6:		.EQU	$43		
Q7:		.EQU	$45		
Q8:		.EQU	$47		
Q9		.EQU	$49		
Q10:		.EQU	$4B		
Q11:		.EQU	$4D
Q12:		.EQU	$4F

;-----------PROGRAM--------------------
		.ORG	$0004
		goto	ISR
		.ORG	$0005

		clrf	PORTA		;put PORTA into a defined state
		clrf	PORTB		;put PORTB into a defined state
		PAGE1
		clrf	TRISA		;set PORTA as outputs
		movlw 	%10000011	;set PORTB pins 0,1,7 as I/P, Qt as O/P
		movwf	TRISB		;store in PORTB
		movlw	%10000100	;set RBO/INT falling edge, Prescaler to 32
		movwf	OPTION		;store in OPTION
		PAGE0
		GOTO	SETUP

LCTABLE:	addwf PCL,F		;LCD initialisation table
        	retlw %00110011 	;initialise lcd - first byte
        	retlw %00110011 	;2nd byte (repeat of first)
        	retlw %00110010 	;set for 4-bit operation
        	retlw %00100100 	;set for 1 line
        	retlw %00000110 	;set entry mode to increment each Address
        	retlw %00001100 	;set display on, cursor off, blink off
        	retlw %00000001 	;clear display
        	retlw %00000010 	;return home, cursor & RAM to zero
                        		;end initialisation table

MSGTABLE	addwf	PCL,F
		goto	FREQMES
		goto	FRELMES
		goto	PERDMES
		goto	MARKMES
		goto	SPACMES
		goto	CAPMES
		goto	CALMES
FREQMES:	
		decf	V1,W
		addwf	PCL,F		;Frequency High message
		retlw	' '
		retlw	')'
		retlw	'H'
		retlw	'('
		retlw	'F'

FRELMES:	
		decf	V1,W
		addwf	PCL,F		;Frequency Low message
		retlw	' '
		retlw	')'
		retlw	'L'
		retlw	'('
		retlw	'F'

PERDMES:	
		decf	V1,W
		addwf	PCL,F		;Period message
		retlw	' '
		retlw	'D'
		retlw	'R'
		retlw	'E'
		retlw	'P'

MARKMES:	
		decf	V1,W
		addwf	PCL,F		;Mark message
		retlw	' '
		retlw	'K'
		retlw	'R'
		retlw	'A'
		retlw	'M'

SPACMES:	
		decf	V1,W
		addwf	PCL,F		;Space message
		retlw	' '
		retlw	'E'
		retlw	'C'
		retlw	'P'
		retlw	'S'

CAPMES:	
		decf	V1,W
		addwf	PCL,F		;Capacitance message
		retlw	' '
		retlw	' '
		retlw	'P'
		retlw	'A'
		retlw	'C'
CALMES:	
		decf	V1,W
		addwf	PCL,F		;Start of capaitance calibration message
		retlw	'R'
		retlw	'E'
		retlw	'S'
		retlw	'N'
		retlw	'I'

MODESW1:	movf	MODE,W		;Controls mode switch on mode button press				
		addwf	PCL,F
		retlw	1
		retlw	2
		retlw	3
		retlw	4
		retlw	5
		retlw	0
		retlw	6

MODE1:		movf	MODE,W		;Directs flow of control for each function
		addwf	PCL,F
		goto	FREQ1
		goto	FREQL1
		goto	PERD1
		goto	MARK1
		goto	SPACE1
		goto	CAP1
		goto	CAL1

MODE2:		movf	MODE,W		;As MODE1 but used in different places
		addwf	PCL,F
		goto	FREQ1
		goto	FREQL2
		goto	TCNT6
		goto	TCNT6
		goto	TCNT6
		goto	CAP2
		goto	CAL2
ADJTABLE:
		movf	PWR10,W		;Effectively divides PWR10 by 3 -
		addwf	PCL,F		;saves space in units tables
		retlw	0
		retlw	0
		retlw	0
		retlw	1
		retlw	1
		retlw	1
		retlw	2
		retlw	2
		retlw	2
		retlw	3
		retlw	3
		retlw	3
		retlw	3
		
DPTABLE:	movf	PWR10,W
		addwf	PCL,F		;Table to give the decimal point location
		retlw	1
		retlw	2
		retlw	3
		retlw	1
		retlw	2
		retlw	3
		retlw	1
		retlw	2
		retlw	3
		retlw	1
		retlw	2
		retlw	3
		retlw	4

FUTABLE:	addwf	PCL,F		;Selects Frequency Units
		retlw 	' '
		retlw	'K'
		retlw	'M'
		retlw 	'G'

PUTABLE:	addwf	PCL,F		;Selects Time Period Units
		retlw 	'n'
		retlw	%11100100
		retlw	'm'
		retlw	' '

CAPTABLE:	addwf	PCL,F		;Selects Capacitance Units
		retlw 	'p'
		retlw 	'n'
		retlw	%11100100
		retlw	'm'

SETUP:		call	LCPAUSE		;Initialisation delay
		clrf	OLDBUT
		clrf	MODE
;--INITIALISE LCD-------------
LCSET:		clrf	V1	
		clrf	LCRS
LCSET1:		movf	V1,W
		call 	LCTABLE
		call	LCOUT
		incf	V1,F
		btfss	V1,3
		goto	LCSET1
		call 	LCPAUSE
;--START OF MAIN PROGRAM-------------
START:
		clrf	INTCON		;clear all interrupts
		bcf	PORTB,CAPEN		
		bsf	PORTB,RSTPIN
		call	LCRESET		
		call	MSGOUT		
		goto	MODE1
;--FREQUENCY MEASURE----------
FREQ1:		
		call	CLRJ		
	 	clrf	FLAGS		;Set all flags to zero
		movlw	240
		movwf	TMRO		;Set TIMER
		bcf	PORTA,WPIN	;block pulse width measurement
		bsf	PORTB,CPIN	;enable NAND to counter
		bcf	PORTA,SECPIN	;ensure freq enable pin is disabled
		bcf	PORTB,RSTPIN	
		bcf	INTCON,JIPEN	;disable counter interrupts
		bcf	INTCON,JIPFL	;clear Counter i/p flag
		bcf	INTCON,TIMIPFL	;clear TIMER i/p flag
		bsf	INTCON,TIMIPEN	;set TIMER i/p enable
		bsf	INTCON,GIE	;enable interrupts
FCNT1:	
		btfss	PORTB,BUTPIN	;is BUTTON pin set?
		goto	FCNT2		;no, goto see if 1 second has passed
		btfsc	OLDBUT,0	;yes, is it the same as last time
		goto	FCNT3		;old setting also 1
		bsf	OLDBUT,0	;old setting 0, set old to 1
		bcf	INTCON,GIE	;disable interrupts
		goto	BUT

FCNT2:		bcf	OLDBUT,0
FCNT3:		btfss	FLAGS,SECEND	;Is 1 second period complete?
		goto	FCNT4		;no, goto test counter output
		bcf	INTCON,GIE	;yes, disable interrupts
		btfsc	FLAGS,FJ	;is this the first time through?
		goto	FCNT5		;no, goto FREQOUT
		bsf	FLAGS,FJ	;yes, set FJ flag and fall through 
FCNT4:		
		call	JCNT
		goto	FCNT1		;go round loop

FCNT5:	
		call	GETJ		;clock the Counter into J0 & 1
		bsf	PORTB,RSTPIN	;put h/w into reset
		call	RNLJ		;normalise J left
FOUT:
		call	CFRA
		call	DPTABLE
		movwf	DP
		call	QOUT
		call	ADJTABLE
		call	FUTABLE		;get units from table
		call	LCOUT
		movlw	'H'
		call	LCOUT
		movlw	'z'
		call	LCOUT
		goto	MODE1
;-----------------------------------
FREQL1:		
		bcf	PORTA,MSAPIN	;yes, set pins for Period
		bcf	PORTA,MSBPIN
		goto	TCNT0

FREQL2:		
		movlw	$98
		movwf	L4
		movlw	$96
		movwf	L3
		movlw	$80
		movwf	L2
		clrf	L1
		clrf	L0
		movlw	242
		movwf	PWR2L
		call	DIVLJ
		call	LONGD
		btfsc	FLAGS,LONGDF
		goto	BUT
		goto	FOUT
;--------------------------------------
PERD1:		
		bsf	PORTB,RSTPIN
		bcf	PORTA,MSAPIN	;set pins for Period
		bcf	PORTA,MSBPIN
TCNT0:
		call 	CLRJ 
	 	clrf	FLAGS		;Set all flags to zero

		bcf	PORTA,SECPIN	;block frequency measurement
		bsf	PORTA,WPIN	;enable pulse width measurement
		bcf	INTCON,GIE	;ensure all interrupts disabled
		bsf	PORTB,CPIN	;enable NAND to counter
		bcf	PORTB,RSTPIN	;clear reset to start measurement
		bcf	INTCON,JIPFL	;clear Counter interrupt flag
		
TCNT1:	
		btfss	PORTB,BUTPIN	;is BUTTON pin set?
		goto	TCNT2		;no, goto see if pulse has finished
		btfsc	OLDBUT,0	;yes, is it the same as last time
		goto	TCNT3		;old setting also 1
		bsf	OLDBUT,0	;old setting 0, set old to 1
		goto	BUT

TCNT2:		bcf	OLDBUT,0
TCNT3:
		btfss	PORTB,EOPPIN	;Has pulse to be measured ended?
		goto	TCNT4		;no, goto test counter output
		btfsc	FLAGS,FJ	;is this the first time through?
		goto	TCNT5		;no, goto PERDOUT
		bsf	FLAGS,FJ	;yes, set FJ flag & fall through 
TCNT4:
		call	JCNT
		goto	TCNT1
TCNT5:	
		call	GETJ		;clock the Counter into J0 & 1
		bsf	PORTB,RSTPIN	;put h/w into reset

		goto	MODE2		;switch direction according to MODE		
TCNT6:
		call	CLRK		;multiply by 25 for ns
		clrf	PWR2K
		movlw	$19
		movwf	K0
		call	KXJ
		call	MOVLJ
TOUT:		
		call	RNLJ		;Reverse normalise J
		call	CFRA		;Convert to BCD
		call	DPTABLE
		movwf	DP
		call	QOUT
		call	ADJTABLE
		call	PUTABLE		;get units from table
		call	LCOUT
		movlw	'S'
		call	LCOUT
		call	LONGD
		btfsc	FLAGS,LONGDF
		goto	BUT
		goto	MODE1		;and jump without clearing the display
;-----------------------------------
MARK1:
		bcf	PORTA,MSAPIN	;yes, set pins for Mark
		bsf	PORTA,MSBPIN
		goto	TCNT0
;-------------------------------------
SPACE1:
		bsf	PORTA,MSAPIN	;yes, set pins for Space
		bcf	PORTA,MSBPIN
		goto	TCNT0
;-------------------------------------
CAP1:
		bsf	PORTB,CAPEN	
		call	LCPAUSE		;short pause
		goto	PERD1
CAP2:
		bcf	PORTB,CAPEN
		call	MOVJL		;save J in L
		call	CLRK
		clrf	PWR2K

		clrw
		call	RPROM		;get N1 from EEPROM
		movwf	K0
		movlw	1
		call	RPROM		;and subtract
		movwf	K1
		call	SUBLK
		call	MOVLJ

		call	CLRK		;multiply by 680
		clrf	PWR2K
		movlw	$A8
		movwf	K0
		movlw	$02
		movwf	K1
		call	KXJ
		call	MOVLJ
		call	NLJ
		call	MOVJL

		call	CLRJ		;get N2-N1 from EEPROM
		clrf	PWR2J
		movlw	2
		call	RPROM
		movwf	J0
		movlw	3
		call	RPROM
		movwf	J1
		call	DIVLJ		;divide
COUT:
		call	CFRA

		movf	PWR10,W		;ensure PWR10 is in 
		andlw	%11110000	;range 0 - 8
		btfss	STATUS,Z
		goto	COUT1
		movf	PWR10,W		
		sublw	8		
		btfsc	STATUS,C
		goto	COUT2
COUT1:
		call	CLRQ
		clrf	PWR10
COUT2:
		call	DPTABLE
		movwf	DP
		call	QOUT
		call	ADJTABLE
		call	CAPTABLE	;get units from table
		call	LCOUT
		movlw	'F'
		call	LCOUT
		movlw	' '
		call	LCOUT
		bcf	PORTB,CAPEN
		call	LONGD
		btfsc	FLAGS,LONGDF
		goto	BUT
		goto	MODE1
;-------------------------------------
CAL1:
		bcf	FLAGS2,FTIME
		bsf	PORTB,CAPEN
		call	LCPAUSE		;short pause
		goto	PERD1		;Measure period for N1
CAL2:
		btfsc	FLAGS2,FTIME
		goto	CAL4

		bsf	FLAGS2,FTIME
		movlw	0		;store (N1) J0 & J1 in EEPROM
		movwf	EEADR
		movf	J0,W
		call	WPROM
		movlw	1
		movwf	EEADR
		movf	J1,W
		call	WPROM

		call	MOVJK		;move N1 to K0 & K1
		movlw	'T'		
		call	LCOUT
		movlw	' '		
		call	LCOUT
		movlw	'6'		
		call	LCOUT

;*********************************S1LINELCD************
		call	CHLCDADDR	;set my LCD address
;*********************************E1LINELCD************

		movlw	'8'		
		call	LCOUT
		movlw	'0'		
		call	LCOUT
		movlw	'p'		
		call	LCOUT
		movlw	'F'		
		call	LCOUT
		movlw	' '		
		call	LCOUT
		movlw	'C'		
		call	LCOUT
		movlw	'A'		
		call	LCOUT
		movlw	'P'		
		call	LCOUT
CAL2A:
		btfsc	PORTB,BUTPIN
		goto	CAL2A
		call	LCPAUSE		;debounce button
		call	LCPAUSE		;debounce button
		call	LCPAUSE		;debounce button
CAL3:
		btfss	PORTB,BUTPIN
		goto	CAL3
		call	LCPAUSE		;debounce button
		call	LCPAUSE		;debounce button
		call	LCPAUSE		;debounce button
CAL3A:
		btfsc	PORTB,BUTPIN
		goto	CAL3A
		call	LCPAUSE		;debounce button
		call	LCPAUSE		;debounce button
		call	LCPAUSE		;debounce button
		
		goto	PERD1		;Measure new period (N2)
CAL4:
		bcf	FLAGS,FTIME
		call	MOVJL		;move J (N2) to L
		call	SUBLK		;N2 - N1, result in L

		movlw	2		;store (N2 - N1) in EEPROM
		movwf	EEADR
		movf	L0,W
		call	WPROM
		movlw	3
		movwf	EEADR
		movf	L1,W
		call	WPROM

		movlw	5		;Go to Capacitance Measure
		movwf	MODE
		goto	START
;-----------SUBROUTINES-------------
;This s/r reads 1 byte of EEPROM from address given in W 
RPROM:
		movwf	EEADR
		PAGE1
		bsf	EECON1,RD
		PAGE0
		movf	EEDATA,W
		return
;-----------------------------------
;This s/r writes 1 byte to EEPROM from W
WPROM:
		movwf	EEDATA
		PAGE1
		bsf	EECON1,WREN
		movlw	$55
		movwf	EECON2
		movlw	$AA
		movwf	EECON2
		bsf	EECON1,WR
WPROM1:
		btfsc	EECON1,WR
		goto	WPROM1
		bcf	EECON1,WREN
		bcf	EECON1,EEIF		
		PAGE0
		bcf	INTCON,EEIE
		return
;-----------------------------------
;Interrupt service routine to time 1 second
ISR:		
		movwf	LCST		;save W in available Store
		movf	STATUS,W	;save STATUS
		movwf	MSD		;in available store
		btfss	FLAGS,FTIME	;is this the first time through
		goto	ISRFT		;yes, got to ISRFT
		decfsz 	V1,F		;decrement time loop variable
		goto	ISRRET		;goto return sequence
		bsf	FLAGS,SECEND	;set flag showing end of 1 sec period
		bcf	PORTA,SECPIN	;disable Frequency NAND gate

ISRRET:
		movf	MSD,W		
		movwf	STATUS
		movf	LCST,W
		bcf	INTCON,TIMIPFL	;no, clear TIMER i/p flag
		retfie			;return

ISRFT:
		movlw	100		;set up loop for 1 sec = 3.2768MHz/
		movwf	V1		;4*32*256*100
		bsf	PORTA,SECPIN	;enable FREQ NAND gate
		bsf	FLAGS,FTIME	;set First-time-through flag
		goto	ISRRET

;-----------------------------------
;Subroutine to clock the counter into J0 & 1 
GETJ:		bcf	INTCON,JIPFL	;clear Counter interrupt flag
		clrf	J0		;clear J0
		clrf	J1		;clear J1
		movlw	4		;put 4 into W
GETJ1:		
		btfsc	INTCON,JIPFL	;Has Counter overflowed?
		goto	GETJ2		;yes, goto final part
		bcf	PORTB,CPIN	;yes, toggle Counter
		bsf	PORTB,CPIN
		incfsz	J0,F		;increment J0 - test if zero
		goto	GETJ1		;no, go round loop again
		incf	J1,F		;zero, increment J1
		btfss	J1,6		;has J1 overflowed?
		goto	GETJ1
GETJ2:
		comf	J0,F		;subtract counters from zero
		comf	J1,F		;by complementing
		incfsz	J0,F		;and add one
		goto	GETJ3
		incf	J1,F
GETJ3:
		addlw	0		;shift J0,J1
		rlf	J0,F		;up 2 bits
		rlf	J1,F
		addlw	0
		rlf	J0,F
		rlf	J1,F
		clrf	PWR2J
		call	SRJ		;shift down because top 
		call	SRJ		;2 bits of Counter don't exist
		return			
;-----------------------------
BUT:
		movlw	35
		movwf	V1
BUT1:
		call	LCPAUSE		;test if button is pressed for a long time
		btfss	PORTB,BUTPIN
		goto	BUT2
		decfsz	V1,F
		goto	BUT1
		movlw	6
		goto	BUT3
BUT2:
		call	MODESW1
BUT3:
		movwf	MODE
		goto	START
;-----------------------------
JCNT:
		btfss	INTCON,JIPFL	;test if Counter has interrupted
		return			;no, go round loop
		bcf	INTCON,JIPFL	;yes, clear Counter interrupt flag
		incfsz 	J2,F		;and increment J2, test if zero
		return			;no, go round loop
		incfsz 	J3,F		;yes,	increment J3, test if zero
		return			;no, go round loop
		incfsz 	J4,F		;yes, increment J4, test if zero
		return			;no, go round loop
		movlw	'O'		;yes, overflow error
		bsf	LCRS,LCRSPIN	;set RS for data output
		call	LCOUT		;output 'O' on LCD
		return			;go round loop
;-----------------------------
LCRESET:
		clrf	LCRS		;set command mode
		movlw	%00000001	;clear display
		call	LCOUT
		movlw	%00000010	;return home, cursor & ram to zero
		call	LCOUT
		call	LCPAUSE		;provide LCD delay
		return
;-----------------------------
;This s/r outputs 1 character to the LCD
LCOUT: 		movwf	LCST		;temp store data
        	movlw 	32		;set minimum time between sending full bytes to
        	movwf 	LCV		;LCD - value of 32 seems OK for this prog with
LCDELAY:	decfsz 	LCV,F		;PIC clk of 3.2768MHz and prescaler set to 32
        	goto 	LCDELAY		;keep decrementing LCV until zero
        	call 	LCSEND		;send MSB
        	call 	LCSEND		;send LSB
        	return

LCSEND:		swapf 	LCST,F		;swap data nibbles
        	movf 	LCST,W		;get data byte
        	andlw 	15		;get nibble from byte (LSB)
        	iorwf 	LCRS,W 		;OR the RS bit
        	movwf 	LCPORTO		;output the byte
        	bsf 	LCPORTE,LCEPIN	;set E line high
        	nop
		bcf  	LCPORTE,LCEPIN	;set E line low
        	return
;-----------------------------
LCPAUSE: 	movlw	5		;at 10ms per timer overflow then
		movwf	LCV		;this gives a 50ms delay i.e.>15ms
		clrf	TMRO		;
        	bcf 	INTCON,TIMIPFL	;clear interupt flag
LCPAUSE1:				
        	btfss 	INTCON,TIMIPFL	;has a timer time-out been detected?
        	goto 	LCPAUSE1	;no
        	bcf 	INTCON,TIMIPFL	;yes
        	decfsz 	LCV,F		;dec counter, is it zero?
        	goto 	LCPAUSE1	;no
        	return			;yes
;-----------------------------
;This s/r gives a long delay of 1 second
LONGD:
		movlw	20		;at 50ms per LCPAUSE
		movwf	V1		;this gives a 1 second delay
LONGD1:
		call	LCPAUSE
		btfss	PORTB,BUTPIN	;is BUTTON pin set?
		goto 	LONGD2
		bsf	FLAGS,LONGDF
		return
LONGD2:
		decfsz	V1,F
		goto	LONGD1
		return
;-----------------------------
;This s/r converts the left justified normalised fraction i.ffff..
;in J to EBCD in Q.

;Clear P & Q, put 1 in P0 and clear PWR10
;If PWR2J is zero, goto conversion
;If PWR2J is -ve, divide P by 2 PWR2J times, go to conversion
;If PWR2J is +ve, go to multiply
CFRA:

		call	CLRP
		call	CLRQ
		clrf	PWR10
		movf	J0,W		;If J is zero return immediately
		iorwf	J1,W
		iorwf	J2,W
		iorwf	J3,W
		iorwf	J4,W
		btfsc	STATUS,Z
		return

		incf	P0,F		;put 1 in P0
		movf	PWR2J,W
		btfsc	STATUS,Z
		goto	CFRA4A		;PWR2J is zero, goto Conversion
		btfss	PWR2J,7
		goto	CFRA3		;PWR2J is +ve, goto Multiply

		comf	PWR2J,F		;Make PWR2J positive
		incf	PWR2J,F		
		clrf	P0		;clear P0
		incf	P12,F		;Put 1 in P12
CFRA1:		
		call	PD2		;Divide P by 2 - PWR2J times
		decfsz	PWR2J,F
		goto	CFRA1
		goto	CFRA5

;Multiply. Clear 1 in P11. Put 1 in P0, Multiply P by 2 PWR2J times
;Then shift P left so MSD in P11, decrementing PWR10 each shift

CFRA3:                                  ;:Multiply P 
		call	PX2
		decfsz	PWR2J,F
		goto	CFRA3
CFRA4A:
		movlw	12
		movwf	PWR10
CFRA4:					;shift P left so MSD in P11
		movf	P11,W		;test for P11 non zero
		btfss	STATUS,Z
		goto	CFRA5
		call	SLP
		decfsz	PWR10,F
		goto	CFRA4
					;shouldn't arrive here!

;Conversion A loop is set up. Each time J is shifted left 
;and Carry tested. If set P is added to Q. P is then divided by 2
;If PWR10 is zero (i.e no is i.ffff) then no normalisation required
;If non-zero and Q12 is also zero then Q is shifted left 1 place
;and PWR10 decremented accordingly

CFRA5:
		movlw	40
		movwf	V1
CFRA6:		
		call	SLJ
		btfsc	STATUS,C
		call	ADDPQ
		call	PD2
		decfsz	V1,F
		goto	CFRA6
CFRA6A:
		movf	PWR10,F		;test PWR10
		btfsc	STATUS,Z
		return			;zero, no normalisation
CFRA6B:
		movf	Q12,F		;not zero, test Q12 for
		btfss	STATUS,Z	;leading zero
		return
		call	SLQ		;zero shift Q left one place
		decf	PWR10,F
		goto	CFRA6B		
		return
;----------------------------------
;This S/R adds P to Q in extended BCD
ADDPQ:		
		movlw	13		;load size of P & Q
		movwf	LCV		;and store in loop counter
		movlw	P0		;load addr. of P0
		movwf	FSR		;and store in FSR
		movlw	6		;put first P test value in W

ADDPQ1:		addwf	INDF,W		;add ind addr P to W
		incf	FSR,F		;point at corresponding Q
		addwf	INDF,F		;and add W into Q
		btfss	INDF,4		;is Q>15
		goto	ADDPQ2		;no, goto ADDPQ2
		bcf	INDF,4		;yes, clear bit 4
		movlw	7		;make next P test value 7
		goto	ADDPQ3

ADDPQ2:		movlw	6
		subwf	INDF,F		;subtract 6 as not needed
ADDPQ3:		incf	FSR,F		;point to next P
		decfsz 	LCV,F		;is addition complete?
		goto	ADDPQ1		;no, go round loop
		return			;yes, return
;-----------------------------
;This S/R mmultiplies P by 2 by adding it to itself
PX2:
		movlw	13		;load size of P
		movwf	LCV		;and store in loop counter
		movlw	P0		;load addr. of P0
		movwf	FSR		;and store in FSR
		movlw	6		;put first P test value in W

PX21:		addwf	INDF,W		;add ind. addr. P to W
		addwf	INDF,F		;add it to the same P
		btfss	INDF,4		;is P>15?
		goto	PX22		;no, goto PX22
		bcf	INDF,4		;yes, clear bit 4
		movlw	7		;make the next P test 7
		goto	PX23	

PX22:		movlw	6
		subwf	INDF,F		;subtract 6 as not needed
PX23:		incf	FSR,F		;increment FSR
		incf	FSR,F		;twice to next P
		decfsz 	LCV,F		;is addition complete?
		goto	PX21		;no, go round loop
		return			;yes, return
;------------------------------
;This s/r divides P by 2
PD2:
		movlw	13
		movwf	LCV
		movlw	P12
		movwf	FSR
		addlw	0
PD21:		
		movlw	0
		btfsc	STATUS,C
		movlw	10
		addwf	INDF,F
		addlw	0		;clear Carry
		rrf	INDF,F
		decf	FSR,F
		decf	FSR,F
		decfsz	LCV,F
		goto	PD21
		return
;--------------------------------;-----------------------------
;This subroutine outputs the 6 most significant digits
;from Q, with Decimal Point
QOUT:	
		clrf	LCRS		;set LCRS for command
		movlw	%10000101	;set address 5
		call	LCOUT
		call	LCPAUSE		;provide LCD delay
		bsf	LCRS,LCRSPIN	;set LCRS for data

;*********************************S1LINELCD************
		movlw	3		;Set up variable for LCD address
		movwf	MSD		;control
;*********************************E1LINELCD************

		movlw	Q12
		movwf	FSR
		movlw	6
		movwf	V1
QOUT1:		
		movf	DP,F
		btfss	STATUS,Z
		goto	QOUT2
		movlw	'.'
		call	LCOUT

;*********************************S1LINELCD************
		call	TLCDADDR
;*********************************E1LINELCD************
QOUT2:
		movf	INDF,W
		addlw	$30
		call	LCOUT

;*********************************S1LINELCD************
		call	TLCDADDR
;*********************************E1LINELCD************

		decf	DP,F
		decf	FSR,F
		decf	FSR,F
		decfsz	V1,F
		goto	QOUT1
		movlw	' '
		call	LCOUT
		return
;*********************************S1LINELCD************
;-------------------------------
;This s/r tests whether the address should be changed for my 1 line LCD
;and if so changes it (address goes to 40 after first 8 chars o/p)

TLCDADDR:	decfsz	MSD,F
		return

CHLCDADDR:	clrf	LCRS
		movlw	%11000000	;set address to hex 40
		call	LCOUT
		call	LCPAUSE
		bsf	LCRS,LCRSPIN
		return
;*********************************E1LINELCD************
;-------------------------------
;This s/r divides the frequency of the measurement crystal (40MHz) in L
;by the contents of register J, putting the answer in J
;This is in normalised form of i.fffff.. with binary power in PWR2J,
;left justified in J

DIVLJ:
;First test J for zero & exit if so 
;copy J to K, put normalised 40M in L, clear J

		movf	J0,W
		iorwf	J1,W
		iorwf	J2,W
		iorwf	J3,W
		iorwf	J4,W
		btfsc	STATUS,Z	
		return		

		call	MOVJK
		call	CLRJ
		call	NLK		;normalise K left
		movf	PWR2K,W
		subwf	PWR2L,W
		movwf	PWR2J
;subtract K from L. If not negative set J0b1.
;if negative add back
;shift J left and K right and repeat another 39 times
		movlw	39
		movwf	V1
DIVLJ2:
		call	SUBLK		;subtract K from L
		bsf	J0,0
		movf	L0,W
		iorwf	L1,W
		iorwf	L2,W
		iorwf	L3,W
		iorwf	L4,W
		btfss	STATUS,Z
		goto	DIVLJ3B
		
DIVLJ3A:		
		call	SLJ		;dividend is zero
		decfsz	V1,F
		goto	DIVLJ3A
		goto	DIVLJ6		
DIVLJ3B:
		btfss	CARRY,0
		goto	DIVLJ5		;CARRY not set, leave J0,0 set, skip add

		bcf	J0,0
		call	ADDLK		;CARRY set, unset J0,0, add back		
DIVLJ5:		
		call	SRK
		call	SLJ
		decfsz	V1,F
		goto	DIVLJ2
DIVLJ6:
		btfsc	J4,7
		return
		call	SLJ		;normalise J left if necessary
		decf	PWR2J,F
		return
;-------------------------------
;This s/r clears the J register
CLRJ:		
		clrf	J0
		clrf	J1
		clrf	J2
		clrf	J3
		clrf	J4
		return
;-------------------------------
;This s/r clears the K register
CLRK:		
		clrf	K0
		clrf	K1
		clrf	K2
		clrf	K3
		clrf	K4
		return
;-------------------------------
;This s/r clears the L register
CLRL:		
		clrf	L0
		clrf	L1
		clrf	L2
		clrf	L3
		clrf	L4
		return
;-------------------------------
;This s/r shifts the J register right 1 bit
SRJ:
		addlw	$00		;clear Carry flag
		rrf	J4,F		;rotate J4
		rrf	J3,F		;through J3,2,1
		rrf	J2,F		;to J0
		rrf	J1,F
		rrf	J0,F
		return
;------------------------------
;This s/r shifts the J register left 1 bit
SLJ:
		addlw	$00		;clear Carry flag
		rlf	J0,F		;rotate J0
		rlf	J1,F		;through J1,2,3
		rlf	J2,F		;to J4
		rlf	J3,F
		rlf	J4,F
		return
;------------------------------
;This s/r shifts the K register right 1 bit
SRK:
		addlw	$00		;clear Carry flag
		rrf	K4,F		;rotate K4
		rrf	K3,F		;through K3,2,1
		rrf	K2,F		;to K0
		rrf	K1,F
		rrf	K0,F
		return
;------------------------------
;This s/r shifts the K register left 1 bit
SLK:
		addlw	$00		;clear Carry flag
		rlf	K0,F		;rotate K0
		rlf	K1,F		;through K1,2,3
		rlf	K2,F		;to K4
		rlf	K3,F
		rlf	K4,F
		return
;------------------------------
;This s/r shifts the Q register left 1 byte
SLQ:
		movlw	Q12
		movwf	FSR
		movlw	12		
		movwf	LCV
SLQ1:		decf	FSR,F
		decf	FSR,F
		movf	INDF,W
		incf	FSR,F
		incf	FSR,F
		movwf	INDF
		decf	FSR,F
		decf	FSR,F
		decfsz	LCV,F
		goto	SLQ1
		clrf	INDF
		return
;------------------------------
;This s/r shifts the Q register right 1 byte
SRQ:
		movlw	Q0
		movwf	FSR
		movlw	12		
		movwf	LCV
SRQ1:		incf	FSR,F
		incf	FSR,F
		movf	INDF,W
		decf	FSR,F
		decf	FSR,F
		movwf	INDF
		incf	FSR,F
		incf	FSR,F
		decfsz	LCV,F
		goto	SRQ1
		clrf	INDF
		return
;------------------------------
;This s/r shifts the P register left 1 byte
SLP:
		movlw	P12
		movwf	FSR
		movlw	12		
		movwf	LCV
SLP1:		decf	FSR,F
		decf	FSR,F
		movf	INDF,W
		incf	FSR,F
		incf	FSR,F
		movwf	INDF
		decf	FSR,F
		decf	FSR,F
		decfsz	LCV,F
		goto	SLP1
		clrf	INDF
		return
;------------------------------
;This s/r rotates the P register right 1 byte
SRP:
		movlw	P0
		movwf	FSR
		movlw	12		
		movwf	LCV
SRP1:		incf	FSR,F
		incf	FSR,F
		movf	INDF,W
		decf	FSR,F
		decf	FSR,F
		movwf	INDF
		incf	FSR,F
		incf	FSR,F
		decfsz	LCV,F
		goto	SRP1
		clrf	INDF
		return
;------------------------------
;This s/r clears the P register
CLRP:
		movlw	P0
		movwf	FSR
		movlw	13		
		movwf	LCV
CLRP1:		clrf	INDF
		incf	FSR,F
		incf	FSR,F
		decfsz	LCV,F
		goto	CLRP1
		return
;------------------------------
;This s/r clears the Q register
CLRQ:
		movlw	Q0
		movwf	FSR
		movlw	13		
		movwf	LCV
CLRQ1:		clrf	INDF
		incf	FSR,F
		incf	FSR,F
		decfsz	LCV,F
		goto	CLRQ1
		return
;------------------------------
;This s/r outputs the mode message to the LCD

MSGOUT:
		movlw	$05		;set loop to message length
		movwf	V1		;and store in loop counter
		bsf	LCRS,LCRSPIN	;set RS for data send
MSGOUT1:	
		movf	MODE,W
		call	MSGTABLE
		call	LCOUT		;output character
		decfsz 	V1,F		;decrement counter & test if zero
		goto	MSGOUT1		;no, go round loop again
		return
;------------------------------
;This s/r normalises left the binary K register
NLK:
		movlw	39
		movwf	V1
		
NLK1:		
		btfsc	K4,7
		return
		call	SLK
		decf	PWR2K,F
		decfsz	V1,F
		goto	NLK1
		return
;------------------------------
;This s/r normalises left the binary J register
NLJ:
		movlw	39
		movwf	V1
		
NLJ1:		btfsc	J4,7
		return
		call	SLJ
		decf	PWR2J,F
		decfsz	V1,F
		goto	NLJ1
		return
;------------------------------
;This s/r normalises right the binary J register
NRJ:
		movlw	39
		movwf	V1
		
NRJ1:		btfsc	J0,0
		return
		call	SRJ
		incf	PWR2J,F
		decfsz	V1,F
		goto	NRJ1
		return
;------------------------------
;This s/r reverse normalises left the binary J register
RNLJ:
		call	NLJ
		movlw	39
		addwf	PWR2J,F
		return
;------------------------------
;This s/r subtracts binary K register from L register
SUBLK:
		movlw	5
		movwf	LCV
		movlw	K0
		movwf	FSR
		clrf	CARRY
SUBLK1:	
		movf	CARRY,W
		addwf	INDF,W
		clrf	CARRY
		btfsc	STATUS,C
		bsf	CARRY,0	
		incf	FSR,F
		subwf	INDF,F
		btfss	STATUS,C
		bsf	CARRY,0
		incf	FSR,F
		decfsz	LCV,F
		goto	SUBLK1
		return
;------------------------------
;This s/r adds binary K register to L register
ADDLK:
		movlw	5		;CARRY set, unset J0,0, SRJ, add back
		movwf	LCV		;add
		movlw	K0
		movwf	FSR
		clrf	CARRY
ADDLK1:	
		movf	CARRY,W
		addwf	INDF,W
		clrf	CARRY
		btfsc	STATUS,C
		bsf	CARRY,0	
		incf	FSR,F
		addwf	INDF,F
		btfsc	STATUS,C
		bsf	CARRY,0
		incf	FSR,F
		decfsz	LCV,F
		goto	ADDLK1
		return
;----------------------------------
;This s/r multiplies the binary multiplicand in register K with the multiplier
;in binary register J, leaving the result in binary register L, and J zero
;This routine does not detect overflow of the K or L registers.

KXJ:		
		call	CLRL		;clear L
		call	NRK		;right normalise K
		movf	PWR2J,W
		addwf	PWR2K,W		;put new power of 2 in PWR2L
		movwf	PWR2L

		movlw	40
		movwf	LCV

KXJ1:		
		call	SRJ		;shift J register right
		btfsc	STATUS,C	;test if current LSB is set
		call	ADDLK		;set, add K to L
		call	SLK		;multiply K by 2 by shifting
		decfsz	LCV,F
		goto	KXJ1
		return
;----------------------------------
;This s/r normalises the binary K register right

NRK:		movlw	39
		movwf	LCV
NRK1:		
		btfsc	K0,0
		return
		call	SRK
		incf	PWR2K,F
		decfsz	LCV,F
		goto	NRK1
		clrf	PWR2K		;drop through means K is zero
		return
;----------------------------------
;This s/r moves the J register to the K register
MOVJK:
		movf	J0,W
		movwf	K0	
		movf	J1,W
		movwf	K1	
		movf	J2,W
		movwf	K2	
		movf	J3,W
		movwf	K3	
		movf	J4,W
		movwf	K4
		movf	PWR2J,W
		movwf	PWR2K
		return
;----------------------------------
;This s/r moves the J register to the L register
MOVJL:
		movf	J0,W
		movwf	L0
		movf	J1,W
		movwf	L1
		movf	J2,W
		movwf	L2
		movf	J3,W
		movwf	L3
		movf	J4,W
		movwf	L4
		movf	PWR2J,W
		movwf	PWR2L
		return
;----------------------------------
;This s/r moves the L register to the J register
MOVLJ:
		movf	L0,W
		movwf	J0
		movf	L1,W
		movwf	J1
		movf	L2,W
		movwf	J2
		movf	L3,W
		movwf	J3
		movf	L4,W
		movwf	J4
		movf	PWR2L,W
		movwf	PWR2J
		return
;----------------------------------
;This s/r moves the L register to the K register
MOVLK:
		movf	L0,W
		movwf	K0
		movf	L1,W
		movwf	K1
		movf	L2,W
		movwf	K2
		movf	L3,W
		movwf	K3
		movf	L4,W
		movwf	K4
		movf	PWR2L,W
		movwf	PWR2K
		return
;----------------------------------
    		.END            ;final line.
