;WRITTEN BY JIM MAIN
;VER 1.00
;COMPILED USING MPASM V2.30  (MPLAB V4.12)
;
;********************************************************************************
;THIS IS AN EXAMPLE OF A PROGRAM USING MICROPROBE DEBUG MACROS. THE PROGRAM
;INCREMENTS A COUNTER AT HALF SECOND INTERVALS AND DISPLAYS THE BINARY COUNT ON 
;FIVE LED's ATTACHED TO PORTB ON A 16x84
;
;WHEN THE COUNT GETS TO DECIMAL 14, DEBUG 1 IS CARRIED OUT
;WHEN THE COUNT GETS TO DECIMAL 15, DEBUG 2 IS CARRIED OUT  .. AND SO ON UP TO 8.
;WHEN THE COUNT GETS TO DECIMAL 32, THE PROCESS STARTS OVER FROM ZERO.

;THE PIN CHOSEN TO OUTPUT THE DEBUG WORD IN THIS CASE IS PORTB,0 - TO DEMONSTRATE 
;THAT THE DEBUG WORD IS SUCCESFULLY DETECTED WHETHER THE PIN STARTS OFF HIGH
;OR LOW (PORTB,0 IS THE LSB AND ALTERNATES HIGH/LOW AT HALF SEC INTERVALS)
;
;SINCE INTERRUPTS ARE USED IN THIS PROGRAM, THE GLOBAL INTERRUPT ENABLE BIT IS
;DISABLED BEFORE EACH CALL TO DEBUG - THIS IS TO ENSURE THAT A DEBUG WORD IS NOT
;RUINED BY BEING INTERRUPTED.
;********************************************************************************


	TITLE "EXAMPLE"
	LIST P=16C84

	INCLUDE P16C84.INC
	INCLUDE DEBUG.INC

#DEFINE	DEBUGPIN	PORTB,0		;DEBUG PIN TO CONNECT MICROPROBE TO
#DEFINE	CLK		4		;4MHz CLOCK



;=========================================================================
;			PORT DESCRIPTION
;=========================================================================
;
;THE PORTS ARE:-
;
;PORTA	 	UNUSED - ALL O/P's


;
;PORTB		O/P   - OUTPUTS TO 8 LED'S



;======================	END OF PORTS DESCRIPTION =========================
;


;
;====================== ADDITIONAL EQUATES ===============================
;
TEMP_W		EQU	0X0C
TEMP_STAT	EQU	0X0D

COUNTER1	EQU	0X0E
COUNTER2	EQU	0X0F



	ORG	00
	GOTO	INIT


;==========================================================================
;	INTERRUPT SECTION
;==========================================================================

	ORG	04

	MOVWF	TEMP_W			;STORE THE CONTENTS OF THE W REGISTER
	SWAPF	STATUS,W		;AND THE STATUS REGISTER, SO THAT THEY
	NOP
	BCF	STATUS,RP0		;SET RAM PAGE 0
	MOVWF	TEMP_STAT		;CAN BE RESTORED BEFORE LEAVING THE INTERRUPT


TIMER0

	BTFSS	INTCON,T0IF		;TIMER0 OVERFLOW?
	GOTO	RET_INT			;NO
					;YES - EVERY 50MS
	MOVLW	.61
	MOVWF	TMR0			;LOAD TMR0 UP WITH 50mS (256-195)
	BCF	INTCON,T0IF		;CLEAR O/FLOW FLAG

	DECFSZ	COUNTER1,F		;DEC 1 SEC COUNTER, ZERO?
	GOTO	RET_INT			;NO, SO ESCAPE
	MOVLW	.10			;YES, SO FIRST RELOAD COUNTER
	MOVWF	COUNTER1		;WITH 10 x 50mS = 0.5 SEC

	INCF	COUNTER2,F		;INCREMENT THE BINARY COUNTER

	MOVF	COUNTER2,W		;LOAD COUNTER2 BACK INTO W
	MOVWF	PORTB			;AND DISPLAY IT ON THE LED's


;==========================================================================
;	END OF THE INTERRUPT SERVICE ROUTINES
;==========================================================================
RET_INT
	SWAPF	TEMP_STAT,W		;RESTORE THE STATUS & W REGISTERS
	MOVWF	STATUS			;BEFORE LEAVING THE INTERRUPTS
	SWAPF	TEMP_W,F		;USING SWAPF'S SO THAT THE STATUS
	SWAPF	TEMP_W,W		;BITS AREN'T ALTERED
	
	RETFIE				;FINALLY GET OUT OF THE INTERRUPT
;************************************************************************


INIT

	CLRF	PORTA
	CLRF	PORTB

	BSF	STATUS,RP0		;SELECT BANK 1
	CLRF	TRISA			;PORTA ALL OUTPUTS
	CLRF	TRISB			;PORTB ALL OUTPUTS


	MOVLW	B'00000111'
	MOVWF	OPTION_REG		;SET TMR0 PRESCALE= 1:256 

	BCF	STATUS,RP0		;SELECT BANK 0

	CLRF	INTCON

	MOVLW	.61
	MOVWF	TMR0

	MOVLW	.10
	MOVWF	COUNTER1

	BSF	INTCON,T0IE

	MOVLW	.35
	MOVWF	COUNTER2

	BSF	INTCON,GIE


;==========================================================================
;	MAIN LOOP OF PROGRAM FOLLOWS
;==========================================================================

PROG_LOOP 
	MOVF	COUNTER2,W
	SUBLW	.14
	SKPZ
	GOTO	CHECK15
	BCF	INTCON,GIE	;MICROCHIP'S RECOMMENDED METHOD OF ENSURING THE GLOBAL
	BTFSC	INTCON,GIE	;INTERRUPT BIT IS SUCCESFULLY DISABLED..
	GOTO	$-2
	DEBUG	1		;BINARY .14 REACHED, SO OUTPUT DEBUG 1 WORD
	BSF	INTCON,GIE
CHECK15
	MOVF	COUNTER2,W
	SUBLW	.15
	SKPZ
	GOTO	CHECK16
	BCF	INTCON,GIE
	BTFSC	INTCON,GIE
	GOTO	$-2
	DEBUG	2
	BSF	INTCON,GIE
CHECK16
	MOVF	COUNTER2,W
	SUBLW	.16
	SKPZ
	GOTO	CHECK17
	BCF	INTCON,GIE
	BTFSC	INTCON,GIE
	GOTO	$-2
	DEBUG	3
	BSF	INTCON,GIE
CHECK17
	MOVF	COUNTER2,W
	SUBLW	.17
	SKPZ
	GOTO	CHECK18
	BCF	INTCON,GIE
	BTFSC	INTCON,GIE
	GOTO	$-2
	DEBUG	4
	BSF	INTCON,GIE
CHECK18
	MOVF	COUNTER2,W
	SUBLW	.18
	SKPZ
	GOTO	CHECK19
	BCF	INTCON,GIE
	BTFSC	INTCON,GIE
	GOTO	$-2
	DEBUG	5
	BSF	INTCON,GIE
CHECK19
	MOVF	COUNTER2,W
	SUBLW	.19
	SKPZ
	GOTO	CHECK20
	BCF	INTCON,GIE
	BTFSC	INTCON,GIE
	GOTO	$-2
	DEBUG	6
	BSF	INTCON,GIE
CHECK20
	MOVF	COUNTER2,W
	SUBLW	.20
	SKPZ
	GOTO	CHECK21
	BCF	INTCON,GIE
	BTFSC	INTCON,GIE
	GOTO	$-2
	DEBUG	7
	BSF	INTCON,GIE
CHECK21
	MOVF	COUNTER2,W
	SUBLW	.21
	SKPZ
	GOTO	CHECK35
	BCF	INTCON,GIE
	BTFSC	INTCON,GIE
	GOTO	$-2
	DEBUG	8
	BSF	INTCON,GIE

CHECK35
	MOVF	COUNTER2,W
	SUBLW	.32
	SKPNZ
	CLRF	COUNTER2		;RESET COUNTER2 WHEN IT GETS TO 32

	GOTO	PROG_LOOP		;AND LOOP BACK TO THE HEAD

	END
