;********************************************************************
;MIDI "BELLS" PROGRAM
;********************************************************************
;
STATUS      EQU             	03
PORTA		EQU             	05
PORTB       EQU             	06
ADIR        EQU             	05
BDIR		EQU			06
CNTR        EQU             	0C
CNTR2		EQU			0D
TRDATA	EQU			0E
TRDATA2	EQU			0F
TRDATA3	EQU			10
TRDATA4	EQU			11
TRDATA5	EQU			12
KEYS		EQU			13
KEYCH		EQU			14
DEL		EQU			15
KEYS2		EQU			16
KEYCH2	EQU			17
;
		BSF			STATUS,5	;Select page 1
		MOVLW           	0E
		MOVWF            	ADIR		;Set RA0 as output
		BCF			STATUS,5	;Select page 0
		BCF            	PORTA,0     ;Set RA0 low initially 
START 	MOVLW			90
		MOVWF			TRDATA	;Note on status byte
		MOVLW			40
		MOVWF			TRDATA3	;Dummy velocity value (64)
		MOVLW			80
		MOVWF			TRDATA4	;Note off status byte
		MOVLW			00
		MOVWF			TRDATA5	;Dummy velocity value (0)
		MOVF			PORTB,0
		MOVWF			KEYS
		MOVF			PORTA,0
		ANDLW			0E
		MOVWF			KEYS2
MAINLOOP	MOVF			PORTB,0
		XORWF			KEYS,0
		BTFSC			STATUS,2	;Wait for change in keys
		GOTO			TST2
		MOVWF			KEYCH		;Store key change data
		MOVF			PORTB,0
		MOVWF			KEYS		;Update value in KEYS register
		MOVLW			0xFF
		MOVWF			DEL
DEBNC		DECFSZ		DEL,1
		GOTO			DEBNC
		BTFSC			KEYCH,0
		GOTO			KEY0
		BTFSC			KEYCH,1
		GOTO			KEY1
		BTFSC			KEYCH,2
		GOTO			KEY2
		BTFSC			KEYCH,3
		GOTO			KEY3
		BTFSC			KEYCH,4
		GOTO			KEY4
		BTFSC			KEYCH,5
		GOTO			KEY5
		BTFSC			KEYCH,6
		GOTO			KEY6
		BTFSC			KEYCH,7
		GOTO			KEY7
PLAY		BTFSC			KEYCH2,1
		GOTO			KEY8
		BTFSC			KEYCH2,2
		GOTO			KEY9
		BTFSC			KEYCH2,3
		GOTO			KEY10
		GOTO			MAINLOOP
;
TST2		MOVF			PORTA,0
		ANDLW			0E
		XORWF			KEYS2,0
		BTFSC			STATUS,2
		GOTO			MAINLOOP
		MOVWF			KEYCH2
		MOVF			PORTA,0
		ANDLW			0E
		MOVWF			KEYS2
		MOVLW			0xFF
		MOVWF			DEL
DEBNC2	DECFSZ		DEL,1
		GOTO			DEBNC2
		GOTO			PLAY
;
KEY0		MOVLW		3C
		MOVWF		TRDATA2	;Load note value (C)
		BTFSC		PORTB,0
		CALL		NTON
		BTFSS		PORTB,0
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY1		MOVLW		3E
		MOVWF		TRDATA2	;Load note value (D)
		BTFSC		PORTB,1
		CALL		NTON
		BTFSS		PORTB,1
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY2		MOVLW		40
		MOVWF		TRDATA2	;Load note value (E)
		BTFSC		PORTB,2
		CALL		NTON
		BTFSS		PORTB,2
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY3		MOVLW		41
		MOVWF		TRDATA2	;Load note value (F)
		BTFSC		PORTB,3
		CALL		NTON
		BTFSS		PORTB,3
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY4		MOVLW		43
		MOVWF		TRDATA2	;Load note value (G)
		BTFSC		PORTB,4
		CALL		NTON
		BTFSS		PORTB,4
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY5		MOVLW		45
		MOVWF		TRDATA2	;Load note value (A)
		BTFSC		PORTB,5
		CALL		NTON
		BTFSS		PORTB,5
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY6		MOVLW		47
		MOVWF		TRDATA2	;Load note value (B)
		BTFSC		PORTB,6
		CALL		NTON
		BTFSS		PORTB,6
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY7		MOVLW		48
		MOVWF		TRDATA2	;Load note value (C)
		BTFSC		PORTB,7
		CALL		NTON
		BTFSS		PORTB,7
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY8		MOVLW		4A
		MOVWF		TRDATA2	;Load note value (D)
		BTFSC		PORTA,1
		CALL		NTON
		BTFSS		PORTA,1
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY9		MOVLW		4C
		MOVWF		TRDATA2	;Load note value (E)
		BTFSC		PORTA,2
		CALL		NTON
		BTFSS		PORTA,2
		CALL		NTOFF
		GOTO		MAINLOOP
;
KEY10		MOVLW		4D
		MOVWF		TRDATA2	;Load note value (F)
		BTFSC		PORTA,3
		CALL		NTON
		BTFSS		PORTA,3
		CALL		NTOFF
		GOTO		MAINLOOP
;
NTON		BSF			PORTA,0	;Generate start bit
		MOVLW			09
		MOVWF			CNTR
STRT1		DECFSZ		CNTR,1
		GOTO			STRT1
		NOP
		MOVLW			08		;Generate data bits
		MOVWF			CNTR2
LOOP1		COMF			TRDATA,0	;Inverts status data and loads into W
		MOVWF			PORTA,0	;Set output line to correct state
		MOVLW			08
		MOVWF			CNTR
DELAY1	DECFSZ		CNTR,1
		GOTO			DELAY1
		NOP
		NOP
		RRF			TRDATA,1
		DECFSZ		CNTR2,1
		GOTO			LOOP1
		BCF			PORTA,0	;Generate stop bit
		MOVLW			09
		MOVWF			CNTR
STP1		DECFSZ		CNTR,1
		GOTO			STP1
		NOP
		BSF			PORTA,0	;Generate start bit
		MOVLW			09
		MOVWF			CNTR
STRT2		DECFSZ		CNTR,1
		GOTO			STRT2
		NOP
		MOVLW			08
		MOVWF			CNTR2
LOOP2		COMF			TRDATA2,0	;Invert note data and load into W
		MOVWF			PORTA,0	;Set output to correct state
		MOVLW			08
		MOVWF			CNTR
DELAY2	DECFSZ		CNTR,1
		GOTO			DELAY2
		NOP
		NOP
		RRF			TRDATA2,1
		DECFSZ		CNTR2,1
		GOTO			LOOP2
		BCF			PORTA,0	;Generate stop bit
		MOVLW			09
		MOVWF			CNTR
STP2		DECFSZ		CNTR,1
		GOTO			STP2
		NOP
		BSF			PORTA,0	;Generate start bit
		MOVLW			09
		MOVWF			CNTR
STRT3		DECFSZ		CNTR,1
		GOTO			STRT3
		NOP
		MOVLW			08
		MOVWF			CNTR2
LOOP3		COMF			TRDATA3,0	;Invert velocity data and load into W
		MOVWF			PORTA,0	;Set output at correct state
		MOVLW			08
		MOVWF			CNTR
DELAY3	DECFSZ		CNTR,1
		GOTO			DELAY3
		NOP
		NOP
		RRF			TRDATA3,1
		DECFSZ		CNTR2,1
		GOTO			LOOP3
		BCF			PORTA,0	;Generate stop bit
		MOVLW			09
		MOVWF			CNTR
STP3		DECFSZ		CNTR,1
		GOTO			STP3
		MOVLW			90		;Reset affected variables
		MOVWF			TRDATA
		MOVLW			40
		MOVWF			TRDATA3
		RETURN
;
NTOFF		BSF			PORTA,0	;Generate start bit
		MOVLW			09
		MOVWF			CNTR
STRT4		DECFSZ		CNTR,1
		GOTO			STRT4
		NOP
		MOVLW			08		;Generate data bits
		MOVWF			CNTR2
LOOP5		COMF			TRDATA4,0	;Inverts status data and loads into W
		MOVWF			PORTA,0	;Set output line to correct state
		MOVLW			08
		MOVWF			CNTR
DELAY4	DECFSZ		CNTR,1
		GOTO			DELAY4
		NOP
		NOP
		RRF			TRDATA4,1
		DECFSZ		CNTR2,1
		GOTO			LOOP5
		BCF			PORTA,0	;Generate stop bit
		MOVLW			09
		MOVWF			CNTR
STP4		DECFSZ		CNTR,1
		GOTO			STP4
		NOP
		BSF			PORTA,0	;Generate start bit
		MOVLW			09
		MOVWF			CNTR
STRT5		DECFSZ		CNTR,1
		GOTO			STRT5
		NOP
		MOVLW			08
		MOVWF			CNTR2
LOOP6		COMF			TRDATA2,0	;Invert note data and load into W
		MOVWF			PORTA,0	;Set output to correct state
		MOVLW			08
		MOVWF			CNTR
DELAY5	DECFSZ		CNTR,1
		GOTO			DELAY5
		NOP
		NOP
		RRF			TRDATA2,1
		DECFSZ		CNTR2,1
		GOTO			LOOP6
		BCF			PORTA,0	;Generate stop bit
		MOVLW			09
		MOVWF			CNTR
STP5		DECFSZ		CNTR,1
		GOTO			STP5
		NOP
		BSF			PORTA,0	;Generate start bit
		MOVLW			09
		MOVWF			CNTR
STRT6		DECFSZ		CNTR,1
		GOTO			STRT6
		NOP
		MOVLW			08
		MOVWF			CNTR2
LOOP7		COMF			TRDATA5,0	;Invert velocity data and load into W
		MOVWF			PORTA,0	;Set output at correct state
		MOVLW			08
		MOVWF			CNTR
DELAY6	DECFSZ		CNTR,1
		GOTO			DELAY6
		NOP
		NOP
		RRF			TRDATA5,1
		DECFSZ		CNTR2,1
		GOTO			LOOP7
		BCF			PORTA,0	;Generate stop bit
		MOVLW			09
		MOVWF			CNTR
STP6		DECFSZ		CNTR,1
		GOTO			STP6
		MOVLW			80		;Reset affected variables
		MOVWF			TRDATA4
		MOVLW			00
		MOVWF			TRDATA5
		RETURN
;
		END
