;EVENT202.ASM 16JAN99  EPE EVENT AND FREQ COUNTER copyright JOHN BECKER
;PIC16C84, set for 3.2768MHz XTAL, WDT OFF, POR on
;written in TASM

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:   .EQU $00        ;page 0 & 1
TMR0:   .EQU $01        ;0
OPTION: .EQU $01        ;1
PCL:    .EQU $02        ;0 & 1
STATUS: .EQU $03        ;0 & 1
FSR:    .EQU $04        ;0 & 1
PORTA:  .EQU $05        ;0
TRISA:  .EQU $05        ;1
PORTB:  .EQU $06        ;0
TRISB:  .EQU $06        ;1
                        ;$07 not available
EEDATA: .EQU $08        ;0
EECON1: .EQU $08        ;1
EEADR:  .EQU $09        ;0
EECON2: .EQU $09        ;1
PCLATH: .EQU $0A        ;0 & 1
INTCON: .EQU $0B        ;0 & 1

LOOPA:  .EQU $0C        ;loop counter
SWITCH: .EQU $0D        ;switch status
SWFLAG: .EQU $0E        ;switch change flag
STORE1: .EQU $0F        ;general store
TSTFLG: .EQU $10        ;miscellaneous other uses

PULSE:  .EQU $11        ;pulse flag for freq mode
MODE:   .EQU $12        ;mode route
SOURCE: .EQU $13        ;source for input (port pin) (RB6 or RB7)
COUNT1: .EQU $14        ;count byte 1
COUNT2: .EQU $15        ;count byte 2
COUNT3: .EQU $16        ;count byte 3

CLKCNT: .EQU $17        ;pre-counter for CLOCK
CLKSEC: .EQU $18        ;CLOCK main counter - secs
CLKMIN: .EQU $19        ;CLOCK - mins
CLKHRS: .EQU $1A        ;CLOCK - hours

MASK:   .EQU $1B        ;mask for extracting input source
WORK1:  .EQU $1C        ;working store 1
WORK2:  .EQU $1D        ;working store 2
WORK3:  .EQU $1E        ;working store 3
WORK4:  .EQU $1F        ;working store 4

DEC1:   .EQU $20        ;decimalisation byte 1 & other uses
DEC2:   .EQU $21        ; byte 2
DEC3:   .EQU $22        ; byte 3
DEC4:   .EQU $23        ; byte 4
DEC5:   .EQU $24        ; byte 5
ANSA1:  .EQU $25        ;decimalisation answer store 1 & other uses
ANSA2:  .EQU $26        ; answer 2
ANSA3:  .EQU $27        ; answer 3
ANSA4:  .EQU $28        ; answer 4
ANSA5:  .EQU $29        ; answer 5

STORE3: .EQU $2A        ;general store 3
LOOPB:  .EQU $2B        ;general loop 2
STORE2: .EQU $2C        ;general store 2
MLTPL1: .EQU $2D        ;multiply lsb & other uses
MLTPL2: .EQU $2E        ;multiply nmsb & other uses
MLTPL3: .EQU $2F        ;multiply msb & other uses

W:      .EQU 0  ;Result to go into working register (accumulator)
F:      .EQU 1  ;Result to go into a file register.

C:      .EQU 0  ;Carry flag  (located in STATUS register)
DC:     .EQU 1  ;Digit carry            "
Z:      .EQU 2  ;Zero flag              "
PD:     .EQU 3  ;Power Down bit         "
TO:     .EQU 4  ;Time-out bit           "
WR:     .EQU 1  ;eeprom write initiate address
WREN:   .EQU 2  ;eeprom write enable address
RD:     .EQU 0  ;eeprom read enable address
GIE:    .EQU 7  ;GIE bit in INTCON reg

                ;TSTFLG USE:
                ;bit 0 decimal point flag
                ;bit 1
                ;bit 2
                ;bit 3 
                ;bit 4 RS flag for LCD
                ;bit 5 
                ;bit 6 Add/Subtract flag
                ;bit 7 data input flag

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF

        PAGE1
        MOVLW %11000000
        MOVWF TRISB     ;Configure port B0-B5 as output, B6-B7 as input
        movlw %00011111
        MOVWF TRISA     ;Port A0-A4 as input
        MOVLW %00000100 ;timer ratio 1:32 (1/100sec). Pull-up Rs on (bit7=0)
        MOVWF OPTION
        PAGE0

        CLRF PORTA
        CLRF PORTB
        goto SETUP

TABLCD:                 ;LCD initialisation table
        ADDWF PCL,F     ;add program counter
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display 
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

TBDEC1:                 ;table for decimalisation lsb
        ADDWF PCL,F     ;add program counter
        retlw $10       ;lsb of 10000
        retlw $E8       ;lsb of 1000
        retlw $64       ;lsb of 100
        retlw $0A       ;lsb of 10

TBDEC2:                 ;table for decimalisation msb
        ADDWF PCL,F     ;add program counter
        retlw $27       ;msb of 10000
        retlw $03       ;msb of 1000
        retlw 0         ;msb of 100
        retlw 0         ;msb of 10

FRQTAB:                 ;LCD table for frequency
        ADDWF PCL,F     ;add program counter
        retlw ' '
        retlw 'F'
        retlw 'R'
        retlw 'E'
        retlw 'Q'
        retlw 'U'
        retlw 'E'
        retlw 'N'
        retlw 'C'
        retlw 'Y'

SETUP:  call RESETA     ;reset working bytes
        CALL PAUSIT     ;1/5 sec delay

LCDSET: CLRF LOOPA      ;clr LCD set-up loop
LCDST2: MOVF LOOPA,W    ;get table address
        CALL TABLCD     ;get set-up instruction
        CALL LCDLIN     ;perform it
        INCF LOOPA,F    ;inc loop
        BTFSS LOOPA,3   ;has last LCD set-up instruction now been done?
        GOTO LCDST2     ;no
        CALL PAUSIT     ;1/5 sec delay
        movlw 128
        movwf MASK      ;set MASK for RB7 (MIC input)
        goto EVENT

ROUTE:  incf MODE,F
ROUTE1: btfsc PORTA,3   ;is S2 still pressed?
        goto ROUTE1     ;yes
        call CLRSCR     ;clear screen
        movf MODE,W
        andlw 3
        addwf PCL,F
        goto EVENT      ;show event counts
        goto FRQSET     ;show frequency
        goto PLSTIM     ;show individual pulse times
        goto SETDIR     ;set source direction (port pin as input)
        goto EVENT

FRQSET: bcf TSTFLG,0
        movlw 1
        movwf MODE
        call LCD8
        movlw 'H'
        call LCDOUT
        movlw 'z'
        call LCDOUT
        call LCD21
        clrf LOOPA
        movlw 10
        movwf COUNT1
FRQST2: movf LOOPA,W
        call FRQTAB
        call LCDOUT
        incf LOOPA,F
        decfsz COUNT1,F
        goto FRQST2
        clrf COUNT2
        clrf COUNT3
        movlw 100     ;initial basic CLKCNT val for secs timing
        movwf CLKCNT
        bcf INTCON,2
        goto FREQ

EVENT:  call RESETE     ;reset required working bytes, and set screen
        movlw 100       ;initial basic CLKCNT val for secs timing
        movwf CLKCNT
EVNT2:  btfsc PORTA,3   ;is MODE switch pressed?
        goto ROUTE      ;yes
        btfsc PORTA,4   ;is RESET still pressed?
        goto EVNT2      ;yes
        comf PORTB,W    ;is RB6/RB7 high (depending on MASK)?
        andwf MASK,W
        btfsc STATUS,Z
        goto EVNT2      ;yes
        bcf INTCON,2    ;no, so clear timer flag and start timing

INTRPT:                 ;working interrupt routine for event counting
        btfss INTCON,2  ;has a timer time-out been detected?
        goto INTRPT     ;no
        bcf INTCON,2    ;yes (NB, max input rate via this route is 25Hz)
        call CLKIN
        btfsc PORTA,3   ;is MODE switch pressed?
        goto ROUTE      ;yes
        btfsc PORTA,4   ;is reset needed?
        goto EVENT      ;yes

TSTBT1: comf PORTB,W    ;is RB7/RB6 high
        andwf MASK,W
        btfss STATUS,Z
        goto TSTPRV     ;yes
        bcf TSTFLG,7    ;no, clear data flag
        goto INTRPT     
TSTPRV: btfsc TSTFLG,7  ;is data flag high?
        goto INTRPT     ;yes
        bsf TSTFLG,7    ;no, set data flag high
        incf COUNT1,F   ;inc count
        btfss STATUS,Z
        goto TSTBT4
        incf COUNT2,F
        btfss STATUS,Z
        goto TSTBT4
        incf COUNT3,F
TSTBT4: call DISPLY
        goto INTRPT

DISPLY: bsf TSTFLG,4    ;set RS flag high
        bsf TSTFLG,0    ;flag for decimal point
        call LCD21
        call TIMSHW     ;show elapsed time
        bcf TSTFLG,0    ;flag for decimal point
        call LCD9
        call CNTSHW     ;show count value
        call AVRAGE     ;show average count per sec/min/hrs
        return

FREQ:                   ;working interrupt routine for freq
        btfss INTCON,2  ;has a timer time-out been detected?
        goto FREQ1      ;no
        bcf INTCON,2    ;yes
        btfsc PORTA,3   ;is switch 2 pressed?
        goto ROUTE      ;yes
        decfsz CLKCNT,F ;is CLKCNT = 0?
        goto FREQ1      ;no
        call FRQSHW
        clrf COUNT1
        clrf COUNT2
        movlw 100        ;initial basic CLKCNT val for secs timing
        movwf CLKCNT
        goto FREQ

FREQ1:  comf PORTB,W    ;get pulse level
        andwf MASK,W    ;get RB6/RB7 value (depending on MASK)
        xorwf PULSE,W   ;is it equal to previous level?
        btfsc STATUS,Z
        goto FREQ       ;yes
        incfsz COUNT1,F ;inc count
        goto FREQA
        incfsz COUNT2,F
        goto FREQA
        decf COUNT2,F   ;limit MSB to 255 without rollover
FREQA:  comf PORTB,W    ;get pulse level again
        andwf MASK,W    ;get RB6/RB7
        movwf PULSE     ;store new level
        goto FREQ

FRQSHW: bcf STATUS,C
        rrf COUNT2,F
        rrf COUNT1,F
        call LCD1
        movf COUNT1,W
        iorwf COUNT2,W
        btfss STATUS,Z
        goto FREQ5
        call ZERO
        goto FREQ6

FREQ5:  movlw COUNT1    ;address 1st byte of COUNT
        call PREPRP     ;decimalise and prepare for screen
FREQ6:  call LCD8
        movlw 'H'
        call LCDOUT
        movlw 'z'
        call LCDOUT
        bcf INTCON,2
        movlw 50        ;allow for 2 secs time-out
        movwf CLKCNT
FREQ2:                  ;working interrupt routine for freq
        btfss INTCON,2  ;has a timer time-out been detected?
        goto FREQ2      ;no
        bcf INTCON,2    ;yes
        btfsc PORTA,3   ;is switch 2 pressed?
        return          ;yes
FREQ3:  movf PORTB,W    ;get pulse level
        andlw 128       ;get bit 7
        xorwf PULSE,W   ;is it equal to previous level?
        btfss STATUS,Z
        goto FREQ4      ;no
        decfsz CLKCNT,F ;time-out count-down (2 secs max)
        goto FREQ2
FREQ4:  movf PORTB,W    ;store new level
        andlw 128
        movwf PULSE
        return

PLSTIM: bsf TSTFLG,0    ;flag for decimal point
        call LCD1
        call ZERO
        clrf COUNT1
        clrf COUNT2
        clrf COUNT3
        clrf CLKCNT
        clrf PULSE
        call LCD9
        movlw 'S'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'S'
        call LCDOUT

        call LCD21
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'E'
        call LCDOUT

ITEM1:  btfss INTCON,2  ;has a timer time-out been detected?
        goto ITEM1      ;no
        bcf INTCON,2    ;yes
        btfsc PORTA,3   ;is mode pressed?
        goto ITEM5      ;yes
        incf COUNT1,F   ;inc count
        btfss STATUS,Z
        goto ITEM3
        incf COUNT2,F
        btfss STATUS,Z
        goto ITEM3
        incf COUNT3,F

ITEM3:  comf PORTB,W    ;get pulse level
        andwf MASK,W    ;get RB6/RB7 value (depending on MASK)
        btfss STATUS,Z  ;is pulse high?
        goto ITEM2      ;yes
        clrf PULSE      ;clear flag
        goto ITEM1

ITEM2:  movf PULSE,W    ;is flag clear?
        btfss STATUS,Z
        goto ITEM1      ;no
        bsf PULSE,0     ;yes, so set flag
        call LCD1
        call CNTSHW     ;show count value
        clrf COUNT1
        clrf COUNT2
        clrf COUNT3
        btfsc PORTA,3   ;is MODE pressed?
        goto ITEM5      ;yes
        bcf INTCON,2    ;no
        goto ITEM1
ITEM5:  goto ROUTE

LCD28:  movlw %11001000
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD9:   movlw %10001001
        goto LCDLIN
LCD8:   movlw %10001000
        goto LCDLIN
LCD1:   movlw %10000000

LCDLIN: bcf TSTFLG,4    ;clear RS flag - sets LCD command/line

LCDOUT: movwf STORE1
        movf TSTFLG,W   ;get RS and store it in STORE2
        andlw %00010000 ;(RS = bit 4)
        movwf STORE2    ;
        movlw 20        ;set min time between sending full bytes to LCD
        movwf LOOPB
DELAY:  decfsz LOOPB,F
        goto DELAY
        call SENDIT     ;send MSB
        call SENDIT     ;send LSB
        bsf TSTFLG,4    ;set RS flag (default is flag set)
        return

SENDIT:                 ;get and send data nibble
        swapf STORE1,F  ;get nibble
        movf STORE1,W
        andlw 15
        iorwf STORE2,W  ;OR the RS bit
        movwf PORTB     ;output the byte
        bsf PORTB,5     ;set E high
        bcf PORTB,5     ;set E low
        return
            
CLKIN:  decfsz CLKCNT,F ;increment clock routine. Is it = 0?
        return          ;no
CLKIN2: btfsc PORTA,2   ;is RA2 high? (period change switch high?)
        goto SWPRV      ;yes
        bcf SWFLAG,0    ;no, clear data flag
        goto CLKADD     
SWPRV:  btfsc SWFLAG,0  ;is switch flag high?
        goto CLKADD     ;yes
        bsf SWFLAG,0    ;no, set switch flag high
        incf SWITCH,F   ;inc switch count and check for value of 3
        btfss SWITCH,1  ;is switch bit 1 high?
        goto CLKIN3     ;no
        btfss SWITCH,0  ;is switch bit 0 high?
        goto CLKIN3     ;no
        clrf SWITCH
CLKIN3: bsf TSTFLG,0    ;flag for decimal point
        call AVRAGE

CLKADD: movlw 100        ;reset start value of CLKCNT
        movwf CLKCNT

SECCLK: movlw CLKSEC
        movwf FSR
        movlw 3
        movwf LOOPA

ADDCLK: incf INDF,F     ;inc units
        movlw 6
        addwf INDF,W    ;if 6 is added is there a digit carry?
        btfss STATUS,DC
        goto CHKH24     ;no
        movwf INDF      ;yes
        movlw 160
        addwf INDF,W    ;if 160 is added is there a carry
        btfss STATUS,C  ;(adding 160 checks if tens of units = 6)
        goto CHKH24     ;no
        clrf INDF       ;yes
        incf FSR,F
        decfsz LOOPA,F
        goto ADDCLK

CHKH24: movlw 220       ;is clock = 24 hrs? (adding 220 checks it)
        addwf CLKHRS,W
        btfsc STATUS,C
        clrf CLKHRS
        call LCD1
        bsf TSTFLG,0
        call TIMSHW     ;show immediate elapsed time
        return

DECIML:                 ;decimalise binary number
                        ;copy source into working area
                        ;source address is brought in on W
                        ;DEC1-5 becomes source
                        ;answer goes into ANSA
        call COPYFD     ;copy data at FSR into DEC
        clrf STORE1
        clrf LOOPA
        call CLRANS

        movlw ANSA4     ;set answer store address
        movwf FSR

DCML0:  movf LOOPA,W
        call TBDEC1     ;subtract lsb from source value
        subwf DEC1,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no
        movlw 1
        subwf DEC2,F    ;yes so decrement next byte
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no
        movlw 1         ;yes
        subwf DEC3,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no

DCML3:  movf LOOPA,W    ;yes, so re-add last table values lsb
        call TBDEC1
        addwf DEC1,F
        btfss STATUS,C  ;is there a carry?
        goto DCML5      ;no so exit loop
        incf DEC2,F     ;yes so inc next byte
        btfss STATUS,Z  ;is there a carry? (is it zero)
        goto DCML5      ;no so exit loop
        incf DEC3,F     ;yes
        goto DCML5      ;exit loop

DCML1:  movf LOOPA,W
        call TBDEC2     ;subtract msb from source value
        subwf DEC2,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML2      ;no
        movlw 1
        subwf DEC3,F    ;yes so decrement next byte
        btfss STATUS,C  ;is there a borrow?
        goto DCML4      ;yes

DCML2:  incfsz STORE1,F ;inc counter & continue looping till zero
        goto DCML0

DCML4:  movf LOOPA,W    ;re-add last table values lsb
        call TBDEC1
        addwf DEC1,F
        btfss STATUS,C  ;is there a carry?
        goto DCML4A     ;no so add msb
        incf DEC2,F     ;yes so inc next byte
        btfsc STATUS,Z  ;is there a carry? (is it zero)
        incf DEC3,F     ;yes, so inc next byte

DCML4A: movf LOOPA,W    ;re-add last table values msb
        call TBDEC2
        addwf DEC2,F
        btfsc STATUS,C  ;is there a carry?
        incf DEC3,F     ;yes, so inc next byte

DCML5:  movf STORE1,W   ;store counter and loop for next values
        movwf INDF
        clrf STORE1
        decf FSR,F
        incf LOOPA,F
        btfss LOOPA,2   ;is it = 4?
        goto DCML0      ;no

DCML6:  movlw 15        ;compact answers into 3 bytes
        andwf ANSA1,F
        andwf ANSA2,F
        andwf ANSA3,F
        swapf ANSA1,F
        movf DEC1,W
        iorwf ANSA1,F
        swapf ANSA3,W
        iorwf ANSA2,F
        movf ANSA4,W
        movwf ANSA3
        movlw 6
        addwf ANSA3,W
        btfsc STATUS,DC
        movwf ANSA3
        return

MULTI:                  ;multiply routine. Source is in DEC1-5
                        ;multiplier is in MLTPL1 & MLTPL2
                        ;answer goes into ANSA1-5
        bcf STATUS,C    ;rotate divisor right by 1
        rrf MLTPL2,F
        rrf MLTPL1,F
        btfss STATUS,C  ;is carry = 1?
        goto MULT2      ;no
        movlw 5         ;yes
        movwf LOOPA     ;number of bytes to be added from
        movlw DEC1      ;set first source address
        movwf STORE1
        movlw ANSA1     ;set first answer address
        movwf STORE2

MULTB:  movf LOOPA,W
        movwf LOOPB     ;number of bytes for answer
        movf STORE1,W   ;get source address
        movwf FSR
        movf INDF,W     ;get source byte to be added
        movwf STORE3    ;temp store it
        movf STORE2,W   ;get first answer address
        movwf FSR
        movf STORE3,W   ;get stored source byte to be added
        addwf INDF,F    ;add it
        decfsz LOOPB,F
        call MLTINC     ;no, so increment next set of bytes as needed

MULTA:  incf STORE2,F   ;increment answer address
        incf STORE1,F   ;increment source address
        decfsz LOOPA,F  ;do same with next source byte
        goto MULTB

MULT2:  bcf STATUS,C    ;rotate left all source bytes
        rlf DEC1,F
        rlf DEC2,F
        rlf DEC3,F
        rlf DEC4,F
        rlf DEC5,F
        movf MLTPL1,W   ;is multiplier = 0?
        iorwf MLTPL2,W
        btfss STATUS,Z
        goto MULTI      ;no, loop back for next set
        return          ;yes

MLTINC: incf FSR,F
        movlw 1
        andwf STATUS,W
        addwf INDF,F
        decfsz LOOPB,F  ;yes
        goto MLTINC     ;if LOOPB > 0 then loop again
        return

DIVIDE:                 ;divide source val in ANSA1-4 by val in DEC1-3
                        ;result goes back into ANSA1-4
                        ;bit flag 1 is held in MLTPL1
                        ;byte flag 2 is held in MLTPL2
                        ;flag result total is in WORK1-5 (i.e. answer)
                        ;main loop held in MLTPL3

SETBYT: movf ANSA4,F    ;check if ANSA4 >0
        btfsc STATUS,Z
        goto BYTOK      ;it equals 0
        bcf STATUS,C    ;divide ANSA x 2
        rrf ANSA4,F
        rrf ANSA3,F
        rrf ANSA2,F
        rrf ANSA1,F
        bcf STATUS,C    ;divide DEC x 2
        rrf DEC4,F
        rrf DEC3,F
        rrf DEC2,F
        rrf DEC1,F
        goto SETBYT     ;repeat till ANSA4 = 0

BYTOK:  call CLRWRK
        clrf MLTPL1
        clrf MLTPL2
        clrf MLTPL3
        bsf MLTPL1,0    ;set flag
        movlw 3         ;set FLAGX (DEC5)
        movwf DEC5

DIV0:   movlw 3
        movwf LOOPA
        movlw DEC3      ;find 1st non-zero divide byte
        movwf FSR

DIV0A:  movf INDF,F     ;is byte = 0
        btfss STATUS,Z
        goto DIV0B      ;no
        decf FSR,F      ;yes, so look at next byte
        decf DEC5,F     ;dec FLAGX
        decfsz LOOPA,F  ;is loop = 0?
        goto DIV0A      ;no
        return          ;yes, divisor = 0 therefore return

DIV0B:  movlw 3
        movwf LOOPA
        clrf STORE1

DIV1:   bcf STATUS,C    ;rotate L divisor & flag until carryout from DEC3
        incf STORE1,F
        rlf MLTPL1,F
        btfss STATUS,C  ;is there a carry out?
        goto DIV2       ;no
        bsf MLTPL1,0    ;yes, so set bit 1
        decfsz LOOPA,F  ;is loop = 0
        goto DIV1A      ;no
        return          ;yes, therefore divisor = 0, return

DIV1A:  movlw 3         ;set MLTPL2
        movwf MLTPL2

DIV2:   incf MLTPL3,F
        bcf STATUS,C
        rlf DEC1,F      ;rotate divisor
        rlf DEC2,F
        rlf DEC3,F
        btfss DEC3,7    ;is DEC3 >= 128?
        goto DIV1       ;no
        incf MLTPL3,F   ;yes
        movlw 3
        movwf MLTPL2
        goto DIV3A

DIV2A:  call DIV3       ;rotate right divisor by 1 place

DIV3A:  bcf TSTFLG,6    ;set flag for Subtract
        call DIV4

        movf ANSA4,F    ;has there been a borrow? (is ANSA4>0 ?)
        btfss STATUS,Z
        goto DIV3C      ;yes

        movlw WORK1     ;no, so add flag to total
        addwf MLTPL2,W  ;set answer address
        movwf FSR
        movf MLTPL1,W   ;OR flag with running answer
        iorwf INDF,F
        goto DIV3B

DIV3C:  bsf TSTFLG,6    ;set flag for Add
        call DIV4

DIV3B:  decf MLTPL3,F   ;is main counter = 0?
        btfsc STATUS,Z
        goto DIV7       ;yes, so correct for decimal point
        bcf STATUS,C
        goto DIV2A      ;no, so repeat

DIV7:   movf DEC5,F     ;is FLAGX = 0?
        btfsc STATUS,Z
        goto DIV7C      ;yes, so end division and return

DIV7A:  movlw 3         ;shift right WORK bytes by one place
        movwf LOOPA
        movlw WORK2
        movwf FSR

DIV7B:  movf INDF,W
        decf FSR,F
        movwf INDF
        incf FSR,F
        incf FSR,F
        decfsz LOOPA,F
        goto DIV7B
        clrf WORK4
        decfsz DEC5,F   ;if FLAGX <> 0 then repeat
        goto DIV7A
DIV7C:  return

DIV4:                   ;sub-routine for DIVIDE, plus ADD TOTAL
        movlw 3         ;set outer byte loop
        movwf LOOPA
        movlw ANSA1     ;set address for source
        movwf STORE1
        movlw DEC1      ;set address for divisor/adder
        movwf STORE2

DIV5:   movf LOOPA,W    ;set inner byte loop - 1 more than outer
        movwf LOOPB
        incf LOOPB,F
        movf STORE2,W   ;set address for divisor/adder byte
        movwf FSR
        movf INDF,W     ;get divisor/adder byte
        movwf STORE3    ;store it
        movf STORE1,W   ;set address for source
        movwf FSR

DIV5C:  movf STORE3,W   ;recall divisor byte
        btfsc TSTFLG,6  ;is Add needed?
        goto DIV5A      ;yes
        call SBTRCT     ;no
        goto DIV6
DIV5A:  call ADDIT

DIV6:   incf STORE1,F   ;inc source address
        incf STORE2,F   ;inc divisor address
        decfsz LOOPA,F  ;is outer loop = 0?
        goto DIV5       ;no, so continue loop
        return

SBTRCT: btfsc STATUS,Z  ;is byte zero?
        goto SBT2       ;yes
        subwf INDF,F
        btfsc STATUS,C  ;is there a borrow?
        goto SBT2       ;no
        incf FSR,F      ;yes
        movlw 1         ;so set up decrement for next byte
        decfsz LOOPB,F  ;is loop = 0?
        goto SBTRCT     ;no, so decrement next byte
SBT2:   return          ;yes

ADDIT:  addwf INDF,F
        movf STATUS,W
        andlw 1
        incf FSR,F
        decfsz LOOPB,F  ;is loop > 0
        goto ADDIT      ;yes, so repeat for next byte
        return

DIV3:   rrf DEC3,F      ;rotate right divisor by 1 place
        rrf DEC2,F      ;carry flag is preset by calling routine
        rrf DEC1,F

        bcf STATUS,C
        rrf MLTPL1,F    ;rotate flag right by 1 place
        btfss STATUS,C  ;is there a carry out?
        goto DIV3D      ;no
        decf MLTPL2,F   ;yes, dec flag 2
        bsf MLTPL1,7    ;and set bit 7 of flag 1
DIV3D:  return

ZERO:   call CLRANS
        movlw ANSA1
        goto PREPRP

TIMSHW:                 ;show TIME
        movlw CLKSEC    ;address of seconds
        call PRPSHW     ;prepare byte data
        movf DEC3,W
        movwf DEC4
        movf DEC2,W
        movwf DEC3
        movlw 58        ;colon
        movwf DEC2
        goto SCREEN

CNTSHW:                 ;show COUNT value
        movf COUNT1,W
        iorwf COUNT2,W
        btfsc STATUS,Z
        goto ZERO
        movlw COUNT1    ;address 1st byte of COUNT
        goto PREPRP     ;decimalise and prepare for screen

AVRAGE:
        btfsc SWITCH,1  ;is hours average needed?
        goto AVHRS      ;yes
        btfsc SWITCH,0  ;is mins average needed?
        goto AVMIN      ;yes

AVSEC:  call LCD9
        movlw 'S'
        call LCDOUT
        call LCD28
        bsf TSTFLG,0
        goto AV1

AVMIN:  call LCD9
        movlw 'M'
        call LCDOUT
        call LCD28
        bsf TSTFLG,0
        goto AV1

AVHRS:  call LCD9
        movlw 'H'
        call LCDOUT
        call LCD28
        movlw 32
        call LCDOUT     ;step on address by one place
        bcf TSTFLG,0

AV1:    call CLRWRK     ;clear WORK1-4
        call CLRANS     ;clear ANSA1-5

        movf COUNT1,W   ;check if COUNT = 0
        iorwf COUNT2,W
        iorwf COUNT3,W
        btfsc STATUS,Z
        goto ZERO

        movf CLKHRS,W   ;check if time=0
        iorwf CLKMIN,W
        iorwf CLKSEC,W
        btfsc STATUS,Z
        goto ZERO

        movlw CLKHRS    ;convert hours to binary
        movwf FSR
        call CVBIN      ;answer in STORE1
        call CLRDEC
        movf STORE1,W
        movwf DEC1      ;source for divider
        call MLTx60     ;multiply hrs*60, answer in ANSA

        movlw CLKMIN    ;convert mins to binary
        movwf FSR
        call CVBIN      ;answer in STORE1
        call ADDTIM     ;add mins to hrs*60 (in ANSA), answer in DEC
        call MLTx60     ;multiply mins*60 (in DEC), answer in ANSA

CVSEC:  movlw CLKSEC    ;convert secs to binary
        movwf FSR
        call CVBIN      ;answer in STORE1
        call ADDTIM     ;add secs to min*60 (in ANSA), answer in DEC
                        ;answer = total secs of elapsed time

        movf DEC1,W     ;store secs answer in WORK
        movwf WORK1
        movf DEC2,W
        movwf WORK2
        movf DEC3,W
        movwf WORK3

TIMMLT:                 ;multiply COUNT for secs, mins, hrs
        movlw COUNT1    ;copy COUNT into DEC as source to be multiplied
        call COPYFD
        btfsc SWITCH,1
        goto CPH
        btfsc SWITCH,0
        goto CPM

CPS:    movlw 100       ;LSB pulses per second
        movwf MLTPL1
        movlw 0         ;MSB
        movwf MLTPL2
        call CLRANS
        call MULTI      ;answer in ANSA
        goto TIMMLT2

CPM:    movlw $70       ;LSB pulses per minute (* 6000)
        movwf MLTPL1
        movlw $17       ;MSB
        movwf MLTPL2
        call CLRANS
        call MULTI      ;answer in ANSA
        goto TIMMLT2

CPH:    movlw $10       ;LSB pulses per hour (* 3600)
        movwf MLTPL1
        movlw $0E       ;MSB
        movwf MLTPL2
        call CLRANS
        call MULTI      ;answer in ANSA

TIMMLT2: movlw WORK1     ;copy stored secs answer back to DEC
        call COPYFD     ;now divide secs by pulse count
        call DIVIDE     ;S in ANSA, Div in DEC, answer in WORK
        movlw WORK1
        goto PREPRP     ;kms

CVBIN:  clrf STORE1     ;convert decimal byte to binary
        movf INDF,W
        btfsc STATUS,Z  ;is it = 0?
        goto CVB3       ;yes = 0
        andlw 15        ;no
        movwf STORE1    ;store units
        swapf INDF,W
        andlw 15
        btfsc STATUS,Z  ;is 10s = 0
        goto CVB3       ;yes
        movwf LOOPA
CVB2:   movlw 10
        addwf STORE1,F
        decfsz LOOPA,F
        goto CVB2
CVB3:   return

MLTx60: movlw 60        ;multiply * 60
        movwf MLTPL1
        clrf MLTPL2
        call CLRANS     ;clear ANSA
        call MULTI      ;answer into ANSA
        return

ADDTIM: movf STORE1,W   ;add STORE to ANSA
        addwf ANSA1,W   ;answer into DEC1-3
        movwf DEC1
        movf STATUS,W
        andlw 1
        addwf ANSA2,W
        movwf DEC2
        movf STATUS,W
        andlw 1
        addwf ANSA3,W
        movwf DEC3
        clrf DEC4
        clrf DEC5
        return

CLRWRK: clrf WORK1
        clrf WORK2
        clrf WORK3
        clrf WORK4
        return

CLRANS: clrf ANSA1
        clrf ANSA2
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        return

CLRDEC: clrf DEC1
        clrf DEC2
        clrf DEC3
        clrf DEC4
        clrf DEC5
        return

PREPRP: call DECIML     ;convert to decimal. Answer in ANSA
        movlw ANSA1
        call PRPSHW
        goto SCREEN

PRPSHW: movwf FSR       ;prepare dual BCD data for single byte showing
        movwf STORE1
        movlw WORK2
        movwf STORE2
        movlw 3
        movwf LOOPA

PREP2:  movf STORE1,W
        movwf FSR
        movf INDF,W
        movwf STORE3
        movf STORE2,W
        movwf FSR
        movf STORE3,W
        andlw 15
        iorlw 48        ;OR decimal 48
        movwf INDF
        incf STORE2,F
        incf FSR,F
        swapf STORE3,W
        andlw 15
        iorlw 48        ;OR decimal 48
        movwf INDF
        incf STORE2,F
        incf STORE1,F
        decfsz LOOPA,F
        goto PREP2

        btfsc TSTFLG,0  ;is decimal point needed?
        goto PREP31     ;yes
        movlw 32
        movwf WORK1
        goto PREP3      ;no
PREP31: movf WORK2,W
        movwf WORK1
        movf WORK3,W
        movwf WORK2
        movlw 46        ;decimal point
        movwf WORK3

PREP3:  movlw 128
        btfss TSTFLG,0
        movlw ' ' 
        movwf STORE1
        btfss STORE1,7  ;is it 128?
        movwf DEC3
        movlw ' '
        movwf DEC4
        return

SCREEN: movlw 8
        movwf LOOPA
        movlw WORK1
        addlw 7
        movwf FSR

SCRN2:  movf INDF,W
        call LCDOUT
        decf FSR,F
        decfsz LOOPA,F
        goto SCRN2
        return          ;return to INTRPT routine

COPYFD: movwf FSR       ;copy data at FSR to DEC - 3 bytes
        movf INDF,W     ;DO NOT CALL CLRDEC with this
        movwf DEC1      ;for reasons unknown it does not work then!
        incf FSR,F
        movf INDF,W
        movwf DEC2
        incf FSR,F
        movf INDF,W
        movwf DEC3
        clrf DEC4
        clrf DEC5
        return

RESETA: movlw $20
        movwf LOOPA
        movlw $0D
        movwf FSR

RESETB: clrf INDF
        incf FSR,F
        decfsz LOOPA,F
        goto RESETB
        call DISPLY
        movlw 100        ;initial basic CLKCNT val for secs timing
        movwf CLKCNT
        bsf TSTFLG,0    ;flag for decimal point
        call LCD1
        call TIMSHW     ;show elapsed time
        call DISPLY
        return

RESETC: movlw $20
        movwf LOOPA
        movlw $0D
        movwf FSR
RESETD: clrf INDF
        incf FSR,F
        decfsz LOOPA,F
        goto RESETD
        return

RESETE: clrf CLKSEC
        clrf CLKMIN
        clrf CLKHRS
        clrf COUNT1
        clrf COUNT2
        clrf COUNT3
        call DISPLY
        movlw 100       ;initial basic CLKCNT val for secs timing
        movwf CLKCNT
        bsf TSTFLG,0    ;flag for decimal point
        call LCD1
        call TIMSHW     ;show elapsed time
        return

PAUSIT: MOVLW 20              ;1/5th sec wait set
        MOVWF CLKCNT          
        CLRF INTCON
PAUSE:  BTFSS INTCON,2        ;has a timer time-out been detected?
        GOTO PAUSE            ;no
        bcf INTCON,2          ;yes
        DECFSZ CLKCNT,F       ;dec loop, is it zero?
        GOTO PAUSE            ;no
        return                ;yes

SETDIR: call LCD1
        movlw 'S'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        btfsc SOURCE,0
        goto PINRB6

PINRB7: movlw 'M'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 128
        movwf MASK
        goto SETDR3

PINRB6: movlw 'E'
        call LCDOUT
        movlw 'X'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw '/'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw '5'
        call LCDOUT
        movlw 64
        movwf MASK

SETDR3: btfsc PORTA,4   ;is S4 still pressed?
        goto SETDR3     ;yes

SETDR2: btfsc PORTA,3   ;is MODE switch S3 pressed?
        goto ROUTE      ;yes
        btfss PORTA,4   ;is S4 pressed?
        goto SETDR2     ;no
        incf SOURCE,F   ;inc source
        goto SETDIR

CLRSCR: call LCD1
        call CLR2
        call LCD21
CLR2:   clrf LOOPA
CLR3:   movlw ' '
        call LCDOUT
        incf LOOPA,F
        btfss LOOPA,4
        goto CLR3
        return

        .END            ;final line. This line must be retained.

