;WCLOCK450.ASM 22DEC01 - John Becker - PIC World Clock
;PIC16F877 3.2768MHz xtal, WDT off, POR on
; written in TASM for TK3 assembly

                LIST P=16F877,R=DEC
                __config H'3F31' 

#DEFINE         PAGE0 BCF  3,5          ;status bit 5
#DEFINE         PAGE1 BSF  3,5          ;status bit 5

INDF:           .EQU $00                ;page 0, 1, 2, 3
OPSHUN:         .EQU $01                ;page 1, 3
PCL:            .EQU $02                ;page 0, 1, 2, 3
STATUS:         .EQU $03                ;page 0, 1, 2, 3
FSR:            .EQU $04                ;page 0, 1, 2, 3

PORTA:          .EQU $05                ;page 0
TRISA:          .EQU $05                ;page 1
PORTB:          .EQU $06                ;page 0, 2
TRISB:          .EQU $06                ;page 1, 3
PORTC:          .EQU $07                ;page 0
TRISC:          .EQU $07                ;page 1
PORTD:          .EQU $08                ;page 0
TRISD:          .EQU $08                ;page 1
PORTE:          .EQU $09                ;page 0
TRISE:          .EQU $09                ;page 1
PCLATH:         .EQU $0A                
INTCON:         .EQU $0B                ;page 0, 1, 2, 3
EEDATA:         .EQU $0C                ;page 2
EECON1:         .EQU $0C                ;page 3
EEADR:          .EQU $0D                ;page 2
EECON2:         .EQU $0D                
PIR2:           .EQU $0D                

LOOPA:          .EQU $20                ; general loop
LOOPB:          .EQU $21                ; general loop
LOOPC:          .EQU $22                ; general loop
LOOPD:          .EQU $23                ; general loop
LOOPE:          .EQU $24                ; general loop
STORE:          .EQU $25                ; temp store
STORE1:         .EQU $26                ; temp store
STORE2:         .EQU $27                ; temp store
TEMPA:          .EQU $28                ; temp store
CLKCNT:         .EQU $29                ; counter for pause val
ADRLSB:         .EQU $2A                ; low address
ADRMSB:         .EQU $2B                ; high address
ATTRIB:         .EQU $2C                ; attribute value
BITVAL:         .EQU $2D                ; val of bit to be set/reset
COUNT:          .EQU $2E                ; counter
COUNT2:         .EQU $2F                ; counter

COLUMN:         .EQU $30                ; column length holder
TIMELINE:       .EQU $31                ; noon position counter
CLKSEC:         .EQU $32                ; clock main counter - secs
CLKMIN:         .EQU $33                ; clock - mins
CLKHRS:         .EQU $34                ; clock - hours
TIMELSB:        .EQU $35                ; clock adjustment factor
TIMENSB:        .EQU $36                ; clock adjustment factor
TIMEMSB:        .EQU $37                ; clock adjustment factor
LOCATLSB:       .EQU $38                
LOCATMSB:       .EQU $39                
LOCATSEC:       .EQU $3A                ;locat clock main counter - secs
LOCATMIN:       .EQU $3B                ;locat clock - mins
LOCATHRS:       .EQU $3C                ;locat clock - hours
EVENT:          .EQU $3E                
DAY:            .EQU $3F                
MONTH:          .EQU $40                
YEAR:           .EQU $41                
MONTHLEN:       .EQU $42                
LIMIT:          .EQU $43                
WEEKDAY:        .EQU $44                
ANSA0:          .EQU $45                
ANSA1:          .EQU $46                
CLKAD0:         .EQU $47                ;clock rate adjustment lsb
CLKAD1:         .EQU $48                ;clock rate adjustment nsb
CLKAD2:         .EQU $49                ;clock rate adjustment msb
BYTE4:          .EQU $4A                
SECAD0:         .EQU $4B                
SECAD1:         .EQU $4C                
SECAD2:         .EQU $4D                
ZONEON:         .EQU $4E                
LOOPZ:          .EQU $4F                
CITYADRLSB:     .EQU $50                ; low address
CITYADRMSB:     .EQU $51                ; high address
NOONMIN:        .EQU $52                
NOONHRS:        .EQU $53                
TIMELINELSB:    .EQU $55                
TEMPSTORE:      .EQU $56                
PCLATHA:        .EQU $57                
LATITUDE:       .EQU $58

                                        ;........fixed values for commands

TXHOME:         .EQU $40                ; text home address command
TXAREA:         .EQU $41                ; text area (columns) address command
GRHOME:         .EQU $42                ; graphics home address command
GRAREA:         .EQU $43                ; graphic area (columns) address command
AWRON:          .EQU $B0                ; autowrite on command
AWROFF:         .EQU $B2                ; autowrite off command
OFFSET:         .EQU $22                ; offset command
ADPSET:         .EQU $24                ; address set command
PEEK:           .EQU $E0                ; screen peek command
CSRPOS:         .EQU $21                ; set cursor position command

                                        ;........bit values

W:              .EQU 0                  ; working reg
F:              .EQU 1                  ; file reg
Z:              .EQU 2                  ; zero status
C:              .EQU 0                  ; carry status
DC:             .EQU 1                  ; digit carry
RP0:            .EQU 5                  ; status bank reg
RP1:            .EQU 6                  ; status bank reg
RD:             .EQU 0                  ; eeprom read flag
EEPGD:          .EQU 7                  ; eecon1 reg
EEIF:           .EQU 4                  
WR:             .EQU 1                  
WREN:           .EQU 2                  
FS:             .EQU %00000000          ;fs mode set by bit 5: 1 = 6x8, 0 = 8x8

                .ORG $04
                goto 5                  
                .ORG $05
                goto START              

CSRTABLE:       movf EVENT,W            
                addwf PCL,F             ; msb = line, lsb = col
                retlw $30               ; hrs 10s
                retlw $31               ; hrs 1s
                retlw $33               ; min 10s
                retlw $34               ; min 1s
                retlw $3E               ; year 10s
                retlw $3F               ; year 1s
                nop                     
                retlw $38               ; month
                retlw $36               ; day 10s
                retlw $37               ; day 1s
                retlw $50               ; weekday
                retlw $71               ; +/- time
                retlw $00               


ROUTE:          movf EVENT,W
                addwf PCL,F
                retlw CLKHRS            
                retlw CLKHRS            
                retlw CLKMIN
                retlw CLKMIN
                retlw YEAR
                retlw YEAR
                retlw MONTH
                retlw MONTH
                retlw DAY
                retlw DAY
                retlw 0                 
                retlw 0                 

LIMITVAL:       movf EVENT,W
                addwf PCL,F
                retlw $23      ; hours         
                retlw $23      ; hours                  
                retlw $59      ; mins
                retlw $59      ; mins
                retlw $99      ; years 
                retlw $99      ; years 
                retlw $00      ; month
                retlw $00      ; month
                retlw $31      ; days
                retlw $31      ; days
                retlw 0
                retlw 0

DAY1:           andlw 7                 
                addwf PCL,F             
                retlw 'M'               
                retlw 'T'               
                retlw 'W'               
                retlw 'T'               
                retlw 'F'               
                retlw 'S'               
                retlw 'S'               
                retlw '*'               

DAY2:           andlw 7                 
                addwf PCL,F             
                retlw 'O'               
                retlw 'U'               
                retlw 'E'               
                retlw 'H'               
                retlw 'R'               
                retlw 'A'               
                retlw 'U'               
                retlw '*'               

DAY3:           andlw 7                 
                addwf PCL,F             
                retlw 'N'               
                retlw 'E'               
                retlw 'D'               
                retlw 'U'               
                retlw 'I'               
                retlw 'T'               
                retlw 'N'               
                retlw '*'               

MONTH1:         andlw 15                
                addwf PCL,F             
                retlw 'J'               
                retlw 'F'               
                retlw 'M'               
                retlw 'A'               
                retlw 'M'               
                retlw 'J'               
                retlw 'J'               
                retlw 'A'               
                retlw 'S'               
                retlw 'O'               
                retlw 'N'               
                retlw 'D'               
                retlw '*'               
                retlw '*'               
                retlw '*'               
                retlw '*'               

MONTH2:         andlw 15                
                addwf PCL,F             
                retlw 'A'               
                retlw 'E'               
                retlw 'A'               
                retlw 'P'               
                retlw 'A'               
                retlw 'U'               
                retlw 'U'               
                retlw 'U'               
                retlw 'E'               
                retlw 'C'               
                retlw 'O'               
                retlw 'E'               
                retlw '*'               
                retlw '*'               
                retlw '*'               
                retlw '*'               

MONTH3:         andlw 15                
                addwf PCL,F             
                retlw 'N'               
                retlw 'B'               
                retlw 'R'               
                retlw 'R'               
                retlw 'Y'               
                retlw 'N'               
                retlw 'L'               
                retlw 'G'               
                retlw 'P'               
                retlw 'T'               
                retlw 'V'               
                retlw 'C'               

                retlw '*'               
                retlw '*'               
                retlw '*'               
                retlw '*'               

MONTH4:         movf MONTH,W            ; vals in bcd
                andlw 15                
                addwf PCL,F             
                retlw $31
                retlw $29
                retlw $31               
                retlw $30               
                retlw $31               
                retlw $30               
                retlw $31               
                retlw $31               
                retlw $30               
                retlw $31               
                retlw $30               
                retlw $31               
                retlw $31               
                retlw $31               
                retlw $31               
                retlw $31               

FAST:           addwf PCL,F             ;fast/slow message for clock accuracy adjust
                retlw 'F'               ;0
                retlw 'A'               ;1
                retlw 'S'               ;2
                retlw 'T'               ;3
                retlw '/'               ;4
                retlw 'S'               ;5
                retlw 'L'               ;6
                retlw 'O'               ;7
                retlw 'W'               ;8

LATMONTH:       movf MONTH,W
                addwf PCL,F             ;flashing sun month position table
                retlw 36                ;0
                retlw 33                ;1
                retlw 30                ;2
                retlw 27                ;3
                retlw 24                ;4
                retlw 21                ;5
                retlw 18                ;6
                retlw 21                ;7
                retlw 24                ;8
                retlw 27                ;9
                retlw 30                ;10
                retlw 33                ;11

LATDAYPLUS:     swapf DAY,W
                andlw %00000011
                addwf PCL,F             ;flashing sun month position table 2
                retlw 0                 ;Days 1 to 9     sub 0
                retlw 255               ;Days 10 to 19   sub 1
                retlw 254               ;Days 20 to 29   sub 2
                retlw 254               ;Days 30 to 31   sub 2

LATDAYMINUS:    swapf DAY,W
                andlw %00000011
                addwf PCL,F             ;flashing sun month position table 2
                retlw 0                 ;Days 1 to 9     add 0
                retlw 1                 ;Days 10 to 19   add 1
                retlw 2                 ;Days 20 to 29   add 2
                retlw 2                 ;Days 30 to 31   add 3


LATSEASON:      movf MONTH,W
                addwf PCL,F             ;flashing sun month position table 3
                goto LATDAYPLUS
                goto LATDAYPLUS
                goto LATDAYPLUS
                goto LATDAYPLUS
                goto LATDAYPLUS
                goto LATDAYPLUS
                goto LATDAYMINUS
                goto LATDAYMINUS
                goto LATDAYMINUS
                goto LATDAYMINUS
                goto LATDAYMINUS
                goto LATDAYMINUS

START:          bcf STATUS,RP0
                bcf STATUS,RP1          
                clrf PORTA              
                movlw %11111111         
                movwf PORTB             
                movlw %00001111         ; fs low, rst low, cd ce rd wr high
                movwf PORTC             
                clrf PORTD              
                clrf PORTE              
                PAGE1                   
                movlw 255               
                movwf TRISA             ; porta as input
                movwf TRISB             ; porta as input
                movlw FS                
                movwf TRISC             ; portc as output graphic lcd control/fs
                clrf TRISD              ; portd as output graphic lcd d0-d7
                clrf TRISE              ; porte as output
                movlw %00000101         ; pull-up rs on (bit 7 lo), timer 1/25 sec
                movwf OPSHUN            ; (for 3.2768mhz xtal)
                PAGE0                   
                movlw %00011111         ; fs low,  rst cd ce rd wr high
                movwf PORTC             
                call PAUSIT             

                clrf CLKSEC             ;clear seconds counter
                clrf CLKMIN             ;clear minutes counter
                clrf CLKHRS             ;clear hours counter
                clrf TIMELSB            
                clrf TIMENSB            
                clrf TIMEMSB            
                movlw 7                 
                movwf LOCATMSB          
                movlw %11111000         
                movwf LOCATLSB          
                clrf LOCATSEC           ;clear locat seconds counter
                clrf LOCATMIN           ;clear locat minutes counter
                clrf LOCATHRS           ;clear locat hours counter
                clrf ZONEON             
                clrf NOONMIN            
                clrf NOONHRS            
                clrf LATITUDE

                movlw 25                ;initial basic clkcnt val for secs timing
                movwf CLKCNT            

GRAPHIC:        movlw 16                
                movwf COLUMN            ;set column length
                call SETUP              

                movlw %10000000         ; internal cg ram mode, or
                call SENDCMD            ; send command
                movlw %10011111         ; text & graphic on, cursor & blink on
                call SENDCMD            ; send command

                movlw %11111111         ; bits 0-2 indicate bit affected - time line
                movwf TIMELINELSB       ; bit 3 high set, low = clear
                clrf TIMELINE          

                call MAP                
                call LOCAT              
                clrf PCLATH             
                clrf EVENT              

                movlw 13                
                call PRMGET             
                movwf CLKHRS            
                movlw 14                
                call PRMGET             
                movwf CLKMIN            

                movlw 0                 
                call PRMGET             
                movwf DAY               
                movlw 1                 
                call PRMGET             
                movwf MONTH             
                movlw 2                 
                call PRMGET             
                movwf YEAR              
                movlw 3                 
                call PRMGET             
                movwf WEEKDAY           
                movlw 4                 
                call PRMGET             
                movwf CLKAD0            
                movlw 5                 
                call PRMGET             
                movwf CLKAD1            
                movlw 6                 
                call PRMGET             
                movwf CLKAD2            
                movlw 7                 
                call PRMGET             
                xorlw 'W'               ; check if unit has been used before
                btfss STATUS,Z          ; if not, reset clock factors etc
                goto SETADJ             
                movlw 8                 
                call PRMGET             
                xorlw 'C'               
                btfss STATUS,Z          
                goto SETADJ             
                movlw 9                 
                call PRMGET             
                xorlw 'L'               
                btfss STATUS,Z          
                goto SETADJ             
                movlw 10                
                call PRMGET             
                xorlw 'O'               
                btfss STATUS,Z          
                goto SETADJ             
                movlw 11                
                call PRMGET             
                xorlw 'C'               
                btfss STATUS,Z          
                goto SETADJ             
                movlw 12                
                call PRMGET             
                xorlw 'K'               
                btfss STATUS,Z          
                goto SETADJ             
                goto NOADJ              

SETADJ:         clrf CLKAD0             
                clrf CLKAD1             
                movlw $80               
                movwf CLKAD2            
                movlw 2                 
                movwf YEAR              ;set for 2002 jan02 tues 00:00
                clrf MONTH              
                movlw 1                 
                movwf WEEKDAY           
                clrf CLKHRS             
                clrf CLKMIN             
                movlw 1                 
                movwf DAY               

NOADJ:          call SETCURSOR          
                call ROUTE              
                movwf FSR               
                call LIMITVAL           
                movwf LIMIT             

                call MONTH4             ; get days in month
                movwf MONTHLEN          

                bcf INTCON,2            
                movlw 12                
                movwf CLKCNT            

                clrf LOOPD              
                clrf ADRLSB             ; set column
                movlw 14                ; set line
                call GLINE              ; multiply by line length to get address
                call SCREENADR          
                movlw AWRON             ; auto write on
                call SENDCMD            ; send command
                clrf LOOPE              

CLRMAP:         movlw 0                 
                call AUTOWRITE          
                decfsz LOOPE,F          
                goto CLRMAP             

                movlw AWROFF            ; set auto write on
                call SENDCMD            ; send command

                call SHOWTIME           
                call ALTTIM             

INTRPT2:        btfss INTCON,2          ;has a timer time-out been detected?
                goto INTRPT2            ;no
                bcf INTCON,2            ;yes
                decfsz CLKCNT,F         
                goto INTRPT2            

                movlw 12                
                movwf CLKCNT            

                btfss portb,2           
                goto ENDSETALL          

                btfsc portb,1           
                goto INT2               

                incf EVENT,F            
                movlw 6                 
                xorwf EVENT,W           
                btfsc STATUS,Z          
                incf EVENT,F            

                call SETCURSOR          
                call ROUTE              
                movwf FSR               
                call LIMITVAL           
                movwf LIMIT             

                movf EVENT,W            
                andlw %00001000         
                xorlw 8                 
                btfss STATUS,Z          
                goto INT1               
                movf MONTHLEN,W         
                movwf LIMIT             

INT1:           btfss portb,1           ; wait release rb2
                goto INT1               

                movf EVENT,W            
                xorlw 11                
                btfsc STATUS,Z          
                goto ADJTIM             

INT2:           btfsc PORTB,0           
                goto ENDSET             

                movf EVENT,W            
                xorlw 7                 
                btfsc STATUS,Z          
                goto INCMONTH           

                movf EVENT,W            
                xorlw 10                
                btfsc STATUS,Z          
                goto INCWEEKDAY         

                btfsc EVENT,0           
                goto INC1               

INC10:          movlw %11110000         ; inc tens of value
                andwf LIMIT,F           

                movlw 16                
                addwf INDF,F            

                movf INDF,W             
                andlw %11110000         ; limit check to just tens
                subwf LIMIT,W           ;is count =<  than allowed?
                movlw %00001111         ; preload W in case reset is needed
                btfss STATUS,C
                andwf INDF,F            ;no, it's greater, so clear tens but keep units
                goto SHWSET

INC1:           incf INDF,F             ; inc units
                movlw %00001010         ; is it = 10?
                andwf INDF,W            
                xorlw %00001010         
                btfss STATUS,Z          
                goto INC2               ; no
                movlw %11110000         ; yes
                andwf INDF,F            ; clear units
                goto SHWSET             

INC2:           movf INDF,W             
                subwf LIMIT,W           ;is count =<  than allowed?
                btfsc STATUS,C          
                goto SHWSET             
                movlw %11110000         ; yes
                andwf INDF,F            ; clear units
                goto SHWSET             

INCMONTH:       incf MONTH,F            
                movf MONTH,W            
                xorlw %00001100         ; is month = 12?
                btfss STATUS,Z          
                goto ENDMONTH           
                clrf MONTH              ; reset units

ENDMONTH:       call SHOWTIME           
                call MONTH4             ; get days in month
                movwf MONTHLEN          

                movf MONTH,W            ; is month = feb ?
                xorlw 1                 
                btfss STATUS,Z          
                goto ENDSET             ; no

                movlw %00000011         ; check for leap year
                andwf YEAR,W            
                btfsc STATUS,Z          
                goto ENDSET             ; no
                movlw $28               
                movwf MONTHLEN          
                goto ENDSET             

INCWEEKDAY:     incf WEEKDAY,F          
                movlw 7                 
                xorwf WEEKDAY,W         
                btfsc STATUS,Z          
                clrf WEEKDAY            

SHWSET:         movf DAY,W              ; is day = 0?
                btfsc STATUS,Z          
                incf DAY,F              ; yes, so = 1

                call SHOWTIME           
;                call TESTSHOW            ;****temp

ENDSET:         btfss PORTB,0           ; wait release rb0
                goto ENDSET             
                goto INTRPT2            

ADJTIM:         call ALTTIM             

INTRPT3:        btfss portb,2           
                goto ENDSETALL          
                btfss INTCON,2          ;has a timer time-out been detected?
                goto INTRPT3            ;no
                bcf INTCON,2            ;yes
                decfsz CLKCNT,F         
                goto INTRPT3            
                movlw 12                
                movwf CLKCNT            

                btfss PORTB,0           
                goto ALTUP              
                btfss portb,1           
                goto ALTDN              
                goto INTRPT3            

ALTUP:          incfsz CLKAD0,F         
                goto ALTUP2             
                incfsz CLKAD1,F         
                goto ALTUP2             
                incf CLKAD2,F           

ALTUP2:         btfss PORTB,0           
                goto ALTUP2             
                call ALTTIM             
                goto INTRPT3            

ALTDN:          movlw 1                 
                subwf CLKAD0,F          
                btfsc STATUS,C          
                goto ALTDN2             
                movlw 1                 
                subwf CLKAD1,F          
                btfsc STATUS,C          
                goto ALTDN2             
                movlw 1                 
                subwf CLKAD2,F          
                btfsc STATUS,C          

ALTDN2:         btfss portb,1           
                goto ALTDN2             
                call ALTTIM             
                goto INTRPT3            

ENDSETALL:      call STOREPROM          

                movlw %10011100         ; text & graphic on, cursor & blink off
                call SENDCMD            ; send command
                call CLRTXT             

                movf CLKMIN,W           
                movwf LOCATMIN          
                movf CLKHRS,W           
                movwf LOCATHRS          

                call MAP                
                call CLKSHW             
                call DATESHW            
                call LOCAT              
                call NOONCLK            

WAITIT:         comf PORTB,W            
                andlw %00000111         
                btfss STATUS,Z          
                goto WAITIT             
                call SETLATITUDE
                call SUN
                goto INTRPT

ALTTIM:         clrf ADRMSB             
                movlw 0                 ; set column
                call LINE7              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command
                movlw '+'               ;colon
                call LCDOUT             ;no, send to lcd
                movlw '/'               ;colon
                call LCDOUT             ;no, send to lcd
                movlw '-'               ;colon
                call LCDOUT             ;no, send to lcd
                movlw ' '               ;colon
                call LCDOUT             ;no, send to lcd
                call SHWALT             

                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command
                return                  

SHWALT:         btfss CLKAD1,7          ;show real-time clock adjustment factor
                goto FASTER             

SLOWER:         movlw '-'               
                call LCDOUT             
                movf CLKAD1,W           
                movwf ANSA1             
                movf CLKAD0,W           
                movwf ANSA0             
                comf ANSA0,F            
                incf ANSA0,F            
                btfsc STATUS,Z          
                incf ANSA1,F            
                comf ANSA1,F            
                movf ANSA1,W            
                call LCDHEX             
                movf ANSA0,W            
                call LCDHEX             
                return                  

FASTER:         movlw '+'               
                call LCDOUT             
                movf CLKAD1,W           
                call LCDHEX             
                movf CLKAD0,W           
                call LCDHEX             
                return                  

LCDHEX:         movwf STORE2            ;split & format decimal byte as hex for lcd
                swapf STORE2,W          ;get tens nibble
                andlw 15                
                movwf STORE1            
                addlw 6                 
                btfss STATUS,DC         
                goto HEX2               
                movf STORE1,W           
                addlw 55                ;set as alpha
                goto HEX3               
HEX2:           movf STORE1,W           
                iorlw 48                ;set as numeral
HEX3:           call LCDOUT             ;send it
                movf STORE2,W           ;get units
                andlw 15                
                movwf STORE1            
                addlw 6                 
                btfss STATUS,DC         
                goto HEX4               
                movf STORE1,W           
                addlw 55                ;set as alpha
                goto HEX5               
HEX4:           movf STORE1,W           
                iorlw 48                ;set as numeral
HEX5:           call LCDOUT             
                return                  

STOREPROM:      clrf LOOPB              ;store data to eeprom
                movf DAY,W              ;0
                call INCPRM             
                movf MONTH,W            ;1
                call INCPRM             
                movf YEAR,W             ;2
                call INCPRM             
                movf WEEKDAY,W          ;3
                call INCPRM             
                movf CLKAD0,W           ;4
                call INCPRM             
                movf CLKAD1,W           ;5
                call INCPRM             
                movf CLKAD2,W           ;6
                call INCPRM             
                movlw 'W'               ;7
                call INCPRM             
                movlw 'C'               ;8
                call INCPRM             
                movlw 'L'               ;9
                call INCPRM             
                movlw 'O'               ;10
                call INCPRM             
                movlw 'C'               ;11
                call INCPRM             
                movlw 'K'               ;12
                call INCPRM             
                movf CLKHRS,W           ;13
                call INCPRM             
                movf CLKMIN,W           ;14
                call INCPRM             
                return                  

                                        ;******** start of main program ***********

INTRPT:         btfss INTCON,2          ;has a timer time-out been detected?
                goto INTRPT             ;no
                bcf INTCON,2            ;yes

                call CLKADD             ;update time
                btfss portb,2
                goto CITY
                goto INTRPT             

CLKADD:         decfsz CLKCNT,F         ;dec 1/25 clock counter. is it = 0?
                return                  ;no

                btfsc PORTB,0           ; yes, is rb0 switch pressed (=0) ?
                goto CLK2               ; no

                movlw 8                 ; yes, inc dotted (local) timeline value 8 times
                movwf LOOPA             
CLK1:           call INCTIMELINE        
                decfsz LOOPA,F          
                goto CLK1               

                call MAP                
                call LOCAT              
                goto CLK3               

CLK2:           btfsc portb,1           ; is rb2 switch pressed (=0) ?
                goto CLK3               ; no

                call INCTIMELINE        ; yes, inc dotted (local) timeline value once
                call MAP                
                call LOCAT              

CLK3:           movlw 25                ; reset start value of clkcnt
                movwf CLKCNT            

                clrf BYTE4
                movlw SECAD0            
                movwf FSR               
                movf CLKAD0,W           ;secs add step lsb (decimal place)
                call DADD0              
                movlw SECAD1            
                movwf FSR               
                movf CLKAD1,W           ;secs add step nsb (decimal place)
                call DADD1              
                movlw SECAD2            
                movwf FSR               
                movf CLKAD2,W           ;secs add step msb (decimal place)
                call DADD2              
                movf BYTE4,W            ;is there an overflow i.e. has 1 sec been counted?
                btfsc STATUS,Z          
                return                  

SECCLK:         incf CLKSEC,F           ;inc secs in bcd

;                goto DAYCLK             ; ****....

                movlw 6                 ;check units >9
                addwf CLKSEC,W          ;if 6 is added is there a digit carry?
                btfss STATUS,DC         
                goto LOCATCLK           
                movwf CLKSEC            ;yes
                xorlw %01100000         ;xor w with 96 (bcd 60)
                btfss STATUS,Z          ;is the answer = 0 (secs = 60)?
                goto LOCATCLK           
                clrf CLKSEC             ;yes, clear secs counter

MINCLK:                                 
                call NOONLINE           

                call MAP                
                call LOCAT              

                incf CLKMIN,F           ;inc mins in bcd
                movlw 6                 ;check units >9
                addwf CLKMIN,W          ;if 6 is added is there a digit carry?
                btfss STATUS,DC         
                goto LOCATCLK           
                movwf CLKMIN            ;yes
                xorlw 96                ;xor w with 96 (bcd 60)
                btfss STATUS,Z          ;is the answer = 0 (mins = 60)?
                goto LOCATCLK           
                clrf CLKMIN             ;yes, clear mins counter

HRSCLK:         incf CLKHRS,F           ;inc hrs in bcd
                movlw 6                 ;check units >9
                addwf CLKHRS,W          ;if 6 is added is there a digit carry?
                btfsc STATUS,DC         
                movwf CLKHRS            ;yes

                movf CLKHRS,W           
                xorlw %00100100         ;xor w with bcd 24 (check total=24)
                btfss STATUS,Z          ;is the answer = 1 (equality)
                goto LOCATCLK           
                clrf CLKHRS             ;yes, clear hours count

WEEKCLK:        incf WEEKDAY,F          ;inc weekday in binary
                movlw 7                 
                xorwf WEEKDAY,W         
                btfsc STATUS,Z          
                clrf WEEKDAY            

DAYCLK:         incf DAY,F              ;inc days in bcd
                movlw 6                 ;check units >9
                addwf DAY,W             ;if 6 is added is there a digit carry?
                btfsc STATUS,DC         
                movwf DAY               ;yes

                call SETLATITUDE        ; update sun's position

                movf DAY,W
                xorwf MONTHLEN,W        ;xor w with month length
                btfss STATUS,Z          ;is the answer = 1 (equality)
                goto STORECLK
                movlw 1                 
                movwf DAY               ;yes, reset days count

MONTHCLK:       incf MONTH,F            ;inc month in binary
                movlw 12                ; dec = 11
                xorwf MONTH,W           
                btfsc STATUS,Z          
                clrf MONTH              ; jan = 0

                call MONTH4             ; get days in month
                addlw 1                 ; monthlen is 1 > than true
                movwf MONTHLEN          

                movf MONTH,W            ; is month = feb ?
                xorlw 1                 
                btfss STATUS,Z          
                goto YEARCLK            ; no

                movlw $30               ; monthlen is 1 > than true
                movwf MONTHLEN          
                movlw %00000011         ; check for leap year
                andwf YEAR,W            
                btfsc STATUS,Z          
                goto YEARCLK            ; no
                movlw $29               ; monthlen is 1 > than true
                movwf MONTHLEN          

YEARCLK:        movf MONTH,W            
                btfss STATUS,Z          
                goto STORECLK           
                incf YEAR,F             ;inc month in bcd
                movlw 6                 ;check units >9
                addwf YEAR,W            ;if 6 is added is there a digit carry?
                btfsc STATUS,DC         
                movwf YEAR              ;yes

                movf YEAR,W             
                xorlw $A0               ;xor w with bcd 100 (check total=100)
                btfsc STATUS,Z          ;is the answer = 1 (equality)
                clrf YEAR               

STORECLK:       call STOREPROM          

LOCATCLK:       incf LOCATSEC,F         ;inc secs in bcd
                movlw 6                 ;check units >9
                addwf LOCATSEC,W        ;if 6 is added is there a digit carry?
                btfss STATUS,DC         
                goto CLKSHW             
                movwf LOCATSEC          ;yes
                xorlw %01100000         ;xor w with 96 (bcd 60)
                btfss STATUS,Z          ;is the answer = 0 (secs = 60)?
                goto CLKSHW             
                clrf LOCATSEC           ;yes, clear secs counter

MINLOCAT:       incf LOCATMIN,F         ;inc mins in bcd
                movlw 6                 ;check units >9
                addwf LOCATMIN,W        ;if 6 is added is there a digit carry?
                btfss STATUS,DC         
                goto CLKSHW             
                movwf LOCATMIN          ;yes
                xorlw 96                ;xor w with 96 (bcd 60)
                btfss STATUS,Z          ;is the answer = 0 (mins = 60)?
                goto CLKSHW             
                clrf LOCATMIN           ;yes, clear mins counter

HRSLOCAT:       incf LOCATHRS,F         ;inc hrs in bcd
                movlw 6                 ;check units >9
                addwf LOCATHRS,W        ;if 6 is added is there a digit carry?
                btfsc STATUS,DC         
                movwf LOCATHRS          ;yes

                movf LOCATHRS,W         
                xorlw %00100100         ;xor w with bcd 24 (check total=24)
                btfsc STATUS,Z          ;is the answer = 1 (equality)
                clrf LOCATHRS           ;yes, clear hours count

CLKSHW:         clrf ADRMSB             
                movlw 0                 ; set column
                call LINE7              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command

                movf CLKHRS,W           ;get hrs
                call LCDFRM             ;format and sent it to lcd
                movlw ':'               ;colon
                call LCDOUT             ;send to lcd
                movf CLKMIN,W           ;get mins
                call LCDFRM             ;format and send to lcd
                movlw '.'               ;decimal point
                call LCDOUT             ;send to lcd
                movf CLKSEC,W           ;get secs
                call LCDFRM             ;format and send to lcd

                btfsc ZONEON,0          
                goto ENDSHW             

                movlw ' '               
                call LCDOUT             ;send to lcd
                movlw ' '               
                call LCDOUT             ;send to lcd
                movlw 'L'               
                call LCDOUT             ;send to lcd

                movf LOCATHRS,W         ;get hrs
                call LCDFRM             ;format and sent it to lcd
                movlw ':'               ;colon
                call LCDOUT             ;send to lcd
                movf LOCATMIN,W         ;get mins
                call LCDFRM             ;format and send to lcd
ENDSHW:         movlw AWROFF            ; auto write off
                call SENDCMD            ; send command

                call SUN

                btfsc ZONEON,0
                return                  
                goto DATESHW            
                                        ;................

DADD0:          addwf INDF,F            ; adding routine for secs timing adjustment
                incf FSR,F              
                movf STATUS,W           
                andlw 1                 
DADD1:          addwf INDF,F            
                incf FSR,F              
                movf STATUS,W           
                andlw 1                 
DADD2:          addwf INDF,F            
                movf STATUS,W           
                andlw 1                 
                addwf BYTE4,F           
                return                  
                                        ;............

NOONLINE:       movlw 193               ; add equiv to .088889 = 22.75 relative to 256
                addwf TIMELSB,F         
                btfss STATUS,C          ; is there a carry (overflow)?
                goto MCL2               ; no
                incfsz TIMENSB,F        ; yes, inc nsb, is there a rollover?
                goto MCL2               ; no
                incf TIMEMSB,F          ; yes, inc msb

MCL2:           movlw 22                
                addwf TIMENSB,F         
                btfss STATUS,C          ; is there a carry (overflow)?
                goto MCL3               ; no
                incf TIMEMSB,F          ; yes, inc msb
MCL3:                                   
                movf TIMEMSB,W          
                iorlw %11111000         
                movwf TIMELINELSB       

                rlf TIMEMSB,W           
                movwf TIMELINE          
                comf TIMELINE,F         
                swapf TIMELINE,W        
                andlw %00001111         
                movwf TIMELINE          
                return                  

                                        ;..............

NOONCLK:        movf CLKMIN,W           ; count for determining position of solid "noon" line
                xorwf NOONMIN,W         
                btfss STATUS,Z          
                goto NCLK2              
                movf CLKHRS,W           
                xorwf NOONHRS,W         
                btfss STATUS,Z          
                goto NCLK2              
                call NOONLINE           
                return                  

NCLK2:          call NOONLINE           
                incf NOONMIN,F          ;inc mins in bcd
                movlw 6                 ;check units >9
                addwf NOONMIN,W         ;if 6 is added is there a digit carry?
                btfss STATUS,DC         
                goto NOONCHK            
                movwf NOONMIN           ;yes
                xorlw 96                ;xor w with 96 (bcd 60)
                btfss STATUS,Z          ;is the answer = 0 (mins = 60)?
                goto NOONCHK            
                clrf NOONMIN            ;yes, clear mins counter

NOONCLK2:       incf NOONHRS,F          ;inc hrs in bcd
                movlw 6                 ;check units >9
                addwf NOONHRS,W         ;if 6 is added is there a digit carry?
                btfsc STATUS,DC         
                movwf NOONHRS           ;yes

                movf NOONHRS,W          
                xorlw %00100100         ;xor w with bcd 24 (check total=24)
                btfss STATUS,Z          ;is the answer = 1 (equality)
                goto NOONCHK            
                clrf NOONHRS            ;yes, clear hours count

NOONCHK:        goto NOONCLK            

                                        ;................

LCDFRM:         movwf STORE2            ;split & format decimal byte for lcd
                swapf STORE2,W          ;swap byte into w to get tens
                andlw 15                ;and to get nibble
                iorlw 48                ;or with 48 to make ascii value
                call LCDOUT             ;send to lcd
                movf STORE2,W           ;get units
                andlw 15                ;and to get nibble
                iorlw 48                ;or with 48 to make ascii value
                call LCDOUT             ;send to lcd
                return                  

LCDOUT:         addlw 224               ; +224 is same as -32 for conversion from ascii
                call AUTOWRITE          ; auto write and increment
                return                  
                                        ;************* inc time line

INCTIMELINE:                            
                decf LOCATLSB,W         
                iorlw %11111000         
                movwf LOCATLSB          
                comf LOCATLSB,W         
                andlw %00000111         
                btfss STATUS,Z          
                goto CLK2A              
                incf LOCATMSB,W         
                andlw %00001111         
                movwf LOCATMSB          

CLK2A:                                  ; add time zone displacement per div
                clrf PCLATH             
                bsf PCLATH,3            
                bsf PCLATH,2            
                bsf PCLATH,0            
                call TIMEZONE           
                clrf PCLATH             

CLK2B:                                  
                addwf LOCATMIN,F        ; add mins in bcd (30 or 0)
                movlw 6                 ;check units >9
                addwf LOCATMIN,W        ;if 6 is added is there a digit carry?
                btfsc STATUS,DC         
                movwf LOCATMIN          ;yes
                movlw 160               ;check tens > 60
                addwf LOCATMIN,W        ;if 160 is added is there a carry?
                btfss STATUS,C          
                goto CLK2C              ;no
                movwf LOCATMIN          ;yes

                incf LOCATHRS,F         ;inc hrs in bcd
                movlw 6                 ;check units >9
                addwf LOCATHRS,W        ;if 6 is added is there a digit carry?
                btfsc STATUS,DC         
                movwf LOCATHRS          ;yes
                movf LOCATHRS,W         
                xorlw %00100100         ;xor w with bcd 24 (check total=24)
                btfsc STATUS,Z          ;is the answer = 1 (equality)
                clrf LOCATHRS           ;yes, clear hours count

CLK2C:          return                  

                                        ;.............

DATESHW:        clrf ADRMSB             
                movlw 0                 ; set column
                call LINE5              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command
                movf WEEKDAY,W          ; get weekday
                call DAY1               
                call LCDOUT             
                movf WEEKDAY,W          ; get weekday
                call DAY2               
                call LCDOUT             
                movf WEEKDAY,W          ; get weekday
                call DAY3               
                call LCDOUT             
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command

                clrf ADRMSB             
                movlw 0                 ; set column
                call LINE2              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command
                movf DAY,W              ;get day
                call LCDFRM             ;format and sent it to lcd
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command

                clrf ADRMSB             
                movlw 0                 ; set column
                call LINE3              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command
                movf MONTH,W            ;get month
                call MONTH1             
                call LCDOUT             
                movf MONTH,W            ;get month
                call MONTH2             
                call LCDOUT             
                movf MONTH,W            ;get month
                call MONTH3             
                call LCDOUT             
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command

                clrf ADRMSB             
                movlw 0                 ; set column
                call LINE4              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command
                movlw '2'               
                call LCDOUT             ;send to lcd
                movlw '0'               
                call LCDOUT             ;send to lcd
                movf YEAR,W             ;get year
                call LCDFRM             ;format and sent it to lcd
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command
                return                  

                                        ;******* show map ******************

MAP:            btfsc ZONEON,0          
                return                  

                clrf PCLATH             
                clrf LOOPD              
                clrf ADRLSB             ; set column
                movlw 0                 ; set line
                call GLINE              ; multiply by line length to get address
                call SCREENADR          
                movlw AWRON             ; auto write on
                call SENDCMD            ; send command
                clrf LOOPE              


MAP2:           movf LOOPE,W            
                bsf PCLATH,3            
                call WCLOCK             
                bcf PCLATH,3            
                call OUTDATA            
                incf LOOPE,F            
                incf LOOPE,W            
                btfss STATUS,Z          
                goto MAP2               
                movf PCLATH,W           ; is pclath = 3 ? (affects correctness of box rhs box)
                andlw %00000111         
                xorlw 3                 
                movlw 1                 
                btfsc STATUS,Z          
                movlw 0                 
                call OUTDATA            
                clrf LOOPE              
                incf PCLATH,F           ; inc pclath for next table block of 256
                movf PCLATH,W           
                andlw %00000111         
                xorlw 4                 
                btfss STATUS,Z          
                goto MAP2               

                clrf PCLATH             
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command

                return                  

                                        ;******* show city time factors ******

CITY:           call INTRPT4            
                btfss portb,2           ; wait switch
                goto CITY               
                call STOREPROM
                clrf PCLATHA
                bsf PCLATHA,4           

                PAGE1                   
                movlw %00100000         
                movwf TRISC             ; portc as output graphic lcd control/fs
                PAGE0                   

                movlw 22                
                movwf COLUMN            ;set column length
                call TEXTAREA           
                clrf LOOPE              

                movlw %10010100         ; text on, graphic off, cursor & blink off
                call SENDCMD            ; send command
                bsf ZONEON,0            

CITY01:         call CLRTXT             
                call CLKSHW             

                clrf COUNT              
                clrf COUNT2             

                movlw 7                 
                movwf LOOPZ             
                clrf ADRLSB             
                clrf ADRMSB             
                clrf CITYADRLSB         
                clrf CITYADRMSB         

CITY0:          call SCREENADR          
                movlw AWRON             ; auto write on
                call SENDCMD            ; send command

CITY1:          call CITY2              ; look for space following numeral
                movf STORE,W            
                xorlw '&'               ; ... ' '
                btfsc STATUS,Z          
                goto CITY5              

                movf STORE,W            ; end of data marker
                xorlw '#'               
                btfsc STATUS,Z          
                goto ENDCITY            

;                movf STORE,W            ; substitute space for "_"
;                xorlw '_'               
;                btfss STATUS,Z          
;                goto CITY1A             
;                movlw ' '               
;                movwf STORE             

CITY1A:         movf STORE,W
                xorlw '-'               
                btfsc STATUS,Z          
                goto CITY4              

                movf STORE,W
                xorlw '+'               
                btfss STATUS,Z          
                goto CITY3              
CITY4:          movf COUNT2,W           ; is count = numeral start col?
                addlw 238               
                btfsc STATUS,C          
                goto CITY4A             ; yes
                movlw ' '               
                call LCDOUT             
                incf COUNT,F            
                incf COUNT2,F           
                goto CITY4              
CITY4A:         movf COUNT2,W           ; is count at line end?
                addlw 235               
                btfsc STATUS,C          
                goto CITY5              ; yes
                goto CITY3              

CITY5:          clrf COUNT2             
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command
                movf COLUMN,W           ; set address for next line of 8
                addwf CITYADRLSB,F      
                btfsc STATUS,C          
                incf CITYADRMSB,F       
                movf CITYADRLSB,W       
                movwf ADRLSB            
                movf CITYADRMSB,W       
                movwf ADRMSB            
                decfsz LOOPZ,F          
                goto CITY0              

WAITSW:         call INTRPT4            
                btfss portb,2           ; if S3 pressed exit to map
                goto ENDZONES           
                btfss portb,0           ; wait for switch press to start next page
                goto WAIT2             
                btfsc portb,1           ; wait for switch press to start next page
                goto WAITSW             

WAIT2:          call INTRPT4            
                comf PORTB,W            ; wait for switch release
                andlw %00000111         
                btfss STATUS,Z          
                goto WAIT2              
                goto CITY01             

CITY3:          movf STORE,W            ; show character
                call LCDOUT             
                goto CITY1              

ENDCITY:                                
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command

WAITSW5:        call INTRPT4            
                btfss portb,2           
                goto ENDZONES           
                btfss portb,0           ; wait for switch press to start next page
                goto WAITSW3            
                btfsc portb,1           ; wait for switch press to start next page
                goto WAITSW5            

WAITSW3:        call INTRPT4            
                btfss portb,2           
                goto ENDZONES           
                btfsc portb,0           ; wait for switch press to start from page 1
                goto WAITSW4            
                btfss portb,1           ; wait for switch press to start from page 1
                goto WAITSW3            

WAITSW4:        call INTRPT4            
                comf PORTB,W            ; wait for switch release
                andlw %00000111         
                btfss STATUS,Z          
                goto WAITSW4            
                goto CITY               

CITY2:                                  
                movf PCLATHA,W          
                iorlw %00010000         
                movwf PCLATH            
                movf LOOPE,W            
                call CITYTIME           
                clrf PCLATH             
                movwf STORE             
                incf COUNT,F            
                incf COUNT2,F           
                incf LOOPE,F            
                incf LOOPE,W            
                btfss STATUS,Z          
                return                  
                clrf LOOPE              
                incf PCLATHA,F          
                return                  

ENDZONES:                               
ENDZONE2:       call INTRPT4            
                btfss portb,2           
                goto ENDZONE2           

                PAGE1                   
                movlw %00000000         
                movwf TRISC             ; portc as output graphic lcd control/fs
                PAGE0                   

                movlw 16                
                movwf COLUMN            ;set column length
                call TEXTAREA           
                call CLRGRAPH           
                clrf LOOPE              

                movlw %10011100         ; text & graphic on, cursor & blink off
                call SENDCMD            ; send command

                clrf ZONEON             
                call CLRTXT             
                call MAP                
                call LOCAT              
                call CLKSHW             
                movlw 12                
                movwf CLKCNT            
                goto INTRPT             

INTRPT4:        btfss INTCON,2          ;has a timer time-out been detected?
                goto INTRPT4            ;no
                bcf INTCON,2            ;yes
                decfsz CLKCNT,F         ;dec 1/25 clock counter. is it = 0?
                return                  ;no
                call CLK3               
                return                  

                                        ;********** sun overhead line (solid)*******


SETLATITUDE:    call LATMONTH           ; get graph line value
                movwf LATITUDE
                call LATSEASON
                addwf LATITUDE,F
                return
                                        ;********** flashing sun pixel *******

SUN:            btfsc ZONEON,0          
                return                  

                movf TIMELINE,W         
                movwf ADRLSB            
                movf LATITUDE,W
                call GLINE              ; multiply by line length to get address

                movlw 4               
                movwf LOOPD             
SUN2:           movf TIMELINELSB,W      ; draw up
                btfsc CLKSEC,0
                andlw %11110111
                call BITWRITE
                movf COLUMN,W           
                addwf ADRLSB,F          
                btfsc STATUS,C          
                incf ADRMSB,F           
                decfsz LOOPD,F          
                goto SUN2              
                return                  

                                        ;********** locat time line (dotted) *********


LOCAT:          btfsc ZONEON,0          
                return                  

                movf LOCATMSB,W         
                movwf ADRLSB            
                movlw 0                 ; set graph line
                call GLINE              ; multiply by line length to get address

                movlw 28                
                movwf LOOPD             
LOCAT2:         movf LOCATLSB,W         
                call BITWRITE           
                movf COLUMN,W           
                addwf ADRLSB,F          
                btfsc STATUS,C          
                incf ADRMSB,F           
                movf COLUMN,W           
                addwf ADRLSB,F          
                btfsc STATUS,C          
                incf ADRMSB,F           
                decfsz LOOPD,F          
                goto LOCAT2             
                return                  

                                        ;********** start of sub-routines ***************

PAUSIT:         movlw 5                 ; pause routine, 1/5th sec
                movwf CLKCNT            
                clrf INTCON             
PAUSE:          btfss INTCON,2          
                goto PAUSE              
                bcf INTCON,2            
                decfsz CLKCNT,F         
                goto PAUSE              
                return                  

                                        ;................

SETCURSOR:      call CSRTABLE           ; get cursor line & col
                movwf STORE1            
                andlw 15                
                movwf ADRLSB            
                swapf STORE1,W          
                andlw 15                
                movwf ADRMSB            
                call CMDADR             ; send command address for cursor position
                movlw CSRPOS            ; cursor position command
                call SENDCMD            ; send command
                movlw %10100111         ; 8-line cursor
                call SENDCMD            ; send command
                return                  ;


                                        ;...............

                                        ;write data to eeprom routine modified for pic16f87x devices
                                        ;according to data sheet ds30292a page 43

                                        ;this routine is entered with w holding
                                        ;the eeprom byte address at which data
                                        ;is to be stored. the data to be stored
                                        ;is held in store1.
SETPRM:         bsf STATUS,RP1          ;set for page 2
                bcf STATUS,RP0          
                movwf EEADR             ;copy w into eeadr to set eeprom address
                bcf STATUS,RP1          ;set for page 0
                movf STORE1,W           ;get data value from store1 and hold in w
                bsf STATUS,RP1          ;set for page 2
                movwf EEDATA            ;copy w into eeprom data byte register
                bsf STATUS,RP0          ;set for page 3
                bcf EECON1,EEPGD        ;point to data memory
                bsf EECON1,WREN         ;enable write flag

MANUAL:         movlw $55               ;these lines cause the action required by
                movwf EECON2            ;by the eeprom to store the data in eedata
                movlw $AA               ;at the address held by eeadr.
                movwf EECON2            
                bsf EECON1,WR           ;set the ``perform write'' flag
                bcf STATUS,RP1          ;set for page 0
                bcf STATUS,RP0          

CHKWRT:         btfss PIR2,EEIF         ;wait until bit 4 of pir2 is set
                goto CHKWRT             
                bcf PIR2,EEIF           ;clear bit 4 of pir2
                return                  

                                        ;..............

INCPRM:         movwf STORE1            ;used for consecutive writes to eeprom
                movf LOOPB,W            
                incf LOOPB,F            
                goto SETPRM             

                                        ;..........

                                        ;read data from eeprom routine modified for pic16f87x devices
                                        ;according to data sheet ds30292a page 43

                                        ;this routine is entered with w holding
                                        ;the eeprom byte address to be read.
PRMGET:         bsf STATUS,RP1          ;set for page 2
                bcf STATUS,RP0          
                movwf EEADR             ;copy w into eeadr to set eeprom address
                bsf STATUS,RP0          ;set for page 3
                bcf EECON1,EEPGD        ;point to data memory
                bsf EECON1,RD           ;enable read flag
                bcf STATUS,RP0          ;set for page 2
                movf EEDATA,W           ;read eeprom data now in eedata into w
                bcf STATUS,RP1          ;set for page 0
                return                  


BITWRITE:                               ; ** write single single bit data routine **
                movwf BITVAL            
                call SCREENADR          ; set screen write address
                movf BITVAL,W           
                call SENDCMD            ; send command
                return                  ;

                                        ;.........

ONEWRITE:                               ;  ** write single byte **
                movwf ATTRIB            ; temp store val brought in on w
                call SCREENADR          ; set screen write address - vals preset at call
                movlw AWRON             ; auto write on
                call SENDCMD            ; send command
                call CHECK3             ; read status for da0/da1 = 3
                movf ATTRIB,W           
                call OUTDATA            ;
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command
                return                  
                                        ;............

AUTOWRITE:                              ; ** auto write routine **
                movwf TEMPA             ; temp store value brought in on w
                call CHECK8             ; read status for da3 = 8
                movf TEMPA,W            ; write data
                call OUTDATA            ;
                return                  ;

                                        ;..............

CMDADR:                                 ; ** set address for command sending **
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRLSB,W           ; write data d1
                call OUTDATA            
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRMSB,W           ; write data d2
                call OUTDATA            
                return                  

                                        ;.........

SCREENADR:                              ; ** set address for write/read to/from screen
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRLSB,W           ; write address lsb
                call OUTDATA            ;
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRMSB,W           ; write address msb
                call OUTDATA            ;
                movlw ADPSET            ; set address pointer
                call SENDCMD            ; send command
                return                  ;

                                        ;.............

TEXTHOME:                               ; ** set text home address **
                clrf ADRMSB             ; text home address $0000
                clrf ADRLSB             ;
                call CMDADR             ; send command address
                movlw TXHOME            ;
                call SENDCMD            ; send command
                return                  

                                        ;...........

GRAPHHOME:                              ;  ** set graphic home address **
                movlw $02               ; graphic home address $0200
                movwf ADRMSB            
                clrf ADRLSB             
                call CMDADR             ; send command address
                movlw GRHOME            
                call SENDCMD            ; send command
                return                  

                                        ;...........

TEXTAREA:                               ; ** set text area **
                clrf ADRMSB             ;
                movf COLUMN,W           ; columns length
                movwf ADRLSB            ;
                call CMDADR             ; send command address
                movlw TXAREA            ; text area command
                call SENDCMD            ; send command
                return                  

                                        ;...........

GRAPHAREA:                              ; ** set graphic area **
                clrf ADRMSB             
                movf COLUMN,W           ; columns length
                movwf ADRLSB            
                call CMDADR             ; send command address
                movlw GRAREA            ; graphic area command
                call SENDCMD            ; send command
                return                  
                                        ;...........

SETMODE:                                ;  ** set mode - many options, see epe text **
                movlw %10000000         ; (or mode, internal cg mode)
                call SENDCMD            ; send command
                return                  
                                        ; %1000x000   ; or mode
                                        ; %1000x001   ; xor mode
                                        ; %1000x011   ; and mode
                                        ; %1000x100   ; text attribute mode
                                        ; %10000xxx   ; internal cg rom mode
                                        ; %10001xxx   ; external cg ram mode

                                        ;...........

SETOFFSET:                              ; ** set offset register **
                                        ; setting offset address at 2 selects
                                        ; cg ram start address = $1400 where
                                        ; $80 is character number of 1st graphic byte
                                        ; values below that call ascii text characters
                clrf ADRMSB             
                movlw 2                 
                movwf ADRLSB            
                call CMDADR             ; send command address
                movlw OFFSET            
                call SENDCMD            ; send command
                return                  

                                        ;...........

SETDISPLAY:                             ;  ** display mode **  some options:
                movlw %10010100         ; text on, graphic off, cursor & blink off
                call SENDCMD            ; send command
                return                  

                                        ;...........

CLRTXT:                                 ;  ** clear text area ($0000) **
                clrf ADRMSB             ; clear all text screen lines, length as set
                clrf ADRLSB             
                call SCREENADR          ; set screen write address
                movlw AWRON             ; auto write on
                call SENDCMD            ; send command
                movlw 8                 ; number of lines
                movwf LOOPC             
CLR2:           movf COLUMN,W           ; column length
                movwf LOOPB             ;
CLR3:           movlw 0                 ; write 0
                call AUTOWRITE          ; auto write and increment
                decfsz LOOPB,F          
                goto CLR3               
                decfsz LOOPC,F          
                goto CLR2               
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command
                return                  

                                        ;............

CLRGRAPH:                               ; ** clear graph area ($0200) **
                movlw $02               
                movwf ADRMSB            
                clrf ADRLSB             
                call SCREENADR          ; set screen write address
                movlw AWRON             ; auto write on
                call SENDCMD            ; send command
                movlw 64                ; number of lines
                movwf LOOPC             
CLRG2:          movf COLUMN,W           ; column length
                movwf LOOPB             
CLRG3:          movlw 0                 ; write 0
                call AUTOWRITE          ; auto write and increment
                decfsz LOOPB,F          
                goto CLRG3              
                decfsz LOOPC,F          
                goto CLRG2              
                movlw AWROFF            ; auto reset off
                call SENDCMD            ; send command
                return                  

                                        ;............

SETATTR:                                ;  ** send attribute & other data to screen as 1 character, looped
                call SCREENADR          ; set screen write address - vals preset at call
                movlw AWRON             ; auto write on
                call SENDCMD            ; send command
SETAT:          movf ATTRIB,W           ; val to be sent preset at call
                call AUTOWRITE          ; auto write and increment
                decfsz LOOPC,F          ; loopc val specified by calling routine
                goto SETAT              
                movlw AWROFF            ; auto write off
                call SENDCMD            ; send command
                return                  

                                        ;............

CHECK3:         PAGE1                   ; status check for da0/da1 = 3
                movlw 255               
                movwf TRISD             ; set portd as inputs
                PAGE0                   ; rst  cd  ce  rd  wr
                movlw %00011001         ;  1   1   0   0   1
                movwf PORTC             ; set ce, rd low
                nop                     
CK3:            btfss PORTD,0           ; portd bit 0 set?
                goto CK3                ; no
CK3A:           btfss PORTD,1           ; portd bit 1 set?
                goto CK3A               ; no  rst  cd  ce  rd  wr
                movlw %00011111         ;      1   1   1   1   1
                movwf PORTC             ; set controls
                nop                     
                PAGE1                   
                clrf TRISD              ; set portd as outputs
                PAGE0                   
                return                  

                                        ;............

CHECK6:         PAGE1                   ; status check for da6 low
                bsf TRISD,6             ; set portd bit as input
                PAGE0                   ; rst  cd  ce  rd  wr
                movlw %00011001         ;  1   1   0   0   1
                movwf PORTC             ; set ce, rd low
                nop                     
CK6:            btfsc PORTD,6           ; is portd bit 6 low?
                goto CK6                ; no rst  cd  ce  rd  wr
                movlw %00011111         ;     1   1   1   1   1
                movwf PORTC             ; set controls
                nop                     
                PAGE1                   
                bcf TRISD,6             ; set portd bit 6 as output
                PAGE0                   
                return                  

                                        ;............

CHECK8:         PAGE1                   ; status check for da3 = 8
                bsf PORTD,3             ; set portd bit 3 as input
                PAGE0                   ; rst  cd  ce  rd  wr
                movlw %00011001         ;  1   1   0   0   1
                movwf PORTC             ; set ce, rd low
                nop                     
CK8:            btfss PORTD,3           ; is portd,3 high?
                goto CK8                ; no  rst  cd  ce  rd  wr
                movlw %00011111         ;      1   1   1   1   1
                movwf PORTC             ; set controls
                nop                     
                PAGE1                   
                bcf TRISD,3             ; set portd bit 3 as output
                PAGE0                   
                return                  

                                        ;........

OUTDATA:                                ; ** send data routine **
                movwf TEMPA             ; temp store val brought in on w
                                        ; rst  cd  ce  rd  wr
                movlw %00010111         ;  1   0   1   1   1
                movwf PORTC             ; set cd low
                movf TEMPA,W            ; get stored data
                movwf PORTD             ; send data
                nop                     ; rst  cd  ce  rd  wr
                movlw %00010010         ;  1   0   0   1   0
                movwf PORTC             ; set cd, ce, wr low
                nop                     ; rst  cd  ce  rd  wr
                movlw %00010111         ;  1   0   1   1   1
                movwf PORTC             ; set ce, wr high
                nop                     ; rst  cd  ce  rd  wr
                movlw %00011111         ;  1   1   1   1   1
                movwf PORTC             ; set cd high
                return                  

                                        ;..........

SENDCMD:                                ;  ** command write routine **
                movwf TEMPA             ; temp store val brought in on w
                call CHECK3             ; read status for da0/da1 = 3
                movf TEMPA,W            ; write command
                movwf PORTD             ; send stored data
                nop                     ; rst  cd  ce  rd  wr
                movlw %00011010         ;  1   1   0   1   0
                movwf PORTC             ; set ce, wr low
                nop                     ; rst  cd  ce  rd  wr
                movlw %00011111         ;  1   1   1   1   1
                movwf PORTC             ; set all high
                return                  

                                        ;............

LINE7:          addwf COLUMN,W          ; sets line addresses for text screen
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE6:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE5:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE4:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE3:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE2:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE1:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE0:          movwf ADRLSB            ; column sets number of cells per line
                return                  ; adrmsb is set/cleared before routine called

                                        ;..............

GLINE:                                  ;** get graphic line address **
                movwf LOOPB             ; store line val
                movlw 2                 ; set graphic base address ($02xx)
                movwf ADRMSB            
                movf LOOPB,W            ; line val = 0?
                btfsc STATUS,Z          
                return                  ; yes
GLIN2:          movf COLUMN,W           ; no, multiply line length by line val
                addwf ADRLSB,F          
                movlw 1                 
                andwf STATUS,W          ; extract and add carry (if any) to msb
                addwf ADRMSB,F          
                decfsz LOOPB,F          
                goto GLIN2              
                return                  

                                        ;..........

SETUP:                                  ; rst  cd  ce  rd  wr  general setup
                movlw %00011111         ;  1   1   1   1   1
                movwf PORTC             ; set controls high (off)
                call TEXTHOME           ; set text home address
                call GRAPHHOME          ; set graphic home address
                call TEXTAREA           ; set text area
                call GRAPHAREA          ; set graphic area
                call SETMODE            ; set mode (int/ext/and-or-xor etc)
                call SETOFFSET          ; set offset (see epe text)
                call SETDISPLAY         ; display mode (text, graph on/off etc)
                call CLRTXT             ; write text blank code $0000
                call CLRGRAPH           ; write graph blank code $0200
                return                  


SHOWTIME:       clrf ADRMSB             
                movlw 0                 ; set column
                call LINE2              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command

                movf CLKHRS,W           ;get hrs
                call LCDFRM             ;format and sent it to lcd
                movlw ':'               ;colon
                call LCDOUT             ;send to lcd
                movf CLKMIN,W           ;get mins
                call LCDFRM             ;format and send to lcd
                movlw ' '               ;colon
                call LCDOUT             ;send to lcd

                movf DAY,W              ;get day
                call LCDFRM             ;format and sent it to lcd

                movf MONTH,W            ;get month
                call MONTH1             
                call LCDOUT             
                movf MONTH,W            ;get month
                call MONTH2             
                call LCDOUT             
                movf MONTH,W            ;get month
                call MONTH3             
                call LCDOUT             
                movlw ' '               
                call LCDOUT             ;send to lcd

                movlw '2'               
                call LCDOUT             ;send to lcd
                movlw '0'               
                call LCDOUT             ;send to lcd
                movf YEAR,W             ;get year
                call LCDFRM             ;format and sent it to lcd
                movlw AWROFF            ; set auto write on
                call SENDCMD            ; send command

                movlw 0                 ; set column
                call LINE4              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command

                movf WEEKDAY,W          ; get weekday
                call DAY1               
                call LCDOUT             
                movf WEEKDAY,W          ; get weekday
                call DAY2               
                call LCDOUT             
                movf WEEKDAY,W          ; get weekday
                call DAY3               
                call LCDOUT             

                movlw AWROFF            ; set auto write on
                call SENDCMD            ; send command

                return                  


TESTSHOW:       clrf ADRMSB             
                movlw 8                 ; set column
                call LINE5              ; set cell number for line stated
                call SCREENADR          
                movlw AWRON             ; set auto write on
                call SENDCMD            ; send command
                movf LIMIT,W
                call LCDFRM
                movlw ' '
                call LCDOUT
                movf MONTH,W
                call LCDFRM
                movlw ' '
                call LCDOUT
                movf MONTHLEN,W
                call LCDFRM

                movlw AWROFF            ; set auto write on
                call SENDCMD            ; send command
                return

                                        ; ***** map table imported to here ******

                .ORG $0800

WCLOCK:         addwf PCL,F             
                include "WCLOCKMAP.INC"  

                                        ; ***** time zone steps imported to here ******

                .ORG $0D00

TIMEZONE:       addwf PCL,F             
                include "WCLOCKZONESTEP.INC"  


                                        ; ***** city time table imported to here ******

                .ORG $1000

CITYTIME:       addwf PCL,F             
                include "WCLOCKTIMEZONE.INC"  


                .END
