; V8 engine sound generator

	list P=16F628A
	#include p16f628A.inc

	__config _HS_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_ON & _MCLRE_OFF & _LVP_OFF

; Define variables at memory locations

EEPROM0		equ	H'00'	; non-volatile storage for cylinder phase (180 default 5 degrees per step)
EEPROM1		equ	H'01'	; non-volatile storage for exhaust overlap (30deg default, 0, -30 and 60 stepped)
EEPROM2		equ	H'02'	; non-volatile storage for exhaust frequency 
EEPROM3		equ	H'03'	; non-volatile storage for 1 or 2 rpm sequences
EEPROM4		equ	H'04'	; eight or six cylinders

; Bank 0 RAM

COUNTER			equ	H'20'	; position counter for waveform generation
STORE1			equ	H'21'	; delay value
STORE2			equ	H'22'	; delay value
INPUT			equ	H'23'	; input level storage
PHASE			equ	H'24'	; phase flags
CURRENT			equ	H'25'	; current waveform value
SHIFT1			equ	H'26'	; shift register ms byte
SHIFT2			equ	H'27'	; shift register mid byte
SHIFT3			equ	H'28'	; shift register ls byte
SHIFT4			equ	H'29'	; shift register carry storage

CYLINDER1		equ	H'2C'	; evens cylinder counter (0-256)
CYLINDER2		equ	H'2D'	; odds cylinder counter (0-256)

SIX_8			equ	H'30'	; 6 or 8 cylinder working register
SEQ2			equ	H'31'	; second rpm sequence flag
START_FLG		equ	H'32'	; extended idle at start flag

CURRENT_TEMP	equ	H'34'	; temporary current value
DEL_NOTE		equ	H'35'	; delay for odd cylinders
FREQ_OSC		equ H'36'	; noise frequency oscillator
STORE3			equ	H'37'	; storage
WORK_VAL		equ	H'38'	; working value
NOISE			equ	H'39'	; noise generator signal
DOOR_AWAIT		equ	H'3A'	; awaiting doorbell pressing
PORT_STO		equ	H'3B'	; storage of PORTA
UP_DN			equ	H'3C'	; up or down rpm sequence
STOREX			equ	H'3D'	; extended delay counter
WORK_VAL1		equ	H'3E'	; working value during interrupt

; All Banks RAM
ST_ADR		equ	H'70'	; storage of EEPROM Address during interrupt
EDTA_ST		equ	H'71'	; EEPROM data store
W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt

; preprogram EEPROM DATA 
	
	ORG     2100
	DE	D'125', 0x01, D'140', 0x00, 0x00

; start at memory 0

	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

ALL_PHASE				; 8 cylinders overlap by 1
	addwf	PCL,f		; add value to program counter
	retlw	B'10000001'
	retlw	B'00000001'
	retlw	B'00000001'
	retlw	B'00000011'
	retlw	B'00000010'
	retlw	B'00000010'
	retlw	B'00000110'
	retlw	B'00000100'
	retlw	B'00000100'
	retlw	B'00001100'
	retlw	B'00001000'
	retlw	B'00001000'
	retlw	B'00011000'
	retlw	B'00010000'
	retlw	B'00010000'
	retlw	B'00110000'
	retlw	B'00100000'
	retlw	B'00100000'
	retlw	B'01100000'
	retlw	B'01000000'
	retlw	B'01000000'
	retlw	B'11000000'
	retlw	B'10000000'
	retlw	B'10000000'

ALT_EXH					; 8 cylinders overlap by 2
	addwf	PCL,f		; add value to program counter
	retlw	B'10000001'
	retlw	B'10000001'
	retlw	B'00000001'
	retlw	B'00000011'
	retlw	B'00000011'
	retlw	B'00000010'
	retlw	B'00000110'
	retlw	B'00000110'
	retlw	B'00000100'
	retlw	B'00001100'
	retlw	B'00001100'
	retlw	B'00001000'
	retlw	B'00011000'
	retlw	B'00011000'
	retlw	B'00010000'
	retlw	B'00110000'
	retlw	B'00110000'
	retlw	B'00100000'
	retlw	B'01100000'
	retlw	B'01100000'
	retlw	B'01000000'
	retlw	B'11000000'
	retlw	B'11000000'
	retlw	B'10000000'


ALT_PHASE				; 8 cylinders non-overlap by -1. shorter exhaust period used for gated noise source
	addwf	PCL,f		; add value to program counter
	retlw	B'00000001'
	retlw	B'00000001'
	retlw	B'00000000'
	retlw	B'00000010'
	retlw	B'00000010'
	retlw	B'00000000'
	retlw	B'00000100'
	retlw	B'00000100'
	retlw	B'00000000'
	retlw	B'00001000'
	retlw	B'00001000'
	retlw	B'00000000'
	retlw	B'00010000'
	retlw	B'00010000'
	retlw	B'00000000'
	retlw	B'00100000'
	retlw	B'00100000'
	retlw	B'00000000'
	retlw	B'01000000'
	retlw	B'01000000'
	retlw	B'00000000'
	retlw	B'10000000'
	retlw	B'10000000'
	retlw	B'00000000'

ALTER_PHASE				; 8 cylinders non-overlap 
	addwf	PCL,f		; add value to program counter
	retlw	B'00000001'
	retlw	B'00000001'
	retlw	B'00000001'
	retlw	B'00000010'
	retlw	B'00000010'
	retlw	B'00000010'
	retlw	B'00000100'
	retlw	B'00000100'
	retlw	B'00000100'
	retlw	B'00001000'
	retlw	B'00001000'
	retlw	B'00001000'
	retlw	B'00010000'
	retlw	B'00010000'
	retlw	B'00010000'
	retlw	B'00100000'
	retlw	B'00100000'
	retlw	B'00100000'
	retlw	B'01000000'
	retlw	B'01000000'
	retlw	B'01000000'
	retlw	B'10000000'
	retlw	B'10000000'
	retlw	B'10000000'
; ::::::::::::::::::::::::::::::::::::::::::::::::::::::			
; INTERRUPT

; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		INTCON,T0IF	; clear TMRO interrupt flag
	bsf		STATUS,RP0	; bank 1
	movf	EEADR,w		; EEPROM address 
	movwf	ST_ADR		; keep address
	movf	EEDATA,w	; EEPROM data
	movwf	EDTA_ST		; store value
	bcf		STATUS,RP0	; select bank 0

; get exhaust frequency value (D'155' default)
	movlw	EEPROM2		; exhaust frequency
	call	EEREAD
    btfss	PORTA,0		; if filter off
	addlw	D'15'		; higher freq
	addwf	TMR0,f		; speed interrupt rate
	incf	FREQ_OSC,f	; increase

; noise generator

	movf	FREQ_OSC,w
	btfss	STATUS,Z	; if zero 
	goto	MOD_HALF
	movlw	0xFC		; noise counter rate
	movwf	FREQ_OSC	
	bcf		STATUS,C	; clear carry	
	btfss	SHIFT4,7	; last bit in shift register

; if this bit is high and bit 5 of SHIFT2 is high set carry to 0
	goto	OTHER_LEVEL
	bsf		NOISE,0		; output

	btfss	SHIFT2,5	; 2,5 is a noise source	
	bsf		STATUS,C	; set carry (XOR gate function)	
	goto	SHIFT_REG

OTHER_LEVEL
	bcf		NOISE,0		; output
	btfsc	SHIFT2,5	; 2,5 is a noise source	
	bsf		STATUS,C	; set carry (XOR gate function)	
	goto	SHIFT_REG

SHIFT_REG
	rrf		SHIFT1,f	; shift right
	rrf		SHIFT2,f
	rrf		SHIFT3,f
 	rrf		SHIFT4,f	; last bit

; noise source add in 8-cycles per 2rev
	movf	COUNTER,w	; cylinder position
	call	ALT_PHASE
	movwf	STORE3
	movf	STORE3,w		; look at value
	btfss	STATUS,Z		; if zero clear port
	goto	NOISE_GATE

; modulate at half supply
MOD_HALF
; if DOOR_AWAIT,0 is clear, then high input impedance
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	INPUT_IMP		; high input impedance
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,2		; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER1,0
	goto	CLR_PORT		; high freq square wave
	bsf		PORTA,2
	goto	CYL1_VAL

NOISE_GATE
; if DOOR_AWAIT,0 is clear, then high input impedance
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	INPUT_IMP		; high input impedance
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,2		; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	NOISE,0			; noise signal
	goto	CLR_PORT
	bsf		PORTA,2
	goto	CYL1_VAL
CLR_PORT
	bcf		PORTA,2
	goto	CYL1_VAL

INPUT_IMP				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,2		; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0

; firing 1		
CYL1_VAL
	incf	CYLINDER1,f	
	btfss	PORTA,0		; if filter off
	incf	CYLINDER1,f	; evens cylinder 1 interrupt counter
	btfss	PORTA,1		; if filter off
	incf	CYLINDER1,f	; evens cylinder 1 interrupt counter
;	btfss	PORTA,0		; if filter off
;	incf	CYLINDER1,f	; evens cylinder 1 interrupt counter
;	btfss	PORTA,1		; if filter off
;	incf	CYLINDER1,f	; evens cylinder 1 interrupt counter

	btfss	CURRENT,0	; if set drive waveform
	goto	CYL1_MOD	; high input impedance
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL1_MOD
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,7		; output port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER1,7  ; if bit set, set output
	goto	CYL1_CLR
	bsf		PORTB,7		; portB,7 set
	goto	CYL2_VAL
CYL1_CLR
	bcf		PORTB,7		; portB,7 clear
	goto	CYL2_VAL	;

CYL1_MOD				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,7		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

; firing 2
CYL2_VAL
	incf	CYLINDER2,f
	btfss	PORTA,0		; if filter off increase output frequency	
	incf	CYLINDER2,f	; odds cylinder 2 interrupt counter
	btfss	PORTA,1		; if filter off increase output frequency	
	incf	CYLINDER2,f	; odds cylinder 2 interrupt counter
;	btfss	PORTA,0		; if filter off
;	incf	CYLINDER2,f	; odds cylinder 2 interrupt counter
;	btfss	PORTA,1		; if filter off
;	incf	CYLINDER2,f	; odds cylinder 2 interrupt counter
	
	btfss	CURRENT,1	; if set drive waveform
	goto	CYL2_MOD	; high input impedance
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL2_MOD
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,3		; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER2,7  ; if bit set, set output
	goto	CYL2_CLR
	bsf		PORTA,3		; portA,3 set
	goto	CYL3_VAL
CYL2_CLR
	bcf		PORTA,3		; portA,3 clear
	goto	CYL3_VAL	;
CYL2_MOD				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,3		; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0

; firing 3
CYL3_VAL
	btfss	CURRENT,2	; if set drive waveform
	goto	CYL3_MOD	; high input impedance
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL3_MOD

	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,6		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER1,7  ; if bit set, set output
	goto	CYL3_CLR
	bsf		PORTB,6		; portB,6 set
	goto	CYL4_VAL
CYL3_CLR
	bcf		PORTB,6		; portB,6 clear
	goto	CYL4_VAL	;
CYL3_MOD				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,6		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	
; firing 4
CYL4_VAL
	btfss	CURRENT,3	; if set drive waveform
	goto	CYL4_MOD	; high input impedance
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL4_MOD
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,0		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER2,7  ; if bit set, set output
	goto	CYL4_CLR
	bsf		PORTB,0		; portB,0 set
	goto	CYL5_VAL
CYL4_CLR
	bcf		PORTB,0		; portB,0 clear
	goto	CYL5_VAL	;

CYL4_MOD				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,0		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

; firing 5
CYL5_VAL
	btfss	CURRENT,4	; if set drive waveform
	goto	CYL5_MOD	; high input impedance
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL5_MOD
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,5		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER1,7  ; if bit set, set output
	goto	CYL5_CLR
	bsf		PORTB,5		; portB,5 set
	goto	CYL6_VAL
CYL5_CLR
	bcf		PORTB,5		; portB,5 clear
	goto	CYL6_VAL	;

CYL5_MOD				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,5		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

; firing 6
CYL6_VAL
	btfss	CURRENT,5	; if set drive waveform
	goto	CYL6_MOD	; high input impedance
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL6_MOD

	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,1		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER2,7  ; if bit set, set output
	goto	CYL6_CLR
	bsf		PORTB,1		; portB,1 set
	goto	CYL7_VAL
CYL6_CLR
	bcf		PORTB,1		; portB,1 clear
	goto	CYL7_VAL	;
CYL6_MOD				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,1		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

; firing 7
CYL7_VAL
	btfss	CURRENT,6	; if set drive waveform
	goto	CYL7_MOD	; high input impedance
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL7_MOD

	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,4		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER1,7  ; if bit set, set output
	goto	CYL7_CLR
	bsf		PORTB,4 	; portB,4 set
	goto	CYL8_VAL
CYL7_CLR
	bcf		PORTB,4		; portB,4 clear
	goto	CYL8_VAL	;
CYL7_MOD				; make an input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,4		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

; firing 8
CYL8_VAL
	btfss	CURRENT,7	; if set drive waveform
	goto	CYL8_MOD	; high freq square wave
; if DOOR_AWAIT,0 is clear, then modulate signal
	btfss	DOOR_AWAIT,0	; if set doorbell pressed
	goto	CYL8_MOD

	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,2		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfss	CYLINDER2,7  ; if bit set, set output
	goto	CYL8_CLR
	bsf		PORTB,2		; portB,2 set
	goto	CYL9_VAL
CYL8_CLR
	bcf		PORTB,2		; portB,2 clear
	goto	CYL9_VAL	;
CYL8_MOD				; make an input
			
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,2		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

CYL9_VAL

; signal output generation
	movf	PORTA,w		; capture porta
	movwf	PORT_STO
	movf	INPUT,w		; last RA4 reading
	andlw	B'00010000'	; if bit4 set keep set
	movwf	INPUT		; store
	btfsc	INPUT,4		; if set, bypass
	goto 	NEW_STORE
	btfsc	PORT_STO,4	; if set then input gone high so generate waveforms
	goto	WAVE_GEN
NEW_STORE
	movf	PORT_STO,w
	movwf	INPUT			
	goto	RECLAIM	

; generate waveforms
WAVE_GEN
	movlw	EEPROM1		; Exhaust overlap
	call	EEREAD
	movwf	WORK_VAL1	; store value
	btfsc	WORK_VAL1,1	; if clear other overlaps
	goto	OTH_OVR

	btfss	WORK_VAL1,0	; current value setting
	goto	BY_PH	
	movf	COUNTER,w	; current position for waveform 
	call	ALT_EXH		; alternative non exhaust overlap
	movwf	CURRENT		; store
	goto	EOF_GEN
BY_PH
	movf	COUNTER,w	; current position for waveform 
	call	ALL_PHASE	; get overlapped exhaust
	movwf	CURRENT		; store
	goto	EOF_GEN
OTH_OVR	
	
	btfss	WORK_VAL1,0	; current value setting
	goto	BY_PH1
	movf	COUNTER,w	; current position for waveform 
	call	ALTER_PHASE	; get overlapped exhaust
	movwf	CURRENT		; store	
	goto	EOF_GEN
BY_PH1
	movf	COUNTER,w	; current position for waveform 
	call	ALT_PHASE	; alternative non exhaust overlap
	movwf	CURRENT		; store	

; end of each signal generation
EOF_GEN

	incf	COUNTER,f
	movlw	EEPROM4		; eight-six cylinder select
	call	EEREAD
	movwf	SIX_8
	movlw	D'24'		; 8-cylinder lookup table length
	btfsc	SIX_8,0
	movlw	D'18'		; six cylinder lookup table length
	subwf	COUNTER,w
	btfsc	STATUS,C	; if negative continue
	clrf	COUNTER		; return to 0 
	goto	NEW_STORE

; end of interrupt reclaim w and status 
RECLAIM
	bsf		STATUS,RP0	; select bank 1
	movf	ST_ADR,w	; EEPROM address store
	movwf	EEADR		; return to original address
	movf	EDTA_ST,w	; EEPROM data store 
	movwf	EEDATA
	bcf		STATUS,RP0	; select bank 0
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; **************************************************************************

SETUP
	movlw	B'00000111'	; comparators off
	movwf	CMCON		; 
	movlw	B'00000011'
	movwf	PORTA		; Q1 and Q2 on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'10000000'	; port B inputs/outputs (was 1000000)
	movwf	TRISB		; port B data direction register
	movlw	B'00110000'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register

	movlw	B'10000000'	; 
	movwf	OPTION_REG	; port B pullups disabled
	movlw	0xFF
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm set
	movlw	H'FF'		; 100% duty
	movwf	CCPR1L		; ms byte of PWM
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation
	
; initial conditions
	bcf		PORTA,3		; this pulls RB4-7 and RB0-2 low
	clrf	DOOR_AWAIT	; clear until doorbell pressed

; read RB0-RB2 and RB4-RB7 inputs (if held high via 1k resistor at startup)
; bit 7 input
	movlw	B'00000000'	; set other inputs low
	movwf	PORTB
	btfsc	PORTB,7		; check the phase change up count
	goto	PHASE_UP
; bit 6 input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01000000'	; port B inputs/outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; memory bank 0
	movlw	B'00000000'	; set other inputs low
	movwf	PORTB
	btfsc	PORTB,6		; check for phase default
	goto	PHASE_DEF
; bit 5 input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00100000'	; port B inputs/outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; memory bank 0
	movlw	B'00000000'	; set other inputs low
	movwf	PORTB
	btfsc	PORTB,5		; exhaust overlap
	goto	EXH_OVR

; bit 4 input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00010000'	; port B inputs/outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; memory bank 0
	movlw	B'00000000'	; set other inputs low
	movwf	PORTB
	btfsc	PORTB,4		; 8/6 cylinder
	goto	EIGHT_SIX
	
; bit 2 input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000100'	; port B inputs/outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; memory bank 0
	movlw	B'00000000'	; set other inputs low
	movwf	PORTB
	btfsc	PORTB,2		; exhaust frequency UP
	goto	FREQ_UP

; bit 1 input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000010'	; port B inputs/outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; memory bank 0
	movlw	B'00000000'	; set other inputs low
	movwf	PORTB
	btfsc	PORTB,1		; exhaust frequency down
	goto	FREQ_DN	

; bit 0 input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000001'	; port B inputs/outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; memory bank 0
	movlw	B'00000000'	; set other inputs low
	movwf	PORTB
	btfsc	PORTB,0		; rev number
	goto	REV_CHNG	
	goto	RES_PORTS

PHASE_UP
	movlw	EEPROM0		; phase EEPROM
	call	EEREAD		; reads current value
	movwf	WORK_VAL
	movlw	0x15
	addwf	WORK_VAL,f	; increase by 15 (~20 degree shifts)
	movf	WORK_VAL,w
	call	EWRITE		; write new value
	goto	RES_PORTS

PHASE_DEF				; default phase and frequency
	movlw	EEPROM0		; phase EEPROM
	call	EEREAD		; sets EEADR
	movlw	D'125'		; default value (180 degree shift)
	call	EWRITE		; write to EEPROM0
	movlw	EEPROM2		; frequency EEPROM
	call	EEREAD		; sets EEADR
	movlw	D'155'		; default value 
	call	EWRITE		; write to EEPROM2
	goto	RES_PORTS

EXH_OVR
	movlw	EEPROM1		; exhaust overlap EEPROM
	call	EEREAD		; reads current value
	movwf	WORK_VAL
	incf	WORK_VAL,f	; increase loops between different overlaps
	movf	WORK_VAL,w
	call	EWRITE		; write new value
	goto	RES_PORTS

EIGHT_SIX
	movlw	EEPROM4		; eight-six EEPROM
	call	EEREAD		; reads current value
	movwf	WORK_VAL
	incf	WORK_VAL,w
	call	EWRITE		; write new value
	goto	RES_PORTS

FREQ_UP
	movlw	EEPROM2		; frequency EEPROM
	call	EEREAD		; reads current value
	movwf	WORK_VAL
	incf	WORK_VAL,w
	xorlw	D'190'		; max
	btfsc	STATUS,Z	; if 0 do not increase
	goto	RES_PORTS
	incf	WORK_VAL,w
	call	EWRITE		; write new value
	goto	RES_PORTS

FREQ_DN
	movlw	EEPROM2		; frequency EEPROM
	call	EEREAD		; reads current value
	movwf	WORK_VAL
	decf	WORK_VAL,w
	xorlw	D'130'		; min
	btfsc	STATUS,Z	; if 0 do not decrease
	goto	RES_PORTS
	decf	WORK_VAL,w
	call	EWRITE		; write new value
	goto	RES_PORTS

REV_CHNG
	movlw	EEPROM3		; rev change EEPROM
	call	EEREAD		; reads current value
	movwf	WORK_VAL
	incf	WORK_VAL,f	; increase loops between different overlaps
	movf	WORK_VAL,w
	call	EWRITE		; write new value
;	goto	RES_PORTS
	
; reset ports
RES_PORTS
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; port B outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; memory bank 0
	 
INIT_WAVE

	clrf	COUNTER		; position counter at start
	clrf	CYLINDER1	; odds cylinder phasing
	clrf	UP_DN		; rpm sequence up or down
	movlw	EEPROM0		; even to odd cylinder phasing of 100Hz firing pulses
	call	EEREAD		; retrieve value (in w)
	movwf	CYLINDER2

; allow interrupts
	bsf		INTCON,T0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above

; check if doorbell pressed	
; if DOOR_AWAIT,0 is clear, then doorbell off
WAIT_DOOR
	clrf	SEQ2			; second seq flag
	btfsc	DOOR_AWAIT,0	; if set doorbell pressed
	goto	RPM_SEQ
	btfss	PORTA,5			; if high then pressed
	goto	WAIT_DOOR
	bsf		DOOR_AWAIT,0	; set so rev sequence starts
	bcf		UP_DN,0			; up sequence
	clrf	START_FLG		; start flag
	goto	RPM_SEQ

; rpm sequence
RPM_SEQ2
	bsf		SEQ2,0		; second rpm sequence set
RPM_SEQ
	bcf		INTCON,GIE	; clear global interrupt enable for above
	movlw	EEPROM3		; rev style EEPROM
	call	EEREAD		; reads current value
	bsf		INTCON,GIE	; set global interrupt enable for above
	movwf	WORK_VAL
	btfsc	WORK_VAL,0
	goto	STYLE
	btfsc	UP_DN,0		; up down flag
	goto	END_RPMSEQ
	decfsz	CCPR1L,f	; ms byte of PWM reduce voltage
	goto	CONT_RPM
; delay at max rpm
	movlw	0x01		; extended delay for max rpm
	movwf	STOREX
DE_LONGE
	movlw	0x80
	movwf	STORE1
	call	LOOP1		; delay loop
	decfsz	STOREX,f

	goto	DE_LONGE
	bsf		UP_DN,0		; down sequence
	bsf		PORTA,0		; restore filter
	goto	END_RPMSEQ
CONT_RPM
	call	DELAYms		; up delay
	movf	CCPR1L,w
	xorlw	D'150'		; when at this value switch off Q1
	btfsc	STATUS,Z
	bcf		PORTA,1		; accelerate sound with Q1 off
	movf	CCPR1L,w
	xorlw	D'100'		; when at this value switch off Q2
	btfsc	STATUS,Z
	bcf		PORTA,0		; growl sound with Q2 off
	goto	RPM_SEQ
END_RPMSEQ	
	bsf		PORTA,0		; filter restored
	bsf		PORTA,1
	movf	CCPR1L,w
	xorlw	D'230'
	btfss	STATUS,Z	; if at 230 stop increment
	goto	CONT_DNSWQ
; end down
	movlw	0x10		; extended delay for idle finish (was 40)
	movwf	STOREX
DEL_LONG
	movlw	0x80
	movwf	STORE1
	call	LOOP1		; delay loop
	decfsz	STOREX,f

	goto	DEL_LONG
	clrf	UP_DN		; reset
; check if two or 1 rev with doorbell
	btfsc	SEQ2,0		; if bit set end of sequence
	goto	END_SEQ
	
	goto	RPM_SEQ2	; redo rpm
END_SEQ
	clrf	DOOR_AWAIT	; 
	movlw	0xFF
	movwf	CCPR1L		; PWM at maximim
	goto	WAIT_DOOR
CONT_DNSWQ
	incf	CCPR1L,f	; increase PWM
	movlw	0x0F		; down delay (was 9)
	movwf	STORE1
	call	LOOP1		; delay loop
	goto	RPM_SEQ

; different rev style	
STYLE	
	btfsc	START_FLG,0	; extended idle at start flag
	goto	BY_START
	movlw	D'230'
	movwf	CCPR1L		; increase volume
	movlw	0x10		; extended delay for idle start (was40)
	movwf	STOREX
DEL_LONGY
	movlw	0x80
	movwf	STORE1
	call	LOOP1		; delay loop
	decfsz	STOREX,f

	goto	DEL_LONGY
BY_START
	bsf		START_FLG,0
	btfsc	UP_DN,0		; up down flag
	goto	END_RPMSTYLE
	decfsz	CCPR1L,f	; ms byte of PWM reduce voltage
	goto	CONT_STYLE
; delay at max rpm
	movlw	0x01		; extended delay for max rpm
	movwf	STOREX
DE_LONGE1
	movlw	0x80
	movwf	STORE1
	call	LOOP1		; delay loop
	decfsz	STOREX,f

	goto	DE_LONGE1
	bsf		UP_DN,0		; down sequence
	bsf		PORTA,0		; restore filter
	goto	END_RPMSEQ
CONT_STYLE
	call	DELAYms		; up delay
	movf	CCPR1L,w
	xorlw	D'150'		; when at this value switch off Q1
	btfsc	STATUS,Z
	bcf		PORTA,1		; accelerate sound with Q1 off
	movf	CCPR1L,w
	xorlw	D'100'		; when at this value switch off Q2
	btfsc	STATUS,Z
	bcf		PORTA,0		; growl sound with Q2 off
	goto	RPM_SEQ
END_RPMSTYLE	
	bsf		PORTA,0		; filter restored
	bsf		PORTA,1
	movf	CCPR1L,w
	xorlw	D'230'
	btfss	STATUS,Z	; if at 230 stop increment
	goto	CONT_DNSTYLE
; end down
	movlw	0x08		; extended delay for idle finish(was40)
	movwf	STOREX
DEL_LONG1
	movlw	0x80
	movwf	STORE1
	call	LOOP1		; delay loop
	decfsz	STOREX,f

	goto	DEL_LONG1
	clrf	UP_DN		; reset
; check if two or 1 rev with doorbell
	btfsc	SEQ2,0		; if bit set end of sequence
	goto	END_SEQ1
	
	goto	RPM_SEQ2	; redo rpm
END_SEQ1
	clrf	DOOR_AWAIT	; 
	movlw	0xFF
	movwf	CCPR1L		; PWM at maximim
	goto	WAIT_DOOR
CONT_DNSTYLE
	incf	CCPR1L,f	; increase PWM
	movlw	0x0F		; down delay (was 9)
	movwf	STORE1
	call	LOOP1		; delay loop
	goto	RPM_SEQ
; ******************************************************************************************

; subroutines
DELAYms
	movlw	0x06		; delay set (08 orig)
	movwf	STORE1		; STORE1 is number of loops value
LOOP1
	movlw	0xA0
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return

; subroutine to read EEPROM memory

EEREAD	
	bsf 	STATUS,RP0	; select memory bank 1
	movwf 	EEADR		; indirect special function register
	bsf		EECON1,RD	; read EEPROM
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP0	; select bank 0
	return

; subroutine to write to EEPROM

EWRITE
	bsf		STATUS,RP0	; select bank 1
	movwf	EEDATA		; data register
	bcf		INTCON,GIE	; disable interrupts

	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank 0 
	return				; value written 


	end




