; TUNEFORK40.ASM 26AUG02  WRITTEN IN TASM (Can be translated to MPASM via TK3)

;PIC16F84-4, 4MHz, WDT OFF, POR ON, XTAL XS

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

        List P = PIC16F84, R=DEC; 
        __CONFIG   h'3FF1'

INDF:    .EQU $00
OPTION:  .EQU $01
PCL:     .EQU $02
STATUS:  .EQU $03
FSR:     .EQU $04

PORTA:   .EQU $05
TRISA:   .EQU $05
PORTB:   .EQU $06
TRISB:   .EQU $06

EEDATA:  .EQU $08
EECON1:  .EQU $08
EEADR:   .EQU $09
EECON2:  .EQU $09
INTCON:  .EQU $0B

FREQLO:   .EQU $0C        ; frequency counter LSB
FREQHI:   .EQU $0D        ; frequency counter MSB
WAVELO:   .EQU $0E        ; frequency value LSB
WAVEHI:   .EQU $0F        ; frequency value MSB
STORE:    .EQU $10        ; temp store 
LOOP:     .EQU $11        ; loop
PREVINPUT: .EQU $12       ; store for prev input val
PREVPORT: .EQU $13        ; store for prev PORT in use val 
OUTPUT:   .EQU $14        ; store for output to PORTA
BEAT:     .EQU $15        ; beat counter for metronome
MASK2:    .EQU $16        ; flag for metronome syncopation

NOTEVAL:  .EQU $17        ; 17 MSB/LSB location pairs ( = 34 locations)

          ; locations up to $3F are available

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1 
Z:      .EQU 2
GIE:    .EQU 7           ;INTCON reg
WR:     .EQU 1  ;eeprom write initiate flag
WREN:   .EQU 2  ;eeprom write enable flag
RD:     .EQU 0  ;eeprom read enable flag

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF

START:  clrf PORTA
        PAGE1
        movlw %11111000     ; RA0-RA2 as outputs, RA3-RA4 as inputs
        movwf TRISA
        movlw %11111111
        movwf TRISB         ; PORTB as input
        movlw %00000110
        movwf OPTION        ; pull-ups on (bit 7 lo), timer on
        PAGE0

        clrf WAVEHI
        clrf WAVELO
        clrf PREVINPUT
        clrf OUTPUT
        clrf MASK2
        clrf PREVPORT
        call PAUSIT

        movf PORTB,W     ; get PORTB
        andlw %00001111  ; limit range
        xorlw 7          ; is val = 7?
        btfsc STATUS,Z
        goto TUNEDOWN    ; yes, so decrease in tuning freq needed

        movf PORTB,W     ; get PORTB
        andlw %00001111  ; limit range
        xorlw 8          ; is val = 8?
        btfsc STATUS,Z
        goto TUNEUP      ; yes, so increase in tuning freq needed

        movf PORTB,W     ; get PORTB
        andlw %00001111  ; limit range
        xorlw 9          ; is val = 9?
        btfsc STATUS,Z
        goto RESTORETUNE ; yes, restore tuning to author's defaults

START2: call PAUSIT
        call GETNOTES

TUNER:  PAGE1
        movlw %11111110     ; RA0-RA2 as outputs, RA3-RA4 as inputs
        movwf TRISA
        PAGE0

MAIN:   btfss PORTB,4
        goto METRONOME

        btfss PORTB,5
        goto TUNER2

        btfsc PORTB,3
        goto MAIN

        rlf PORTB,W      ; double PORTB
        andlw %00011110  ; limit range
        addlw NOTEVAL    ; add to address of NOTEVAL
        addlw 1          ; inc for LSB
        movwf FSR
        movf INDF,W      ; get LSB
        addwf WAVELO,F   ; add LSB to running counter
        movf STATUS,W    ; add Carry (if any) to WAVE MSB
        andlw 1
        addwf WAVEHI,F
        movf STATUS,W    ; add Carry (if any) to PORTA
        andlw 1
        addwf PORTA,F

        decf FSR,F       ; dec for MSB
        movf INDF,W      ; get MSB
        addwf WAVEHI,F   ; add to running counter
        movf STATUS,W    ; add Carry (if any) to PORTA
        andlw 1
        addwf PORTA,F
        goto MAIN

TUNER2: PAGE1
        movlw %11111110     ; RA0-RA2 as outputs, RA3-RA4 as inputs
        movwf TRISA
        PAGE0

MAIN2:  btfss PORTB,4
        goto METRONOME

        btfsc PORTB,5
        goto TUNER

        btfsc PORTB,3
        goto MAIN2

        rlf PORTB,W      ; double PORTB
        andlw %00011110  ; limit range
        addlw NOTEVAL    ; add to address of NOTEVAL
        addlw 17         ; inc for LSB
        movwf FSR
        movf INDF,W      ; get LSB
        addwf WAVELO,F   ; add LSB to running counter
        movf STATUS,W    ; add Carry (if any) to WAVE MSB
        andlw 1
        addwf WAVEHI,F
        movf STATUS,W    ; add Carry (if any) to PORTA
        andlw 1
        addwf PORTA,F

        decf FSR,F       ; dec for MSB
        movf INDF,W      ; get MSB
        addwf WAVEHI,F   ; add to running counter
        movf STATUS,W    ; add Carry (if any) to PORTA
        andlw 1
        addwf PORTA,F
        goto MAIN2

;..........

;WRITE DATA TO EEPROM ROUTINE:
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE.
SETPRM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1
        bsf EECON1,WREN ;enable write flag
        PAGE0
        movf STORE,W    ;get data value from STORE and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register

MANUAL: PAGE1           ;these next 12 lines are according to
        movlw $55       ;Microchip manual dictated factors
        movwf EECON2    ;they cause the action required by
        movlw $AA       ;by the eeprom to store the data in EEDATA
        movwf EECON2    ;at the address held by EEADR.
        bsf EECON1,WR   ;set the ``perform write'' flag

CHKWRT: btfss EECON1,4  ;wait until bit 4 of EECON1 is set
        goto CHKWRT
        bcf EECON1,WREN ;disable write
        bcf EECON1,4    ;clear bit 4 of EECON1
        PAGE0
        bcf INTCON,6    ;clear bit 6 of INTCON
        return          ;and return

;..........

;READ DATA FROM EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1           ;
        BSF EECON1,RD   ;enable read flag
        PAGE0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        return          ;and return

TUNEUP: clrf LOOP
INCNOTE: movf LOOP,W
        call PRMGET      ; get current note MSB & LSB
        movwf FREQHI
        incf LOOP,W
        call PRMGET
        movwf FREQLO

        movf LOOP,W
        addlw 32
        call PRMGET      ; get default MSB
        movwf STORE
        rrf STORE,W      ; halve it
        andlw %01111111
        addwf FREQLO,F   ; add to current LSB
        btfsc STATUS,C   ; is there a carry?
        incf FREQHI,F    ; yes

        movf FREQHI,W    ; store new vals back to eeprom
        movwf STORE
        movf LOOP,W
        call SETPRM
        movf FREQLO,W
        movwf STORE
        incf LOOP,F
        movf LOOP,W
        call SETPRM
        incf LOOP,F
        movf LOOP,W
        xorlw 32         ;34
        btfss STATUS,Z
        goto INCNOTE     ; no

;        movlw 255        ; test only
;        movwf STORE
;        movf LOOP,W
;        call SETPRM
        goto START2

TUNEDOWN: clrf LOOP
DECNOTE: movf LOOP,W
        call PRMGET
        movwf FREQHI
        incf LOOP,W
        call PRMGET
        movwf FREQLO

        movf LOOP,W
        addlw 32
        call PRMGET
        movwf STORE
        rrf STORE,W
        andlw %01111111
        subwf FREQLO,F
        btfss STATUS,C     ; is there a borrow?
        decf FREQHI,F      ; yes, so dec MSB

        movf FREQHI,W      ; store new vals back to eeprom
        movwf STORE
        movf LOOP,W
        call SETPRM
        movf FREQLO,W
        movwf STORE
        incf LOOP,F
        movf LOOP,W
        call SETPRM
        incf LOOP,F
        movf LOOP,W
        xorlw 32
        btfss STATUS,Z
        goto DECNOTE

;        movlw 255        ; test only
;        movwf STORE
;        movf LOOP,W
;        call SETPRM
        goto START2

RESTORETUNE: clrf LOOP   ; restore tuning to author's orig vals
RES2:   movf LOOP,W
        addlw 32
        call PRMGET
        movwf STORE
        movf LOOP,W
        call SETPRM
        incf LOOP,F
        movf LOOP,W
        xorlw 34
        btfss STATUS,Z
        goto RES2
        goto START2

GETNOTES: clrf LOOP
        movlw NOTEVAL
        movwf FSR
GETNOTE: movf LOOP,W
        call PRMGET
        movwf INDF
        incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 34
        btfss STATUS,Z
        goto GETNOTE
        return

METRONOME: PAGE1
        movlw %11111100     ; RA0-RA2 as outputs, RA3-RA4 as inputs
        movwf TRISA
        PAGE0

MET1:   btfss PORTA,4
        goto METRONOME
        bcf PORTA,4
        PAGE1
        bcf TRISA,4
        PAGE0
        PAGE1
        bsf TRISA,4
        PAGE0
        incfsz OUTPUT,F
        goto MET1

        btfsc PORTB,4
        goto TUNER

        movf PORTB,W
        andlw %00000111
        xorwf PREVPORT,W
        btfsc STATUS,Z
        goto MET2
        clrf MASK2

MET2:   incf BEAT,F
        movf BEAT,W
        andlw 1
        movwf PORTA
        incf MASK2,F
        movf PORTB,W
        andlw 7
        addlw 1
        xorwf MASK2,W
        btfss STATUS,Z
        goto BYPASS
        bsf PORTA,1
        clrf MASK2
BYPASS: movlw %10000000
        movwf STORE
PULSE:  incfsz STORE,F
        goto PULSE
        movlw %10000000
        movwf STORE
PULSEX: incfsz STORE,F
        goto PULSEX

        clrf BEAT
        clrf PORTA
        bcf MASK2,3
        movf PORTB,W
        andlw %00000111
        movwf PREVPORT
        goto MET1


PAUSIT: movlw 5
        movwf STORE
        BCF INTCON,2
PAUSE2: btfss INTCON,2
        goto PAUSE2
        BCF INTCON,2
        decfsz STORE,F
        goto PAUSE2
        return

        ORG $2100    ; data values for EEPROM
        DE $03,$0A   :A0  220.000
        DE $03,$69   ;B0  246.941
        DE $03,$9D   ;C0  261.625
        DE $04,$0E   ;D0  293.664
        DE $04,$8D   ;E0  329.627
        DE $04,$D3   ;F0  349.229
        DE $05,$6A   ;G0  391.995
        DE $00,$00   :nil 000.000
        DE $06,$14   ;A1  440.000
        DE $06,$D2   ;B1  493.883
        DE $07,$3A   ;C1  523.251
        DE $08,$1D   ;D1  587.328
        DE $09,$1B   ;E1  659.254
        DE $09,$A6   ;F1  698.458
        DE $0A,$D5   ;G1  783.990
        DE $00,$00   :nil 000.000

        ;0,0,$03,$03,$03,$04,$04,$04,$05,$00,$06,$06,$07,$08,$09,$09,$0A,$00

        DE $03,$0A   :A0  220.000
        DE $03,$69   ;B0  246.941
        DE $03,$9D   ;C0  261.625
        DE $04,$0E   ;D0  293.664
        DE $04,$8D   ;E0  329.627
        DE $04,$D3   ;F0  349.229
        DE $05,$6A   ;G0  391.995
        DE $00,$00   :nil 000.000
        DE $06,$14   ;A1  440.000
        DE $06,$D2   ;B1  493.883
        DE $07,$3A   ;C1  523.251
        DE $08,$1D   ;D1  587.328
        DE $09,$1B   ;E1  659.254
        DE $09,$A6   ;F1  698.458
        DE $0A,$D5   ;G1  783.990
        DE $00,$00   :nil 000.000


        .END              ; of program



