; SPEECH876RECORD150.ASM 16APR07
; record phonemes for Speech Synth

; PIC16F876-20

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
#DEFINE BLOCK0 BCF H'03',7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF H'03',7 ; set   STATUS bit 7 (IRP)
#DEFINE CHAN0 iorlw B'00000000'
#DEFINE SERIALDELAY call CYCLES25
; CYCLES25 for 20MHz, CYCLES5 for 4MHz or below

    list p=16f876
    include p16f876.inc
    __config  $3F32   ; 20MHz

        CBLOCK

STORE
CLKCNT
COUNTERLSB
COUNTA
LOOPA
LOOPB
LOOP
LOOPMSB
FILELENMSB
FILELENLSB
PRMGET

; ******* serial eeprom equates

MEMHI     
MEMLO     
WADDRL    
WADDRH    
RADDRH
RADDRL    
POLLCNT     ; serial eeprom use
SLAVE       ; serial eeprom use
TXBUF       ; serial eeprom use
BCOUNT  
COUNT   
DATAI   
DATAO   
EEPROM  
ECHAN
MEMFUL
COUNTERMSB
RCSTORE

	ENDC

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

DI:         EQU 7        ; eeprom input bit
DO:         EQU 6        ; eeprom output bit
SDATA:      EQU 4        ; serial EE data & RTC data line (PORTC) 
SCLK:       EQU 3        ; serial EE clock 

PROMVAL .EQU $70    ; in both pages
SPBRG   .EQU $99    ; not in INC file for some odd reason.  Bank 1

    
        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF

;*******************

STARTIT:
        bcf STATUS,RP0
        bcf STATUS,RP1

        clrf PORTA
        clrf PORTB
        clrf PORTC
        clrf ECHAN

        BANK1
        movlw B'00000000'     ; PORTB as output
        movwf TRISB
        movlw B'00000001'     ; RA0 as input
        movwf TRISA

        movlw B'00001110'     ; set LHS justify, set for analog RA0
        movwf ADCON1          ; other PORTA digital I/O
                              ; PORTB pull ups

        movlw B'10000000'     ; bits 0-2 not used
                              ; bits 3,4 as output for serial eeprom, RC5 not used
                              ; RC6 as RS232 out, RC7 as RS232 in
        movwf TRISC
        movlw B'00000111'     ; set timer ratio 1:256, pull-ups on
        movwf OPTION_REG
        BANK0

        movlw B'01000001'       ; set AD on, Fosc/8
        CHAN0                   ; set for CHAN0 - RA0
        movwf ADCON0

;****************** START OF MAIN

MAIN:   clrf INTCON
        call PAUSIT
        clrf INTCON
        call PAUSIT
        call SETBAUD
        clrf STORE
        clrf    STATUS                ; Select bank 0
        clrf    INTCON                ; No interrupts
        clrf    PCLATH                ; Code is in first bank

WAITPC: btfss   PIR1,RCIF    ; Check for any RX'd data
        goto WAITPC          ; wait Start command from PC
        movf RCREG,W         ; get recd val, is it - "G"
        movwf RCSTORE

        movf RCSTORE,W
        xorlw 'G'
        btfsc STATUS,Z
        goto TEMPA

        movf RCSTORE,W
        xorlw 'S'             ; does it = S ?
        btfsc STATUS,Z
        goto RECEIVEDATA      ; yes

        movf RCSTORE,W
        xorlw 'P'             ; does it = P ?
        btfsc STATUS,Z
        goto READSERIALEEPROM ;
        goto WAITPC           ; no

TEMPA:;  bsf PORTA,1          ; turn on LED
        bsf ADCON0,GO        ; start data conversion

GETADC0: btfsc ADCON0,GO
        goto GETADC0
;        movf ADRESH,W        ; get ADC MSB val (ignore LSB)
;        bsf ADCON0,GO        ; restart data conversion
;        addlw 120            ; is val >136 (Carry set)

;        btfss STATUS,C
;        goto GETADC0         ; no
        bsf PORTA,1         ; yes, turn on LED

        clrf LOOPA
        movlw 12
        movwf LOOPB

GETADC4: btfsc ADCON0,GO
        goto GETADC4
        movf ADRESH,W        ; get ADC MSB val (ignore LSB)
        bsf ADCON0,GO        ; restart data conversion
        call TXBYTE

       decfsz LOOPA,F
       goto GETADC4          ; no, get next data
       decfsz LOOPB,F
       goto GETADC4          ; no, get next data

       bcf PORTA,1         ; set LED off
       goto WAITPC

;*****************************************************************************

PAUSIT: movlw 14        ; 1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:  btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                         ;This routine is entered with W holding
                         ;the eeprom byte address at which data
                         ;is to be stored. The data to be stored
                         ;is held in PROMVAL
SETPRM: bsf STATUS,RP1   ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR      ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1   ;set for Page 0
        MOVF PROMVAL,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1   ;set for Page 2
        movwf EEDATA     ;copy W into eeprom data byte register
        bsf STATUS,RP0   ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN  ;enable write flag

MANUAL: movlw H'55'      ;these lines cause the action required by
        movwf EECON2     ;by the eeprom to store the data in EEDATA
        movlw H'AA'      ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR    ;set the ``perform write'' flag
        bcf STATUS,RP1   ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF  ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF    ;clear bit 4 of PIR2
        return


;CONVERTED MPASM FILE C:\ASMCNV\2WDPOLL.ASM
;       TO TASM  FILE C:\PIC\2WDPOLL.ASM 03-12-1999 19:28:42
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
; the original used timings based on a 4MHz clock
; this routine has been modified to enable different xtal rates
; Defining SERIALDELAY as "call CYCLE5" is for 4MHz or less xtal
; Defining SERIALDELAY as "call CYCLE25" is for 20MHz xtal

          ;***************************************************************
          ;       Byte Write Routine with data polling
          ;***************************************************************

WRBYTE:   movwf DATAO         ;entry with val to send in W, stored to DATAO
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE

BYTE:     CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; move slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRL,W       ; send address low byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF DATAO,W        ; move data byte
          MOVWF TXBUF         ; to tranmit buffer
          CALL TX             ; and transmit it
          CALL BSTOP          ; generate stop bit

          MOVLW 40            ; now start polling for a low ack bit
          MOVWF POLLCNT       ; set max number of times to poll
POLL:     CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it
          BTFSS EEPROM,DI     ; was the ack bit low?
          GOTO EXITPOLL       ; yes, do another byte
          DECFSZ POLLCNT,F    ; is poll counter down to zero?
          GOTO POLL           ; no, poll again.
EXITPOLL: return

          ;**************************************************************
          ;       Start Bit Subroutine - generates a start bit
          ;       (Low going data line while clock is high)
          ;**************************************************************

BSTART:   BSF PORTC,SDATA    ; make sure data is high
          BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC        ; set data and clock lines for output
          BANK0
          BCF PORTC,SCLK     ; make sure clock is low
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SDATA    ; data line goes low during
                             ; high clock for start bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; start clock train
          NOP                 
          NOP                 
          RETLW 0             

          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP:    BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC        ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA    ; make sure data line is low
          SERIALDELAY        ; timing adjustment        
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BSF PORTC,SDATA    ; data goes high while clock high for stop bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; set clock low again
          SERIALDELAY        ; timing adjustment
          RETLW 0

            ;*************************************************************
            ;       BITOUT routine takes one bit of data in 'do' and
            ;       transmits it to the serial EE device
            ;*************************************************************

BITOUT:   BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BTFSS EEPROM,DO    ; check for state of data bit to xmit
          GOTO BITLOW        ;
          BSF PORTC,SDATA    ; set data line high
          GOTO CLKOUT        ; go toggle the clock

BITLOW:   BCF PORTC,SDATA    ; output a low bit
CLKOUT:   BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; return clock line low
          RETLW 0             

          ;**************************************************************
          ;       BITIN routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN:    BSF EEPROM,DI      ; assume input bit is high
          BANK1
          movlw %10110111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BSF PORTC,SDATA    ; set sdata line for input
          BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI      ; input bit was low
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX:       MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP:     BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; otherwise data bit =1
          CALL BITOUT         ; serial data out
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP           ; no - go again
          CALL BITIN          ; read ack bit
          RETLW 0             
                              
;CONVERTED MPASM FILE C:\ASMCNV\2WSEQR.ASM
;       TO TASM  FILE C:\PIC\2WSEQR.ASM 03-12-1999 19:29:04

          ;************************************************************
          ;       2-Wire Sequential Read Program
          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP2:   BANK1
          movlw %10100111     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC         ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA     ; make sure data line is low
          SERIALDELAY
          BSF PORTC,SCLK      ; set clock high
          SERIALDELAY
          BSF PORTC,SDATA     ; data goes high while clock high for stop bit
          SERIALDELAY
          BCF PORTC,SCLK      ; set clock low again
          SERIALDELAY
          RETLW 0

          ;**************************************************************
          ;       BITIN2 routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN2:   BSF EEPROM,DI       ; assume input bit is high
          BANK1
          movlw %10110111     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BSF PORTC,SCLK      ; set clock line high
          SERIALDELAY
          BTFSS PORTC,SDATA   ; read the data bit
          BCF EEPROM,DI       ; input bit was low, set 'di' accordingly
          BCF PORTC,SCLK      ; set clock line low
          RETLW 0             

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX2:      MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP2:    BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; no, set it high
          CALL BITOUT         ; send the bit to serial EE
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP2          ; no - go again
          CALL BITIN2         ; read ack bit
          BTFSC EEPROM,DI     ; check ack bit
          NOP
          RETLW 0             

          ;****************************************************************
          ;       Receive data Routine
          ;****************************************************************

RX:       MOVLW 8             ; set # bits to 8
          MOVWF COUNT         
          CLRF DATAI          ; clear input register
          BCF STATUS,0        ; make sure carry bit is low
RXLP:     RLF DATAI,F         ; rotate DATAI 1 bit left
          CALL BITIN2         ; read a bit
          BTFSC EEPROM,DI     
          BSF DATAI,0         ; set bit 0 if necessary
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO RXLP           ; no, do another
          RETLW 0             

          ;**************************************************************
          ;       READ (sequential read routine)
          ;**************************************************************

READ:     MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE:    CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf MEMLO         ; data low byte
          return

LOWACK:   movf DATAI,W
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE          ; and read another byte

; *****************

INCADDRESS: clrf MEMFUL    ; inc write address
         movlw 2
         addwf WADDRL,F    ;inc write address by 2
         btfss STATUS,C
         return
         incfsz WADDRH,F     ; has MSB rolled over?
         return            ; no
         incf ECHAN,F      ; yes
         return

INCREADADDRESS:
         movlw 1
         addwf RADDRL,F    ;inc read address by 1
         btfss STATUS,C
         return 
         incf RADDRH,F
         return 

INCCOUNTER:
         movlw 1
         addwf COUNTERLSB,F    ;inc read address by 1
         btfss STATUS,C
         return 
         incf COUNTERMSB,F
         return

; *****************

CLEARADR: clrf MEMHI
        clrf MEMLO
        clrf RADDRH      ; set read address MSB
        clrf RADDRL      ; set read address LSB
        clrf ECHAN
        clrf MEMFUL
        return

;*********** cycles pause called by Serial EEPROM write routines ****

; the CALL takes 2 clock cycles
; the RETURN takes 2 clock cycles
; a pause of 4 clock cycles is created by just CALLing CYCLES4 and returning
; each NOP adds a further 1 cycle pause

CYCLES25:  NOP
CYCLES24:  NOP
CYCLES23:  NOP
CYCLES22:  NOP
CYCLES21:  NOP
CYCLES20:  NOP
CYCLES19:  NOP
CYCLES18:  NOP
CYCLES17:  NOP
CYCLES16:  NOP
CYCLES15:  NOP
CYCLES14:  NOP
CYCLES13:  NOP
CYCLES12:  NOP
CYCLES11:  NOP
CYCLES10:  NOP
CYCLES9:   NOP
CYCLES8:   NOP
CYCLES7:   NOP
CYCLES6:   NOP
CYCLES5:   NOP
CYCLES4:   return

;*************

SETBAUD:

; TRISC must have bit 7 set for this to work, eg :
;        movlw B'10000000'     ; RC7 as input (RS232 receive)
;        movwf TRISC

        bcf STATUS,RP1
        bsf STATUS,RP0

        movlw 64                ; 19200 Baud with 20MHz XTAL (See PIC data sheet for these values)
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed) & ASYNC transmission
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call 	FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop: nop

Rec2:   btfss   PIR1,RCIF       ; Check for any RX'd data
        goto RecLoop
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

; Send byte to output

TxByte:
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

;*************

;SERIALMEM01 30MAR02 from LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER MODIFIED EXTRACT

SAVESAMPLE:  movf MEMHI,W  ; store MSB
        call WRBYTE
        incf WADDRL,F      ; inc address
        movf MEMLO,W       ; store LSB
        call WRBYTE
        decf WADDRL,F      ; dec address back to prev count
        call INCADDRESS
        return

;*************

RECEIVEDATA:
        bsf PORTA,1 ; turn on LED

        movlw 'S'
        call TXBYTE
        clrf WADDRH
        clrf WADDRL
        clrf RADDRH
        clrf RADDRL
        clrf LOOP

RD1:    btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD1            ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf PROMVAL       ; MSB of file length
        movwf FILELENMSB

        call TXBYTE
        movf LOOP,W
        call SETPRM         ; store file len data in PIC eeprom at 0
        incf LOOP,F

RD1A:   btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD1A           ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf STORE
        call TXBYTE
        movf STORE,W
        movwf PROMVAL       ; LSB of file length
        andlw 254
        movwf FILELENLSB

        movf LOOP,W
        call SETPRM         ; store file len data in PIC eeprom at 0

RD2:    btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD2            ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf MEMHI
        call TXBYTE         ; ack back to PC

RD3:    btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD3            ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf MEMLO
        call TXBYTE         ; ack back to PC

        call SAVESAMPLE     ; save both bytes to serial eeprom
        movf WADDRH,W
        movwf PORTC

        movf WADDRH,W       ; is write address MSB same as FILELENMSB ?
        xorwf FILELENMSB,W
        btfss STATUS,Z
        goto RD2            ; no

        movf WADDRL,W       ; is write address LSB same as FILELENLSB ?
        xorwf FILELENLSB,W
        btfss STATUS,Z
        goto RD2            ; no

        call TXBYTE         ; yes, send extra bytes in case PC prog waiting
        call TXBYTE         ; for triplet completion

        goto 0

;hereZZ: nop
;        goto hereZZ

;        goto 0

READSERIALEEPROM:  ; author's use only
        movf RCSTORE,W
        bsf PORTA,1

        clrf RADDRH      ; set read address MSB
        clrf RADDRL      ; set read address LSB
        clrf ECHAN
TRBD1:  call READ
        movf MEMHI,W
        call TXBYTE

        incfsz RADDRL,F
        goto TRBD1

        bcf PORTA,1

        goto 0

herek:  nop
        goto herek

        END

        ORG $2100
        DE 0,128,0,0,3,255
   
    END                ; End of program
