VERSION 5.00
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#9.0#0"; "EPESeralIO.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Sample1 - PerformLoopBackTest"
   ClientHeight    =   3675
   ClientLeft      =   2685
   ClientTop       =   2340
   ClientWidth     =   7650
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3675
   ScaleWidth      =   7650
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   180
      Top             =   225
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.ListBox List1 
      Height          =   2790
      Left            =   120
      TabIndex        =   1
      Top             =   810
      Width           =   7395
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Start"
      Height          =   360
      Left            =   810
      TabIndex        =   0
      Top             =   255
      Width           =   1470
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub Command1_Click()
    Dim X           As Integer

    On Error GoTo ErrorHandler
    
    Command1.Enabled = False         ' Don't want people clicking the button again while were busy
    List1.Clear
    
    With EPESerial1                  ' Use a With here as it saves in typing EPESerial1 for every line AND is faster to execute
        .ComPort = 1                 ' Change this to your COM port no
        .Speed = sio19200            ' Sets speed to 19200 baud
        .WordLength = sio8Bits       ' 8 Bits per word
        .StopBits = sio1Bit          ' 1 stop bit
        .Parity = sioNoParity        ' No Parity
        .PortStatus = sioPortOpen    ' Open the serial port
        
        X = .PerformLoopBackTest(10) ' Perform loopback test 10 times
                                     ' AND return how many times the LoopBack worked
                                     ' without errors.
                                     ' Each one of the 10 tests, raises an event
                                     ' within the EPESerial control.
                                     ' Checkout 'EPESerial1_LoopBack' for code that creates
                                     ' entries in the list box indicating a pass or fail.
                                     
        
        .PortStatus = sioPortClosed  ' Tidy up - Close the serial port
    End With
    
    MsgBox "Testing resulted in:" & Format$(X) & ", Passes !"
    
    Command1.Enabled = True          ' Re-enable the button, ready for another test
    Exit Sub
    
ErrorHandler:
    MsgBox "An error occured in 'Command1_Click' - The error was:" & Err.Description, vbOKOnly + vbCritical, "Critical Error"
    '
    ' Attempt to tidy up
    On Error Resume Next ' Ignore any further errors
    EPESerial1.PortStatus = sioPortClosed
    
    Command1.Enabled = True          ' Re-enable the button, ready for another test
End Sub




Private Sub EPESerial1_LoopBack(ByVal TestNumber As Integer, ByVal TestPass As Boolean, ByVal RXBufferContents As String)

    ' This event fires each time a loop-back test has been performed.
    ' 'TestNumber' counts from 1 to n
    ' 'TestPass' indicates if the loop-back test completed correctly
    ' 'BufferContents' contains any characters that were received from the serial port
    
    List1.AddItem "Test Number:" & Format$(TestNumber, "00") & ", Success:" & Format$(TestPass, "Yes/No") & ", Buffer Contents=" & RXBufferContents
    
End Sub

