; ORGANNEWLEDS200.ASM 24NOV06   LEDS EXAMPLE DISPLAY
; COPYRIGHT JOHN BECKER

; PIC16F877, INTERNAL OSC WDT OFF, POR ON, RC osc
; EXT OSC SOURCE IC1 OSC2 MAIN UNIT PCB

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5

        List P = PIC16F877, R=DEC; 
        __CONFIG  h'3F32'  ; h'3F33'
        include P16F877.inc

        CBLOCK
RATE
STORE

COLUMNB0  ; dummy - for use with PCL allocation
COLUMNB1  ; the 12 LED columns
COLUMNB2
COLUMNB3
COLUMNB4
COLUMNB5
COLUMND1
COLUMND2
COLUMND3
COLUMND4
COLUMND5
COLUMNE1
COLUMNE2

DELAY0 ; dummy
DELAY1 ; note length delays
DELAY2
DELAY3
DELAY4
DELAY5
DELAY6
DELAY7
DELAY8
DELAY9

LENGTHNOTE
NOTEVAL
NOTELENFLAG

CHOSEN0 ; temp store for chosen path selection
CHOSEN1 ; chosen note path number (out of 8 total)
CHOSEN2
CHOSEN3
CHOSEN4
CHOSEN5
CHOSEN6
CHOSEN7
CHOSEN8
CHOSEN9

SELECTCOL0
SELECTCOL1
SELECTCOL2
SELECTCOL3
SELECTCOL4
SELECTCOL5
SELECTCOL6
SELECTCOL7
SELECTCOL8
SELECTCOL9

CONTFLAG
SWITCH
LOOPA
LOOPB
PRMLOOP

	ENDC

PROMVAL .EQU $70    ; in both banks
SPBRG   .EQU $99    ; not in INC file for some odd reason.  Bank 1

; **********************

        ORG 0
        goto GIEOFF
        nop
        nop
        nop
        ORG 4                 ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE        ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

;*******************

OCTAVE: swapf NOTEVAL,W
        andlw %00000111    ; octave rate in bits 4-7, swapping to become 0-3
        addwf PCL,F
        retlw 0          ; 0 not used
        retlw %10000000  ; 1  A = 55   Oct
        retlw %01000000  ; 2  A = 110  Oct 
        retlw %00100000  ; 3  A = 220  Oct 
        retlw %00010000  ; 4  A = 440  Oct 
        retlw %00001000  ; 5  A = 880  Oct 
        retlw %00000100  ; 6  A = 1760 Oct 
        retlw %00000010  ; 7  A = 3520 Oct 

SETLEN: bcf CONTFLAG,0
        andlw %00001111
        addwf PCL,F
        retlw 0         ; 0  nil
        retlw 2         ; 1  demisemiquaver
        retlw 4         ; 2  semiquaver
        retlw 8         ; 3  quaver
        retlw 16        ; 4  crotcHet
        retlw 32        ; 5  minim   
        retlw 64        ; 6  semibreve
        retlw 128       ; 7  breve
        retlw 3         ; 8  demisemiquaver dotted
        retlw 6         ; 9  semiquaver dotted
        retlw 12        ; 10 quaver dotted
        retlw 24        ; 11 crotchet dotted
        retlw 48        ; 12 minim dotted
        retlw 96        ; 13 semibreve dotted
        retlw 192       ; 14 breve dotted
        bsf CONTFLAG,0  ; 15 continuous
        bcf CHOSEN1,0     
        call CLEARDISPLAYS
        retlw 32

ROUTEIT: movf CHOSEN0,W  ;  which note path to use
        addwf PCL,F
        return         ;0 all paths chosen
        goto VAL1      ;1 Path 1
        goto VAL2      ;2 Path 2
        goto VAL3      ;3 Path 3
        goto VAL4      ;4 Path 4
        goto VAL5      ;5 Path 5 
        goto VAL6      ;6 Path 6 
        goto VAL7      ;7 Path 7 
        goto VAL8      ;8 Path 8
        goto VAL9      ;9 Path 9

SWITCHVAL: movf SWITCH,W
        addwf PCL,F
        retlw 0
        retlw 2
        retlw 4 
        retlw 7

DOLOOPA: movf LOOPA,W
        andlw 7
        addwf PCL,F
        goto OUTCOLB1
        goto OUTCOLB2
        goto OUTCOLB3
        goto OUTCOLB4
        goto OUTCOLB5
        goto OUTCOLE1  ; 9 nov
        goto OUTCOLE2  ; 9 nov

;***********

START:  bcf STATUS,RP0
        bcf STATUS,RP1

        clrf PORTA            ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
	clrf PRMLOOP

        BANK1
        movlw %10000111       ; all digital I/O
        movwf ADCON1
        movlw %00010001       ; RA0, RA4 as input
        movwf TRISA

        clrf TRISB            ; PORTB as output
        movlw 255
        movwf TRISC           ; PORTC as input
        clrf TRISD            ; PORTD as output
        clrf TRISE            ; PORTE as output

        movlw B'00000110'     ; set for digital RA, RE
        movwf ADCON1

        movlw B'10000000'                ; timer 1:2, pull-ups off
        movwf OPTION_REG
        BANK0

        call SETUP

; *************** START OF MAIN PROG ***********

LOOPIT: clrf PORTA
        clrf PORTE

        clrf LOOPA
        movlw 16
        movwf LOOPB


LOOPIT3: clrf SWITCH          ; get note length rate from switches
	btfsc PORTA,0
	bsf SWITCH,0
	btfsc PORTA,4
	bsf SWITCH,1
        call SWITCHVAL
        BANK1
        movwf OPTION_REG
        BANK0

        call DOLOOPA

        btfsc PORTC,7   ; is bit 7 set (note length value byte)?
        goto NOTELENGTH  ; yes. Immediate response for NOTELENGTH data
        movf PORTC,W
        movwf NOTEVAL

        bcf NOTELENFLAG,0       ; clear note length flag

LOOPIT4: decfsz LOOPB,F
        goto LOOPIT3

        movlw 16
        movwf LOOPB

        incf LOOPA,F

        movf LOOPA,W
        xorlw 7
        btfss STATUS,Z
        goto LOOPIT3
        clrf LOOPA

LOOPIT2: call DODELAYS
        goto LOOPIT3

CHOSENROUTE: movlw 1
        btfss CHOSEN1,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 2
        btfss CHOSEN2,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 3
        btfss CHOSEN3,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 4
        btfss CHOSEN4,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 5
        btfss CHOSEN5,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 6
        btfss CHOSEN6,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 7
        btfss CHOSEN7,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 8
        btfss CHOSEN8,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 9         ; all paths in use

VALCHOSEN: movwf CHOSEN0
        return

NOTELENGTH: movf NOTELENFLAG,W
        andlw 1
        btfss STATUS,Z          ; has note length flag been set?
        goto LOOPIT4            ; yes, continue LOOPA
        movf PORTC,W            ; no, so update all
        call SETLEN             ; get note length

        movwf LENGTHNOTE

        call OCTAVE             ; get note val & oct data
        movwf RATE
        call CHOSENROUTE
        bsf NOTELENFLAG,0       ; set note length flag
        goto ROUTEIT            ; do update

DODELAYS: btfss INTCON,2        ; has a timer time-out been detected?
        return                  ; no

DEC1:   decfsz DELAY1,F         ; no, dec DELAYA, is it zero?
        goto DEC2               ; no
        bcf CHOSEN1,0           ; clear flag to show path now free
        movf SELECTCOL1,W
        movwf FSR
        clrf INDF

DEC2:   decfsz DELAY2,F         ; is it zero?
        goto DEC3               ; no
        bcf CHOSEN2,0           ; clear flag to show path now free
        movf SELECTCOL2,W
        movwf FSR
        clrf INDF

DEC3:   decfsz DELAY3,F         ; is it zero?
        goto DEC4               ; no
        bcf CHOSEN3,0           ; clear flag to show path now free
        movf SELECTCOL3,W
        movwf FSR
        clrf INDF

DEC4:   decfsz DELAY4,F         ; is it zero?
        goto DEC5               ; no
        bcf CHOSEN4,0           ; clear flag to show path now free
        movf SELECTCOL4,W
        movwf FSR
        clrf INDF

DEC5:   decfsz DELAY5,F         ; is it zero?
        goto DEC6               ; no
        bcf CHOSEN5,0           ; clear flag to show path now free
        movf SELECTCOL5,W
        movwf FSR
        clrf INDF

DEC6:   decfsz DELAY6,F         ; is it zero?
        goto DEC7               ; no
        bcf CHOSEN6,0           ; clear flag to show path now free
        movf SELECTCOL6,W
        movwf FSR
        clrf INDF

DEC7:   decfsz DELAY7,F         ; is it zero?
        goto DEC8               ; no
        bcf CHOSEN7,0           ; clear flag to show path now free
        movf SELECTCOL7,W
        movwf FSR
        clrf INDF

DEC8:   decfsz DELAY8,F         ; is it zero?
        goto DECNIL             ; no
        bcf CHOSEN8,0           ; clear flag to show path now free
        movf SELECTCOL8,W
        movwf FSR
        clrf INDF

DECNIL: clrf INTCON
        return

VAL1:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL1
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY1
        clrf LENGTHNOTE
        bsf CHOSEN1,0      ; flag to show path chosen
        goto LOOPIT

VAL2:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL2
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY2
        clrf LENGTHNOTE
        bsf CHOSEN2,0      ; flag to show path chosen
        goto LOOPIT

VAL3:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL3
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY3
        clrf LENGTHNOTE
        bsf CHOSEN3,0      ; flag to show path chosen
        goto LOOPIT

VAL4:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL4
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY4
        clrf LENGTHNOTE
        bsf CHOSEN4,0      ; flag to show path chosen
        goto LOOPIT

VAL5:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL5
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY5
        clrf LENGTHNOTE
        bsf CHOSEN5,0      ; flag to show path chosen
        goto LOOPIT

VAL6:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL6
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY6
        clrf LENGTHNOTE
        bsf CHOSEN6,0      ; flag to show path chosen
        goto LOOPIT

VAL7:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL7
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY7
        clrf LENGTHNOTE
        bsf CHOSEN7,0      ; flag to show path chosen
        goto LOOPIT

VAL8:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL8
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY8
        clrf LENGTHNOTE
        bsf CHOSEN8,0      ; flag to show path chosen
        goto LOOPIT

VAL9:   movf NOTEVAL,W
        andlw 15             ; note val in LSB
        movwf STORE
        movlw COLUMNB0       ; add note to address of COLUMNB0
        addwf STORE,W
        movwf FSR
        movwf SELECTCOL9
        movf RATE,W          ; octave held in rate
        movwf INDF           ; put into correct column
        movf LENGTHNOTE,W
        movwf DELAY9
        clrf LENGTHNOTE
        bsf CHOSEN9,0      ; flag to show path chosen
        goto LOOPIT

SETUP:  clrf INTCON     ;clear interrupt flag
        clrf NOTELENFLAG

        movlw 32 
        movwf DELAY1
        movwf DELAY2 
        movwf DELAY3
        movwf DELAY4
        movwf DELAY5 
        movwf DELAY6
        movwf DELAY7 
        movwf DELAY8
        movwf DELAY9

        clrf CHOSEN1
        clrf CHOSEN2
        clrf CHOSEN3
        clrf CHOSEN4
        clrf CHOSEN5
        clrf CHOSEN6
        clrf CHOSEN7
        clrf CHOSEN8
        clrf CHOSEN9
        clrf NOTEVAL
        call CLEARDISPLAYS

        movlw 4
        movwf RATE

        clrf CONTFLAG
        return

OUTCOLB1:
        clrf PORTE
        comf COLUMNB1,W
        movwf PORTB
        comf COLUMND1,W
        movwf PORTD
        movlw 4
        movwf PORTA
        return

OUTCOLB2: comf COLUMNB2,W
        movwf PORTB
        comf COLUMND2,W
        movwf PORTD
        movlw 2
        movwf PORTA
        return

OUTCOLB3: comf COLUMNB3,W
        movwf PORTB
        comf COLUMND3,W
        movwf PORTD
        movlw 8
        movwf PORTA
        return

OUTCOLB4: clrf PORTA
        comf COLUMNB4,W
        movwf PORTB
        comf COLUMND4,W
        movwf PORTD
        movlw 1
        movwf PORTE
        return

OUTCOLB5:
        clrf PORTE
        comf COLUMNB5,W
        movwf PORTB
        comf COLUMND5,W
        movwf PORTD
        movlw 32
;        movlw %00100100
        movwf PORTA
        return

OUTCOLE1:
        clrf PORTA
        comf COLUMNE1,W
        movwf PORTD
        movlw 2
        movwf PORTE
        return

OUTCOLE2:  comf COLUMNE2,W
        movwf PORTD
        movlw 4
        movwf PORTE
        return

CLEARDISPLAYS: clrf COLUMNB1
        clrf COLUMNB2
        clrf COLUMNB3
        clrf COLUMNB4
        clrf COLUMNB5
        clrf COLUMND1
        clrf COLUMND2
        clrf COLUMND3
        clrf COLUMND4
        clrf COLUMND5
        clrf COLUMNE1
        clrf COLUMNE2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                          ;This routine is entered with W holding
                          ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1    ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR       ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0    ;set for Page 3
        bcf EECON1,EEPGD  ;point to data memory
        bsf EECON1,RD     ;enable read flag
        bcf STATUS,RP0    ;set for Page 2 
        movf EEDATA,W     ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1    ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                         ;This routine is entered with W holding
                         ;the eeprom byte address at which data
                         ;is to be stored. The data to be stored
                         ;is held in PROMVAL
SETPRM: bsf STATUS,RP1   ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR      ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1   ;set for Page 0
        MOVF PROMVAL,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1   ;set for Page 2
        movwf EEDATA     ;copy W into eeprom data byte register
        bsf STATUS,RP0   ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN  ;enable write flag

MANUAL: movlw H'55'      ;these lines cause the action required by
        movwf EECON2     ;by the eeprom to store the data in EEDATA
        movlw H'AA'      ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR    ;set the ``perform write'' flag
        bcf STATUS,RP1   ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF  ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF    ;clear bit 4 of PIR2
        return

        END

