;PRINT70.ASM 12MAR01 - JOHN BECKER - EPE PIC TO EPSON PRINTER LOGGER

;PIC16F877, 3.2768MHz, WDT OFF, POR ON, XTAL XT

;Config register bits (all PIC TOOLKIT MK2 defaults)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC16F877 data sheet.

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:    .EQU $00  ;page 0, 1, 2, 3
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1

INTCON:  .EQU $0B  ;page 0, 1, 2, 3
ADRESH:  .EQU $1E  ;page 0

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

LOOPA:   .EQU $20        ;loop used by LCD send routine
LOOPB:   .EQU $21        ;general loop
STORE:   .EQU $22
STORE1:  .EQU $23
STORE2:  .EQU $24
RSLINE:  .EQU $25        ;LCD function flag store
SLOWIT:  .EQU $26        ;sample limit value
SWITCH:  .EQU $27
COUNT0:  .EQU $28
COUNT1:  .EQU $29
COUNT2:  .EQU $2A
COUNTER0: .EQU $2B
COUNTER1: .EQU $2C
COUNTER2: .EQU $2D
MEM0:     .EQU $2E       ;memory for ADC sample
FOSC:     .EQU $2F

DIGIT1:  .EQU $30
DIGIT2:  .EQU $31
DIGIT3:  .EQU $32
DIGIT4:  .EQU $33

CLKCNT:  .EQU $34        ;pre-counter for CLOCK
CLKSEC:  .EQU $35        ;CLOCK main counter - secs
CLKMIN:  .EQU $36        ;CLOCK - mins
CLKHRS:  .EQU $37        ;CLOCK - hours

PINOUT:  .EQU $38        ; value sent to printer as pin to activate
STARTIT: .EQU $39        ; start point for drawing printer line
ENDIT:   .EQU $3A        ; end point for drawing printer line
PREVX:   .EQU $3B        ; value of previous sample
LINECNT: .EQU $3C        ; line count of data sent to printer
COUNTP:  .EQU $3D        ; counter used when sending sample to printer
RATE:    .EQU $3E        ; rate at which samples are taken, in secs
RATECNT: .EQU $3F        ; counter for sample taking
TOTAL0:  .EQU $4A        ; total samples taken counter LSB
TOTAL1:  .EQU $4B        ; total samples taken counter MSB

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

RP0:    .EQU 5           ;STATUS reg
RP1:    .EQU 6           ;STATUS reg
GIE:    .EQU 7           ;INTCON reg
GO:     .EQU 2           ;ADCON0 reg
                         ; printer control bits

PAPER:  .EQU 1           ; printer pin 12
BUSY:   .EQU 2           ; printer pin 11
ACK:    .EQU 3           ; printer pin 10

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end initialisation table

PINBIT: movf LINECNT,W  ; get printer pin value to activate
        andlw %00000111
        addwf PCL,F
        retlw %10000000
        retlw %01000000
        retlw %00100000
        retlw %00010000
        retlw %00001000
        retlw %00000100
        retlw %00000010
        retlw %00000001

MESSAGE1: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'R'
        retlw 'A'
        retlw 'T'
        retlw 'E'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

MESSAGE2: addwf PCL,F
        retlw 'W'
        retlw 'A'
        retlw 'I'
        retlw 'T'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'S'
        retlw 'T'
        retlw 'A'
        retlw 'R'
        retlw 'T'
        retlw ' '
        retlw ' '
        retlw ' '

MESSAGEP: addwf PCL,F
        retlw 'W'
        retlw 'A'
        retlw 'I'
        retlw 'T'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'P'
        retlw 'R'
        retlw 'I'
        retlw 'N'
        retlw 'T'
        retlw 'E'
        retlw 'R'
        retlw ' '

MESSAGE3:  addwf PCL,F
        retlw 'S'
        retlw 'A'
        retlw 'M'
        retlw 'P'
        retlw 'L'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'F'
        retlw 'O'
        retlw 'R'
        retlw ' '
        retlw 'O'
        retlw 'N'
        retlw 'C'
        retlw 'E'
        retlw ' '
        retlw 'P'
        retlw 'E'
        retlw 'R'
        retlw ' '
        retlw ' '
        retlw 'S'
        retlw 'E'
        retlw 'C'
        retlw 'O'
        retlw 'N'
        retlw 'D'

MESSAGE4:  addwf PCL,F
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '0'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '1'
        retlw '/'
        retlw '4'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '1'
        retlw '/'
        retlw '2'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '3'
        retlw '/'
        retlw '4'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw 'M'
        retlw 'A'
        retlw 'X'

;..............

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTD
        clrf PORTE
        movlw %10110000  ; INIT=1 (bit 7), AUTO=1 (bit 5), STROBE=1 (bit 4)
        movwf PORTC      ; output control val to printer (STROBE high)

        PAGE1
        movlw %00111111     ;RA0-RA5
        movwf TRISA
        clrf TRISB          ;PORTB as output
        movlw %01001111
        movwf TRISC         ;PORTC
        clrf TRISD          ;PORTD as output
        movlw %00000111     ; CAUTION - setting TRISE bit 4 high sets PORTD
        movwf TRISE         ;PORTE                as slave PORT!

        movlw %00000111     ;set LHS justify, RA0-RA5, as analog inputs
        
        movwf ADCON1        ;with RE digital
        movlw %10000101     ;timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0

        movlw %01000001
        movwf ADCON0        ;set AD on, Fosc/8

        call PAUSIT         ; start up pause
LCDSET: clrf LOOPB          ; initialise LCD
        clrf RSLINE
LCDST2: movf LOOPB,W
        call TABLCD
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,3
        goto LCDST2
        call PAUSIT
        movlw 1
        movwf RATE
        call INCRATE

CLEARIT: clrf CLKSEC     ;clear seconds counter
         clrf CLKMIN     ;clear minutes counter
         clrf CLKHRS     ;clear hours counter
         clrf PREVX
         clrf MEM0
         clrf STARTIT
         clrf ENDIT
         clrf TOTAL0
         clrf TOTAL1
         clrf PINOUT
         clrf MEM0

SHWMSG1: call LCD1       ; show SET RATE message
         bsf RSLINE,4
         clrf LOOPB
SM2:     movf LOOPB,W
         call MESSAGE1
         call LCDOUT
         incf LOOPB,F
         btfss LOOPB,3
         goto SM2

SHWMSG2: call LCD21      ; show WAITING START message
         bsf RSLINE,4
         clrf LOOPB
SM3:     movf LOOPB,W
         call MESSAGE2
         call LCDOUT
         incf LOOPB,F
         btfss LOOPB,4
         goto SM3

         movlw 50
         movwf CLKCNT
         BCF INTCON,2    ;yes

WAITIT:  btfss INTCON,2  ;has a timer time-out been detected?
         goto WAITIT     ;no
         BCF INTCON,2    ;yes
         btfsc PORTE,2   ; is switch on for Start?
         goto CLRMSG1    ; yes
         movf PORTE,W    ; no, get switch value
         andlw %00000111
         movwf SWITCH    ; store it
         btfss STATUS,Z  ; is it zerp
         call GETRATE    ; no, so rate change required
         decfsz CLKCNT,F ; is clock counter zero?
         goto WAITIT     ; no
         movlw 50        ; yes
         movwf CLKCNT
         goto WAITIT

CLRMSG1: call LCD1       ; clear message line 1
         bsf RSLINE,4
         clrf LOOPB
SM4:     movlw ' '
         call LCDOUT
         incf LOOPB,F
         btfss LOOPB,3
         goto SM4

SHWMSGP: call LCD21      ; show WAITING PRINTER message
         bsf RSLINE,4
         clrf LOOPB
SMP:     movf LOOPB,W
         call MESSAGEP
         call LCDOUT
         incf LOOPB,F
         btfss LOOPB,4
         goto SMP


         movlw 50        ;initial basic CLKCNT val for secs timing
         movwf CLKCNT
         clrf SWITCH

WAITACK: btfss PORTC,ACK  ; wait for printer ACKNOWLEDGE to go high
         goto WAITACK

         call INITPRINTER ; initialise printer

CLRMSG2: call LCD21      ; clear message line 2
         bsf RSLINE,4
         clrf LOOPB
SM5:     movlw ' '
         call LCDOUT
         incf LOOPB,F
         btfss LOOPB,4
         goto SM5

         call SETLINE
         call LINEFEED

         clrf LOOPB
SHWMSG3: movf LOOPB,W     ; send 1st text line to printer
         call MESSAGE3
         call PRINTIT
         incf LOOPB,F
         movf LOOPB,W
         xorlw 26
         btfss STATUS,Z
         goto SHWMSG3
         movf RATE,W
         call SHWRATE
         movf DIGIT3,W
         call PRINTIT
         movf DIGIT2,W
         call PRINTIT
         movf DIGIT1,W
         call PRINTIT
SHWMSG4: movf LOOPB,W
         call MESSAGE3
         call PRINTIT
         incf LOOPB,F
         movf LOOPB,W
         xorlw 33
         btfss STATUS,Z
         goto SHWMSG4
         decf RATE,W
         movlw ' '
         btfss STATUS,Z
         movlw 'S'
         call PRINTIT
         call CARRIAGE
         call LINEFEED
         call LINEFEED

         clrf LOOPB
SHWMSG5: movf LOOPB,W       ; send second text line to printer
         call MESSAGE4
         call PRINTIT
         incf LOOPB,F
         movf LOOPB,W
         xorlw 40
         btfss STATUS,Z
         goto SHWMSG5
         call CARRIAGE
         call LINEFEED
         call LINEFEED
         call ADDTIM
         movlw 1
         movwf CLKCNT

;............................ END OF SETUP

MAIN:    btfss INTCON,2  ;has a timer time-out been detected?
         goto MAIN       ;no
         BCF INTCON,2    ;yes
         btfss PORTE,2
         goto ENDPRINT
 
MAIN2:   decfsz CLKCNT,F ;increment system clock counter. Is it = 0?
         goto MAIN
         call ADDSEC

         decfsz RATECNT,F
         goto MAIN

         movf RATE,W
         movwf RATECNT
         incf TOTAL0,F
         btfsc STATUS,Z
         incf TOTAL1,F

         bsf ADCON0,GO     ; start data conversion
       
GETDAT:  btfsc ADCON0,GO   ; get data
         goto GETDAT

         movf ADRESH,W     ; get ADC val

         movwf MEM0
;         movlw 27
;         addwf MEM0,F

         call SHOWIT
         call LCD28         ;show sample value on LCD
         bsf RSLINE,4

         call PRINTER       ; plot sample val to printer
         movf MEM0,W
         movwf PREVX

         movf TOTAL0,W      ; decimalise and show total sample count on LCD
         movwf COUNT0
         movf TOTAL1,W
         movwf COUNT1
         clrf COUNT2
         call DECIML
         call LCD29
         bsf RSLINE,4
         movlw 'T'
         call LCDOUT
         movlw 'L'
         call LCDOUT
         movlw '='
         call LCDOUT
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         goto MAIN

;........

PRINTER: movlw 10         ; plot data to printer routine
         movwf LOOPB
INDENT:  movlw ' '
         call PRINTIT
         decfsz LOOPB,F
         goto INDENT

         movf PREVX,W     ; set printer line start and end points
         movwf STARTIT
         movf MEM0,W
         movwf ENDIT

         subwf STARTIT,W  ; subtract ENDIT from STARTIT
         btfss STATUS,C   ; is there a borrow?
         goto STARTLIN    ; yes
         movf STARTIT,W   ; no, so swap values
         movwf STORE
         movf ENDIT,W
         movwf STARTIT
         movf STORE,W
         movwf ENDIT

STARTLIN: movf STARTIT,W   ; is Start = End?
         xorwf ENDIT,W
         btfsc STATUS,Z
         decf STARTIT,F   ; yes

         movlw 27         ; ESC        set horiz density
         call PRINTIT
         movlw 42         ; *
         call PRINTIT
         movlw 6          ; 6 is horiz/vert for 90dpi/60dpi - page R-65
         call PRINTIT

         movlw 0
         call PRINTIT     ; send LSB  set for 256 bytes to be sent
         movlw 1
         call PRINTIT     ; send MSB

         clrf COUNTP
         clrf PINOUT

SENDVAL: movf STARTIT,W   ; is start val = count val?
         xorwf COUNTP,W
         btfss STATUS,Z
         goto SV2         ; no
         call PINBIT      ; yes, get val of printer pin to be activated
         movwf PINOUT

SV2:     movf ENDIT,W     ; is end val =  count val?
         xorwf COUNTP,W
         btfsc STATUS,Z
         clrf PINOUT      ; yes, so no printer pin to be activated

         movf COUNTP,W    ;
         btfsc STATUS,Z   ; is count = 0?
         goto SV3         ; yes, so send graph line bit
         xorlw 63         ; is count = 63?
         btfsc STATUS,Z
         goto SV3         ; yes, so send graph line bit
         movf COUNTP,W
         xorlw 127        ; is count = 127?
         btfsc STATUS,Z
         goto SV3         ; yes, so send graph line bit
         movf COUNTP,W
         xorlw 191        ; is count = 191?
         btfsc STATUS,Z
         goto SV3         ; yes, so send graph line bit
         movf COUNTP,W
         xorlw 255        ; is count = 255?
         btfsc STATUS,Z
         goto SV3         ; yes, so send graph line bit
         movf PINOUT,W
         goto SV4
SV3:     movlw %10101010
         iorwf PINOUT,W     ;movlw 0         ; send blank
SV4:     call PRINTIT
         incfsz COUNTP,F
         goto SENDVAL

SENDEND: call CARRIAGE   ; send carriage return
         incf LINECNT,F  ; inc line count sent to printer
         movf LINECNT,W  ; is line count MOD 8 = 0 ?
         andlw %00000111
         btfss STATUS,Z
         return          ; no
         call LINEFEED   ; yes, send line feed
         call ADDTIM     ; send time to printer
         return
;.........

SHOWIT: call LCD21        ;show sample value on LCD
        bsf RSLINE,4
        movlw 'D'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf MEM0,W     ;show sample value
        movwf COUNT0
        clrf COUNT1
        clrf COUNT2
        call DECIML
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        return

;.............

PAUSIT: movlw 50            ; pause routine
        movwf SLOWIT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return
;..............

LCD1:   movlw %10000000     ;LCD cell position codes - not all used
        goto LCDLIN
LCD9:   movlw %10001001
        goto LCDLIN

LCD21:  movlw %11000000
        goto LCDLIN

LCD28:  movlw %11001000
        goto LCDLIN
LCD29:  movlw %11001001
        goto LCDLIN

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE           ; send data to LCD routine
        movlw 50
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT
SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        BCF PORTB,5
        RETURN

;.........switch 

GETRATE: decf CLKCNT,W      ; get sampling rate from switch setting
         btfsc STATUS,Z
         goto CHKSW
         xorlw 25
         btfss STATUS,Z
         return

CHKSW:   btfsc SWITCH,0
         goto INCRATE
         btfsc SWITCH,1
         goto DECRATE
         return

INCRATE: incfsz RATE,W
         goto SHWRATE
         movlw 1
         goto SHWRATE         

DECRATE: decfsz RATE,W
         goto SHWRATE         
         movlw 255

SHWRATE: movwf RATE
         movwf RATECNT
         movwf COUNT0
         clrf COUNT1
         clrf COUNT2
         call DECIML

         call LCD9
         bsf RSLINE,4
         movlw 'P'
         call LCDOUT
         movlw 'R'
         call LCDOUT
         movlw 'D'
         call LCDOUT
         movlw '='
         call LCDOUT

         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         return

;............. Modified BIN-DEC ROUTINE - could be tightened up!

DECIML:                   ;decimalise binary number
                          ;on entry COUNT0-2 holds number to be decimalised
                          ;answer goes into DIGIT1-4

        call BINDEC
        call BLANK0       ;blank leading zeros
        return

BINDEC: call CLRDIG       ;reset DIGITs
        movlw 24          ;24 bits to do
        movwf COUNTER1
        goto SHIFT1

ADJBCD  movlw DIGIT1
        movwf FSR         ;pointer to digits
        movlw 4           ;4 ... 7 digits to do (Digit 8 never >4)
        movwf COUNTER2    ;if Digit > 4 then digit = digit + 3
        movlw 3           ;check for Digit > 4 by adding 3 to it
ADJLOOP: addwf INDF,F     ;and test bit 3 of result
        btfss INDF,3      ;is it greater than 7?
        subwf INDF,F      ;restore to original
        incf FSR,F        ;next digit
        decfsz COUNTER2,F
        goto ADJLOOP

SHIFT1: call SLCNT        ;shift MSB into Carry

SLDEC:  movlw DIGIT1      ;shift Carry and Digits 1 bit left
        movwf FSR         ;pointer to digits
        movlw 4           ;4 .... 8 Digits to do
        movwf COUNTER2

SLDLOOP:                  ;after RLF if bit 4 is set then shift 1
        rlf INDF,F        ;into LSB of next Digit else shift 0
        btfsc INDF,4      ;test for BCD carry
        bsf STATUS,C      ;set Carry for next Digit (cleared by RLF)
        bcf INDF,4        ;clear BCD overflow (if any)
        incf FSR,F        ;next Digit
        decfsz COUNTER2,F
        goto SLDLOOP

        decfsz COUNTER1,F ;next bit
        goto ADJBCD
        return

SLCNT:  rlf COUNT0,F      ;LSB
        rlf COUNT1,F      ;shift left count 0-2
        rlf COUNT2,F      ;MSB
        return

CLRDIG: clrf DIGIT1       ;lsd
        clrf DIGIT2
        clrf DIGIT3
        clrf DIGIT4
        return

BLANK0: movlw 4            ; blank leading digits
        movwf LOOPA
        movlw DIGIT4
        movwf FSR
BLANK1: movf INDF,W
        btfss STATUS,Z
        goto BLANK2
        movlw ' '
        movwf INDF
        decf FSR,F
        decfsz LOOPA,F
        goto BLANK1
        movlw 48
        iorwf DIGIT1,F
        return

BLANK2: movlw 48
        iorwf INDF,F
        decf FSR,F
        decfsz LOOPA,F
        goto BLANK2
        return

;..........

ADDSEC: movlw 50          ;reset start value of CLKCNT
        movwf CLKCNT
        incf CLKSEC,F     ;inc secs {all units in BCD}
        movlw 6
        addwf CLKSEC,W    ;if 6 is added is there a digit carry?
        btfss STATUS,DC
        goto CLKSHW       ;no
        movwf CLKSEC      ;yes
        movlw %01100000
        xorwf CLKSEC,W    ;is count = 60?
        btfss STATUS,Z
        goto CLKSHW       ;no
        clrf CLKSEC       ;yes

ADDMIN: incf CLKMIN,F     ;inc mins
        movlw 6
        addwf CLKMIN,W    ;if 6 is added is there a digit carry?
        btfss STATUS,DC
        goto CLKSHW       ;no
        movwf CLKMIN      ;yes
        movlw %01100000
        xorwf CLKMIN,W    ;is count = 60?
        btfss STATUS,Z
        goto CLKSHW       ;no
        clrf CLKMIN       ;yes

ADDHRS: incf CLKHRS,F     ;inc hours
        movlw 6
        addwf CLKHRS,W    ;if 6 is added is there a digit carry?
        btfsc STATUS,DC
        movwf CLKHRS      ;yes
        movlw %00100100
        xorwf CLKHRS,W    ;is HRS = 24?
        btfss STATUS,Z
        goto CLKSHW       ;no
        clrf CLKHRS       ;yes

CLKSHW: call LCD1
        bsf RSLINE,4
        swapf CLKHRS,W  ;get hrs
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        movf CLKHRS,W   ;get units
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        movlw ':'       ;insert colon
        call LCDOUT

        swapf CLKMIN,W  ;get mins
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        movf CLKMIN,W   ;get units
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        movlw '.'       ;insert point
        call LCDOUT

        swapf CLKSEC,W  ;get secs
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        movf CLKSEC,W   ;get units
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        return

;******* PRINTER CONTROL ****** pages nos refer to 1991 Epson ESC/P2 book

INITPRINTER:            ; initialise printer - page C-184
        movlw 27        ; ESC
        call PRINTIT
        movlw 64        ; @
        call PRINTIT
        return

SETLINE:                 ; set n/180 inch line spacing - page C-52, R-12
        movlw %10110000  ; INIT=1 (bit 7), AUTO=1 (bit 5), STROBE=1 (bit 4)
        movwf PORTC      ; output control val to printer (STROBE high)
        nop             ; 1 cycle pause for port to stabilise
        nop             ; 1 cycle pause for printer to stabilise (min requirement is for 1 microsecond - page A-30) 
        movlw 27        ; ESC
        call PRINTIT
        movlw 51        ; @
        call PRINTIT
        movlw 24        ; n = 24
        call PRINTIT
        return
        
;...........

PRINTIT:  call REVERSE    ; reverse order of bits to suit PCB layout

WAITBUSY: btfsc PORTC,BUSY ; wait till BUSY goes low
          goto WAITBUSY
          movwf PORTD     ; output Reversed val held in W - send to printer
;          nop             ; 1 cycle pause for port to stabilise
          nop             ; 1 cycle pause for printer to stabilise (min requirement is for 1 microsecond - page A-30) 
          movlw %10100000 ; INIT=1 (bit 7), AUTO=1 (bit 5), STROBE=0 (bit 4)
          movwf PORTC     ; output control val to printer (STROBE low)
;          nop             ; 1 cycle pause for port to stabilise
          nop             ; 1 cycle pause for printer to stabilise (min requirement is for 0.5 microsecond - page A-30) 
          movlw %10110000 ; INIT=1 (bit 7), AUTO=1 (bit 5), STROBE=1 (bit 4)
          movwf PORTC     ; output control val to printer (STROBE high)
;          nop             ; 1 cycle pause for port to stabilise
;          nop             ; 1 cycle pause for printer to stabilise (min requirement is for 0.5 microsecond - page A-30) 

;WAITBUSY: btfsc PORTC,BUSY ; wait till BUSY goes low
;          goto WAITBUSY
          return

;.......

CARRIAGE: movlw 13         ; cause carriage return
          call PRINTIT
          return
;.........

LINEFEED: movlw 10         ; cause line feed
          call PRINTIT
          btfss PORTC,PAPER
          return
;.......

LINELENGTH: call PRINTIT ; send LSB (brought in on W) - not used
          movlw 0
          call PRINTIT     ;send MSB
          return
;.......

ADDTIM:  swapf CLKHRS,W  ;get hrs
         andlw 15        ;AND to get nibble
         iorlw 48        ;OR with 48 to make ASCII value
         call PRINTIT    ;send
         movf CLKHRS,W   ;get units
         andlw 15        ;AND to get nibble
         iorlw 48        ;OR with 48 to make ASCII value
         call PRINTIT    ;send
         movlw ':'       ;insert colon
         call PRINTIT
  
         swapf CLKMIN,W  ;get hrs
         andlw 15        ;AND to get nibble
         iorlw 48        ;OR with 48 to make ASCII value
         call PRINTIT    ;send
         movf CLKMIN,W   ;get units
         andlw 15        ;AND to get nibble
         iorlw 48        ;OR with 48 to make ASCII value
         call PRINTIT    ;send
         movlw '.'       ;insert point
         call PRINTIT

         swapf CLKSEC,W  ;get hrs
         andlw 15        ;AND to get nibble
         iorlw 48        ;OR with 48 to make ASCII value
         call PRINTIT    ;send
         movf CLKSEC,W   ;get units
         andlw 15        ;AND to get nibble
         iorlw 48        ;OR with 48 to make ASCII value
         call PRINTIT    ;send
         call CARRIAGE
         return

;.............

REVERSE: movwf STORE1   ; reverse order of bits to suit PCB track order
         movlw 8
         movwf LOOPA
REV1:    rrf STORE1,F
         rlf STORE2,F
         decfsz LOOPA,F
         goto REV1
         movf STORE2,W
         return
;............

ENDPRINT: call INITPRINTER
         call LINEFEED
         call LINEFEED
         movlw 'F'
         call PRINTIT
         movlw 'I'
         call PRINTIT
         movlw 'N'
         call PRINTIT
         movlw 'I'
         call PRINTIT
         movlw 'S'
         call PRINTIT
         movlw 'H'
         call PRINTIT
         movlw 'E'
         call PRINTIT
         movlw 'D'
         call PRINTIT
         movlw ' '
         call PRINTIT
         call ADDTIM
         call LINEFEED
         call LINEFEED
         call LINEFEED
         call LINEFEED
         goto CLEARIT

         .END

