; PnM05Nov11.asm 03SEP05 - COPYRIGHT JOHN BECKER
; PIC'n Mix ADC MAX118 demo

;PIC16F877-20, 20MHz, WDT OFF, POR ON, XTAL HS

;PROGRAM WRITTEN IN TASM - MAY NEED TRANSLATING VIA TK3 TO SUIT MPASM

        List P = PIC16F877, R=DEC;
        __CONFIG   h'3F32'

        include P16F877.inc

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

        CBLOCK

ADCSTORE0
ADCSTORE1
ADCSTORE2
ADCSTORE3
ADCSTORE4
ADCSTORE5
ADCSTORE6
ADCSTORE7
LOOPA
STORE1
CLKCNT
RSLINE
COUNT0
COUNT1
COUNT2
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
BITCNT
DIGCNT
LOOP
CHANE
	ENDC

; *********** BITS *******

ADCCS      equ 2         ; PORTC,2
ADCINT     equ 4         ; PORTC,4
ADCRD      equ 5         ; PORTC,5

; **********************

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

SETUP:  call PAUSIT     ;1st delay
LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        call PAUSIT
        return

;*******************

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA       ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE

        bsf PORTC,ADCCS       ; set ADC CS high

        BANK1
        movlw 255
        movwf TRISA           ; PORTA as input
        clrf TRISB            ; PORTB as output
        movlw B'00010000'     ; RC4 input for ADCINT
        movwf TRISC
        movlw 255             ; PORTD as input
        movwf TRISD
        clrf TRISE            ; PORTE as output
        movlw B'00000110'     ; set for digital RA, RE
        movwf ADCON1
        movlw B'10000100'     ; timer 1:32, pull-ups off
        movwf OPTION_REG
        BANK0

        call SETUP            ; lcd setup

; *************** START OF MAIN PROG ***********

MAIN:     call PAUSIT
 	  call PAUSIT
 	  call PAUSIT
 	  call PAUSIT
 	  call PAUSIT
          clrf CHANE
          movlw ADCSTORE0
          movwf FSR

ROUTECHANS: movlw 3
          movwf PORTE
          movf CHANE,W
          call GETCHAN
          movwf INDF
          incf FSR,F
          incf CHANE,F
          btfss CHANE,3
          goto ROUTECHANS
          call SHOWCHANS
          goto MAIN

SHOWCHANS: call LCD1
          movf ADCSTORE0,W
          call BIN2DEC
          call SHOW3
          movf ADCSTORE1,W
          call BIN2DEC
          call SHOW3
          movf ADCSTORE2,W
          call BIN2DEC
          call SHOW3
          movf ADCSTORE3,W
          call BIN2DEC
          call SHOW3

          call LCD21

          movf ADCSTORE4,W
          call BIN2DEC
          call SHOW3
          movf ADCSTORE5,W
          call BIN2DEC
          call SHOW3
          movf ADCSTORE6,W
          call BIN2DEC
          call SHOW3
          movf ADCSTORE7,W
          call BIN2DEC
          call SHOW3
          return

; *************

GETCHAN:  movwf PORTE
          nop
          bcf PORTC,ADCCS       ; start ADC conversion
          nop
          bcf PORTC,ADCRD
WAITADC:  btfsc PORTC,ADCINT    ; wait for ADC INT to go low
          goto WAITADC
          movf PORTD,W          ; get ADC val
          bsf PORTC,ADCRD       ; reset ADC RD & CS
          bsf PORTC,ADCCS
          return

;******** LCD ROUTINES **********

LCD1:     movlw %10000000
          goto LCDLIN
LCD21:    movlw %11000000

LCDLIN:   bcf RSLINE,4
          call LCDOUT
          bsf RSLINE,4
          return

LCDOUT:   movwf STORE1    ;temp store value that will be output to LCD
          movlw 128       ;set minimum time between sending full bytes to LCD
          movwf LOOPA
DELAY:    decfsz LOOPA,F
          goto DELAY
          call SENDIT     ;send MSB, then (by default) send LSB

SENDIT:   swapf STORE1,F  ;swap byte nibbles
          movf STORE1,W   ;get nibble (MSB)
          andlw 15        ;AND to isolate nibble
          iorwf RSLINE,W  ;OR the RS bit
          movwf PORTB     ;output the byte
          bsf PORTB,5     ;set E high
          bcf PORTB,5     ;set E low
          return

; *************

SHOW8:  movf DIGIT8,W  
	call LCDOUT	
SHOW7:  movf DIGIT7,W  
	call LCDOUT	
SHOW6:  movf DIGIT6,W  
	call LCDOUT	
SHOW5:  movf DIGIT5,W  
	call LCDOUT	
SHOW4:  movf DIGIT4,W  
	call LCDOUT	
SHOW3:  movf DIGIT3,W  
	call LCDOUT	
SHOW2:  movf DIGIT2,W  
	call LCDOUT	
SHOW1:  movf DIGIT1,W  
	call LCDOUT	
	movlw ' '
	call LCDOUT	
	return

;*************

PAUSIT: movlw 50        ;wait set
        movwf CLKCNT
        clrf INTCON     ;clear interupt flag
PAUSE:  btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE      ;no
        BCF INTCON,2    ;yes
        decfsz CLKCNT,F ;dec loop, is it zero?
        goto PAUSE      ;no
        return          ;yes

;************

BIN2DEC:
         movwf COUNT0
         clrf COUNT1
         clrf COUNT1

        clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ;24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F        ;Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ;Pointer to DIGITs
        movlw   8               ;8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F          ;Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ;Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ;Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ;Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F       ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F

        movf DIGIT8,W       ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        movf DIGIT7,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT7,4
        movf DIGIT6,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT6,4
        movf DIGIT5,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return

;*************

        END


