VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form MagnetometerFullGrid 
   Caption         =   "Magnetometer and Earth Resistivity Full Grid Display"
   ClientHeight    =   7590
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11880
   Icon            =   "MagnetometerFullGrid.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7590
   ScaleWidth      =   11880
   StartUpPosition =   1  'CenterOwner
   Begin VB.PictureBox Picture1 
      Height          =   6615
      Left            =   1320
      ScaleHeight     =   6555
      ScaleWidth      =   10035
      TabIndex        =   24
      Top             =   840
      Width           =   10095
   End
   Begin VB.CheckBox ShowZero 
      Caption         =   "Show 0"
      Height          =   255
      Left            =   120
      TabIndex        =   23
      ToolTipText     =   "When ticked in Matrix mode shows dots in zero value positions"
      Top             =   6480
      Width           =   855
   End
   Begin VB.CheckBox Resist 
      Caption         =   "Current"
      Height          =   255
      Left            =   120
      TabIndex        =   22
      ToolTipText     =   "Multiplies sample voltage by current value across TX probes"
      Top             =   6240
      Width           =   855
   End
   Begin VB.CheckBox Matrix 
      Caption         =   "Matrix"
      Height          =   255
      Left            =   120
      TabIndex        =   21
      ToolTipText     =   "When ticked square sizes become relative to value"
      Top             =   6000
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   2640
      TabIndex        =   20
      Text            =   "0"
      ToolTipText     =   "Subtracts this value before implementing slider correction values. Press Enter to activate new value"
      Top             =   0
      Width           =   975
   End
   Begin VB.CommandButton RefreshIt 
      BackColor       =   &H00FFFF00&
      Caption         =   "Refresh"
      Default         =   -1  'True
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   13
      ToolTipText     =   "Refresh grid screen"
      Top             =   1080
      Width           =   975
   End
   Begin VB.CommandButton FullGraph 
      BackColor       =   &H0000FF00&
      Caption         =   "Full Graph"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   17
      ToolTipText     =   "Calls up Full Graph display"
      Top             =   720
      Width           =   975
   End
   Begin VB.CommandButton Main 
      BackColor       =   &H0000FFFF&
      Caption         =   "Main"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   6
      ToolTipText     =   "Return to main page"
      Top             =   360
      Width           =   975
   End
   Begin MSComctlLib.Slider Zoomer 
      Height          =   375
      Left            =   0
      TabIndex        =   16
      ToolTipText     =   "Zoom control. Screen scale = image height / zoom. Click Refresh to activate change"
      Top             =   0
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   661
      _Version        =   393216
      LargeChange     =   1
      Min             =   1
      SelStart        =   4
      Value           =   4
   End
   Begin VB.CheckBox Inverter 
      Caption         =   "Invert"
      Height          =   255
      Left            =   120
      TabIndex        =   15
      ToolTipText     =   "When ticked sets high values low and low values high"
      Top             =   5640
      Value           =   1  'Checked
      Width           =   975
   End
   Begin VB.CommandButton Quit 
      BackColor       =   &H0000FF00&
      Caption         =   "Quit"
      Height          =   375
      Left            =   11160
      Style           =   1  'Graphical
      TabIndex        =   14
      ToolTipText     =   "Final exit from program"
      Top             =   0
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Option1"
      Height          =   255
      Index           =   3
      Left            =   840
      TabIndex        =   10
      ToolTipText     =   "As on main page"
      Top             =   1560
      Width           =   255
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Option1"
      Height          =   255
      Index           =   2
      Left            =   600
      TabIndex        =   9
      ToolTipText     =   "As on main page"
      Top             =   1560
      Width           =   255
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Option1"
      Height          =   255
      Index           =   1
      Left            =   360
      TabIndex        =   8
      ToolTipText     =   "As on main page"
      Top             =   1560
      Width           =   255
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Option1"
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   7
      ToolTipText     =   "As on main page"
      Top             =   1560
      Value           =   -1  'True
      Width           =   255
   End
   Begin MSComctlLib.Slider Slider1 
      Height          =   3255
      Left            =   120
      TabIndex        =   0
      ToolTipText     =   "Value multiply/divide"
      Top             =   2160
      Width           =   390
      _ExtentX        =   688
      _ExtentY        =   5741
      _Version        =   393216
      Orientation     =   1
      LargeChange     =   1
      Min             =   1
      Max             =   20
      SelStart        =   1
      TickStyle       =   1
      TickFrequency   =   2
      Value           =   1
   End
   Begin MSComctlLib.Slider Slider4 
      Height          =   3255
      Left            =   600
      TabIndex        =   1
      ToolTipText     =   "Add/Subtract from value after multiplying or dividing"
      Top             =   2160
      Width           =   390
      _ExtentX        =   688
      _ExtentY        =   5741
      _Version        =   393216
      Orientation     =   1
      LargeChange     =   1
      Max             =   250
      TickStyle       =   1
      TickFrequency   =   25
   End
   Begin MSComctlLib.Slider Slider3 
      Height          =   6900
      Left            =   1080
      TabIndex        =   12
      ToolTipText     =   "Allows scroll of image vertically on screen. Refresh must be clicked to activate change"
      Top             =   720
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   12171
      _Version        =   393216
      Orientation     =   1
      Max             =   127
      TickStyle       =   3
   End
   Begin MSComctlLib.Slider Slider2 
      Height          =   375
      Left            =   1440
      TabIndex        =   11
      ToolTipText     =   "Allows scroll of image across screen. Refresh must be clicked to activate change"
      Top             =   360
      Width           =   10365
      _ExtentX        =   18283
      _ExtentY        =   661
      _Version        =   393216
      Max             =   127
      TickStyle       =   3
   End
   Begin VB.Label GPSlabel 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "GPSlabel"
      Height          =   255
      Left            =   4440
      TabIndex        =   27
      Top             =   0
      Visible         =   0   'False
      Width           =   5295
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Label8"
      Height          =   255
      Left            =   120
      TabIndex        =   26
      Top             =   7080
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Label7"
      Height          =   255
      Left            =   120
      TabIndex        =   25
      Top             =   6840
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Wait"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   375
      Left            =   120
      TabIndex        =   18
      Top             =   1800
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.Label Label6 
      Alignment       =   1  'Right Justify
      Caption         =   "Pre-subtract"
      Height          =   255
      Left            =   1560
      TabIndex        =   19
      ToolTipText     =   "Subtracts this value before implementing slider correction values. Press Enter to activate new value"
      Top             =   40
      Width           =   975
   End
   Begin VB.Label MultiplyGrid 
      Alignment       =   2  'Center
      Caption         =   "/"
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   240
      TabIndex        =   2
      ToolTipText     =   "As on Graph page"
      Top             =   1920
      Width           =   255
   End
   Begin VB.Label AddGrid 
      Alignment       =   2  'Center
      Caption         =   "minus"
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   600
      TabIndex        =   3
      ToolTipText     =   "As on Graph page"
      Top             =   1920
      Width           =   495
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "New Value"
      Height          =   255
      Left            =   6960
      TabIndex        =   5
      Top             =   40
      Width           =   3255
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Orig Value"
      Height          =   255
      Left            =   3720
      TabIndex        =   4
      Top             =   40
      Width           =   3255
   End
End
Attribute VB_Name = "MagnetometerFullGrid"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Earth Res Full Grid 18OCT03

Public Sub PlotIt_Click()
If DownloadFlag2 = 1 Then Exit Sub
If PicPath = 1 Then Call MagPlotIt: Exit Sub

Picture1.Cls
Label5.Visible = True: Label5.Refresh
Screen.MousePointer = vbHourglass
B = 0: F = 127: Min2 = 20000: Max2 = 0: Min = 20000: Max = 0
W = Picture1.Width / 128
H = Picture1.Height / 128
H1 = H: W1 = W

Picture1.ScaleHeight = Picture1.Height / Zoomer.Value
Picture1.ScaleWidth = Picture1.Width / Zoomer.Value

X1 = 0

Slider2.Max = FileDataQty(1)

Slider3.Max = MaxLineLen(1) \ 6
StartVal = Slider3.Value * 6 + 1
EndVal = MaxLineLen(1)

For A = Slider2.Value To FileDataQty(1)
tempA$ = FileData(1, A)

D = 0: Y1 = 0

For C = StartVal To EndVal Step 6
V = Val(Mid$(tempA$, C))

v1 = V
If V > 0 Then
If V < Min Then Min = V
If V > Max Then Max = V
Else
If ShowZero.Value = 0 Then GoTo BYPASS
V = 37: GoTo 105
End If

V = V - Val(Text1.Text)
v1 = v1 - Val(Text1.Text)
If Inverter.Value = 1 Then
If v1 > 0 Then v1 = OrigMaxValue - v1
End If

If MultiplyGrid.Caption <> "X" Then
V = V / Slider1.Value
v1 = v1 / Slider1.Value
Else
V = V * Slider1.Value
v1 = v1 * Slider1.Value
End If

If AddGrid.Caption <> "minus" Then
V = V + Slider4.Value
v1 = v1 + Slider4.Value
Else
V = V - Slider4.Value
v1 = v1 - Slider4.Value
End If

If V < 0 Then V = 0
If v1 < 0 Then v1 = 0

If V < Min2 Then Min2 = V
If V > Max2 Then Max2 = V

If Mode2 < 3 Then If V > 36 Then V = 36
If Mode2 = 3 Then If V > 7 Then V = 7

If Inverter.Value = 1 Then
If Mode2 < 3 Then V = 36 - V
If Mode2 = 3 Then V = 7 - V
End If

105:
z1 = X1 + W: z2 = Y1 + H

V = Int(V):
If Matrix.Value = 0 Then
If V <> 37 Then Picture1.Line (X1, Y1)-(z1, z2), Col(Mode2, V), BF: '37
'End If
Else
v2 = v1: v3 = v1

X2 = X1 - (v2 / 2)
X3 = X1 + (v2 / 2)
Y2 = Y1 - (v3 / 2)
y3 = Y1 + (v3 / 2)

gridcol = Col(Mode2, V): If Mode2 = 3 Then gridcol = vbBlack
Picture1.Line (X2, Y2)-(X3, y3), gridcol, BF

End If

BYPASS:

Y1 = Y1 + H: D = D + 1
If Y1 > Picture1.ScaleHeight Then Exit For

Next: X = X + 142: X1 = X1 + W:
If X1 > Picture1.ScaleWidth Then Exit For
Next: Close

Final:
If Min = 65535 Then Min = 0
If Min2 = 65535 Then Min2 = 0
If Max = 0 Then Min = 0
If Max2 = 0 Then Min2 = 0

Label1.Caption = "Orig Value Range Min = " & Min & " Max = " & Max
Label2.Caption = "New Value Range Min = " & Int(Min2) & " Max = " & Int(Max2)
Label5.Visible = False
Screen.MousePointer = vbDefault
Text1.SetFocus
End Sub

Private Sub Matrix_Click()
flag = Option1(3).Value

If Matrix.Value = 1 Then
Option1(3).Value = True
Else
Option1(PrevGridMode) = True
End If
If flag = True Then Call PlotIt_Click

End Sub

Private Sub Form_Unload(Cancel As Integer)
Call Main_Click
End Sub

Private Sub RefreshIt_Click()
Call PlotIt_Click
End Sub

Public Sub FullGraph_Click()
MagnetometerFullGraph.Show
Call MagnetometerFullGraph.PlotIt_Click
End Sub

Private Sub Inverter_Click()
Call PlotIt_Click
End Sub

Private Sub Main_Click()
Magnetometer.Show
End Sub

Private Sub Option1_Click(Index As Integer)
If Index <> 3 Then PrevGridMode = Index
Mode2 = Index: Call PlotIt_Click
End Sub

Private Sub Quit_Click()
End
End Sub

Private Sub MultiplyGrid_Click()
If MultiplyGrid.Caption = "X" Then
MultiplyGrid.Caption = "/"
Else
MultiplyGrid.Caption = "X"
End If
End Sub

Private Sub AddGrid_Click()
If AddGrid.Caption = "minus" Then
AddGrid.Caption = "add"
Else
AddGrid.Caption = "minus"
End If
End Sub

Private Sub resist_Click()
Call PlotIt_Click
End Sub

Private Sub ShowZero_Click()
Call PlotIt_Click
End Sub

Private Sub Zoomer_Change()
Zoom = Zoomer.Value / 2 + 0.5
End Sub

Private Sub Picture1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

Ymouse = Int(Y / H1 + Slider3.Value)
Xmouse = Int(X / W1 + Slider2.Value)
Label7.Caption = "Row = " & Ymouse: Label7.Visible = True
Label8.Caption = "Col = " & Xmouse: Label8.Visible = True
GPSlabel.Visible = True
Call Picture1_Mousemove(Button, Shift, X, Y)

End Sub

Private Sub Picture1_Mouseup(Button As Integer, Shift As Integer, X As Single, Y As Single)

Label7.Visible = False
Label8.Visible = False
GPSlabel.Visible = False

End Sub

Public Sub Picture1_Mousemove(Button As Integer, Shift As Integer, X As Single, Y As Single)

Ymouse = Int(Y / H1 + Slider3.Value)
Xmouse = Int(X / W1 + Slider2.Value)
Label7.Caption = "Row = " & Ymouse
Label8.Caption = "Col = " & Xmouse
If Ymouse > 0 And Xmouse > 0 Then
If Left$(FileData(2, Ymouse), 1) = "A" Then
GPSlabel.Caption = FileData(2, Ymouse)
Else
GPSlabel.Caption = "No GPS data recorded"
End If
Else
GPSlabel.Caption = ""
End If

End Sub


Public Sub MagPlotIt()
Picture1.Cls
Label5.Visible = True: Label5.Refresh
Screen.MousePointer = vbHourglass
B = 0: F = 127: Min2 = 20000: Max2 = 0: Min = 20000: Max = 0
W = Picture1.Width / 128
H = Picture1.Height / 128
H1 = H: W1 = W

Picture1.ScaleHeight = Picture1.Height / Zoomer.Value
Picture1.ScaleWidth = Picture1.Width / Zoomer.Value

X1 = 0

Slider2.Max = FileDataQty(0): ' slider 2 = top

Slider3.Max = MaxLineLen(0) \ 6
StartVal = Slider3.Value * 6 + 1: ' slider 3 = side
EndVal = MaxLineLen(0)

For A = Slider2.Value To FileDataQty(0): ' (1)
tempA$ = FileData(0, A)

D = 0: Y1 = 0

For C = StartVal To EndVal Step 6
V = Val(Mid$(tempA$, C))

v1 = V
If V > 0 Then
If V < Min Then Min = V
If V > Max Then Max = V
Else
If ShowZero.Value = 0 Then GoTo BYPASS
V = 37: GoTo 105
End If

V = V - Val(Text1.Text)
v1 = v1 - Val(Text1.Text)
If Inverter.Value = 1 Then
If v1 > 0 Then v1 = OrigMaxValue - v1
End If

If MultiplyGrid.Caption <> "X" Then
V = V / Slider1.Value
v1 = v1 / Slider1.Value
Else
V = V * Slider1.Value
v1 = v1 * Slider1.Value
End If

If AddGrid.Caption <> "minus" Then
V = V + Slider4.Value
v1 = v1 + Slider4.Value
Else
V = V - Slider4.Value
v1 = v1 - Slider4.Value
End If

If V < 0 Then V = 0
If v1 < 0 Then v1 = 0

If V < Min2 Then Min2 = V
If V > Max2 Then Max2 = V

If Mode2 < 3 Then If V > 36 Then V = 36
If Mode2 = 3 Then If V > 7 Then V = 7

If Inverter.Value = 1 Then
If Mode2 < 3 Then V = 36 - V
If Mode2 = 3 Then V = 7 - V
End If

105:
z1 = X1 + W: z2 = Y1 + H

V = Int(V):
If Matrix.Value = 0 Then
If V <> 37 Then Picture1.Line (X1, Y1)-(z1, z2), Col(Mode2, V), BF
Else
v2 = v1: v3 = v1

X2 = X1 - (v2 / 2)
X3 = X1 + (v2 / 2)
Y2 = Y1 - (v3 / 2)
y3 = Y1 + (v3 / 2)

gridcol = Col(Mode2, V): If Mode2 = 3 Then gridcol = vbBlack
Picture1.Line (X2, Y2)-(X3, y3), gridcol, BF

End If

BYPASS:

Y1 = Y1 + H: D = D + 1
If Y1 > Picture1.ScaleHeight Then Exit For

Next: X = X + 142: X1 = X1 + W:
If X1 > Picture1.ScaleWidth Then Exit For
Next: Close

Final:
If Min = 65535 Then Min = 0
If Min2 = 65535 Then Min2 = 0
If Max = 0 Then Min = 0
If Max2 = 0 Then Min2 = 0

Label1.Caption = "Orig Value Range Min = " & Min & " Max = " & Max
Label2.Caption = "New Value Range Min = " & Int(Min2) & " Max = " & Int(Max2)
Label5.Visible = False
Screen.MousePointer = vbDefault
Text1.SetFocus
End Sub

