; TK3TUT34.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2 (prev tut35)
; makes use of an internally timer-generated
; interrupt to increment a count on PORTA

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
STATUS          EQU 3                   ; STATUS register
FSR             EQU 4                   ; indirect register pointer
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
                 
                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO INTRPT             ; go to interrupt routine
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA
                clrf TRISB
                movlw B'10000111'       ; set timer to max (1:256 = TMR0 value)
                movwf OPTION_REG        ; (light pull-ups off - bit 7 high)
                BANK0
                 
                movlw B'10100000'       ; enable interrupt (bit 7) and timer for
                movwf INTCON            ; use with TMR0 (bit 5)
                 
START           nop                     ; routine repeats until interrupt received
                goto START
                 
TEST            bsf PORTA,0             ; if program reached here, PORTA RA0 would
                                        ; be set. But the program can never reach
                                        ; here from START loop or interrupt
                 
INTRPT          movlw 2                 ; add 2 to PORTB each time a TMR0
	  	addwf PORTB,F           ; interrupt occurs
                bcf INTCON,2            ; its interrupt bit is then cleared
                retfie                  ; and a return to the jump point made
                 
                end 			; final line
