; TK3TUT47.ASM 25FEB03 - JOHN BECKER - EPE PIC TUTOR V2
; Dual ADC input
; Serial chip interfacing
; Serial output to PC
       
; PIC16F877, 3.2768MHz, WDT OFF, POR ON, XTAL XT
       
; Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
; N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
; respectively - refer to PIC16F877 data sheet
       
#DEFINE  BANK0 BCF STATUS,5        ; clear STATUS bit 5 
#DEFINE  BANK1 BSF STATUS,5        ; set   STATUS bit 5 
#DEFINE  BLOCK0 BCF STATUS,7       ; clear STATUS bit 7 (IRP)
#DEFINE  BLOCK1 BSF STATUS,7       ; set   STATUS bit 7 (IRP)
#DEFINE  SERIALDELAY CALL CYCLES5  ; set serial chip write delay value (5)
; #DEFINE  SERIALDELAY CALL CYCLES25  ; set serial chip write delay value (25)
				   ; (see text and prog TK3TUT45.ASM)
#DEFINE   SETECHAN MOVLW 0         ; set serial chip channel 0
 ; (value from 0 to 7) is placed into ECHAN via main prog, where its definition should be made
; #DEFINE   SETECHAN MOVLW 7       ; set serial chip channel 7
       
; ****************************************
       
      list P = PIC16F877
      __config H'3F31'
       
      include P16F877.INC  ; standard Microchip headers for this chip
       
        CBLOCK H'20'
LOOPA      ; general loop counter
CLKCNT     ; pre-counter for seconds
CHIPADRMSB ; MSB of EEPROM chip address counter
CHIPADRLSB ; LSB of EEPROM chip address counter
RECORD     ; recording flag
NOWA       ; flag for current value of RA4
PREVA      ; flag for previous value of RA4
        ENDC
       
; ****************************************
       
           ORG 0
           goto START
           ORG 4
           goto START
           ORG 5
           goto START
       
MESSAGE    addwf PCL,F
           retlw 'S'
           retlw 'E'
           retlw 'N'
           retlw 'D'
           retlw 'I'
           retlw 'N'
           retlw 'G'
           retlw ' '
           retlw 'T'
           retlw 'O'
           retlw ' '
           retlw 'P'
           retlw 'C'
           retlw ' '
           retlw ' '
           retlw ' '
       
;*******************

         include TK3TUT45.ASM    ; serial chip routines
         include TK3TUT46.ASM    ; output to PC routines
         include TK3TUTLCD.INC   ; LCD routines
         include TK3BIN2DEC.INC  ; binary to decimal routines
         include TK3TUTADC.INC   ; ADC routines
       
START    bcf STATUS,RP0    ; ensure Block0, Bank0
         bcf STATUS,RP1    ; ensure Block0, Bank0
         clrf PORTA        ; initialise all port outputs to zero
         clrf PORTB
         clrf PORTC
         clrf PORTD
         clrf PORTE
           
         BLOCK0 
         BANK1 
         clrf TRISB        ; PORTB as output
         clrf TRISC        ; PORTC as output
         clrf TRISD        ; PORTD as output
         clrf TRISE        ; PORTE as output
         movlw B'10000100' ; set RHS justify, RA0, RA1, RA3 as analog inputs
         movwf ADCON1      ; with RA, RE digital, ref to VE and 0V
         movlw B'00010111' ; RA0, RA1, RA2, RA4 as input, rest as output
         movwf TRISA
         movlw B'10000110' ; timer 1:128 (1/25th sec)
         movwf OPTION_REG  ; (light pull-ups off - bit 7 high)
         BANK0 
       
         call LCDSETUP     ; set up LCD (via include file)
       
         call SETBAUD      ; set baud rate (via include file)
       
         movlw B'10000001' ; set AD on, Fosc/32
         CHAN0             ; set for CHAN0 - RA0
         movwf ADCON0
         call DELAYB       ; short delay following channel change (via include file)
       
         clrf CHIPADRMSB   ; clear chip address counter MSB
         clrf CHIPADRLSB   ; clear chip address counter LSB
         clrf RECORD       ; clear recording flag
	 SETECHAN          ; sets channel for serial EEPROM, defined at head of prog
	 movwf ECHAN

         movlw 25          ; set timing counter value
         movwf CLKCNT
       
        ;********* START OF MAIN PROGRAM ********
       
MAIN     btfss INTCON,2    ; has a timer time-out been detected?
         goto MAIN         ; no
         bcf INTCON,2      ; yes

         movf PORTA,W      ; get PORTA
         andlw B'00010000' ; extract status of RA4
         movwf NOWA        ; temp store it
         xorwf PREVA,W     ; XOR it with previous value of RA4 in PREVA
         btfsc STATUS,Z    ; is it equal (the same as before)?
         goto MAIN2        ; yes, so bypass recording flag change
         btfsc NOWA,4      ; is current RA4 high?
         incf RECORD,F     ; yes, so toggle RECORD flag
         movlw 1           ; trigger end of timing countdown
         movwf CLKCNT      ; by setting CLKCNT to 1

MAIN2    movf NOWA,W       ; recall current RA4
         movwf PREVA       ; store it into PREVA
         btfsc PORTA,2     ; is download needed?
         call DOWNLOAD     ; yes

         decfsz CLKCNT,F   ; dec counter, is it = 0?
         goto MAIN         ; no
         movlw 25          ; yes, so reset counter value
         movwf CLKCNT

         movlw B'10000001' ; set AD on, Fosc/32
         CHAN0             ; set for CHAN0 - RA0
         movwf ADCON0
         call DELAYB       ; short delay following channel change
         bsf ADCON0,GO     ; start data conversion
       
         call GETADC       ; get value at ADC chan 0
         call LCD1         ; set LCD screen address to line 1 cell 1
         bsf RSLINE,4
       
         call SHOWADDRESS  ; show address at which data to be stored
         call SHOWADC      ; show value on line 1
         btfss RECORD,0    ; is recording flag on?
         goto GETCHAN1     ; no, so bypass storing and address inc
         call STOREIT      ; yes, so store value to external EEPROM chip
         call SHOWREAD     ; show value read back from EEPROM chip
       
         movlw 2           ; add 2 to EEPROM chip address
         addwf CHIPADRLSB,F
         movf STATUS,W
         andlw 1
         addwf CHIPADRMSB,F
      
       
GETCHAN1 movlw B'10000001' ; set AD on, Fosc/32
         CHAN1             ; set for CHAN1 - RA1
         movwf ADCON0
         call DELAYB       ; short delay following channel change
         bsf ADCON0,GO     ; start data conversion
         call GETADC       ; get value at ADC chan 1
         call LCD21        ; set LCD screen address to line 2 cell 1
         bsf RSLINE,4
       
         call SHOWADDRESS  ; show address at which data to be stored
         call SHOWADC      ; show value on line 2
         btfss RECORD,0    ; is recording flag on?
         goto MAIN         ; no, so bypass storing and address inc
         call STOREIT      ; store value to external EEPROM chip
         call SHOWREAD     ; show value read back from EEPROM chip
       
         movlw 2           ; add 2 to EEPROM chip address
         addwf CHIPADRLSB,F
         movf STATUS,W
         andlw 1
         addwf CHIPADRMSB,F
       
         goto MAIN         ; do it all again
       
        ; *************** MAIN PAUSE ROUTINE
       
PAUSIT   movlw 5           ; 1/5th sec wait set
         movwf CLKCNT
         clrf INTCON       ; clear interupt flag
PAUSE    btfss INTCON,2    ; has a timer time-out been detected?
         goto PAUSE        ; no
         bcf INTCON,2      ; yes
         decfsz CLKCNT,F   ; dec loop, is it zero?
         goto PAUSE        ; no
         return            ; yes
       
        ;*************** OUTPUT EEPROM CHIPS TO PC SERIAL PORT
       
DOWNLOAD call CLRLINE2     ; clear LCD line 2 (via include routine)
         clrf LOOPA
         call LCD1
         bsf RSLINE,4
SHOWMSG2 movf LOOPA,W
         call MESSAGE      ; sending to PC message
         call LCDOUT
         incf LOOPA,F
         btfss LOOPA,4
         goto SHOWMSG2
       
         call SENDDOWNLOAD
       
         movlw 25          ; reset clk counter
         movwf CLKCNT
         return 
       
        ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD
       
SENDDOWNLOAD  
       
         BANK1 
         bsf TXSTA,5       ; enable transmission (bit TXEN)
         BANK0 
          
         clrf RADDRH       ; reset start address for reading EEPROM chip
         clrf RADDRL
       
         movlw 0           ; send opening marker to PC (not really necessary)
         call SERIALSEND   ; via include routine
         movlw 255
         call SERIALSEND
         movlw 0
         call SERIALSEND
         movlw 0
         call SERIALSEND
          
         movlw 'R'
         call SERIALSEND
         movlw 'E'
         call SERIALSEND
         movlw 'S'
         call SERIALSEND
         movlw 'I'
         call SERIALSEND
         movlw 'S'
         call SERIALSEND
         movlw 'T'
         call SERIALSEND
         movlw 'Y'
         call SERIALSEND
       
SEND2    call READ         ; read from EEPROM chip
         movf MEMLO,W      ; get LSB value
         call SERIALSEND   ; send it to PC
         movf MEMHI,W      ; get MSB value
         call SERIALSEND   ; send it to PC
       
         movlw 2
         addwf RADDRL,F    ; inc read address by 2
         movf STATUS,W     ; add Carry (if any) to MSB
         andlw 1
         addwf RADDRH,F
         btfss RADDRH,7    ; is bit 7 of MSB high? (32768)
         goto SEND2        ; no, so continue

         movlw 0           ; yes so send a couple of zero bytes followed by END
         call SERIALSEND   ; (not actually necessary, but it gives an end marker)
         movlw 0
         call SERIALSEND
         movlw 'E'
         call SERIALSEND
         movlw 'N'
         call SERIALSEND
         movlw 'D'
         call SERIALSEND

         clrf RADDRH       ; reset start address for reading EEPROM chip
         clrf RADDRL
       
         return 
       
;********
       
STOREIT  movf ADCMSB,W     ; store to external serial EEPROM chip
         movwf MEMHI
         movf ADCLSB,W
         movwf MEMLO
      
         movf CHIPADRMSB,W
         movwf WADDRH      ; set address MSB
         movf CHIPADRLSB,W
         movwf WADDRL      ; set address LSB
         call SAVESAMPLE   ; save via include file
         return 
       
SHOWREAD movf CHIPADRMSB,W
         movwf RADDRH      ; set read address
         movf CHIPADRLSB,W
         movwf RADDRL      ; set read address
         call READ         ; read external EEPROM chip value

         movf MEMHI,W      ; convert and show Read value
         movwf COUNT1
         movf MEMLO,W
         movwf COUNT0
         clrf COUNT2
         call BIN2DEC      ; convert to decimal
         call SHOWVALUE
         return 
       
SHOWADC  movf ADCMSB,W     ; show value of ADC
         movwf COUNT1
         movf ADCLSB,W
         movwf COUNT0
         clrf COUNT2
         call BIN2DEC      ; convert to decimal
         call SHOWVALUE
         btfss RECORD,0    ; is recording flag on?
         goto ADC2         ; no
         movlw 'R'         ; yes, so show R
         call LCDOUT
         return
ADC2     movlw ' '         ; show blanks in place of READ value
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw ' '
         call LCDOUT
         return

SHOWVALUE movf DIGIT5,W    ; show decimal value
         call LCDOUT
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         return 
       
SHOWADDRESS   
         movf CHIPADRMSB,W
         movwf COUNT1
         movf CHIPADRLSB,W
         movwf COUNT0
         clrf COUNT2
      
         call BIN2DEC      ; convert to decimal
       
         movf DIGIT5,W     ; show decimal value
         call LCDOUT
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         return 
       
         END 
