; TK3TUT45.ASM 27FEB03
; Illustrating Microchip serial EEPROM chip interfacing (e.g. 24LC256 etc)

; THIS PROGRAM IS INCAPABLE OF BEING RUN ON ITS OWN
; IT IS FOR USE WITHIN A MAIN ASM FILE

              ;************************************************************
              ;  Definitions specific to serial EEPROM read/write
              ;  equates values need changing to suit your ASM program  
              ;************************************************************

; #DEFINE   BANK0 BCF STATUS,5
; #DEFINE   BANK1 BSF STATUS,5
; #DEFINE   SERIALDELAY CALL CYCLES5  ; set serial chip write delay value
              ; (see text) CYCLES5 for 4MHz or below, CYCLES25 for 20MHz
; #DEFINE   SETECHAN MOVLW 0          ; set serial chip channel (value from 0 to 7)
  ; is placed into ECHAN via main prog, where its definition should be made

          CBLOCK        ; automatically allocates addresses to the following registers

MEMHI
MEMLO
WADDRL
WADDRH
RADDRH
RADDRL
POLLCNT
SLAVE
TXBUF
BCOUNT
COUNT
DATAI
DATAO
EEPROM
ECHAN
          ENDC          ; end of register allocation block

              ;************************************************************
              ;  Bit Definitions specific to serial EEPROM read/write
              ;************************************************************
         
DI        EQU H'07'         ; eeprom input bit
DO        EQU H'06'         ; eeprom output bit
SDATA     EQU H'04'         ; serial EE data line (PORTC)
SCLK      EQU H'03'         ; serial EE clock line (PORTC)
         
;*********  entry point for storing double byte data to serial EEPROM
; before calling this routine place
; data MSB to be stored into MEMHI
; data LSB into MEMLO
; set WADDRL with LSB of EEPROM chip address
; set WADDRH with MSB of EEPROM chip address
; then use the command CALL SAVESAMPLE

SAVESAMPLE     
         
WRMSB     movf MEMHI,W      ; get data MSB
          call WRBYTE       ; store it to EEPROM
          incf WADDRL,F     ; inc EEPROM address
WRLSB     movf MEMLO,W      ; get data LSB
          call WRBYTE       ; store it to EEPROM
          decf WADDRL,F     ; set EEPROM address back to entry value
          return

; Beware to avoid entry address values which would cause rollover
; when command INCF WADDRL,F is made
         
; *********** cycles pause called by Serial EEPROM write routines ****
         
; the CALL takes 2 clock cycles
; the RETURN takes 2 clock cycles
; a pause of 4 clock cycles is created by just CALLing CYCLES4 and returning
; each NOP adds a further 1 cycle pause
         
CYCLES25  nop 
CYCLES24  nop 
CYCLES23  nop 
CYCLES22  nop 
CYCLES21  nop 
CYCLES20  nop 
CYCLES19  nop 
CYCLES18  nop 
CYCLES17  nop 
CYCLES16  nop 
CYCLES15  nop 
CYCLES14  nop 
CYCLES13  nop 
CYCLES12  nop 
CYCLES11  nop 
CYCLES10  nop 
CYCLES9   nop 
CYCLES8   nop 
CYCLES7   nop 
CYCLES6   nop 
CYCLES5   nop 
CYCLES4   return 
         
;***** THIS IS THE START OF MPASM'S WRITE DATA TO SERIAL EEPROM CHIP ***

; First used by John Becker in 8-CHAN DATA LOGGER 1999
; taken from MPASM FILE C:\PIC\2WDPOLL.ASM
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
; the original used timings based on a 4MHz clock
; this routine has been modified to enable different xtal rates
; Defining SERIALDELAY as "call CYCLE5" is for 4MHz or less xtal
; Defining SERIALDELAY as "call CYCLE25" is for 20MHz xtal
         
;***************************************************************
;       Byte Write Routine with data polling
;***************************************************************

WRBYTE    movwf DATAO       ; entry with val to sent in W, stored to DATAO
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode
          MOVWF SLAVE
         
BYTE      call BSTART       ; generate start bit
          movf SLAVE,W      ; move slave address
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
         
          movf WADDRH,W     ; send address high byte
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
         
          movf WADDRL,W     ; send address low byte
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
         
          movf DATAO,W      ; move data byte
          movwf TXBUF       ; to tranmit buffer
          call TX           ; and transmit it
          call BSTOP        ; generate stop bit
         
          movlw 40          ; now start polling for a low ack bit
          movwf POLLCNT     ; set max number of times to poll
POLL      call BSTART       ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode
        
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
          btfss EEPROM,DI   ; was the ack bit low?
          goto EXITPOLL     ; yes, do another byte
          decfsz POLLCNT,F  ; is poll counter down to zero?
          goto POLL         ; no, poll again.
EXITPOLL  return 
         
;**************************************************************
;       Start Bit Subroutine - generates a start bit
;       (Low going data line while clock is high)
;**************************************************************
         
BSTART    bsf PORTC,SDATA   ; make sure data is high
          BANK1 
          movlw B'10100111'
          movwf TRISC       ; set data and clock lines for output
          BANK0 
          bcf PORTC,SCLK    ; make sure clock is low
          nop 
          bsf PORTC,SCLK    ; set clock high
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SDATA   ; data line goes low during
                            ; high clock for start bit
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SCLK    ; start clock train
          nop 
          nop 
          retlw 0
         
;************************************************************
;       Stop Bit Subroutine - generates a stop bit
;       (High going data line while clock is high)
;************************************************************
         
BSTOP     BANK1 
          movlw B'10100111'
          movwf TRISC       ; set data/clock lines as outputs
          BANK0 
          bcf PORTC,SDATA   ; make sure data line is low
          SERIALDELAY       ; timing adjustment  
          bsf PORTC,SCLK    ; set clock high
          SERIALDELAY       ; timing adjustment
          bsf PORTC,SDATA   ; data goes high while clock high for stop bit
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SCLK    ; set clock low again
          SERIALDELAY       ; timing adjustment
          retlw 0
         
;*************************************************************
;       BITOUT routine takes one bit of data in 'do' and
;       transmits it to the serial EE device
;*************************************************************
         
BITOUT    BANK1 
          movlw B'10100111'
          movwf TRISC
          BANK0 
          btfss EEPROM,DO   ; check for state of data bit to xmit
          goto BITLOW       ;
          bsf PORTC,SDATA   ; set data line high
          goto CLKOUT       ; go toggle the clock
         
BITLOW    bcf PORTC,SDATA   ; output a low bit
CLKOUT    bsf PORTC,SCLK    ; set clock line high
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SCLK    ; return clock line low
          retlw 0
         
;**************************************************************
;       BITIN routine reads one bit of data from the
;       serial EE device and stores it in 'di'
;**************************************************************
         
BITIN     bsf EEPROM,DI     ; assume input bit is high
          BANK1 
          movlw B'10110111' ; make sdata an input line
          movwf TRISC
          BANK0 
          bsf PORTC,SDATA   ; set sdata line for input
          bsf PORTC,SCLK    ; set clock line high
          SERIALDELAY       ; timing adjustment
          btfss PORTC,SDATA ; read the data bit
          bcf EEPROM,DI     ; input bit was low
          bcf PORTC,SCLK    ; set clock line low
          retlw 0
         
;****************************************************************
;       Transmit Data Subroutine
;****************************************************************
         
TX        movlw 8
          movwf COUNT       ; set the #bits to 8
TXLP      bcf EEPROM,DO     ; assume bit out is low
          btfsc TXBUF,7     ; is bit out really low?
          bsf EEPROM,DO     ; otherwise data bit =1
          call BITOUT       ; serial data out
          rlf TXBUF,F       ; rotate txbuf left
          decfsz COUNT,F    ; 8 bits done?
          goto TXLP         ; no - go again
          call BITIN        ; read ack bit
          retlw 0

;****************************************************************
;       Transmit Data Subroutine
;****************************************************************
         
TX2       movlw 8
          movwf COUNT       ; set the #bits to 8
TXLP2     bcf EEPROM,DO     ; assume bit out is low
          btfsc TXBUF,7     ; is bit out really low?
          bsf EEPROM,DO     ; no, set it high
          call BITOUT       ; send the bit to serial EE
          rlf TXBUF,F       ; rotate txbuf left
          decfsz COUNT,F    ; 8 bits done?
          goto TXLP2        ; no - go again
          call BITIN2       ; read ack bit
          btfsc EEPROM,DI   ; check ack bit
          nop 
          retlw 0

;***** THIS IS THE END OF MPASM'S WRITE DATA TO SERIAL EEPROM CHIP ***

;***** THIS IS THE START OF MPASM'S READ DATA FROM SERIAL EEPROM CHIP ***

; First used by John Becker in 8-CHAN DATA LOGGER 1999
; taken from MPASM FILE C:\PIC\2WSEQR.ASM
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
         
;************************************************************
;       2-Wire Sequential Read Program
;************************************************************
;       Stop Bit Subroutine - generates a stop bit
;       (High going data line while clock is high)
;************************************************************
         
BSTOP2    BANK1 
          movlw B'10100111'
          movwf TRISC       ; set data/clock lines as outputs
          BANK0 
          bcf PORTC,SDATA   ; make sure data line is low
          SERIALDELAY 
          bsf PORTC,SCLK    ; set clock high
          SERIALDELAY 
          bsf PORTC,SDATA   ; data goes high while clock high for stop bit
          SERIALDELAY 
          bcf PORTC,SCLK    ; set clock low again
          SERIALDELAY 
          retlw 0
         
;**************************************************************
;       BITIN2 routine reads one bit of data from the
;       serial EE device and stores it in 'di'
;**************************************************************
         
BITIN2    bsf EEPROM,DI     ; assume input bit is high
          BANK1 
          movlw B'10110111' ; make sdata an input line
          movwf TRISC
          BANK0 
          bsf PORTC,SCLK    ; set clock line high
          SERIALDELAY 
          btfss PORTC,SDATA ; read the data bit
          bcf EEPROM,DI     ; input bit was low, set 'di' accordingly
          bcf PORTC,SCLK    ; set clock line low
          retlw 0
         
;****************************************************************
;       Receive data Routine
;****************************************************************
         
RX        movlw 8           ; set # bits to 8
          movwf COUNT
          clrf DATAI        ; clear input register
          bcf STATUS,0      ; make sure carry bit is low
RXLP      rlf DATAI,F       ; rotate DATAI 1 bit left
          call BITIN2       ; read a bit
          btfsc EEPROM,DI
          bsf DATAI,0       ; set bit 0 if necessary
          decfsz COUNT,F    ; 8 bits done?
          goto RXLP         ; no, do another
          retlw 0
         
;**************************************************************
;       READ (sequential read routine)
;**************************************************************
         
READ      MOVLW 2
          MOVWF BCOUNT      ; set number of bytes to read
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode;
          MOVWF SLAVE
         
          call BSTART       ; generate start bit
          movf SLAVE,W      ; get slave address
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and send it
         
          movf RADDRH,W     ; send address high byte
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and send it
         
          movf RADDRL,W     ; get word address
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and send it
          call BSTART       ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100001     ; set slave address and write mode
         
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and transmit it

RBYTE     call RX           ; read 1 byte from device
          decfsz BCOUNT,F   ; are both bytes read?
          goto LOWACK       ; no, send low ack and do another
          bsf EEPROM,DO     ; yes, send high ack bit
          call BITOUT       ; to stop transmission
          call BSTOP2       ; and send a stop bit
          movf DATAI,W
          movwf MEMLO       ; data low byte
          return 
         
LOWACK    movf DATAI,W
          movwf MEMHI       ; data high byte
          bcf EEPROM,DO     ; send low ack bit
          call BITOUT       ; to continue transmission
          goto RBYTE        ; and read another byte
         
;***** THIS IS THE END OF MPASM'S READ DATA FROM SERIAL EEPROM CHIP ***



