; TK3TUT42.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; illustrating use of multiplication
; with BCD to decimal conversions and output to LCD

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

        List P = PIC16F84, R=DEC; 
        __CONFIG   h'3FF1'

INDF    	EQU 0  			; Bank 0, 1, 2, 3
OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
FSR	        EQU 4  			; Bank 0, 1, 2, 3
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
                 
LOOP            EQU H'20'               ; loop counter 1 - general
LOOPA           EQU H'21'               ; loop counter 2 - LCD use only
CLKCNT          EQU H'22'               ; 1/25 secs counter
STORE           EQU H'23'               ; general store
RSLINE          EQU H'24'               ; bit 4 RS line flag for LCD
BIN0            EQU H'25'	        ; lsb of value of initial value
BIN1            EQU H'26'	        ; lsb of value of initial value
BIN2            EQU H'27'	        ; lsb of value of initial value
COUNT0          EQU H'28'	        ; lsb of binary value to be converted
COUNT1          EQU H'29'	        ; nsb of binary value to be converted
COUNT2          EQU H'2A'	        ; msb of binary value to be converted
DIGIT1          EQU H'2B'	        ; lsd digital conversion
DIGIT2          EQU H'2C'
DIGIT3          EQU H'2D'
DIGIT4          EQU H'2E'
DIGIT5          EQU H'2F'
DIGIT6          EQU H'30'
DIGIT7          EQU H'31'
DIGIT8          EQU H'32'	        ; msd digital conversion
BITCNT          EQU H'33'	        ; counter for the number of bits processed
DIGCNT          EQU H'34'	        ; counter for the number of digits processed
TIMESMSB	EQU H'35'	        ; msb of multiplying value
TIMESLSB	EQU H'36'	        ; lsb of multiplying value
MULCLSB         EQU H'37	        ; multiplicant LSB
MULCMSB         EQU H'38	        ; multiplicant MSB
MULPLSB         EQU H'39	        ; multiplier LSB
MULPMSB         EQU H'3A	        ; multiplier MSB
PRODLSB         EQU H'3B	        ; product LSB
PRODMSB         EQU H'3C	        ; product MSB


                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA              ; Port A0-A4 as output
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)
                 
                movlw H'27'             ; set initial values into BIN (H'0727')
                movwf BIN0              ; Experiment with different
                movlw H'07'             ; values between 0 and H'FF'
                movwf BIN1              ; They may be expressed in hex, decimal or binary

		movlw H'13'		; set initial values into multiplier (H'0113')
		movwf TIMESLSB
		movlw H'01'
		movwf TIMESMSB

                goto SETUP              ; bypass tables
                 
TABLCD          addwf PCL,F             ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end initialisation table
SETUP           call PAUSIT             ; perform first 1/5th sec delay
                 
LCDSET          clrf LOOP               ; clr LCD set-up loop
                clrf RSLINE             ; clear RS line for instruction send
LCDST2          movf LOOP,W             ; get table address
                call TABLCD             ; get set-up instruction
                call LCDOUT             ; perform it
                incf LOOP,F             ; inc loop
                btfss LOOP,3            ; has last LCD set-up instruction now been done?
                goto LCDST2             ; no
                call PAUSIT             ; yes, perform second 1/5th sec delay
                                        ; to allow final LCD command to occur
                                        ; (it takes longer than the rest)
                 
MAIN:	        MOVF BIN0,W	        ; place value to be multiplied into MULC
                movwf COUNT0
	        MOVF BIN1,W
                movwf COUNT1
		clrf COUNT2

                call BIN2DEC		; BCD convert it for display

                movlw b'10000000' 	; set LCD screen address
                call LCDLIN
                movf DIGIT5,W		; show it
                call LCDOUT
                movf DIGIT4,W
                call LCDOUT
                movf DIGIT3,W
                call LCDOUT
                movf DIGIT2,W
                call LCDOUT
                movf DIGIT1,W
                call LCDOUT

		movlw ' '		; show space then multiply sign
                call LCDOUT
		movlw '*'
                call LCDOUT

	        MOVF TIMESLSB,W	        ; place value to be multiplied into MULC
                movwf COUNT0
	        MOVF TIMESMSB,W
                movwf COUNT1
		clrf COUNT2

                call BIN2DEC		; BCD convert it for display

                movlw b'10001000' 	; set LCD screen address
                call LCDLIN
                movf DIGIT5,W		; show it
                call LCDOUT
                movf DIGIT4,W
                call LCDOUT
                movf DIGIT3,W
                call LCDOUT
                movf DIGIT2,W
                call LCDOUT
                movf DIGIT1,W
                call LCDOUT


	        MOVF BIN0,W	       ; place value to be multiplied into MULC
        	MOVWF MULCLSB
	        MOVF BIN1,W
	        MOVWF MULCMSB

	        MOVF TIMESLSB,W	       ; place value of multiplier into MULP
	        MOVWF MULPLSB
	        MOVF TIMESMSB,W
	        MOVWF MULPMSB
	        CALL MULTIPLY	       ; call multiply routine

	        MOVF MULPLSB,W         ; copy answer into COUNT for BCD conversion
                movwf COUNT0
	        MOVF MULPMSB,W
                movwf COUNT1
	        MOVF PRODLSB,W
	        MOVWF COUNT2

                call BIN2DEC

                movlw b'11000000' 	; set LCD screen address
                call LCDLIN

		movlw '='		; show equals sign then space
                call LCDOUT
		movlw ' '
                call LCDOUT

                movf DIGIT8,W		; show decimal answer
                call LCDOUT
                movf DIGIT7,W
                call LCDOUT
                movf DIGIT6,W
                call LCDOUT
                movf DIGIT5,W
                call LCDOUT
                movf DIGIT4,W
                call LCDOUT
                movf DIGIT3,W
                call LCDOUT
                movf DIGIT2,W
                call LCDOUT
                movf DIGIT1,W
                call LCDOUT
        
NOMORE          goto NOMORE             ; hold here ad infinitum!

LCDLIN		bcf RSLINE,4		; sets LCD command/line
	        call LCDOUT     	; and outputs cmmand code to LCD
	        bsf RSLINE,4    	; set RS flag
	        return

LCDOUT          movwf STORE             ; temp store data
                movlw 50                ; set minimum time between sending full bytes to
                movwf LOOPA             ; LCD - value of 50 seems OK for this prog with
DELAY           decfsz LOOPA,F          ; XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY              ; keep decrementing LOOPA until zero
                call SENDIT             ; send MSB
                call SENDIT             ; send LSB
                return 
                 
SENDIT          swapf STORE,F           ; swap data nibbles
                movf STORE,W            ; get data byte
                andlw 15                ; get nibble from byte (LSB)
                iorwf RSLINE,W          ; OR the RS bit
                movwf PORTB             ; output the byte
                bsf PORTB,5             ; set E line high
                bcf PORTB,5             ; set E line low
                return 
                 
PAUSIT          movlw 5                 ; set delay counter to 5
                movwf CLKCNT            ; (for 1/25th sec x 5)
                clrf INTCON             ; clear interupt flag
PAUSE                                   ; initial 1/5th sec wait before setting up LCD
                btfss INTCON,2          ; has a timer time-out been detected?
                goto PAUSE              ; no
                bcf INTCON,2            ; yes
                decfsz CLKCNT,F         ; dec counter, is it zero?
                goto PAUSE              ; no
                return                  ; yes


BIN2DEC  clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ;24 bits to do
        movwf   BITCNT

BITLP   rlf     COUNT0,F        ;Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ;Pointer to DIGITs
        movlw   8               ;8 DIGITs to do
        movwf   DIGCNT
ADJLP   rlf     INDF,F          ;Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ;Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ;Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ;Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F       ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F

        movf DIGIT8,W       ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        movf DIGIT7,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT7,4
        movf DIGIT6,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT6,4
        movf DIGIT5,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return


;A neat Multiply routine, from Peter Hemsley 15July01.

;Multiply 16 bit multiplicand (mulcL,H) by 16 bit multiplier (mulpL,H)
;32 bit result (product) in mulpL,H (low word) and prodL,H (high word)

MULTIPLY: movlw  16
          movwf  BITCNT  
          clrf   PRODLSB  
          clrf   PRODMSB  
MULT1     bcf    STATUS,0
          btfss  MULPLSB,0
          goto   MULT3
          movf   MULCLSB,W
          addwf  PRODLSB,F
          movf   MULCMSB,W
          btfsc  STATUS,0
          goto   MULT2
          addwf  PRODMSB,F
          goto   MULT3
MULT2     addwf  PRODMSB,F
          incf   PRODMSB,F
          btfsc  STATUS,2
          bsf    STATUS,0
MULT3     rrf    PRODMSB,F
          rrf    PRODLSB,F
          rrf    MULPMSB,F
          rrf    MULPLSB,F
          decfsz BITCNT,F
          goto   MULT1
          return 
                 
                end                     ; final line

