; TK3TUT27.ASM 31DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; Use of Timer with set rate, with BCD to 59 counting
; on 2 LED 7-segment displays
; plus 1/25 sec counter
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag

CLKCNT          EQU H'20'               ; clock division counter
CLKSEC          EQU H'21'               ; clock seconds counter
DIGIT           EQU H'22'               ; 7-segment digit select

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA		; PORTA as output
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                movlw 25                ; set 1/25 sec counter
                movwf CLKCNT
                clrf CLKSEC             ; clear secs
                clrf DIGIT              ; clear display digit counter
                bcf INTCON,2
                goto INTRPT
                 
COMCATHODE      addwf PCL,F             ; add W value to PCL
                retlw B'00111111'       ; 0   common cathode codes
                retlw B'00000110'       ; 1
                retlw B'01011011'       ; 2
                retlw B'01001111'       ; 3
                retlw B'01100110'       ; 4
                retlw B'01101101'       ; 5
                retlw B'01111100'       ; 6
                retlw B'00000111'       ; 7
                retlw B'01111111'       ; 8
                retlw B'01100111'       ; 9

COMANODE        addwf PCL,F
                retlw B'11000000'       ; 0   common anode codes
                retlw B'11111001'       ; 1
                retlw B'10100100'       ; 2
                retlw B'10110000'       ; 3
                retlw B'10011001'       ; 4
                retlw B'10010010'       ; 5
                retlw B'10000011'       ; 6
                retlw B'11111000'       ; 7
                retlw B'10000000'       ; 8
                retlw B'10011000'       ; 9
                 
DIGSEL          incf DIGIT,W            ; inc display digit count
                andlw 1                 ; limit to 1
                movwf DIGIT             ; get digit val
                addwf PCL,F             ; add to PCL
                goto SECTEN             ; 0 - show tens of secs
                goto SECONE             ; 1 - show units of secs
                 
INTRPT          call DIGSEL             ; route for digit required
                btfss INTCON,2          ; has a timer time-out been detected?
                goto INTRPT             ; no
                bcf INTCON,2            ; yes
                decfsz CLKCNT,F         ; has CLKCNT (1/25 divider) reached zero?
                goto INTRPT             ; no
                movlw 25                ; yes
                movwf CLKCNT            ; reset 1/25 counter
                incf CLKSEC,F           ; inc secs
                movf CLKSEC,W           ; check units >9
                addlw 6
                btfss STATUS,DC         ; is there a digit carry?
                goto ENDTIM             ; no
                movwf CLKSEC            ; yes
                movlw B'01100000'       ; load W with BCD 60
                xorwf CLKSEC,W          ; alternative way of checking instead of adding
                btfsc STATUS,Z          ; is CLKSEC = 60 (does equality exist, Z=1)?
                clrf CLKSEC             ; yes, clear secs counter
ENDTIM          goto INTRPT
                 
SECTEN          swapf CLKSEC,W          ; get tens of secs nibble (MSB)
                goto OUTPUT             ; show it
SECONE          movf CLKSEC,W           ; get units of secs nibble (LSB) and show it
                 
OUTPUT          andlw 15                ; and nibble with 15
                call COMCATHODE         ; get code for value
                clrf PORTA              ; turn off PORTA
                movwf PORTB             ; output to display
                incf DIGIT,W            ; get digit value + 1
                movwf PORTA             ; set digit on via PORTA (bits 0 & 1)
                return                  ; do again
                 
                end                     ; final line
