; TK3TUT24.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; Use of Timer at set rate, with BCD counting on LEDs
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag

COUNT           EQU H'20'               ; general counter

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA		; PORTA as output
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                clrf COUNT              ; clear COUNT
                bcf INTCON,2            ; clear interrupt bit 2 of INTCON
                 
MAIN            btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no, so keep on reading bit 2
                bcf INTCON,2            ; yes, clear interrupt flag on bit 2
                incf COUNT,F            ; inc count
                movf COUNT,W            ; copy COUNT value into W
                addlw 6                 ; add 6 to it (check for >9)
                btfss STATUS,DC         ; is there a digit carry (is answer >15)?
                goto OUTPUT             ; no, so bypass next section
                movwf COUNT             ; yes, move new value into COUNT
                addlw 96                ; add 96 to new val (check for >90)
                btfsc STATUS,C          ; is there a byte carry (is answer > 255)
                clrf COUNT              ; yes, clear COUNT
OUTPUT          movf COUNT,W            ; get val of COUNT
                movwf PORTB             ; output it to PORTB
                goto MAIN               ; go wait for another time-out
                 
                end                     ; final line
