; TK3TUT23.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; Use of Timer 0 with diff rates, showing count/rate on 8 LEDs
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
                 
RATE            EQU H'20'               ; rate set into timer (OPTION)
COUNT           EQU H'21'               ; general counter

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA		; PORTA as output
                clrf TRISB		; PORTB as output
                movlw B'10000000'       ; move zero into W (binary shown intentionally)
                movwf OPTION_REG        ; set into OPTION as timer ratio 1:2 (TMRO rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                clrf RATE               ; clear RATE value
                movlw 8                 ;
                movwf COUNT             ; set COUNT to 8
                bcf INTCON,2            ; clear interrupt flag on INTCON bit 2
                 
MAIN            btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no, keep on reading bit 2
                bcf INTCON,2            ; yes, reset interrupt bit 2
                movlw B'00010000'       ; load W with 8
                addwf PORTB,F           ; add it to Port B
                btfss STATUS,C          ; is there a carry?
                goto MAIN               ; no, keep on reading bit 2
                decfsz COUNT,F          ; yes, so dec COUNT, is it zero?
                goto MAIN               ; no
                bsf COUNT,3             ; yes, so reset COUNT to 8 (00001000)
                incf RATE,W             ; copy and increment RATE into W
                andlw 7                 ; AND it with 00000111
                movwf RATE              ; set it into RATE
                movwf PORTB             ; move same value to PORTB (for bits 0-2)
                BANK1 
                iorlw B'10000000'       ; (keep light pull-ups off - bit 7 high)
                movwf OPTION_REG        ; move same value into OPTION to change ratio
                BANK0 
                goto MAIN               ; go back to waiting for time-out
                 
                end                     ; final line
