; TK3TUT11.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; using two switches on Port A, one to increment PORTB LED count
; (SW0/RA0) and one to decrement it (SW2/RA2). SW0 takes priority.

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
COUNT           EQU H'20'               ; name location H'20' as variable called COUNT
SWITCH          EQU H'21'               ; variable to hold previous switch status

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00000101'       ; RA0, RA2 as inputs
                movwf TRISA
                clrf TRISB
                BANK0
                 
BEGIN           clrf COUNT
                clrf SWITCH
                 
TEST1           btfsc PORTA,0           ; test bit 0 of Port A, is it clear?
                goto TSTPR1             ; no, it's = 1 so go to TSTPR1
                bcf SWITCH,0            ; clear bit 0 of SWITCH
                goto TEST2              ; go to check bit 2
TSTPR1          btfsc SWITCH,0          ; test bit 0 of SWITCH, is it clear?
                goto TEST2              ; no, it's = 1 so go to check bit 2
                bsf SWITCH,0            ; set bit 0 of SWITCH
                incf COUNT,F            ; yes, it's = 0 so inc count
                goto OUTPUT             ; bypass TEST2 completely
                 
TEST2           btfsc PORTA,2           ; test bit 2 of Port A, is it clear?
                goto TSTPR2             ; no, it's = 1 so go to TSTPR2
                bcf SWITCH,2            ; clear bit 2 of SWITCH
                goto TEST1              ; jump back to TEST1
TSTPR2          btfsc SWITCH,2          ; test bit 2 of SWITCH, is it clear?
                goto TEST1              ; no, it's = 1 so go to TEST1
                bsf SWITCH,2            ; set bit 2 of SWITCH
                decf COUNT,F            ; yes, it's = 0 so dec count
                 
OUTPUT          movf COUNT,W		; copy COUNT into W
                movwf PORTB		; output to PORTB
                goto TEST1              ; repeat
                 
                end                     ; final statement
