; TK3BIN2DEC.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; illustrating use BCD to decimal conversion and output to LCD

        include P16F877.inc

COUNT0          EQU H'28'    ; lsb of binary value to be converted
COUNT1          EQU H'29'    ; nsb of binary value to be converted
COUNT2          EQU H'2A'    ; msb of binary value to be converted
DIGIT1          EQU H'2B'    ; lsd digital conversion
DIGIT2          EQU H'2C'
DIGIT3          EQU H'2D'
DIGIT4          EQU H'2E'
DIGIT5          EQU H'2F'
DIGIT6          EQU H'30'
DIGIT7          EQU H'31'
DIGIT8          EQU H'32'    ; msd digital conversion
BITCNT          EQU H'33'    ; counter for the number of bits processed
DIGCNT          EQU H'34'    ; counter for the number of digits processed

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5


BIN2DEC: clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ;24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F        ;Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ;Pointer to DIGITs
        movlw   8               ;8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F          ;Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ;Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ;Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ;Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F       ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F

        movf DIGIT8,W       ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        movf DIGIT7,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT7,4
        movf DIGIT6,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT6,4
        movf DIGIT5,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return
                
        end                     ; final line

